/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.debugger.components.ExceptionBalloon;
import com.jetbrains.rider.debugger.components.RiderPaneWithTitle;
import com.jetbrains.rider.debugger.components.RiderPopupBalloonState;
import com.jetbrains.rider.debugger.exception.ExBalloonController;
import com.jetbrains.rider.ui.components.balloon.DraggableBalloon;
import com.jetbrains.rider.ui.components.utils.RdSwingKt;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000 +2\u00020\u0001:\u0002+,B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020\u001cH$J\u0006\u0010*\u001a\u00020(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006-"}, d2={"Lcom/jetbrains/rider/debugger/components/RiderDebugBalloon;", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "logicalPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "project", "Lcom/intellij/openapi/project/Project;", "debugSession", "Lcom/intellij/xdebugger/XDebugSession;", "parentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "RiderDebugBalloon", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/openapi/editor/LogicalPosition;Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDebugSession", "()Lcom/intellij/xdebugger/XDebugSession;", "lifetimeDef", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getLifetimeDef", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "lifetime", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "controller", "Lcom/jetbrains/rider/debugger/exception/ExBalloonController;", "panel", "Lcom/jetbrains/rider/debugger/components/RiderPaneWithTitle;", "state", "Lcom/jetbrains/rider/debugger/components/RiderPopupBalloonState;", "getState", "()Lcom/jetbrains/rider/debugger/components/RiderPopupBalloonState;", "initialized", "", "getInitialized", "()Z", "setInitialized", "(Z)V", "G", "", "createPanel", "show", "Companion", "RiderDebugBalloonKeyDispatcher", "intellij.rider"})
public abstract class RiderDebugBalloon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final LogicalPosition logicalPosition;
    @NotNull
    private final Project project;
    @NotNull
    private final XDebugSession debugSession;
    @NotNull
    private final LifetimeDefinition lifetimeDef;
    @NotNull
    private final Lifetime lifetime;
    private ExBalloonController controller;
    private RiderPaneWithTitle panel;
    @NotNull
    private final RiderPopupBalloonState state;
    private boolean initialized;
    @NotNull
    private static final Logger logger;

    public RiderDebugBalloon(@NotNull EditorImpl editor2, @NotNull LogicalPosition logicalPosition, @NotNull Project project, @NotNull XDebugSession debugSession, @NotNull Lifetime parentLifetime) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)logicalPosition, (String)"logicalPosition");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)debugSession, (String)"debugSession");
        Intrinsics.checkNotNullParameter((Object)parentLifetime, (String)"parentLifetime");
        this.editor = editor2;
        this.logicalPosition = logicalPosition;
        this.project = project;
        this.debugSession = debugSession;
        this.lifetimeDef = parentLifetime.createNested();
        this.lifetime = this.lifetimeDef.getLifetime();
        this.state = new RiderPopupBalloonState();
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    public final XDebugSession getDebugSession() {
        return this.debugSession;
    }

    @NotNull
    public final LifetimeDefinition getLifetimeDef() {
        return this.lifetimeDef;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final RiderPopupBalloonState getState() {
        return this.state;
    }

    public final boolean getInitialized() {
        return this.initialized;
    }

    public final void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    private final void G() {
        if (this.initialized) {
            return;
        }
        this.panel = this.createPanel();
        RiderPaneWithTitle riderPaneWithTitle = this.panel;
        if (riderPaneWithTitle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            riderPaneWithTitle = null;
        }
        riderPaneWithTitle.initPane();
        RiderPaneWithTitle riderPaneWithTitle2 = this.panel;
        if (riderPaneWithTitle2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            riderPaneWithTitle2 = null;
        }
        JComponent jComponent = riderPaneWithTitle2;
        RiderPaneWithTitle riderPaneWithTitle3 = this.panel;
        if (riderPaneWithTitle3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            riderPaneWithTitle3 = null;
        }
        JComponent jComponent2 = riderPaneWithTitle3.getTitle();
        JComponent jComponent3 = this.editor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent3, (String)"getComponent(...)");
        DraggableBalloon draggableBalloon = new DraggableBalloon(jComponent, jComponent2, jComponent3, this.lifetime);
        this.controller = new ExBalloonController(draggableBalloon, (EditorEx)this.editor, this.logicalPosition, this.state, this.project, this.lifetime);
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        RdSwingKt.documentChanged((Document)((Document)documentEx)).advise(this.lifetime, arg_0 -> RiderDebugBalloon.G(this, arg_0));
        Disposable disposable = this.editor.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        LifetimeDisposableExKt.createLifetime((Disposable)disposable).onTermination(() -> RiderDebugBalloon.G(this));
        this.lifetime.onTermination(() -> RiderDebugBalloon.b(this));
        RiderDebugBalloonKeyDispatcher riderDebugBalloonKeyDispatcher = new RiderDebugBalloonKeyDispatcher();
        this.lifetime.bracketIfAlive(() -> RiderDebugBalloon.b(riderDebugBalloonKeyDispatcher), () -> RiderDebugBalloon.G(riderDebugBalloonKeyDispatcher));
        this.initialized = true;
    }

    @NotNull
    protected abstract RiderPaneWithTitle createPanel();

    public final void show() {
        this.G();
        ExBalloonController exBalloonController = this.controller;
        if (exBalloonController == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"controller");
            exBalloonController = null;
        }
        exBalloonController.show();
    }

    private static final Unit G(RiderDebugBalloon riderDebugBalloon, DocumentEvent documentEvent) {
        Intrinsics.checkNotNullParameter((Object)documentEvent, (String)"it");
        LifetimeDefinition.terminate$default((LifetimeDefinition)riderDebugBalloon.lifetimeDef, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit G(RiderDebugBalloon riderDebugBalloon) {
        LifetimeDefinition.terminate$default((LifetimeDefinition)riderDebugBalloon.lifetimeDef, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit b(RiderDebugBalloon riderDebugBalloon) {
        ExBalloonController exBalloonController = riderDebugBalloon.controller;
        if (exBalloonController == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"controller");
            exBalloonController = null;
        }
        exBalloonController.hide();
        return Unit.INSTANCE;
    }

    private static final Unit b(RiderDebugBalloonKeyDispatcher riderDebugBalloonKeyDispatcher) {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(riderDebugBalloonKeyDispatcher);
        return Unit.INSTANCE;
    }

    private static final Unit G(RiderDebugBalloonKeyDispatcher riderDebugBalloonKeyDispatcher) {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(riderDebugBalloonKeyDispatcher);
        return Unit.INSTANCE;
    }

    static {
        Logger logger2 = Logger.getInstance(ExceptionBalloon.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/debugger/components/RiderDebugBalloon$Companion;", "", "RiderDebugBalloon$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/debugger/components/RiderDebugBalloon$RiderDebugBalloonKeyDispatcher;", "Ljava/awt/KeyEventDispatcher;", "RiderDebugBalloon$RiderDebugBalloonKeyDispatcher", "(Lcom/jetbrains/rider/debugger/components/RiderDebugBalloon;)V", "dispatchKeyEvent", "", "e", "Ljava/awt/event/KeyEvent;", "intellij.rider"})
    private final class RiderDebugBalloonKeyDispatcher
    implements KeyEventDispatcher {
        @Override
        public boolean dispatchKeyEvent(@NotNull KeyEvent e) {
            ExBalloonController exBalloonController;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.getID() != 401 || e.getKeyCode() != 27) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)XDebuggerManager.getInstance((Project)RiderDebugBalloon.this.getProject()).getCurrentSession(), (Object)RiderDebugBalloon.this.getDebugSession())) {
                return false;
            }
            Object object = e.getSource();
            JComponent jComponent = object instanceof JComponent ? (JComponent)object : null;
            if (jComponent == null) {
                return false;
            }
            JComponent jComponent2 = jComponent;
            Set set = UIUtil.uiParents((Component)jComponent2, (boolean)true).toSet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toSet(...)");
            Set set2 = set;
            if (!set2.contains(RiderDebugBalloon.this.editor.getComponent())) {
                RiderPaneWithTitle riderPaneWithTitle = RiderDebugBalloon.this.panel;
                if (riderPaneWithTitle == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
                    riderPaneWithTitle = null;
                }
                if (!set2.contains(riderPaneWithTitle)) {
                    return false;
                }
            }
            if ((exBalloonController = RiderDebugBalloon.this.controller) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"controller");
                exBalloonController = null;
            }
            exBalloonController.hide();
            return true;
        }
    }
}

