/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.breakpoint.validation;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointProperties;
import com.jetbrains.rider.debugger.breakpoint.validation.RiderBreakpointDocumentRangeShifters;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00030\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002H\u0016J\u001c\u0010\u000f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002H\u0016J\u001c\u0010\u0010\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/validation/RiderBreakpointValidationBreakpointsListener;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointListener;", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointProperties;", "project", "Lcom/intellij/openapi/project/Project;", "RiderBreakpointValidationBreakpointsListener", "(Lcom/intellij/openapi/project/Project;)V", "breakpointManager", "Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager;", "kotlin.jvm.PlatformType", "Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager;", "breakpointAdded", "", "breakpoint", "breakpointRemoved", "breakpointChanged", "intellij.rider"})
public final class RiderBreakpointValidationBreakpointsListener
implements XBreakpointListener<XBreakpoint<? extends XBreakpointProperties<?>>> {
    @NotNull
    private final Project project;
    private final XLineBreakpointManager breakpointManager;

    public RiderBreakpointValidationBreakpointsListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)this.project).getBreakpointManager();
        Intrinsics.checkNotNull((Object)xBreakpointManager, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl");
        this.breakpointManager = ((XBreakpointManagerImpl)xBreakpointManager).getLineBreakpointManager();
    }

    public void breakpointAdded(@NotNull XBreakpoint<? extends XBreakpointProperties<?>> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        if (!(breakpoint instanceof XLineBreakpoint) || !(((XLineBreakpoint)breakpoint).getProperties() instanceof DotNetLineBreakpointProperties)) {
            return;
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(((XLineBreakpoint)breakpoint).getFileUrl());
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        Document document = (Document)ActionsKt.runReadAction(() -> RiderBreakpointValidationBreakpointsListener.b(virtualFile2));
        if (document == null) {
            return;
        }
        Document document2 = document;
        DocumentSynchronizer documentSynchronizer = DocumentExKt.getDocumentSynchronizer((Document)document2, (Project)this.project);
        if (documentSynchronizer == null) {
            return;
        }
        DocumentSynchronizer documentSynchronizer2 = documentSynchronizer;
        RiderBreakpointDocumentRangeShifters.Companion.getInstance(this.project).registerShifter$intellij_rider(virtualFile2, documentSynchronizer2, documentSynchronizer2.getDocumentLifetime());
    }

    public void breakpointRemoved(@NotNull XBreakpoint<? extends XBreakpointProperties<?>> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        if (!(breakpoint instanceof XLineBreakpoint) || !(((XLineBreakpoint)breakpoint).getProperties() instanceof DotNetLineBreakpointProperties)) {
            return;
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(((XLineBreakpoint)breakpoint).getFileUrl());
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        Document document = (Document)ActionsKt.runReadAction(() -> RiderBreakpointValidationBreakpointsListener.G(virtualFile2));
        if (document == null) {
            return;
        }
        Document document2 = document;
        if (CollectionsKt.any((Iterable)this.breakpointManager.getDocumentBreakpoints(document2))) {
            return;
        }
        RiderBreakpointDocumentRangeShifters.Companion.getInstance(this.project).removeRangeShifter$intellij_rider(virtualFile2);
    }

    public void breakpointChanged(@NotNull XBreakpoint<? extends XBreakpointProperties<?>> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        if (!(breakpoint instanceof XLineBreakpoint) || !(((XLineBreakpoint)breakpoint).getProperties() instanceof DotNetLineBreakpointProperties)) {
            return;
        }
        RiderBreakpointDocumentRangeShifters.Companion.getInstance(this.project).revalidateShifters$intellij_rider();
    }

    private static final Document b(VirtualFile virtualFile) {
        return FileDocumentManager.getInstance().getDocument(virtualFile);
    }

    private static final Document G(VirtualFile virtualFile) {
        return FileDocumentManager.getInstance().getDocument(virtualFile);
    }
}

