/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.breakpoint;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.breakpoint.BreakpointHitCountMode;
import com.jetbrains.rider.debugger.breakpoint.DotNetBreakpointProperties;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointType;
import com.jetbrains.rider.model.debuggerWorker.BreakpointElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 <2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001<B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nBW\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\u0011J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0000H\u0016J\b\u0010-\u001a\u00020\u0000H\u0016J\b\u0010.\u001a\u00020+H\u0002J\b\u0010/\u001a\u00020+H\u0002J\b\u00100\u001a\u0004\u0018\u000101J\u0018\u00102\u001a\b\u0012\u0004\u0012\u0002030\u000f2\n\u00104\u001a\u0006\u0012\u0002\b\u000305J\b\u00106\u001a\u00020\fH\u0016J\b\u00107\u001a\u00020+H\u0002J\u0012\u00108\u001a\u00020+2\n\u00109\u001a\u00060:R\u00020;R\u001a\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR \u0010\r\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0019\"\u0004\b\u001d\u0010\u001bR\u001e\u0010\u001e\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R(\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006="}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetBreakpointProperties;", "hitCountFilterEnabled", "", "hitCount", "", "hitCountMode", "Lcom/jetbrains/rider/debugger/breakpoint/BreakpointHitCountMode;", "multiMethodBreakpoint", "DotNetLineBreakpointProperties", "(ZILcom/jetbrains/rider/debugger/breakpoint/BreakpointHitCountMode;Z)V", "canonicalDocumentPath", "", "containingFunctionPresentation", "initStartOffsets", "", "initEndOffsets", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;ZILcom/jetbrains/rider/debugger/breakpoint/BreakpointHitCountMode;)V", "rangeMarkers", "", "Lcom/intellij/openapi/editor/RangeMarker;", "startOffsets", "endOffsets", "filename", "getFilename", "()Ljava/lang/String;", "setFilename", "(Ljava/lang/String;)V", "getContainingFunctionPresentation", "setContainingFunctionPresentation", "isMultiMethodBreakpoint", "()Z", "setMultiMethodBreakpoint", "(Z)V", "debugProcessToThreadIdToStopMap", "", "Lcom/jetbrains/rider/debugger/DotNetDebugProcess;", "", "getDebugProcessToThreadIdToStopMap", "()Ljava/util/Map;", "setDebugProcessToThreadIdToStopMap", "(Ljava/util/Map;)V", "loadState", "", "state", "getState", "b", "r", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "getBreakpointElements", "Lcom/jetbrains/rider/model/debuggerWorker/BreakpointElement;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "toString", "G", "setVariant", "variant", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType$DotNetBreakpointVariant;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType;", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDotNetLineBreakpointProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetLineBreakpointProperties.kt\ncom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,227:1\n69#2,4:228\n69#2,4:232\n15#2:258\n1557#3:236\n1628#3,3:237\n1557#3:240\n1628#3,3:241\n1611#3,9:244\n1863#3:253\n1864#3:255\n1620#3:256\n1#4:254\n13#5:257\n*S KotlinDebug\n*F\n+ 1 DotNetLineBreakpointProperties.kt\ncom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties\n*L\n115#1:228,4\n120#1:232,4\n28#1:258\n125#1:236\n125#1:237,3\n126#1:240\n126#1:241,3\n176#1:244,9\n176#1:253\n176#1:255\n176#1:256\n176#1:254\n28#1:257\n*E\n"})
public class DotNetLineBreakpointProperties
extends DotNetBreakpointProperties<DotNetLineBreakpointProperties> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Transient
    @NotNull
    private List<RangeMarker> rangeMarkers;
    @Tag(value="startOffsets")
    @XCollection
    @NotNull
    private List<Integer> startOffsets;
    @Tag(value="endOffsets")
    @XCollection
    @NotNull
    private List<Integer> endOffsets;
    @Attribute(value="documentPath")
    @NotNull
    private String filename;
    @Attribute(value="containingFunctionPresentation")
    @Nls
    @Nullable
    private String containingFunctionPresentation;
    @Attribute(value="isMultiMethodBreakpoint")
    private boolean isMultiMethodBreakpoint;
    @NotNull
    private Map<DotNetDebugProcess, Long> debugProcessToThreadIdToStopMap;
    @NotNull
    private static final Logger logger;

    public DotNetLineBreakpointProperties(boolean hitCountFilterEnabled, int hitCount, @NotNull BreakpointHitCountMode hitCountMode, boolean multiMethodBreakpoint) {
        Intrinsics.checkNotNullParameter((Object)((Object)hitCountMode), (String)"hitCountMode");
        super(hitCountFilterEnabled, hitCount, hitCountMode);
        this.rangeMarkers = new ArrayList();
        this.startOffsets = new ArrayList();
        this.endOffsets = new ArrayList();
        this.filename = "";
        this.isMultiMethodBreakpoint = multiMethodBreakpoint;
        this.debugProcessToThreadIdToStopMap = new LinkedHashMap();
    }

    public /* synthetic */ DotNetLineBreakpointProperties(boolean bl, int n, BreakpointHitCountMode breakpointHitCountMode, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            breakpointHitCountMode = BreakpointHitCountMode.LessThan;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        this(bl, n, breakpointHitCountMode, bl2);
    }

    @NotNull
    public final String getFilename() {
        return this.filename;
    }

    public final void setFilename(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.filename = string;
    }

    @Nullable
    public final String getContainingFunctionPresentation() {
        return this.containingFunctionPresentation;
    }

    public final void setContainingFunctionPresentation(@Nullable String string) {
        this.containingFunctionPresentation = string;
    }

    public final boolean isMultiMethodBreakpoint() {
        return this.isMultiMethodBreakpoint;
    }

    public final void setMultiMethodBreakpoint(boolean bl) {
        this.isMultiMethodBreakpoint = bl;
    }

    @Transient
    @NotNull
    public final Map<DotNetDebugProcess, Long> getDebugProcessToThreadIdToStopMap() {
        return this.debugProcessToThreadIdToStopMap;
    }

    public final void setDebugProcessToThreadIdToStopMap(@NotNull Map<DotNetDebugProcess, Long> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
        this.debugProcessToThreadIdToStopMap = map2;
    }

    public DotNetLineBreakpointProperties(@NotNull String canonicalDocumentPath, @Nls @Nullable String containingFunctionPresentation, @NotNull List<Integer> initStartOffsets, @NotNull List<Integer> initEndOffsets, boolean hitCountFilterEnabled, int hitCount, @NotNull BreakpointHitCountMode hitCountMode) {
        Intrinsics.checkNotNullParameter((Object)canonicalDocumentPath, (String)"canonicalDocumentPath");
        Intrinsics.checkNotNullParameter(initStartOffsets, (String)"initStartOffsets");
        Intrinsics.checkNotNullParameter(initEndOffsets, (String)"initEndOffsets");
        Intrinsics.checkNotNullParameter((Object)((Object)hitCountMode), (String)"hitCountMode");
        this(hitCountFilterEnabled, hitCount, hitCountMode, false, 8, null);
        this.startOffsets = CollectionsKt.toMutableList((Collection)initStartOffsets);
        this.endOffsets = CollectionsKt.toMutableList((Collection)initEndOffsets);
        this.filename = DotNetLineBreakpointProperties.Companion.G(canonicalDocumentPath);
        this.containingFunctionPresentation = containingFunctionPresentation;
        this.r();
    }

    public /* synthetic */ DotNetLineBreakpointProperties(String string, String string2, List list2, List list3, boolean bl, int n, BreakpointHitCountMode breakpointHitCountMode, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        if ((n2 & 0x20) != 0) {
            n = 0;
        }
        if ((n2 & 0x40) != 0) {
            breakpointHitCountMode = BreakpointHitCountMode.LessThan;
        }
        this(string, string2, list2, list3, bl, n, breakpointHitCountMode);
    }

    @Override
    public void loadState(@NotNull DotNetLineBreakpointProperties state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        super.loadState((XBreakpointProperties)state);
        this.startOffsets = state.startOffsets;
        this.endOffsets = state.endOffsets;
        this.filename = state.filename;
        this.containingFunctionPresentation = state.containingFunctionPresentation;
        this.isMultiMethodBreakpoint = state.isMultiMethodBreakpoint;
        this.r();
        Logger logger2 = logger;
        boolean bl = false;
        if (logger2.isTraceEnabled()) {
            Logger logger3 = logger2;
            boolean bl2 = false;
            logger3.trace("Deserialize line breakpoint: " + this);
        }
    }

    @Override
    @NotNull
    public DotNetLineBreakpointProperties getState() {
        this.b();
        Logger logger2 = logger;
        boolean bl = false;
        if (logger2.isTraceEnabled()) {
            Logger logger3 = logger2;
            boolean bl2 = false;
            logger3.trace("Serialize line breakpoint: " + this);
        }
        return this;
    }

    private final void b() {
        boolean bl;
        Collection collection;
        RangeMarker rangeMarker;
        Iterable iterable = this.rangeMarkers;
        DotNetLineBreakpointProperties dotNetLineBreakpointProperties = this;
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl3 = false;
        for (Object t : iterable2) {
            rangeMarker = (RangeMarker)t;
            collection = collection2;
            bl = false;
            RangeMarker rangeMarker2 = rangeMarker;
            collection.add(rangeMarker2 != null ? rangeMarker2.getStartOffset() : -1);
        }
        dotNetLineBreakpointProperties.startOffsets = CollectionsKt.toMutableList((Collection)((List)collection2));
        iterable = this.rangeMarkers;
        dotNetLineBreakpointProperties = this;
        bl2 = false;
        iterable2 = iterable;
        collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        bl3 = false;
        for (Object t : iterable2) {
            rangeMarker = (RangeMarker)t;
            collection = collection2;
            bl = false;
            RangeMarker rangeMarker3 = rangeMarker;
            collection.add(rangeMarker3 != null ? rangeMarker3.getEndOffset() : -1);
        }
        dotNetLineBreakpointProperties.endOffsets = CollectionsKt.toMutableList((Collection)((List)collection2));
    }

    private final void r() {
        int n = this.startOffsets.size();
        if (this.endOffsets.size() != n) {
            logger.error("Breakpoint " + this + " has mismatching offsets arrays: start offsets size is " + n + ", end offsets size is " + this.endOffsets.size());
            n = Math.min(n, this.endOffsets.size());
        }
        List list2 = new ArrayList();
        int n2 = n;
        for (int j = 0; j < n2; ++j) {
            Document document;
            VirtualFile virtualFile;
            int n3 = ((Number)this.startOffsets.get(j)).intValue();
            int n4 = ((Number)this.endOffsets.get(j)).intValue();
            if (VfsUtil.findFileByIoFile((File)new File(this.filename), (boolean)true) == null) {
                return;
            }
            if (FileDocumentManager.getInstance().getDocument(virtualFile) == null) {
                return;
            }
            list2.add((0 <= n3 ? n3 < n4 : false) && n4 <= document.getTextLength() ? document.createRangeMarker(n3, n4) : null);
        }
        this.rangeMarkers = list2;
    }

    @Nullable
    public final TextRange getTextRange() {
        if (this.rangeMarkers.size() != 1) {
            return null;
        }
        RangeMarker rangeMarker = (RangeMarker)CollectionsKt.first(this.rangeMarkers);
        if (rangeMarker == null) {
            return null;
        }
        RangeMarker rangeMarker2 = rangeMarker;
        return rangeMarker2.getTextRange();
    }

    @NotNull
    public final List<BreakpointElement> getBreakpointElements(@NotNull XLineBreakpoint<?> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        return (List)ActionsKt.runReadAction(() -> DotNetLineBreakpointProperties.G(this, breakpoint));
    }

    @NotNull
    public String toString() {
        return "(" + this.filename + ": - " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.filterNotNull((Iterable)this.rangeMarkers), (CharSequence)", ", null, null, (int)0, null, DotNetLineBreakpointProperties::G, (int)30, null) + ")";
    }

    private final void G() {
        this.startOffsets.clear();
        this.endOffsets.clear();
        this.rangeMarkers.clear();
    }

    public final void setVariant(@NotNull DotNetLineBreakpointType.DotNetBreakpointVariant variant) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)variant), (String)"variant");
            this.G();
            TextRange textRange = variant.getHighlightRange();
            if (textRange == null) break block0;
            TextRange textRange2 = textRange;
            boolean bl = false;
            ActionsKt.runReadAction(() -> DotNetLineBreakpointProperties.G(variant, textRange2, this));
        }
    }

    private static final List G(DotNetLineBreakpointProperties dotNetLineBreakpointProperties, XLineBreakpoint xLineBreakpoint) {
        int n = dotNetLineBreakpointProperties.startOffsets.size();
        if (dotNetLineBreakpointProperties.endOffsets.size() != n) {
            logger.error("Breakpoint " + dotNetLineBreakpointProperties + " has mismatching offsets arrays: start offsets size is " + n + ", end offsets size is " + dotNetLineBreakpointProperties.endOffsets.size());
            n = Math.min(n, dotNetLineBreakpointProperties.endOffsets.size());
        }
        if (dotNetLineBreakpointProperties.rangeMarkers.size() != n) {
            logger.error("Breakpoint " + dotNetLineBreakpointProperties + " has mismatching sizes: start offsets size is " + n + ", range markers size is " + dotNetLineBreakpointProperties.endOffsets.size());
            n = Math.min(n, dotNetLineBreakpointProperties.rangeMarkers.size());
        }
        if (n == 0) {
            XSourcePosition xSourcePosition = xLineBreakpoint.getSourcePosition();
            if (xSourcePosition == null) {
                return CollectionsKt.emptyList();
            }
            XSourcePosition xSourcePosition2 = xSourcePosition;
            String string = xSourcePosition2.getFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String string2 = string;
            if (((CharSequence)string2).length() == 0) {
                return CollectionsKt.emptyList();
            }
            return CollectionsKt.listOf((Object)new BreakpointElement(string2, xLineBreakpoint.getLine(), 0, dotNetLineBreakpointProperties.isMultiMethodBreakpoint));
        }
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)n);
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl3 = false;
        Iterator iterator2 = iterable3.iterator();
        while (iterator2.hasNext()) {
            BreakpointElement breakpointElement;
            int n2;
            int n3 = n2 = ((IntIterator)iterator2).nextInt();
            boolean bl4 = false;
            int n4 = n3;
            boolean bl5 = false;
            RangeMarker rangeMarker = dotNetLineBreakpointProperties.rangeMarkers.get(n4);
            if (rangeMarker == null || !rangeMarker.isValid()) {
                breakpointElement = new BreakpointElement(dotNetLineBreakpointProperties.filename, xLineBreakpoint.getLine(), 0, dotNetLineBreakpointProperties.isMultiMethodBreakpoint);
            } else {
                Document document;
                VirtualFile virtualFile;
                int n5 = rangeMarker.getStartOffset();
                if (VfsUtil.findFileByIoFile((File)new File(dotNetLineBreakpointProperties.filename), (boolean)true) == null) {
                    breakpointElement = new BreakpointElement(dotNetLineBreakpointProperties.filename, xLineBreakpoint.getLine(), 0, dotNetLineBreakpointProperties.isMultiMethodBreakpoint);
                } else if (FileDocumentManager.getInstance().getDocument(virtualFile) == null) {
                    breakpointElement = new BreakpointElement(dotNetLineBreakpointProperties.filename, xLineBreakpoint.getLine(), 0, dotNetLineBreakpointProperties.isMultiMethodBreakpoint);
                } else if (document.getLineCount() <= xLineBreakpoint.getLine()) {
                    breakpointElement = null;
                } else {
                    int n6 = document.getLineStartOffset(xLineBreakpoint.getLine());
                    int n7 = n5 - n6;
                    breakpointElement = new BreakpointElement(dotNetLineBreakpointProperties.filename, xLineBreakpoint.getLine(), n7 > 0 ? n7 : 0, dotNetLineBreakpointProperties.isMultiMethodBreakpoint);
                }
            }
            if (breakpointElement == null) continue;
            BreakpointElement breakpointElement2 = breakpointElement;
            boolean bl6 = false;
            collection.add(breakpointElement2);
        }
        return CollectionsKt.distinct((Iterable)((List)collection));
    }

    private static final CharSequence G(RangeMarker rangeMarker) {
        Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"it");
        return "[" + rangeMarker.getStartOffset() + ", " + rangeMarker.getEndOffset() + "]";
    }

    private static final Unit G(DotNetLineBreakpointType.DotNetBreakpointVariant dotNetBreakpointVariant, TextRange textRange, DotNetLineBreakpointProperties dotNetLineBreakpointProperties) {
        Document document = FileDocumentManager.getInstance().getDocument(dotNetBreakpointVariant.getFile());
        if (document == null) {
            return Unit.INSTANCE;
        }
        Document document2 = document;
        int n = textRange.getEndOffset();
        int n2 = textRange.getStartOffset();
        if (!(0 <= n2 ? n2 < n : false) || textRange.getEndOffset() > document2.getTextLength()) {
            return Unit.INSTANCE;
        }
        RangeMarker rangeMarker = document2.createRangeMarker(textRange.getStartOffset(), textRange.getEndOffset());
        Intrinsics.checkNotNull((Object)rangeMarker);
        RangeMarker rangeMarker2 = rangeMarker;
        dotNetLineBreakpointProperties.startOffsets.add(textRange.getStartOffset());
        dotNetLineBreakpointProperties.endOffsets.add(textRange.getEndOffset());
        dotNetLineBreakpointProperties.rangeMarkers.add(rangeMarker2);
        return Unit.INSTANCE;
    }

    public DotNetLineBreakpointProperties() {
        this(false, 0, null, false, 15, null);
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(DotNetLineBreakpointProperties.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JR\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u000fJ\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties$Companion;", "", "DotNetLineBreakpointProperties$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "create", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties;", "canonicalDocumentPath", "", "containingFunctionPresentation", "startOffset", "", "endOffset", "hitCountFilterEnabled", "", "hitCount", "hitCountMode", "Lcom/jetbrains/rider/debugger/breakpoint/BreakpointHitCountMode;", "multiMethodBreakpoint", "G", "fileName", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nDotNetLineBreakpointProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetLineBreakpointProperties.kt\ncom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties$Companion\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,227:1\n13#2:228\n15#3:229\n84#3,2:230\n86#3:233\n1#4:232\n*S KotlinDebug\n*F\n+ 1 DotNetLineBreakpointProperties.kt\ncom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties$Companion\n*L\n57#1:228\n57#1:229\n57#1:230,2\n57#1:233\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DotNetLineBreakpointProperties create(@NotNull String canonicalDocumentPath, @Nls @Nullable String containingFunctionPresentation, int startOffset, int endOffset, boolean hitCountFilterEnabled, int hitCount, @NotNull BreakpointHitCountMode hitCountMode, boolean multiMethodBreakpoint) {
            Intrinsics.checkNotNullParameter((Object)canonicalDocumentPath, (String)"canonicalDocumentPath");
            Intrinsics.checkNotNullParameter((Object)((Object)hitCountMode), (String)"hitCountMode");
            return (DotNetLineBreakpointProperties)((Object)ActionsKt.runReadAction(() -> Companion.G(hitCountFilterEnabled, hitCount, hitCountMode, multiMethodBreakpoint, startOffset, endOffset, canonicalDocumentPath, containingFunctionPresentation)));
        }

        public static /* synthetic */ DotNetLineBreakpointProperties create$default(Companion companion, String string, String string2, int n, int n2, boolean bl, int n3, BreakpointHitCountMode breakpointHitCountMode, boolean bl2, int n4, Object object) {
            if ((n4 & 0x10) != 0) {
                bl = false;
            }
            if ((n4 & 0x20) != 0) {
                n3 = 0;
            }
            if ((n4 & 0x40) != 0) {
                breakpointHitCountMode = BreakpointHitCountMode.LessThan;
            }
            if ((n4 & 0x80) != 0) {
                bl2 = false;
            }
            return companion.create(string, string2, n, n2, bl, n3, breakpointHitCountMode, bl2);
        }

        private final String G(String string) {
            boolean bl = false;
            boolean bl2 = false;
            Logger logger2 = Logger.getInstance(DotNetBreakpointProperties.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            Logger logger3 = logger2;
            bl2 = false;
            Logger logger4 = logger3;
            try {
                Logger logger5 = logger4;
                boolean bl3 = false;
                boolean bl4 = false;
                File file2 = DocumentUtilKt.toIOFile((String)string);
                boolean bl5 = false;
                String string2 = file2.isAbsolute() ? file2.getAbsolutePath() : file2.getPath();
                CharSequence charSequence = string2;
                return charSequence == null || charSequence.length() == 0 ? string : string2;
            }
            catch (Throwable throwable) {
                String string3 = (String)LoggerKt.getOrLogException((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)), (Logger)logger3);
                if (string3 == null) {
                    string3 = string;
                }
                return string3;
            }
        }

        private static final DotNetLineBreakpointProperties G(boolean bl, int n, BreakpointHitCountMode breakpointHitCountMode, boolean bl2, int n2, int n3, String string, String string2) {
            DotNetLineBreakpointProperties dotNetLineBreakpointProperties = new DotNetLineBreakpointProperties(bl, n, breakpointHitCountMode, bl2);
            Integer[] integerArray = new Integer[]{n2};
            dotNetLineBreakpointProperties.startOffsets = CollectionsKt.mutableListOf((Object[])integerArray);
            integerArray = new Integer[]{n3};
            dotNetLineBreakpointProperties.endOffsets = CollectionsKt.mutableListOf((Object[])integerArray);
            dotNetLineBreakpointProperties.setFilename(Companion.G(string));
            dotNetLineBreakpointProperties.setContainingFunctionPresentation(string2);
            Integer[] integerArray2 = VfsUtil.findFileByIoFile((File)new File(string), (boolean)true);
            if (integerArray2 == null) {
                return dotNetLineBreakpointProperties;
            }
            integerArray = integerArray2;
            Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)integerArray);
            if (document == null) {
                return dotNetLineBreakpointProperties;
            }
            Document document2 = document;
            RangeMarker rangeMarker = (0 <= n2 ? n2 < n3 : false) && n3 <= document2.getTextLength() ? document2.createRangeMarker(n2, n3) : null;
            Object[] objectArray = new RangeMarker[]{rangeMarker};
            dotNetLineBreakpointProperties.rangeMarkers = CollectionsKt.mutableListOf((Object[])objectArray);
            return dotNetLineBreakpointProperties;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

