/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.attach.remoting.tools.local;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.debugger.attach.remoting.DebuggerFiles;
import com.jetbrains.rider.debugger.attach.remoting.tools.local.LocalDebuggerTools;
import com.jetbrains.rider.debugger.attach.remoting.tools.url.RemoteDebuggerToolsUrl;
import com.jetbrains.rider.debugger.attach.remoting.tools.url.providers.DebuggerToolsUrlProvider;
import com.jetbrains.rider.model.RdShellModel;
import com.jetbrains.rider.model.RdShellModel_PregeneratedKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\tH\u0002J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/debugger/attach/remoting/tools/local/DefaultLocalDebuggerTools;", "Lcom/jetbrains/rider/debugger/attach/remoting/tools/local/LocalDebuggerTools;", "project", "Lcom/intellij/openapi/project/Project;", "cpuKind", "Lcom/jetbrains/rider/CPUKind;", "DefaultLocalDebuggerTools", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/CPUKind;)V", "getDirectory", "Ljava/io/File;", "exist", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "G", "getDownloadUrl", "Lcom/jetbrains/rider/debugger/attach/remoting/tools/url/RemoteDebuggerToolsUrl;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getCpuKind", "intellij.rider"})
public final class DefaultLocalDebuggerTools
implements LocalDebuggerTools {
    @NotNull
    private final Project project;
    @NotNull
    private final CPUKind cpuKind;

    public DefaultLocalDebuggerTools(@NotNull Project project, @NotNull CPUKind cpuKind) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cpuKind, (String)"cpuKind");
        this.project = project;
        this.cpuKind = cpuKind;
    }

    @Override
    @NotNull
    public File getDirectory() {
        RdShellModel rdShellModel = RdShellModel_PregeneratedKt.getRdShellModel((IProtocol)ApplicationProtocolKt.getProtocol((Project)this.project));
        String string = (String)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)rdShellModel.getWaveMarketingName()));
        File file2 = this.G();
        return new File(new File(new File(new File(file2, "JetBrains"), "RiderRemoteDebugger"), string), this.cpuKind.name());
    }

    @Override
    @Nullable
    public Object exist(@NotNull Continuation<? super Boolean> $completion) {
        File file2 = this.getDirectory();
        return Boxing.boxBoolean((file2.isDirectory() && new File(file2, DebuggerFiles.INSTANCE.getENUMERATOR_RUNTIME_CONFIG_FILE_NAME()).isFile() && new File(file2, DebuggerFiles.INSTANCE.getENUMERATOR_DEPS_FILE_NAME()).isFile() && new File(file2, DebuggerFiles.INSTANCE.getDEBUGGER_RUNTIME_CONFIG_FILE_NAME()).isFile() && new File(file2, DebuggerFiles.INSTANCE.getDEBUGGER_DEPS_FILE_NAME()).isFile() ? 1 : 0) != 0);
    }

    private final File G() {
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            return new File(FileUtil.getTempDirectory());
        }
        return SystemInfo.isWindows ? new File(System.getenv("LOCALAPPDATA")) : new File(new File(new File(System.getProperty("user.home")), ".local"), "share");
    }

    @Override
    @Nullable
    public RemoteDebuggerToolsUrl getDownloadUrl(@Nullable ProgressIndicator indicator) {
        return DebuggerToolsUrlProvider.Companion.get(this.cpuKind, indicator);
    }

    @Override
    @NotNull
    public CPUKind getCpuKind() {
        return this.cpuKind;
    }
}

