/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.attach.remoting.machines;

import com.intellij.remote.RemoteCredentials;
import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.debugger.attach.remoting.SshExtKt;
import com.jetbrains.rider.debugger.attach.remoting.machines.RemoteMacMachine;
import com.jetbrains.rider.debugger.attach.remoting.machines.RemoteMachine;
import com.jetbrains.rider.debugger.attach.remoting.machines.RemoteMachineUtil;
import com.jetbrains.rider.debugger.attach.remoting.ssh.SshExecutor;
import com.jetbrains.rider.util.OSKind;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\tH\u0014J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0014J\u000e\u0010\r\u001a\u00020\u000eH\u0094@\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/debugger/attach/remoting/machines/RemoteMacMachine;", "Lcom/jetbrains/rider/debugger/attach/remoting/machines/RemoteMachine;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "credentials", "Lcom/intellij/remote/RemoteCredentials;", "RemoteMacMachine", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/remote/RemoteCredentials;)V", "getAppDataCmd", "", "getHomeCmd", "getFileExistsCmd", "path", "determineCpuKind", "Lcom/jetbrains/rider/CPUKind;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hasQuarantineAttribute", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeQuarantineAttribute", "", "intellij.rider"})
public final class RemoteMacMachine
extends RemoteMachine {
    public RemoteMacMachine(@NotNull CoroutineScope scope, @NotNull RemoteCredentials credentials) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        super(scope, credentials, OSKind.MacOS);
    }

    @Override
    @NotNull
    protected String getAppDataCmd() {
        return "echo $HOME/.local/share";
    }

    @Override
    @NotNull
    protected String getHomeCmd() {
        return "echo $HOME";
    }

    @Override
    @NotNull
    protected String getFileExistsCmd(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return "test -f " + SshExtKt.shellQuote(path, this.getOsKind()) + " && echo \"Yes, there is such file\" ||:";
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    protected Object determineCpuKind(@NotNull Continuation<? super CPUKind> $completion) {
        if (!($completion instanceof determineCpuKind.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            var4_2 = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ RemoteMacMachine this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.determineCpuKind((Continuation<? super CPUKind>)((Continuation)this));
                }
            };
        }
        var3_3 = var4_2.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var4_2.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)var3_3);
                var4_2.label = 1;
                v0 = RemoteMachineUtil.execCmdOrThrow$default(RemoteMachineUtil.INSTANCE, this, "uname -m", 0L, "detect remote CPU type", (Continuation)var4_2, 2, null);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)var3_3);
                v0 = var3_3;
lbl20:
                // 2 sources

                var2_5 = ((SshExecutor.RemoteExecutionResult)v0).getOutput();
                RemoteMachine.getLogger().info("Output of 'uname -m' command: \"" + StringsKt.trim((CharSequence)var2_5).toString() + "\"");
                return StringsKt.contains$default((CharSequence)var2_5, (CharSequence)"x86_64", (boolean)false, (int)2, null) != false ? CPUKind.MacOs64 : CPUKind.MacOsArm;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object hasQuarantineAttribute(@NotNull String var1_1, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof hasQuarantineAttribute.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            var5_3 = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ RemoteMacMachine this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.hasQuarantineAttribute(null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        var4_4 = var5_3.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var5_3.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)var4_4);
                RemoteMachine.getLogger().info("Verifying quarantine info");
                var5_3.label = 1;
                v0 = RemoteMachineUtil.execCmd$default(RemoteMachineUtil.INSTANCE, this, "xattr " + SshExtKt.shellQuote((String)path, this.getOsKind()), 0L, "check quarantine attribute", (Continuation)var5_3, 2, null);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                ResultKt.throwOnFailure((Object)var4_4);
                v0 = var4_4;
lbl22:
                // 2 sources

                var3_6 = ((SshExecutor.RemoteExecutionResult)v0).getOutput();
                RemoteMachine.getLogger().info("Quarantine cmd output: " + var3_6);
                return Boxing.boxBoolean((boolean)StringsKt.contains$default((CharSequence)var3_6, (CharSequence)"com.apple.quarantine", (boolean)false, (int)2, null));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object removeQuarantineAttribute(@NotNull String path, @NotNull Continuation<? super Unit> $completion) {
        Object object = RemoteMachineUtil.execCmdOrThrow$default(RemoteMachineUtil.INSTANCE, this, "xattr -d -r com.apple.quarantine " + SshExtKt.shellQuote(path, this.getOsKind()), 0L, "remove quarantine attribute", $completion, 2, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

