/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.attach.remoting.errors;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.remote.RemoteCredentials;
import com.intellij.xdebugger.impl.ui.attach.dialog.diagnostics.ProcessesFetchingProblemAction;
import com.jetbrains.rider.debugger.attach.remoting.errors.RemoteDebugActionsOnErrorKt;
import com.jetbrains.rider.debugger.attach.remoting.errors.RemoteDebugErrorDescription;
import com.jetbrains.rider.debugger.attach.remoting.errors.RemoteDebuggerProcessException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/debugger/attach/remoting/errors/ProcessEnumeratorFailedError;", "Lcom/jetbrains/rider/debugger/attach/remoting/errors/RemoteDebugErrorDescription;", "project", "Lcom/intellij/openapi/project/Project;", "credentials", "Lcom/intellij/remote/RemoteCredentials;", "exception", "Lcom/jetbrains/rider/debugger/attach/remoting/errors/RemoteDebuggerProcessException;", "ProcessEnumeratorFailedError", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/remote/RemoteCredentials;Lcom/jetbrains/rider/debugger/attach/remoting/errors/RemoteDebuggerProcessException;)V", "getShortMessage", "", "getFullMessage", "getAction", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/diagnostics/ProcessesFetchingProblemAction;", "isAuthenticationProblem", "", "()Z", "intellij.rider"})
public final class ProcessEnumeratorFailedError
extends RemoteDebugErrorDescription {
    @NotNull
    private final RemoteDebuggerProcessException exception;
    private final boolean isAuthenticationProblem;

    public ProcessEnumeratorFailedError(@NotNull Project project, @NotNull RemoteCredentials credentials, @NotNull RemoteDebuggerProcessException exception) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        super(project, credentials);
        this.exception = exception;
    }

    @Override
    @NotNull
    public String getShortMessage() {
        String string = this.exception.getMessage();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public String getFullMessage() {
        HtmlChunk.Element element = HtmlChunk.html();
        HtmlChunk.Element element2 = HtmlChunk.div((String)"text-align: center");
        String string = this.exception.getMessage();
        if (string == null) {
            string = "";
        }
        String string2 = element.child((HtmlChunk)element2.addText(string)).child((HtmlChunk)HtmlChunk.div((String)"text-align: left; font-family: monospace").addText("$ " + this.exception.getProcess() + "\n" + this.exception.getStderr() + "<exited with code " + this.exception.getExitCode() + ">")).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @Override
    @NotNull
    public ProcessesFetchingProblemAction getAction() {
        return RemoteDebugActionsOnErrorKt.contactSupportAction();
    }

    @Override
    public boolean isAuthenticationProblem() {
        return this.isAuthenticationProblem;
    }
}

