/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.attach.remoting;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.xdebugger.attach.XAttachHostPresentationGroup;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.attach.remoting.RiderSshAttachHost;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J \u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u0012\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/debugger/attach/remoting/RiderSshRemoteGroup;", "Lcom/intellij/xdebugger/attach/XAttachHostPresentationGroup;", "Lcom/jetbrains/rider/debugger/attach/remoting/RiderSshAttachHost;", "RiderSshRemoteGroup", "()V", "getProcessIcon", "Ljavax/swing/Icon;", "project", "Lcom/intellij/openapi/project/Project;", "info", "dataHolder", "Lcom/intellij/openapi/util/UserDataHolder;", "getProcessDisplayText", "", "getOrder", "", "getGroupName", "getItemIcon", "getItemDisplayText", "compare", "a", "b", "intellij.rider"})
public final class RiderSshRemoteGroup
implements XAttachHostPresentationGroup<RiderSshAttachHost> {
    @NotNull
    public static final RiderSshRemoteGroup INSTANCE = new RiderSshRemoteGroup();

    private RiderSshRemoteGroup() {
    }

    @NotNull
    public Icon getProcessIcon(@NotNull Project project, @NotNull RiderSshAttachHost info, @NotNull UserDataHolder dataHolder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)dataHolder, (String)"dataHolder");
        return this.getItemIcon(project, info, dataHolder);
    }

    @NotNull
    public String getProcessDisplayText(@NotNull Project project, @NotNull RiderSshAttachHost info, @NotNull UserDataHolder dataHolder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)dataHolder, (String)"dataHolder");
        return this.getItemDisplayText(project, info, dataHolder);
    }

    public int getOrder() {
        return 0;
    }

    @NotNull
    public String getGroupName() {
        return RiderDebuggerBundle.Companion.message("RiderSshRemoteGroup.group.name.remote.hosts", new Object[0]);
    }

    @NotNull
    public Icon getItemIcon(@NotNull Project project, @NotNull RiderSshAttachHost info, @NotNull UserDataHolder dataHolder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)dataHolder, (String)"dataHolder");
        Icon icon = AllIcons.RunConfigurations.Remote;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Remote");
        return icon;
    }

    @NotNull
    public String getItemDisplayText(@NotNull Project project, @NotNull RiderSshAttachHost info, @NotNull UserDataHolder dataHolder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)dataHolder, (String)"dataHolder");
        return info.getCredentials().getUserName() + "@" + info.getHost() + ":" + info.getPort();
    }

    public int compare(@NotNull RiderSshAttachHost a, @NotNull RiderSshAttachHost b) {
        int n;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!Intrinsics.areEqual((Object)a.getHost(), (Object)b.getHost())) {
            n = a.getHost().compareTo(b.getHost());
        } else if (a.getPort() != b.getPort()) {
            n = Intrinsics.compare((int)a.getPort(), (int)b.getPort());
        } else {
            String string;
            String string2 = a.getCredentials().getUserName();
            if (string2 == null) {
                string2 = "";
            }
            if ((string = b.getCredentials().getUserName()) == null) {
                string = "";
            }
            n = string2.compareTo(string);
        }
        return n;
    }
}

