/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.actions.handlers;

import com.intellij.openapi.util.TextRange;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.model.debuggerWorker.SmartStepIntoElementProxy;
import com.jetbrains.rider.model.debuggerWorker.SmartStepIntoInfoProxy;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/debugger/actions/handlers/RiderSmartStepIntoVariant;", "Lcom/intellij/xdebugger/stepping/XSmartStepIntoVariant;", "index", "", "infoProxy", "Lcom/jetbrains/rider/model/debuggerWorker/SmartStepIntoInfoProxy;", "RiderSmartStepIntoVariant", "(ILcom/jetbrains/rider/model/debuggerWorker/SmartStepIntoInfoProxy;)V", "getIndex", "()I", "getInfoProxy", "()Lcom/jetbrains/rider/model/debuggerWorker/SmartStepIntoInfoProxy;", "getText", "", "getHighlightRange", "Lcom/intellij/openapi/util/TextRange;", "getDescription", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderNewSmartStepIntoHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderNewSmartStepIntoHandler.kt\ncom/jetbrains/rider/debugger/actions/handlers/RiderSmartStepIntoVariant\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
public final class RiderSmartStepIntoVariant
extends XSmartStepIntoVariant {
    private final int index;
    @NotNull
    private final SmartStepIntoInfoProxy infoProxy;

    public RiderSmartStepIntoVariant(int index, @NotNull SmartStepIntoInfoProxy infoProxy) {
        Intrinsics.checkNotNullParameter((Object)infoProxy, (String)"infoProxy");
        this.index = index;
        this.infoProxy = infoProxy;
    }

    public final int getIndex() {
        return this.index;
    }

    @NotNull
    public final SmartStepIntoInfoProxy getInfoProxy() {
        return this.infoProxy;
    }

    @NotNull
    public String getText() {
        String string = ((SmartStepIntoElementProxy)this.infoProxy.getElements().get(this.index)).getPresentation();
        if (string == null) {
            string = ((SmartStepIntoElementProxy)this.infoProxy.getElements().get(this.index)).getIdentifier();
        }
        return string;
    }

    @NotNull
    public TextRange getHighlightRange() {
        boolean bl;
        int n = ((SmartStepIntoElementProxy)this.infoProxy.getElements().get(this.index)).getDocumentStartOffset();
        int n2 = ((SmartStepIntoElementProxy)this.infoProxy.getElements().get(this.index)).getDocumentEndOffset();
        boolean bl2 = bl = n >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Smart step into variant should have non-negative start offset";
            throw new AssertionError((Object)string);
        }
        boolean bl4 = bl = n2 >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Smart step into variant should have non-negative end offset";
            throw new AssertionError((Object)string);
        }
        boolean bl6 = bl = n < n2;
        if (_Assertions.ENABLED && !bl) {
            boolean bl7 = false;
            String string = "Start offset should be less than end offset, actual range (" + n + ", " + n2 + ")";
            throw new AssertionError((Object)string);
        }
        return new TextRange(n, n2);
    }

    @Nullable
    public String getDescription() {
        if (this.index >= this.infoProxy.getCurrentIndex()) {
            return null;
        }
        return RiderDebuggerBundle.Companion.message("RiderSmartStepIntoVariant.description.execute.again", new Object[0]);
    }
}

