/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.actions.handlers;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.actions.XDebuggerSuspendedActionHandler;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.DotNetExecutionStack;
import com.jetbrains.rider.debugger.DotnetDebuggerExtKt;
import com.jetbrains.rider.debugger.actions.handlers.IRiderActionEnabledChecker;
import com.jetbrains.rider.debugger.util.DotNetDebugProcessUtilKt;
import com.jetbrains.rider.debugger.util.JumpToStatementUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/debugger/actions/handlers/RiderJumpToStatementHandler;", "Lcom/intellij/xdebugger/impl/actions/XDebuggerSuspendedActionHandler;", "Lcom/jetbrains/rider/debugger/actions/handlers/IRiderActionEnabledChecker;", "RiderJumpToStatementHandler", "()V", "isEnabled", "", "session", "Lcom/intellij/xdebugger/XDebugSession;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isHidden", "project", "Lcom/intellij/openapi/project/Project;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "perform", "", "intellij.rider"})
public final class RiderJumpToStatementHandler
extends XDebuggerSuspendedActionHandler
implements IRiderActionEnabledChecker {
    protected boolean isEnabled(@NotNull XDebugSession session, @NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        if (!XDebuggerSuspendedActionHandler.isEnabled((XDebugSession)session) || !super.isEnabled(session, dataContext2)) {
            return false;
        }
        DotNetDebugProcess dotNetDebugProcess = DotnetDebuggerExtKt.getDotnetDebugProcess(session);
        if (!(dotNetDebugProcess != null ? DotNetDebugProcessUtilKt.canSetNextStatement(dotNetDebugProcess) : false)) {
            return false;
        }
        XDebugSessionImpl xDebugSessionImpl = session instanceof XDebugSessionImpl ? (XDebugSessionImpl)session : null;
        XExecutionStack xExecutionStack = xDebugSessionImpl != null ? xDebugSessionImpl.getCurrentExecutionStack() : null;
        DotNetExecutionStack dotNetExecutionStack = xExecutionStack instanceof DotNetExecutionStack ? (DotNetExecutionStack)xExecutionStack : null;
        if (dotNetExecutionStack == null) {
            return false;
        }
        DotNetExecutionStack dotNetExecutionStack2 = dotNetExecutionStack;
        XSourcePosition xSourcePosition = XDebuggerUtilImpl.getCaretPosition((Project)((XDebugSessionImpl)session).getProject(), (DataContext)dataContext2);
        if (xSourcePosition == null) {
            return false;
        }
        XSourcePosition xSourcePosition2 = xSourcePosition;
        return JumpToStatementUtilKt.canJumpToStatement(xSourcePosition2, dotNetExecutionStack2);
    }

    public boolean isHidden(@NotNull Project project, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if ((xDebugSession != null ? DotnetDebuggerExtKt.getDotnetDebugProcess(xDebugSession) : null) == null) {
            return true;
        }
        return super.isHidden(project, event);
    }

    protected void perform(@NotNull XDebugSession session, @NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        DotNetDebugProcess dotNetDebugProcess = DotnetDebuggerExtKt.getDotnetDebugProcess(session);
        if (dotNetDebugProcess == null) {
            return;
        }
        DotNetDebugProcess dotNetDebugProcess2 = dotNetDebugProcess;
        XSourcePosition xSourcePosition = XDebuggerUtilImpl.getCaretPosition((Project)session.getProject(), (DataContext)dataContext2);
        if (xSourcePosition != null) {
            dotNetDebugProcess2.setNextStatement$intellij_rider(xSourcePosition);
        }
    }
}

