/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.actions;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.rider.debugger.DebuggerInitializingState;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.DotnetDebuggerExtKt;
import com.jetbrains.rider.debugger.wasm.client.WasmClientRunProfile;
import kotlin.Metadata;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a8\u0006\t"}, d2={"isDebuggerActionEnabled", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isWasmClientProfile", "getCurrentSession", "Lcom/intellij/xdebugger/XDebugSession;", "getCurrentProcess", "Lcom/jetbrains/rider/debugger/DotNetDebugProcess;", "intellij.rider"})
public final class RiderDebuggerActionEnabledUtilsKt {
    public static final boolean isDebuggerActionEnabled(@Nullable AnActionEvent e) {
        DotNetDebugProcess dotNetDebugProcess = RiderDebuggerActionEnabledUtilsKt.getCurrentProcess(e);
        if (dotNetDebugProcess == null) {
            return true;
        }
        DotNetDebugProcess dotNetDebugProcess2 = dotNetDebugProcess;
        return dotNetDebugProcess2.getInitializeDebuggerTask().getDebuggerInitializingState().getValue() == DebuggerInitializingState.Initialized;
    }

    public static final boolean isWasmClientProfile(@Nullable AnActionEvent e) {
        AnActionEvent anActionEvent = e;
        return (anActionEvent != null ? (RunProfile)anActionEvent.getData(LangDataKeys.RUN_PROFILE) : null) instanceof WasmClientRunProfile;
    }

    @Nullable
    public static final XDebugSession getCurrentSession(@Nullable AnActionEvent e) {
        AnActionEvent anActionEvent = e;
        if (anActionEvent == null || (anActionEvent = anActionEvent.getProject()) == null) {
            return null;
        }
        AnActionEvent anActionEvent2 = anActionEvent;
        return XDebuggerManager.getInstance((Project)anActionEvent2).getCurrentSession();
    }

    @Nullable
    public static final DotNetDebugProcess getCurrentProcess(@Nullable AnActionEvent e) {
        XDebugSession xDebugSession = RiderDebuggerActionEnabledUtilsKt.getCurrentSession(e);
        return xDebugSession != null ? DotnetDebuggerExtKt.getDotnetDebugProcess(xDebugSession) : null;
    }
}

