/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.access;

import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.access.RiderDebugWritingAccessProvider;
import com.jetbrains.rider.debugger.settings.DotNetDebuggerSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\b\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u000b"}, d2={"getDebuggerReadonlyFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "G", "", "G", "Lcom/intellij/openapi/ui/MessageDialogBuilder$YesNo;", "G", "", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderDebugWritingAccessManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDebugWritingAccessManager.kt\ncom/jetbrains/rider/debugger/access/RiderDebugWritingAccessManagerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n774#2:188\n865#2,2:189\n*S KotlinDebug\n*F\n+ 1 RiderDebugWritingAccessManager.kt\ncom/jetbrains/rider/debugger/access/RiderDebugWritingAccessManagerKt\n*L\n125#1:188\n125#1:189,2\n*E\n"})
public final class RiderDebugWritingAccessManagerKt {
    @NotNull
    public static final List<VirtualFile> getDebuggerReadonlyFiles(@NotNull List<? extends VirtualFile> $this$getDebuggerReadonlyFiles, @NotNull Project project) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$getDebuggerReadonlyFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (DotNetDebuggerSettings.Companion.getInstance().getAllowTypingDuringDebug()) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = $this$getDebuggerReadonlyFiles;
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl3 = false;
        for (Object t : iterable2) {
            VirtualFile virtualFile = (VirtualFile)t;
            boolean bl4 = false;
            if (!RiderDebugWritingAccessManagerKt.G(virtualFile, project)) continue;
            collection.add(t);
        }
        List list2 = (List)collection;
        if (DotNetDebuggerSettings.Companion.getInstance().getDontShowWritePermissionDialog()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list2;
        }
        boolean bl5 = bl = !RiderDebugWritingAccessManagerKt.G().ask(project);
        if (!bl || DotNetDebuggerSettings.Companion.getInstance().getDontShowWritePermissionDialog()) {
            RiderDebugWritingAccessManagerKt.G(project);
        }
        if (!bl) {
            DotNetDebuggerSettings.Companion.getInstance().setAllowTypingDuringDebug(true);
            return CollectionsKt.emptyList();
        }
        return list2;
    }

    private static final boolean G(VirtualFile virtualFile, Project project) {
        List list2 = RiderDebugWritingAccessProvider.Companion.getEP_NAME().getExtensions((AreaInstance)project);
        for (RiderDebugWritingAccessProvider riderDebugWritingAccessProvider : list2) {
            ThreeState threeState = riderDebugWritingAccessProvider.isReadonly(virtualFile);
            if (threeState == ThreeState.UNSURE) continue;
            return threeState.toBoolean();
        }
        return false;
    }

    private static final MessageDialogBuilder.YesNo G() {
        return (MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(RiderDebuggerBundle.Companion.message("RiderDebugWritingAccessManager.dialog.title.write.access.is.denied", new Object[0]), RiderDebuggerBundle.Companion.message("RiderDebugWritingAccessManager.dialog.message.allow.typing", new Object[0])).doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(){

            public boolean isSelectedByDefault() {
                return false;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }

            public void rememberChoice(boolean isSelected, int exitCode) {
                DotNetDebuggerSettings.Companion.getInstance().setDontShowWritePermissionDialog(isSelected);
            }
        });
    }

    private static final void G(Project project) {
        Notification notification2 = new Notification("Read-only mode during debug settings", RiderDebuggerBundle.Companion.message("RiderDebugWritingAccessManager.notification.title.readonly.settings", new Object[0]), RiderDebuggerBundle.Companion.message("RiderDebugWritingAccessManager.notification.content.readonly.settings", new Object[0]), NotificationType.INFORMATION).setListener((NotificationListener)new NotificationListener.Adapter(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            protected void hyperlinkActivated(Notification notification2, HyperlinkEvent e) {
                Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ShowSettingsUtilImpl.Companion.showSettingsDialog(this.$project, "project.propDebugger", RiderDebuggerBundle.Companion.message("DotNetDebuggerSettings.checkbox.allow.editing.in.the.debug.mode", new Object[0]));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"setListener(...)");
        Notification notification3 = notification2;
        notification3.notify(project);
    }
}

