/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ModalityUiUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.frame.XWatchesViewImpl;
import com.intellij.xdebugger.impl.pinned.items.PinToTopValue;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererImpl;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.ide.model.SourcePositionBase;
import com.jetbrains.rd.ide.model.ValueEntityModelBase;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.debugger.DFA.DFAManager;
import com.jetbrains.rider.debugger.DotNetCompoundFrame;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.DotNetExecutionStack;
import com.jetbrains.rider.debugger.DotNetMethodsTracker;
import com.jetbrains.rider.debugger.DotNetNamedValue;
import com.jetbrains.rider.debugger.DotNetSourcePositionWrapper;
import com.jetbrains.rider.debugger.DotNetStackFrame;
import com.jetbrains.rider.debugger.DotNetStackFramePinToTopAdviceMapProviderImpl;
import com.jetbrains.rider.debugger.DotNetValueGroup;
import com.jetbrains.rider.debugger.DotNetValueUtilsKt;
import com.jetbrains.rider.debugger.DotnetDebuggerExtKt;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.evaluation.DebugEvalAdviceProvider;
import com.jetbrains.rider.debugger.evaluation.DotNetEvaluator;
import com.jetbrains.rider.debugger.settings.DotNetDebuggerSettings;
import com.jetbrains.rider.debugger.util.DebuggerWorkerModelUtilKt;
import com.jetbrains.rider.debugger.util.FileUtilsKt;
import com.jetbrains.rider.debugger.util.StackFramesUtilsKt;
import com.jetbrains.rider.model.debuggerWorker.BreakpointId;
import com.jetbrains.rider.model.debuggerWorker.ComputeChildrenArg;
import com.jetbrains.rider.model.debuggerWorker.ExecutionContextProxy;
import com.jetbrains.rider.model.debuggerWorker.FrameKind;
import com.jetbrains.rider.model.debuggerWorker.GroupProxy;
import com.jetbrains.rider.model.debuggerWorker.ObjectProxy;
import com.jetbrains.rider.model.debuggerWorker.RefreshStackFrameArg;
import com.jetbrains.rider.model.debuggerWorker.SourcePositionProxy;
import com.jetbrains.rider.model.debuggerWorker.StackFrameOriginModel;
import com.jetbrains.rider.model.debuggerWorker.StackFrameProxy;
import com.jetbrains.rider.model.debuggerWorker.ValueOriginKind;
import icons.RiderIcons;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 ~2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001~BG\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0018\u00010\u000fR\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0000H\u0016J\n\u00100\u001a\u0004\u0018\u000101H\u0016J\n\u00102\u001a\u0004\u0018\u00010-H\u0002J\u000e\u00103\u001a\u000204H\u0086@\u00a2\u0006\u0002\u00105J)\u00106\u001a\u0004\u0018\u00010-2\u001c\u00107\u001a\u0018\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010-09\u0012\u0006\u0012\u0004\u0018\u00010-08H\u0082\bJ\n\u0010:\u001a\u0004\u0018\u00010-H\u0002J\b\u0010@\u001a\u00020+H\u0002J\u0010\u0010A\u001a\u0004\u0018\u00010BH\u0086@\u00a2\u0006\u0002\u00105J\n\u0010C\u001a\u0004\u0018\u00010BH\u0002J\u000e\u0010D\u001a\u0002042\u0006\u0010E\u001a\u00020$J\b\u0010F\u001a\u000204H\u0002J\u0006\u0010G\u001a\u00020$J\u0012\u0010H\u001a\u00020$2\b\u0010I\u001a\u0004\u0018\u00010JH\u0002J\u0010\u0010K\u001a\u0002042\u0006\u0010L\u001a\u00020MH\u0016J\u0016\u0010K\u001a\u0002042\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020$J\"\u0010O\u001a\u0002042\u0006\u0010L\u001a\u00020M2\b\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010P\u001a\u00020QH\u0002J\u0010\u0010]\u001a\u0002042\u0006\u0010^\u001a\u00020_H\u0016J\u0016\u0010`\u001a\u0002042\f\u0010a\u001a\b\u0012\u0004\u0012\u00020b0ZH\u0002J\b\u0010c\u001a\u00020dH\u0016J\b\u0010e\u001a\u00020fH\u0016J\u0013\u0010g\u001a\u00020$2\b\u0010h\u001a\u0004\u0018\u00010fH\u0096\u0002J\b\u0010i\u001a\u00020jH\u0016J\n\u0010k\u001a\u0004\u0018\u00010lH\u0016J\u0006\u0010o\u001a\u000204J\u0016\u0010p\u001a\u0002042\u0006\u0010q\u001a\u00020$H\u0086@\u00a2\u0006\u0002\u0010rJ\u0010\u0010s\u001a\u0002042\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010t\u001a\u000204H\u0002J\b\u0010u\u001a\u000204H\u0002J\u000f\u0010v\u001a\b\u0012\u0004\u0012\u00020\u00000wH\u0096\u0002J\b\u0010}\u001a\u000204H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR \u0010\u000e\u001a\b\u0018\u00010\u000fR\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001e\u0010'\u001a\u00020\t2\u0006\u0010&\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010;\u001a\n\u0012\u0004\u0012\u00020-\u0018\u0001098BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u0010?\u001a\u0004\b<\u0010=R\u001c\u0010R\u001a\u0004\u0018\u00010SX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR\u001a\u0010X\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020[0Z0YX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\\\u001a\b\u0012\u0004\u0012\u0002040YX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010m\u001a\u00020nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010x\u001a\u0004\u0018\u00010y8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b|\u0010?\u001a\u0004\bz\u0010{\u00a8\u0006\u007f"}, d2={"Lcom/jetbrains/rider/debugger/DotNetStackFrame;", "Lcom/jetbrains/rider/debugger/DotNetCompoundFrame;", "Lcom/intellij/xdebugger/impl/frame/XDebuggerFramesList$ItemWithCustomBackgroundColor;", "Lcom/intellij/xdebugger/impl/pinned/items/PinToTopValue;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "context", "Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;", "proxy", "Lcom/jetbrains/rider/model/debuggerWorker/StackFrameProxy;", "stack", "Lcom/jetbrains/rider/debugger/DotNetExecutionStack;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "methodOccurrence", "Lcom/jetbrains/rider/debugger/DotNetMethodsTracker$MethodOccurrence;", "Lcom/jetbrains/rider/debugger/DotNetMethodsTracker;", "sessionId", "", "DotNetStackFrame", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;Lcom/jetbrains/rider/model/debuggerWorker/StackFrameProxy;Lcom/jetbrains/rider/debugger/DotNetExecutionStack;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/debugger/DotNetMethodsTracker$MethodOccurrence;J)V", "getSession", "()Lcom/intellij/xdebugger/XDebugSession;", "getContext", "()Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;", "getStack", "()Lcom/jetbrains/rider/debugger/DotNetExecutionStack;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getMethodOccurrence", "()Lcom/jetbrains/rider/debugger/DotNetMethodsTracker$MethodOccurrence;", "setMethodOccurrence", "(Lcom/jetbrains/rider/debugger/DotNetMethodsTracker$MethodOccurrence;)V", "getSessionId", "()J", "containsFrame", "", "frame", "value", "frameProxy", "getFrameProxy", "()Lcom/jetbrains/rider/model/debuggerWorker/StackFrameProxy;", "cachedLocation", "", "lazySourcePositionProxy", "Lcom/jetbrains/rider/model/debuggerWorker/SourcePositionProxy;", "debugProcess", "Lcom/jetbrains/rider/debugger/DotNetDebugProcess;", "getSourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "b", "initLazySourcePositionProxySuspending", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "G", "awaiter", "Lkotlin/Function1;", "Lkotlinx/coroutines/Deferred;", "G", "sourcePositionJob", "G", "()Lkotlinx/coroutines/Deferred;", "sourcePositionJob$delegate", "Lkotlin/Lazy;", "G", "getVirtualFileSuspending", "Lcom/intellij/openapi/vfs/VirtualFile;", "G", "tryUpdateSourceLocation", "withRefresh", "G", "shouldNotifyAboutExternalSources", "G", "location", "Lcom/jetbrains/rd/ide/model/SourcePositionBase;", "customizePresentation", "component", "Lcom/intellij/ui/ColoredTextContainer;", "dump", "G", "attributes", "Lcom/intellij/ui/SimpleTextAttributes;", "localsTreeRoot", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode;", "getLocalsTreeRoot", "()Lcom/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode;", "setLocalsTreeRoot", "(Lcom/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode;)V", "childrenComputedDeferred", "Lkotlinx/coroutines/CompletableDeferred;", "", "Lcom/jetbrains/rider/model/debuggerWorker/ObjectProxy;", "dfaCompletedDeferred", "computeChildren", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "G", "thisChildren", "Lcom/jetbrains/rd/ide/model/ValueEntityModelBase;", "getEvaluator", "Lcom/jetbrains/rider/debugger/evaluation/DotNetEvaluator;", "getEqualityObject", "", "equals", "other", "hashCode", "", "getBackgroundColor", "Ljava/awt/Color;", "refreshMutex", "Lkotlinx/coroutines/sync/Mutex;", "scheduleRefreshing", "refreshSuspending", "allowExternalSymbols", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "G", "r", "b", "iterator", "", "pinToTopAdviceMapProvider", "Lcom/jetbrains/rider/debugger/DotNetStackFramePinToTopAdviceMapProviderImpl;", "getPinToTopAdviceMapProvider", "()Lcom/jetbrains/rider/debugger/DotNetStackFramePinToTopAdviceMapProviderImpl;", "pinToTopAdviceMapProvider$delegate", "a", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDotNetStackFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetStackFrame.kt\ncom/jetbrains/rider/debugger/DotNetStackFrame\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,549:1\n134#1,6:550\n134#1,6:556\n13#2:562\n15#3:563\n*S KotlinDebug\n*F\n+ 1 DotNetStackFrame.kt\ncom/jetbrains/rider/debugger/DotNetStackFrame\n*L\n107#1:550,6\n128#1:556,6\n80#1:562\n80#1:563\n*E\n"})
public final class DotNetStackFrame
extends DotNetCompoundFrame
implements XDebuggerFramesList.ItemWithCustomBackgroundColor,
PinToTopValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final ExecutionContextProxy context;
    @NotNull
    private final DotNetExecutionStack stack;
    @NotNull
    private final Lifetime lifetime;
    @Nullable
    private DotNetMethodsTracker.MethodOccurrence methodOccurrence;
    private final long sessionId;
    @NotNull
    private StackFrameProxy frameProxy;
    @Nullable
    private String cachedLocation;
    @Nullable
    private SourcePositionProxy lazySourcePositionProxy;
    @NotNull
    private final DotNetDebugProcess debugProcess;
    @NotNull
    private final Lazy sourcePositionJob$delegate;
    @Nullable
    private XDebuggerTreeNode localsTreeRoot;
    @NotNull
    private final CompletableDeferred<List<ObjectProxy>> childrenComputedDeferred;
    @NotNull
    private final CompletableDeferred<Unit> dfaCompletedDeferred;
    @NotNull
    private final Mutex refreshMutex;
    @NotNull
    private final Lazy pinToTopAdviceMapProvider$delegate;
    @NotNull
    private static final JBColor ExternalCodeColor = new JBColor(new Color(100, 100, 140), new Color(132, 132, 193));
    @NotNull
    private static final JBColor ExternalCodeSecondColor = new JBColor(new Color(154, 154, 170), new Color(105, 105, 130));
    @NotNull
    private static final Logger logger;

    public DotNetStackFrame(@NotNull XDebugSession session, @NotNull ExecutionContextProxy context, @NotNull StackFrameProxy proxy, @NotNull DotNetExecutionStack stack, @NotNull Lifetime lifetime, @Nullable DotNetMethodsTracker.MethodOccurrence methodOccurrence, long sessionId) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)((Object)stack), (String)"stack");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.session = session;
        this.context = context;
        this.stack = stack;
        this.lifetime = lifetime;
        this.methodOccurrence = methodOccurrence;
        this.sessionId = sessionId;
        this.frameProxy = proxy;
        this.debugProcess = DotnetDebuggerExtKt.getDotnetDebugProcessOrThrow(this.session);
        this.sourcePositionJob$delegate = LazyKt.lazy(() -> DotNetStackFrame.G(this));
        this.childrenComputedDeferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.dfaCompletedDeferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.refreshMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.pinToTopAdviceMapProvider$delegate = LazyKt.lazy(() -> DotNetStackFrame.G(this));
    }

    public /* synthetic */ DotNetStackFrame(XDebugSession xDebugSession, ExecutionContextProxy executionContextProxy, StackFrameProxy stackFrameProxy, DotNetExecutionStack dotNetExecutionStack, Lifetime lifetime, DotNetMethodsTracker.MethodOccurrence methodOccurrence, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            methodOccurrence = null;
        }
        this(xDebugSession, executionContextProxy, stackFrameProxy, dotNetExecutionStack, lifetime, methodOccurrence, l);
    }

    @NotNull
    public final XDebugSession getSession() {
        return this.session;
    }

    @NotNull
    public final ExecutionContextProxy getContext() {
        return this.context;
    }

    @NotNull
    public final DotNetExecutionStack getStack() {
        return this.stack;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @Nullable
    public final DotNetMethodsTracker.MethodOccurrence getMethodOccurrence() {
        return this.methodOccurrence;
    }

    public final void setMethodOccurrence(@Nullable DotNetMethodsTracker.MethodOccurrence methodOccurrence) {
        this.methodOccurrence = methodOccurrence;
    }

    public final long getSessionId() {
        return this.sessionId;
    }

    @Override
    public boolean containsFrame(@NotNull DotNetStackFrame frame2) {
        Intrinsics.checkNotNullParameter((Object)frame2, (String)"frame");
        return Intrinsics.areEqual((Object)frame2, (Object)this);
    }

    @NotNull
    public final StackFrameProxy getFrameProxy() {
        return this.frameProxy;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        XBreakpoint<?> xBreakpoint;
        SourcePositionProxy sourcePositionProxy = this.G();
        if (sourcePositionProxy == null) {
            return null;
        }
        SourcePositionProxy sourcePositionProxy2 = sourcePositionProxy;
        VirtualFile virtualFile = this.G();
        XSourcePosition xSourcePosition = XDebuggerUtil.getInstance().createPosition(virtualFile, sourcePositionProxy2.getLine(), sourcePositionProxy2.getColumn());
        BreakpointId breakpointId = this.frameProxy.getLineBreakpointId();
        XLineBreakpoint xLineBreakpoint = breakpointId != null && this.debugProcess.getShouldComparePositionAndBreakpointRanges() ? ((xBreakpoint = this.debugProcess.getBreakpointsManager().tryGetBreakpoint(breakpointId)) instanceof XLineBreakpoint ? (XLineBreakpoint)xBreakpoint : null) : null;
        XSourcePosition xSourcePosition2 = xSourcePosition;
        if (xSourcePosition2 == null) {
            return null;
        }
        return (XSourcePosition)new DotNetSourcePositionWrapper(xSourcePosition2, sourcePositionProxy2, xLineBreakpoint);
    }

    private final SourcePositionProxy b() {
        SourcePositionProxy sourcePositionProxy;
        SourcePositionProxy sourcePositionProxy2;
        DotNetStackFrame dotNetStackFrame = this;
        boolean bl = false;
        SourcePositionBase sourcePositionBase = dotNetStackFrame.frameProxy.getSourcePosition();
        SourcePositionProxy sourcePositionProxy3 = sourcePositionBase instanceof SourcePositionProxy ? (SourcePositionProxy)sourcePositionBase : null;
        if (sourcePositionProxy3 == null) {
            sourcePositionProxy3 = dotNetStackFrame.lazySourcePositionProxy;
        }
        if ((sourcePositionProxy2 = (sourcePositionProxy = sourcePositionProxy3)) == null) {
            Deferred<SourcePositionProxy> deferred2 = dotNetStackFrame.G();
            if (deferred2 == null) {
                sourcePositionProxy2 = null;
            } else {
                Deferred<SourcePositionProxy> deferred3;
                Deferred<SourcePositionProxy> deferred4 = deferred3 = deferred2;
                boolean bl2 = false;
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    Object[] objectArray = new Object[]{this.frameProxy.getTypeName() + "." + this.frameProxy.getMethodName()};
                    String string = RiderDebuggerBundle.Companion.message("rider.debugger.loading.external.symbol.title", objectArray);
                    ModalTaskOwner modalTaskOwner = ModalTaskOwner.project((Project)this.session.getProject());
                    Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"project(...)");
                    sourcePositionProxy2 = (SourcePositionProxy)TasksKt.runWithModalProgressBlocking((ModalTaskOwner)modalTaskOwner, (String)string, (TaskCancellation)((TaskCancellation)TaskCancellation.Companion.cancellable()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SourcePositionProxy>, Object>(deferred4, null){
                        int label;
                        final /* synthetic */ Deferred<SourcePositionProxy> $it;
                        {
                            this.$it = $it;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = BuildersKt.withContext((CoroutineContext)com.intellij.openapi.application.CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SourcePositionProxy>, Object>(this.$it, null){
                                        int label;
                                        final /* synthetic */ Deferred<SourcePositionProxy> $it;
                                        {
                                            this.$it = $it;
                                            super(2, $completion);
                                        }

                                        /*
                                         * WARNING - void declaration
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        public final Object invokeSuspend(Object object) {
                                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)object);
                                                    IPermittedModalities.Companion.getInstance$default((IPermittedModalities.Companion)IPermittedModalities.Companion, null, (int)1, null).allowPumpProtocolUnderCurrentModality();
                                                    this.label = 1;
                                                    Object object3 = this.$it.await((Continuation)this);
                                                    if (object3 != object2) return object3;
                                                    return object2;
                                                }
                                                case 1: {
                                                    void $result;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    Object object3 = $result;
                                                    return object3;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super SourcePositionProxy> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (Continuation)((Continuation)this));
                                    if (object3 != object2) return object3;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return object3;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super SourcePositionProxy> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                } else {
                    sourcePositionProxy2 = (SourcePositionProxy)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SourcePositionProxy>, Object>(deferred4, null){
                        int label;
                        final /* synthetic */ Deferred<SourcePositionProxy> $it;
                        {
                            this.$it = $it;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = TimeoutKt.withTimeout-KLykuaI((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SourcePositionProxy>, Object>(this.$it, null){
                                        int label;
                                        final /* synthetic */ Deferred<SourcePositionProxy> $it;
                                        {
                                            this.$it = $it;
                                            super(2, $completion);
                                        }

                                        /*
                                         * WARNING - void declaration
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        public final Object invokeSuspend(Object object) {
                                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)object);
                                                    this.label = 1;
                                                    Object object3 = this.$it.await((Continuation)this);
                                                    if (object3 != object2) return object3;
                                                    return object2;
                                                }
                                                case 1: {
                                                    void $result;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    Object object3 = $result;
                                                    return object3;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super SourcePositionProxy> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (Continuation)((Continuation)this));
                                    if (object3 != object2) return object3;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return object3;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super SourcePositionProxy> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                }
            }
        }
        return sourcePositionProxy2;
    }

    @Nullable
    public final Object initLazySourcePositionProxySuspending(@NotNull Continuation<? super Unit> $completion) {
        SourcePositionProxy sourcePositionProxy;
        SourcePositionProxy sourcePositionProxy2;
        DotNetStackFrame dotNetStackFrame = this;
        boolean bl = false;
        SourcePositionBase sourcePositionBase = dotNetStackFrame.frameProxy.getSourcePosition();
        SourcePositionProxy sourcePositionProxy3 = sourcePositionBase instanceof SourcePositionProxy ? (SourcePositionProxy)sourcePositionBase : null;
        if (sourcePositionProxy3 == null) {
            sourcePositionProxy3 = dotNetStackFrame.lazySourcePositionProxy;
        }
        if ((sourcePositionProxy2 = (sourcePositionProxy = sourcePositionProxy3)) == null) {
            Deferred<SourcePositionProxy> deferred2 = dotNetStackFrame.G();
            if (deferred2 == null) {
                sourcePositionProxy2 = null;
            } else {
                Deferred<SourcePositionProxy> deferred3;
                Deferred<SourcePositionProxy> deferred4 = deferred3 = deferred2;
                boolean bl2 = false;
                Object object = deferred4.await($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                sourcePositionProxy2 = (SourcePositionProxy)object;
            }
        }
        return Unit.INSTANCE;
    }

    private final SourcePositionProxy G(Function1<? super Deferred<SourcePositionProxy>, SourcePositionProxy> function1) {
        SourcePositionProxy sourcePositionProxy;
        boolean bl = false;
        SourcePositionBase sourcePositionBase = this.frameProxy.getSourcePosition();
        SourcePositionProxy sourcePositionProxy2 = sourcePositionBase instanceof SourcePositionProxy ? (SourcePositionProxy)sourcePositionBase : null;
        if (sourcePositionProxy2 == null) {
            sourcePositionProxy2 = this.lazySourcePositionProxy;
        }
        SourcePositionProxy sourcePositionProxy3 = sourcePositionProxy = sourcePositionProxy2;
        if (sourcePositionProxy3 != null) {
            return sourcePositionProxy3;
        }
        Deferred<SourcePositionProxy> deferred2 = this.G();
        if (deferred2 == null) {
            return null;
        }
        Deferred<SourcePositionProxy> deferred3 = deferred2;
        return (SourcePositionProxy)function1.invoke(deferred3);
    }

    private final SourcePositionProxy G() {
        SourcePositionProxy sourcePositionProxy;
        try {
            sourcePositionProxy = this.b();
        }
        catch (TimeoutCancellationException timeoutCancellationException) {
            logger.trace("Source position calculation job for " + this.G() + " timed out.");
            return null;
        }
        catch (CancellationException cancellationException) {
            logger.trace("Source position calculation job for " + this.G() + " was cancelled.");
            return null;
        }
        catch (Throwable throwable) {
            logger.error(throwable);
            return null;
        }
        return sourcePositionProxy;
    }

    private final Deferred<SourcePositionProxy> G() {
        Lazy lazy = this.sourcePositionJob$delegate;
        return (Deferred)lazy.getValue();
    }

    private final String G() {
        String string = this.frameProxy.getNamespaceName();
        String string2 = this.frameProxy.getTypeName();
        String string3 = this.frameProxy.getMethodName();
        String string4 = Integer.toString(this.frameProxy.getMethodToken(), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return string + "." + string2 + "." + string3 + " (token " + string4 + ")";
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getVirtualFileSuspending(@NotNull Continuation<? super VirtualFile> $completion) {
        if (!($completion instanceof getVirtualFileSuspending.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            var3_2 = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ DotNetStackFrame this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getVirtualFileSuspending((Continuation<? super VirtualFile>)((Continuation)this));
                }
            };
        }
        var2_3 = var3_2.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var3_2.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)var2_3);
                var3_2.L$0 = this;
                var3_2.label = 1;
                v0 = this.initLazySourcePositionProxySuspending((Continuation<? super Unit>)var3_2);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (DotNetStackFrame)var3_2.L$0;
                ResultKt.throwOnFailure((Object)var2_3);
                v0 = var2_3;
lbl22:
                // 2 sources

                return this.G();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final VirtualFile G() {
        Object object;
        String string;
        String string2 = string = this.cachedLocation;
        if (string2 != null) {
            return DocumentUtilKt.toVirtualFile((String)string2, (boolean)false);
        }
        SourcePositionProxy sourcePositionProxy = this.lazySourcePositionProxy;
        Object object2 = sourcePositionProxy != null ? (SourcePositionBase)sourcePositionProxy : this.frameProxy.getSourcePosition();
        if (object2 == null || (object2 = object2.getFilename()) == null) {
            return null;
        }
        Object object3 = object2;
        if (DebuggerWorkerModelUtilKt.isUserCode(this.frameProxy)) {
            object = this.debugProcess.getVirtualFileProvider().resolveVirtualFile((String)object3);
        } else {
            object = DocumentUtilKt.toVirtualFile((String)object3, (boolean)true);
            if (object == null) {
                String string3 = this.debugProcess.getVirtualFileProvider().getNewPath((String)object3);
                object = string3 != null ? DocumentUtilKt.toVirtualFile((String)string3, (boolean)true) : null;
            }
        }
        if (object == null) {
            return null;
        }
        VirtualFile virtualFile = object;
        this.cachedLocation = virtualFile.getPath();
        return virtualFile;
    }

    public final void tryUpdateSourceLocation(boolean withRefresh) {
        if (this.frameProxy.getSourcePosition() != null) {
            return;
        }
        VirtualFile virtualFile = this.G();
        if (withRefresh && virtualFile == null && !ApplicationKt.getApplication().isUnitTestMode() && DotNetDebuggerSettings.Companion.getInstance().getEnableExternalSourceDebug()) {
            this.G();
        }
    }

    private final void G() {
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> DotNetStackFrame.G(this));
    }

    public final boolean shouldNotifyAboutExternalSources() {
        if (!DotNetDebuggerSettings.Companion.getInstance().getNeedNotifyWhenStoppedInExternalCode()) {
            return false;
        }
        return this.frameProxy.getSourcePosition() != null && this.G((SourcePositionBase)((SourcePositionProxy)this.frameProxy.getSourcePosition())) && this.frameProxy.getFrameOrigin() == StackFrameOriginModel.Decompiled;
    }

    private final boolean G(SourcePositionBase sourcePositionBase) {
        if (!(sourcePositionBase instanceof SourcePositionProxy)) {
            return false;
        }
        return ((SourcePositionProxy)sourcePositionBase).getLine() > 0 && ((SourcePositionProxy)sourcePositionBase).getColumn() > 0 && ((SourcePositionProxy)sourcePositionBase).getEndColumn() > 0 && ((SourcePositionProxy)sourcePositionBase).getEndLine() > 0;
    }

    public void customizePresentation(@NotNull ColoredTextContainer component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.customizePresentation(component2, false);
    }

    public final void customizePresentation(@NotNull ColoredTextContainer component2, boolean dump) {
        DotNetMethodsTracker.MethodOccurrence methodOccurrence;
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        String string = this.frameProxy.getMethodName();
        String string2 = this.frameProxy.getTypeName();
        String string3 = this.frameProxy.getNamespaceName();
        String string4 = StackFramesUtilsKt.getModuleNameOrEmpty(this.frameProxy);
        boolean bl = this.frameProxy.isAsync();
        JBColor jBColor = ExternalCodeColor;
        JBColor jBColor2 = ExternalCodeSecondColor;
        SimpleTextAttributes simpleTextAttributes = DebuggerWorkerModelUtilKt.isNonUserCode(this.frameProxy) ? SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(0, (Color)jBColor, null, null) : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        SimpleTextAttributes simpleTextAttributes2 = DebuggerWorkerModelUtilKt.isNonUserCode(this.frameProxy) ? simpleTextAttributes.derive(0, (Color)jBColor2, null, null) : SimpleTextAttributes.GRAYED_ATTRIBUTES;
        SimpleTextAttributes simpleTextAttributes3 = simpleTextAttributes.derive(1, null, null, null);
        List list2 = this.frameProxy.getExtraValuePresentation();
        switch (WhenMappings.$EnumSwitchMapping$0[this.frameProxy.getFrameKind().ordinal()]) {
            case 1: {
                component2.append(string, simpleTextAttributes);
                break;
            }
            case 2: {
                Object[] objectArray;
                if (Intrinsics.areEqual((Object)string, (Object)".ctor")) {
                    objectArray = "new ";
                    component2.append((String)objectArray, simpleTextAttributes3);
                    component2.append(string2, simpleTextAttributes3);
                } else if (Intrinsics.areEqual((Object)string, (Object)".cctor")) {
                    objectArray = "static ";
                    component2.append((String)objectArray, simpleTextAttributes3);
                    component2.append(string2, simpleTextAttributes3);
                } else if (bl) {
                    ColoredTextContainer coloredTextContainer = component2;
                    boolean bl2 = false;
                    String string5 = "async ";
                    coloredTextContainer.append(string5, simpleTextAttributes.derive(1, null, null, null));
                    coloredTextContainer.append(string2 + ".", simpleTextAttributes);
                    coloredTextContainer.append(string, simpleTextAttributes3);
                } else {
                    component2.append(string2 + ".", simpleTextAttributes);
                    component2.append(string, simpleTextAttributes3);
                }
                component2.append("()", simpleTextAttributes);
                if (dump || list2 != null) break;
                component2.append(" ", simpleTextAttributes2);
                objectArray = new Object[]{string3, string4};
                component2.append(RiderDebuggerBundle.Companion.message("DotNetStackFrame.presentation.suffix.message", objectArray), simpleTextAttributes2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (dump) {
            SourcePositionBase sourcePositionBase = (SourcePositionBase)((SourcePositionProxy)this.frameProxy.getSourcePosition());
            Intrinsics.checkNotNull((Object)simpleTextAttributes);
            this.G(component2, sourcePositionBase, simpleTextAttributes);
        }
        if ((methodOccurrence = this.methodOccurrence) != null && methodOccurrence.isRecursive() && this.frameProxy.getFrameKind() == FrameKind.ILFrame) {
            component2.append(" [" + methodOccurrence.getIndex() + "]", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        if (list2 != null) {
            component2.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            XValueTextRendererImpl xValueTextRendererImpl = new XValueTextRendererImpl(component2);
            DotNetValueUtilsKt.render((XValuePresentation.XValueTextRenderer)xValueTextRendererImpl, list2);
        }
        component2.setIcon(this.frameProxy.getLineBreakpointId() != null ? RiderIcons.Debugger.FrameBreakpoint : (this.frameProxy.getFrameKind() == FrameKind.NativeFrame ? RiderIcons.Debugger.FrameNative : (this.frameProxy.isExceptionTrace() ? RiderIcons.Debugger.FrameException : (DebuggerWorkerModelUtilKt.isNonUserCode(this.frameProxy) ? RiderIcons.Debugger.FrameExternal : (this.frameProxy.isAsync() ? RiderIcons.Debugger.FrameAsync : (this.frameProxy.isIterator() ? RiderIcons.Debugger.FrameEnumerable : RiderIcons.Debugger.FrameRegular))))));
    }

    private final void G(ColoredTextContainer coloredTextContainer, SourcePositionBase sourcePositionBase, SimpleTextAttributes simpleTextAttributes) {
        if (!(sourcePositionBase instanceof SourcePositionProxy)) {
            return;
        }
        if (!StringsKt.isBlank((CharSequence)((SourcePositionProxy)sourcePositionBase).getFilename())) {
            coloredTextContainer.append(" ", simpleTextAttributes);
            Object[] objectArray = new Object[]{((SourcePositionProxy)sourcePositionBase).getFilename()};
            coloredTextContainer.append(RiderDebuggerBundle.Companion.message("DotNetStackFrame.location.presentation.suffix.message", objectArray), simpleTextAttributes);
            if (((SourcePositionProxy)sourcePositionBase).getLine() != -1) {
                objectArray = new Object[]{((SourcePositionProxy)sourcePositionBase).getLine() + 1};
                coloredTextContainer.append(RiderDebuggerBundle.Companion.message("DotNetStackFrame.location.line.presentation.suffix.message", objectArray), simpleTextAttributes);
            }
        }
    }

    @Nullable
    public final XDebuggerTreeNode getLocalsTreeRoot() {
        return this.localsTreeRoot;
    }

    public final void setLocalsTreeRoot(@Nullable XDebuggerTreeNode xDebuggerTreeNode) {
        this.localsTreeRoot = xDebuggerTreeNode;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        XDebuggerTreeNode xDebuggerTreeNode = this.localsTreeRoot = node instanceof XDebuggerTreeNode ? (XDebuggerTreeNode)node : null;
        if (!RLifetimeKt.isAlive((Lifetime)this.lifetime)) {
            node.setErrorMessage("Frame is not valid");
            return;
        }
        this.a();
        DFAManager dFAManager = this.debugProcess.getDFAManager();
        if (DFAManager.isDFAAllowed$default(dFAManager, this, null, 2, null)) {
            if (node instanceof XDebuggerTreeNode) {
                Deferred<Unit> deferred2 = dFAManager.adviseToLaunchDFA(this, (XDebuggerTreeNode)node);
                boolean bl = false;
                v1 = deferred2.invokeOnCompletion(arg_0 -> DotNetStackFrame.G(this, arg_0));
            } else {
                if (!(ApplicationKt.getApplication().isUnitTestMode() && Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(node.getClass()).getQualifiedName(), (Object)"com.jetbrains.rider.test.debugger.XTestContainersCompositeNode") || Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(node.getClass()).getQualifiedName(), (Object)"com.intellij.ml.llm.riderNext.latest.rider.debug.model.wrappers.StackFrameLocalsCollectionWrapper"))) {
                    logger.error("Can't start DFA because can't determine when all frame related activities are done");
                }
                v1 = this.dfaCompletedDeferred.complete((Object)Unit.INSTANCE);
            }
        } else {
            v1 = this.dfaCompletedDeferred.complete((Object)Unit.INSTANCE);
        }
        ClientId clientId = ClientId.Companion.getCurrentOrNull();
        SourceExKt.adviseOnce((ISource)((ISource)this.frameProxy.getComputeLocals().start(this.lifetime, (Object)Unit.INSTANCE).getResult()), (Lifetime)this.lifetime, arg_0 -> DotNetStackFrame.G(clientId, this, node, arg_0));
    }

    private final void G(List<? extends ValueEntityModelBase> list2) {
        XWatchesView xWatchesView3;
        XDebugSession xDebugSession = this.session;
        XDebugSessionImpl xDebugSessionImpl = xDebugSession instanceof XDebugSessionImpl ? (XDebugSessionImpl)xDebugSession : null;
        XWatchesView xWatchesView = xWatchesView3 = xDebugSessionImpl != null && (xDebugSessionImpl = xDebugSessionImpl.getSessionTab()) != null ? xDebugSessionImpl.getWatchesView() : null;
        XWatchesViewImpl xWatchesViewImpl = xWatchesView3 instanceof XWatchesViewImpl ? (XWatchesViewImpl)xWatchesView3 : null;
        if (xWatchesViewImpl == null || (xWatchesViewImpl = xWatchesViewImpl.getTree()) == null) {
            return;
        }
        XWatchesViewImpl xWatchesViewImpl2 = xWatchesViewImpl;
        for (ValueEntityModelBase valueEntityModelBase : list2) {
            if (!(valueEntityModelBase instanceof ObjectProxy) || ((ObjectProxy)valueEntityModelBase).getValueOriginKind() != ValueOriginKind.Field) continue;
            new XValueNodeImpl((XDebuggerTree)xWatchesViewImpl2, null, valueEntityModelBase.getName(), (XValue)new DotNetNamedValue(valueEntityModelBase.getName(), (ObjectProxy)valueEntityModelBase, this, false, this.lifetime, this.sessionId, null, true, null, null, 768, null));
        }
    }

    @NotNull
    public DotNetEvaluator getEvaluator() {
        return new DotNetEvaluator(this.session, this, this.lifetime);
    }

    @NotNull
    public Object getEqualityObject() {
        Object object = this.frameProxy.getSourcePosition();
        if (object == null || (object = object.getFilename()) == null) {
            object = "unknown";
        }
        Object object2 = object;
        return this.frameProxy.getTypeName() + "." + this.frameProxy.getMethodName() + ":" + (String)object2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(object != null ? object.getClass() : null, this.getClass())) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.jetbrains.rider.debugger.DotNetStackFrame");
        DotNetStackFrame cfr_ignored_0 = (DotNetStackFrame)other;
        return this.frameProxy.getId() == ((DotNetStackFrame)other).frameProxy.getId() && Intrinsics.areEqual((Object)((Object)((DotNetStackFrame)other).debugProcess), (Object)((Object)this.debugProcess)) && Intrinsics.areEqual((Object)this.frameProxy.getSourcePosition(), (Object)((DotNetStackFrame)other).frameProxy.getSourcePosition());
    }

    public int hashCode() {
        int n = this.session.hashCode();
        n = 31 * n + this.frameProxy.hashCode();
        n = 31 * n + this.debugProcess.hashCode();
        return n;
    }

    @Nullable
    public Color getBackgroundColor() {
        return null;
    }

    public final void scheduleRefreshing() {
        LifetimeCoroutineUtilKt.async$default((Lifetime)this.lifetime, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DotNetStackFrame this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.refreshSuspending(true, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Nullable
    public final Object refreshSuspending(boolean allowExternalSymbols, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, allowExternalSymbols, null){
            Object L$0;
            Object L$1;
            boolean Z$0;
            int label;
            final /* synthetic */ DotNetStackFrame this$0;
            final /* synthetic */ boolean $allowExternalSymbols;
            {
                this.this$0 = $receiver;
                this.$allowExternalSymbols = $allowExternalSymbols;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = DotNetStackFrame.access$getRefreshMutex$p(this.this$0);
                        var4_4 = this.this$0;
                        var5_5 = this.$allowExternalSymbols;
                        var3_6 = null;
                        var6_7 = false;
                        this.L$0 = var2_3;
                        this.L$1 = var4_4;
                        this.Z$0 = var5_5;
                        this.label = 1;
                        v0 = var2_3.lock(var3_6, (Continuation)this);
                        if (v0 == var12_2) {
                            return var12_2;
                        }
                        ** GOTO lbl28
                    }
                    case 1: {
                        var6_8 = false;
                        var5_5 = this.Z$0;
                        var4_4 = (DotNetStackFrame)this.L$1;
                        var3_6 = null;
                        var2_3 = (Mutex)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl28:
                        // 3 sources

                        var7_10 = false;
                        if (!var4_4.getFrameProxy().getCanRefresh()) ** GOTO lbl34
                        v1 = var4_4.getSourcePosition();
                        v2 = v1 != null && (v1 = v1.getFile()) != null ? FileUtilsKt.isExistingFile((VirtualFile)v1) : false;
                        if (!v2) ** GOTO lbl38
lbl34:
                        // 2 sources

                        var11_12 = Unit.INSTANCE;
                        var2_3.unlock(var3_6);
                        return var11_12;
lbl38:
                        // 2 sources

                        this.L$0 = var2_3;
                        this.L$1 = var4_4;
                        this.label = 2;
                        v3 = IRdCall.DefaultImpls.startSuspending$default((IRdCall)var4_4.getContext().getRefreshStackFrame(), (Lifetime)var4_4.getLifetime(), (Object)new RefreshStackFrameArg(var4_4.getFrameProxy().getId(), var4_4.getStack().getThreadProxy().getId(), var5_5 != false), null, (Continuation)this, (int)4, null);
                        ** if (v3 != var12_2) goto lbl45
lbl44:
                        // 1 sources

                        return var12_2;
lbl45:
                        // 1 sources

                        ** GOTO lbl57
                    }
                    case 2: {
                        var7_11 = false;
                        var6_9 = false;
                        var4_4 = (DotNetStackFrame)this.L$1;
                        var3_6 = null;
                        var2_3 = (Mutex)this.L$0;
                        try {
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
lbl57:
                                // 2 sources

                                var8_13 = (StackFrameProxy)v3;
                                DotNetStackFrame.access$updateWithStackProxy(var4_4, var8_13);
                            }
                            catch (CancellationException var8_14) {
                                throw var8_14;
                            }
                            catch (Throwable var8_15) {
                                DotNetStackFrame.Companion.getLogger().warn("Stack frame refresh faulted", var8_15);
                            }
                            var9_16 = Unit.INSTANCE;
                        }
                        catch (Throwable var10_17) {
                            throw var10_17;
                        }
                        finally {
                            var2_3.unlock(var3_6);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void G(StackFrameProxy stackFrameProxy) {
        String string;
        if (Intrinsics.areEqual((Object)this.frameProxy, (Object)stackFrameProxy)) {
            return;
        }
        this.r();
        SourcePositionBase sourcePositionBase = this.frameProxy.getSourcePosition();
        String string2 = sourcePositionBase != null ? sourcePositionBase.getFilename() : null;
        SourcePositionBase sourcePositionBase2 = stackFrameProxy.getSourcePosition();
        String string3 = string = sourcePositionBase2 != null ? sourcePositionBase2.getFilename() : null;
        if (string2 != null && string != null) {
            this.debugProcess.getVirtualFileProvider().addPair(string2, string);
        }
        this.frameProxy = stackFrameProxy;
        this.b();
    }

    private final void r() {
        this.cachedLocation = null;
        this.lazySourcePositionProxy = null;
        Object object = this.frameProxy.getSourcePosition();
        if (object == null || (object = object.getFilename()) == null) {
            return;
        }
        this.debugProcess.getVirtualFileProvider().invalidateForFileName((String)object);
    }

    private final void b() {
        if (!Intrinsics.areEqual((Object)this.session.getCurrentStackFrame(), (Object)this)) {
            return;
        }
        this.session.rebuildViews();
        this.session.updateExecutionPosition();
    }

    @Override
    @NotNull
    public Iterator<DotNetStackFrame> iterator() {
        return SequencesKt.iterator((Function2)((Function2)new Function2<SequenceScope<? super DotNetStackFrame>, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DotNetStackFrame this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        SequenceScope sequenceScope = (SequenceScope)this.L$0;
                        this.label = 1;
                        Object object3 = sequenceScope.yield((Object)this.this$0, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super DotNetStackFrame> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Nullable
    public final DotNetStackFramePinToTopAdviceMapProviderImpl getPinToTopAdviceMapProvider() {
        Lazy lazy = this.pinToTopAdviceMapProvider$delegate;
        return (DotNetStackFramePinToTopAdviceMapProviderImpl)lazy.getValue();
    }

    private final void a() {
        block0: {
            DotNetStackFramePinToTopAdviceMapProviderImpl dotNetStackFramePinToTopAdviceMapProviderImpl = this.getPinToTopAdviceMapProvider();
            if (dotNetStackFramePinToTopAdviceMapProviderImpl == null) break block0;
            DotNetStackFramePinToTopAdviceMapProviderImpl dotNetStackFramePinToTopAdviceMapProviderImpl2 = dotNetStackFramePinToTopAdviceMapProviderImpl;
            boolean bl = false;
            BuildersKt.async$default((CoroutineScope)this.lifetime.getCoroutineScope(), (CoroutineContext)com.intellij.openapi.application.CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, dotNetStackFramePinToTopAdviceMapProviderImpl2, null){
                Object L$0;
                int label;
                final /* synthetic */ DotNetStackFrame this$0;
                final /* synthetic */ DotNetStackFramePinToTopAdviceMapProviderImpl $it;
                {
                    this.this$0 = $receiver;
                    this.$it = $it;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DotNetStackFrame.access$getChildrenComputedDeferred$p(this.this$0).await((Continuation)this);
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            var2_3 = (List)v0;
                            this.L$0 = var2_3;
                            this.label = 2;
                            v1 = DotNetStackFrame.access$getDfaCompletedDeferred$p(this.this$0).await((Continuation)this);
                            if (v1 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl24
                        }
                        case 2: {
                            var2_3 = (List)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl24:
                            // 2 sources

                            this.L$0 = null;
                            this.label = 3;
                            v2 = this.$it.populateMap(var2_3, (Continuation<? super Unit>)((Continuation)this));
                            if (v2 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl33
                        }
                        case 3: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl33:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    private static final Deferred G(DotNetStackFrame dotNetStackFrame) {
        if (RLifetimeKt.isNotAlive((Lifetime)dotNetStackFrame.lifetime) || !dotNetStackFrame.frameProxy.getHasLazySourcePosition()) {
            return null;
        }
        return BuildersKt.async$default((CoroutineScope)dotNetStackFrame.lifetime.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SourcePositionProxy>, Object>(dotNetStackFrame, null){
            int label;
            final /* synthetic */ DotNetStackFrame this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = IRdCall.DefaultImpls.startSuspending$default((IRdCall)this.this$0.getFrameProxy().getGetSourcePosition(), (Object)Unit.INSTANCE, null, (Continuation)((Continuation)this), (int)2, null);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var2_3 = (SourcePositionProxy)v0;
                        if (DotNetStackFrame.access$getLazySourcePositionProxy$p(this.this$0) == null) {
                            DotNetStackFrame.access$setLazySourcePositionProxy$p(this.this$0, var2_3);
                        }
                        return var2_3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super SourcePositionProxy> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void G(DotNetStackFrame dotNetStackFrame) {
        dotNetStackFrame.scheduleRefreshing();
    }

    private static final Unit G(DotNetStackFrame dotNetStackFrame, Throwable throwable) {
        dotNetStackFrame.dfaCompletedDeferred.complete((Object)Unit.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit G(RdTaskResult rdTaskResult, DotNetStackFrame dotNetStackFrame) {
        RdTaskResult rdTaskResult2 = rdTaskResult;
        if (rdTaskResult2 instanceof RdTaskResult.Success) {
            dotNetStackFrame.G((List)((RdTaskResult.Success)rdTaskResult).getValue());
        } else if (rdTaskResult2 instanceof RdTaskResult.Cancelled) {
            logger.trace("Computation of 'this' was cancelled");
        } else if (rdTaskResult2 instanceof RdTaskResult.Fault) {
            logger.error("Computation of 'this' was failed", (Throwable)((RdTaskResult.Fault)rdTaskResult).getError());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    private static final Unit G(ClientId clientId, DotNetStackFrame dotNetStackFrame, RdTaskResult rdTaskResult) {
        Intrinsics.checkNotNullParameter((Object)rdTaskResult, (String)"thisChildrenResult");
        ClientId.Companion.withClientId(clientId, () -> DotNetStackFrame.G(rdTaskResult, dotNetStackFrame));
        return Unit.INSTANCE;
    }

    private static final void G(DotNetStackFrame dotNetStackFrame, ValueEntityModelBase valueEntityModelBase, ClientId clientId) {
        if (!RLifetimeKt.isAlive((Lifetime)dotNetStackFrame.lifetime)) {
            return;
        }
        SourceExKt.adviseOnce((ISource)((ISource)valueEntityModelBase.getComputeChildren().start(dotNetStackFrame.lifetime, (Object)new ComputeChildrenArg(false)).getResult()), (Lifetime)dotNetStackFrame.lifetime, arg_0 -> DotNetStackFrame.G(clientId, dotNetStackFrame, arg_0));
    }

    private static final Unit G(RdTaskResult rdTaskResult, DotNetStackFrame dotNetStackFrame, XCompositeNode xCompositeNode, ClientId clientId) {
        RdTaskResult rdTaskResult2 = rdTaskResult;
        if (rdTaskResult2 instanceof RdTaskResult.Success) {
            List list2 = (List)((RdTaskResult.Success)rdTaskResult).getValue();
            XValueChildrenList xValueChildrenList = new XValueChildrenList();
            List list3 = new ArrayList();
            for (ValueEntityModelBase valueEntityModelBase : list2) {
                ValueEntityModelBase valueEntityModelBase2 = valueEntityModelBase;
                if (valueEntityModelBase2 instanceof GroupProxy) {
                    DotNetValueGroup dotNetValueGroup = new DotNetValueGroup((GroupProxy)valueEntityModelBase, dotNetStackFrame, dotNetStackFrame.lifetime);
                    if (((GroupProxy)valueEntityModelBase).isTop()) {
                        xValueChildrenList.addTopGroup((XValueGroup)dotNetValueGroup);
                        continue;
                    }
                    xValueChildrenList.addBottomGroup((XValueGroup)dotNetValueGroup);
                    continue;
                }
                if (!(valueEntityModelBase2 instanceof ObjectProxy)) continue;
                xValueChildrenList.add((XNamedValue)new DotNetNamedValue(valueEntityModelBase.getName(), (ObjectProxy)valueEntityModelBase, dotNetStackFrame, true, dotNetStackFrame.lifetime, dotNetStackFrame.sessionId, null, true, null, null, 768, null));
                if (((ObjectProxy)valueEntityModelBase).getValueOriginKind() == ValueOriginKind.This && XDebuggerSettingManagerImpl.getInstanceImpl().getDataViewSettings().isShowValuesInline()) {
                    ApplicationKt.getApplication().invokeLater(() -> DotNetStackFrame.G(dotNetStackFrame, valueEntityModelBase, clientId));
                }
                list3.add(valueEntityModelBase);
            }
            dotNetStackFrame.childrenComputedDeferred.complete((Object)list3);
            xCompositeNode.addChildren(xValueChildrenList, true);
        } else if (rdTaskResult2 instanceof RdTaskResult.Fault) {
            xCompositeNode.setErrorMessage(((RdTaskResult.Fault)rdTaskResult).getError().getReasonMessage());
            dotNetStackFrame.childrenComputedDeferred.completeExceptionally((Throwable)((RdTaskResult.Fault)rdTaskResult).getError());
        } else if (rdTaskResult2 instanceof RdTaskResult.Cancelled) {
            Job.DefaultImpls.cancel$default((Job)((Job)dotNetStackFrame.childrenComputedDeferred), null, (int)1, null);
            xCompositeNode.setErrorMessage("Computation cancelled");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        dotNetStackFrame.stack.getContext().getComputationBarrier().localsLoaded();
        return Unit.INSTANCE;
    }

    private static final Unit G(ClientId clientId, DotNetStackFrame dotNetStackFrame, XCompositeNode xCompositeNode, RdTaskResult rdTaskResult) {
        Intrinsics.checkNotNullParameter((Object)rdTaskResult, (String)"it");
        ClientId.Companion.withClientId(clientId, () -> DotNetStackFrame.G(rdTaskResult, dotNetStackFrame, xCompositeNode, clientId));
        return Unit.INSTANCE;
    }

    private static final DotNetStackFramePinToTopAdviceMapProviderImpl G(DotNetStackFrame dotNetStackFrame) {
        DebugEvalAdviceProvider debugEvalAdviceProvider;
        block3: {
            block2: {
                debugEvalAdviceProvider = (DebugEvalAdviceProvider)ArraysKt.firstOrNull((Object[])DebugEvalAdviceProvider.Companion.getEP_NAME().getExtensions());
                if (debugEvalAdviceProvider == null) break block2;
                Project project = dotNetStackFrame.session.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (debugEvalAdviceProvider.isPinToTopEnabled(project)) break block3;
            }
            return null;
        }
        return new DotNetStackFramePinToTopAdviceMapProviderImpl(debugEvalAdviceProvider, dotNetStackFrame, dotNetStackFrame.session, dotNetStackFrame.lifetime);
    }

    public static final /* synthetic */ Mutex access$getRefreshMutex$p(DotNetStackFrame $this) {
        return $this.refreshMutex;
    }

    public static final /* synthetic */ void access$updateWithStackProxy(DotNetStackFrame $this, StackFrameProxy proxy) {
        $this.G(proxy);
    }

    public static final /* synthetic */ SourcePositionProxy access$getLazySourcePositionProxy$p(DotNetStackFrame $this) {
        return $this.lazySourcePositionProxy;
    }

    public static final /* synthetic */ void access$setLazySourcePositionProxy$p(DotNetStackFrame $this, SourcePositionProxy sourcePositionProxy) {
        $this.lazySourcePositionProxy = sourcePositionProxy;
    }

    public static final /* synthetic */ CompletableDeferred access$getChildrenComputedDeferred$p(DotNetStackFrame $this) {
        return $this.childrenComputedDeferred;
    }

    public static final /* synthetic */ CompletableDeferred access$getDfaCompletedDeferred$p(DotNetStackFrame $this) {
        return $this.dfaCompletedDeferred;
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(DotNetStackFrame.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/debugger/DotNetStackFrame$Companion;", "", "DotNetStackFrame$Companion", "()V", "ExternalCodeColor", "Lcom/intellij/ui/JBColor;", "getExternalCodeColor", "()Lcom/intellij/ui/JBColor;", "ExternalCodeSecondColor", "getExternalCodeSecondColor", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JBColor getExternalCodeColor() {
            return ExternalCodeColor;
        }

        @NotNull
        public final JBColor getExternalCodeSecondColor() {
            return ExternalCodeSecondColor;
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FrameKind.values().length];
            try {
                nArray[FrameKind.NativeFrame.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FrameKind.ILFrame.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

