/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IconUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.ui.DebuggerColors;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.DotNetFrameLocationUpdater;
import com.jetbrains.rider.debugger.DotNetSourcePositionWrapper;
import com.jetbrains.rider.debugger.DotNetStackFrame;
import com.jetbrains.rider.debugger.DotnetDebuggerExtKt;
import com.jetbrains.rider.debugger.util.StackFramesUtilsKt;
import com.jetbrains.rider.ui.components.utils.RdSwingKt;
import icons.RiderIcons;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.util.Collections;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0001$B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\rH\u0016J\b\u0010\u0014\u001a\u00020\rH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\rH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\tH\u0002J\f\u0010\u001d\u001a\u00020\u0016*\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0016H\u0002J\b\u0010\"\u001a\u00020\rH\u0016J\b\u0010#\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/rider/debugger/DotNetFrameLocationUpdater;", "Lcom/intellij/xdebugger/XDebugSessionListener;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "DotNetFrameLocationUpdater", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/xdebugger/XDebugSession;)V", "floatingButtonsMargin", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "stackFrameChanged", "", "myLabelHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "myLabelDisposable", "Lcom/intellij/openapi/Disposable;", "sessionPaused", "settingsChanged", "b", "G", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "G", "G", "", "averageCharWidth", "G", "Lcom/jetbrains/rider/debugger/DotNetStackFrame;", "G", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "isTopFrame", "sessionStopped", "r", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDotNetFrameLocationUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetFrameLocationUpdater.kt\ncom/jetbrains/rider/debugger/DotNetFrameLocationUpdater\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,344:1\n13#2:345\n15#3:346\n*S KotlinDebug\n*F\n+ 1 DotNetFrameLocationUpdater.kt\ncom/jetbrains/rider/debugger/DotNetFrameLocationUpdater\n*L\n81#1:345\n81#1:346\n*E\n"})
public final class DotNetFrameLocationUpdater
implements XDebugSessionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final XDebugSession session;
    private final int floatingButtonsMargin;
    @NotNull
    private final Logger logger;
    @Nullable
    private RangeHighlighter myLabelHighlighter;
    @Nullable
    private Disposable myLabelDisposable;
    @NotNull
    private static final TextAttributesKey threadLabelAttributes;
    public static final int LabelMaxWidth = 150;

    public DotNetFrameLocationUpdater(@NotNull Lifetime lifetime, @NotNull XDebugSession session) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.lifetime = lifetime;
        this.session = session;
        MessageBusConnection messageBusConnection = this.session.getProject().getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.lifetime, null, (int)1, null));
        Topic topic = XDebuggerManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new XDebuggerManagerListener(){

            public void currentSessionChanged(XDebugSession previousSession, XDebugSession currentSession) {
                UIUtil.invokeLaterIfNeeded(() -> 1.G(this, previousSession, currentSession));
            }

            private static final void G(DotNetFrameLocationUpdater dotNetFrameLocationUpdater, XDebugSession xDebugSession, XDebugSession xDebugSession2) {
                if (RLifetimeKt.isNotAlive((Lifetime)dotNetFrameLocationUpdater.lifetime)) {
                    return;
                }
                if (Intrinsics.areEqual((Object)xDebugSession, (Object)dotNetFrameLocationUpdater.session)) {
                    dotNetFrameLocationUpdater.r();
                } else if (Intrinsics.areEqual((Object)xDebugSession2, (Object)dotNetFrameLocationUpdater.session) && dotNetFrameLocationUpdater.session.isSuspended()) {
                    dotNetFrameLocationUpdater.b();
                }
            }
        });
        this.lifetime.onTermination(() -> DotNetFrameLocationUpdater.r(this));
        this.floatingButtonsMargin = 70;
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(DotNetFrameLocationUpdater.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.logger = logger2;
    }

    public void stackFrameChanged() {
        XStackFrame xStackFrame = this.session.getCurrentStackFrame();
        if (xStackFrame != null) {
            StackFramesUtilsKt.tryUpdateCurrentDotNetFrameLocation(xStackFrame, false);
        }
        this.b();
    }

    public void sessionPaused() {
        XStackFrame xStackFrame = this.session.getCurrentStackFrame();
        if (xStackFrame != null) {
            StackFramesUtilsKt.tryUpdateCurrentDotNetFrameLocation(xStackFrame, true);
        }
        this.b();
    }

    public void settingsChanged() {
        ActionsKt.invokeLater$default(null, () -> DotNetFrameLocationUpdater.b(this), (int)1, null);
    }

    private final void b() {
        try {
            this.G();
        }
        catch (Throwable throwable) {
            this.logger.error(throwable);
        }
    }

    private final boolean G(Editor editor2) {
        return editor2.getScrollingModel().getVisibleArea().width < 750;
    }

    private final void G() {
        this.r();
        if (RLifetimeKt.isNotAlive((Lifetime)this.lifetime)) {
            return;
        }
        XSourcePosition xSourcePosition = this.session.getCurrentPosition();
        DotNetSourcePositionWrapper dotNetSourcePositionWrapper = xSourcePosition instanceof DotNetSourcePositionWrapper ? (DotNetSourcePositionWrapper)xSourcePosition : null;
        if (dotNetSourcePositionWrapper == null) {
            return;
        }
        DotNetSourcePositionWrapper dotNetSourcePositionWrapper2 = dotNetSourcePositionWrapper;
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.session.getProject()).getSelectedEditor(dotNetSourcePositionWrapper2.getFile());
        if (fileEditor == null) {
            return;
        }
        FileEditor fileEditor2 = fileEditor;
        TextEditor textEditor = fileEditor2 instanceof TextEditor ? (TextEditor)fileEditor2 : null;
        if (textEditor == null) {
            return;
        }
        xSourcePosition = textEditor;
        Editor editor2 = xSourcePosition.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        MarkupModel markupModel = editor3.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"getMarkupModel(...)");
        MarkupModel markupModel2 = markupModel;
        XStackFrame xStackFrame = this.session.getCurrentStackFrame();
        DotNetStackFrame dotNetStackFrame = xStackFrame instanceof DotNetStackFrame ? (DotNetStackFrame)xStackFrame : null;
        if (dotNetStackFrame == null) {
            return;
        }
        DotNetStackFrame dotNetStackFrame2 = dotNetStackFrame;
        RangeHighlighter rangeHighlighter = markupModel2.addLineHighlighter(dotNetSourcePositionWrapper2.getLine(), 600000, null);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addLineHighlighter(...)");
        RangeHighlighter rangeHighlighter2 = rangeHighlighter;
        RangeMarkerImpl rangeMarkerImpl = rangeHighlighter2 instanceof RangeMarkerImpl ? (RangeMarkerImpl)rangeHighlighter2 : null;
        if (rangeMarkerImpl != null) {
            rangeMarkerImpl.setStickingToRight(true);
        }
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        xStackFrame = disposable;
        Disposer.register((Disposable)((Disposable)xSourcePosition), (Disposable)xStackFrame);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = new Rectangle(0, 0, 0, 0);
        CustomHighlighterRenderer customHighlighterRenderer = new CustomHighlighterRenderer(this, rangeHighlighter2, dotNetStackFrame2, (Ref.ObjectRef<Rectangle>)objectRef){
            final /* synthetic */ DotNetFrameLocationUpdater this$0;
            final /* synthetic */ RangeHighlighter $labelHighlighter;
            final /* synthetic */ DotNetStackFrame $dotNetStackFrame;
            final /* synthetic */ Ref.ObjectRef<Rectangle> $rectangle;
            {
                this.this$0 = $receiver;
                this.$labelHighlighter = $labelHighlighter;
                this.$dotNetStackFrame = $dotNetStackFrame;
                this.$rectangle = $rectangle;
            }

            public void paint(Editor editor2, RangeHighlighter highlighter2, Graphics g2) {
                Point point;
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
                Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
                XDebugSession xDebugSession = DotNetFrameLocationUpdater.access$getSession$p(this.this$0);
                Intrinsics.checkNotNull((Object)xDebugSession, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebugSessionImpl");
                if (((XDebugSessionImpl)xDebugSession).getCurrentExecutionStack() == null) {
                    return;
                }
                if (DotNetFrameLocationUpdater.access$isTooNarrowForIndicator(this.this$0, editor2)) {
                    return;
                }
                VisualPosition visualPosition = editor2.offsetToVisualPosition(this.$labelHighlighter.getStartOffset());
                Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"offsetToVisualPosition(...)");
                VisualPosition visualPosition2 = visualPosition;
                Point point2 = editor2.visualPositionToXY(visualPosition2);
                Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"visualPositionToXY(...)");
                Point point3 = point2;
                float f = Math.min(Math.max((float)editor2.getColorsScheme().getEditorFontSize() * 80.0f / (float)100, 12.0f), (float)editor2.getColorsScheme().getEditorFontSize());
                Font font = new Font(UISettings.Companion.getInstance().getFontFace(), 0, (int)f);
                FontMetrics fontMetrics = g2.getFontMetrics(font);
                EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
                Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
                EditorColorsScheme editorColorsScheme2 = editorColorsScheme;
                TextAttributesKey textAttributesKey = DotNetFrameLocationUpdater.access$getTextAttributesKey(this.this$0, DotNetFrameLocationUpdater.access$isTop(this.this$0, this.$dotNetStackFrame));
                TextAttributes textAttributes = editorColorsScheme2.getAttributes(textAttributesKey);
                g2.setColor(textAttributes.getBackgroundColor());
                int n = fontMetrics.charWidth(' ');
                String string = DotNetFrameLocationUpdater.access$calculateLabelString(this.this$0, n);
                float f2 = editor2.getColorsScheme().getEditorFontSize();
                float f3 = editorColorsScheme2.getConsoleFontSize();
                float f4 = f2 / f3 / (float)JBUIScale.scale((int)1);
                int n2 = fontMetrics.stringWidth(string);
                int n3 = JBUIScale.scale((int)10);
                int n4 = n3 + (int)((float)JBUIScale.scale((int)20) * f4);
                int n5 = editor2.getScrollingModel().getVisibleArea().getLocation().x;
                this.$rectangle.element = new Rectangle(editor2.getScrollingModel().getVisibleArea().width - n2 - JBUIScale.scale((int)70) + n5, point3.y, n2 + JBUIScale.scale((int)10) + n4, editor2.getLineHeight());
                int n6 = EditorUtil.getLastVisualLineColumnNumber((Editor)editor2, (int)visualPosition2.line);
                VisualPosition visualPosition3 = new VisualPosition(visualPosition2.line, n6);
                Point point4 = editor2.visualPositionToXY(visualPosition3);
                Intrinsics.checkNotNullExpressionValue((Object)point4, (String)"visualPositionToXY(...)");
                Point point5 = point4;
                float f5 = DotNetFrameLocationUpdater.access$getFloatingButtonsMargin$p(this.this$0);
                if (editor2 instanceof EditorImpl) {
                    f5 = (float)DotNetFrameLocationUpdater.access$getFloatingButtonsMargin$p(this.this$0) * ((EditorImpl)editor2).getScale() * (float)JBUIScale.scale((int)1);
                }
                if ((float)(((Rectangle)this.$rectangle.element).x + 1) < Math.max((float)(point5.x - n5) + f5, 0.0f)) {
                    return;
                }
                int[] nArray = new int[]{((Rectangle)this.$rectangle.element).x, ((Rectangle)this.$rectangle.element).x, ((Rectangle)this.$rectangle.element).x + JBUIScale.scale((int)10), ((Rectangle)this.$rectangle.element).x + ((Rectangle)this.$rectangle.element).width, ((Rectangle)this.$rectangle.element).x + ((Rectangle)this.$rectangle.element).width, ((Rectangle)this.$rectangle.element).x + JBUIScale.scale((int)10)};
                int[] nArray2 = nArray;
                Object object = new int[]{((Rectangle)this.$rectangle.element).y + MathKt.roundToInt((double)((double)((Rectangle)this.$rectangle.element).height * (double)6 / (double)10)), ((Rectangle)this.$rectangle.element).y + MathKt.roundToInt((double)((double)((Rectangle)this.$rectangle.element).height * (double)4 / (double)10)), ((Rectangle)this.$rectangle.element).y, ((Rectangle)this.$rectangle.element).y, ((Rectangle)this.$rectangle.element).y + ((Rectangle)this.$rectangle.element).height, ((Rectangle)this.$rectangle.element).y + ((Rectangle)this.$rectangle.element).height};
                nArray = object;
                object = new Polygon(nArray2, nArray, nArray2.length);
                g2.fillPolygon((Polygon)object);
                g2.setColor(editorColorsScheme2.getDefaultBackground());
                g2.drawPolygon((Polygon)object);
                Graphics2D graphics2D = (Graphics2D)g2;
                Composite composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.SrcOver);
                Icon icon = RiderIcons.Debugger.SingleThread;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"SingleThread");
                Icon icon2 = IconUtil.scale((Icon)icon, (Component)editor2.getComponent(), (float)f4);
                icon2.paintIcon(editor2.getComponent(), g2, ((Rectangle)this.$rectangle.element).x + n3, ((Rectangle)this.$rectangle.element).y + MathKt.roundToInt((double)((double)editor2.getLineHeight() * 1.0 / (double)8)));
                graphics2D.setComposite(composite);
                Point point6 = (Point)RdSwingKt.mousePoint((Editor)editor2).getValue();
                if (point6 == null) {
                    point6 = new Point(0, 0);
                }
                if (bl = ((Rectangle)this.$rectangle.element).contains(point = point6)) {
                    font = font.deriveFont(Collections.singletonMap(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON));
                }
                TextAttributes textAttributes2 = editorColorsScheme2.getAttributes(DotNetFrameLocationUpdater.Companion.getThreadLabelAttributes());
                ((Graphics2D)g2).setFont(font);
                ((Graphics2D)g2).setColor(textAttributes2.getForegroundColor());
                UISettings.Companion.setupAntialiasing(g2);
                ((Graphics2D)g2).drawString(string, ((Rectangle)this.$rectangle.element).x + n4, ((Rectangle)this.$rectangle.element).y + MathKt.roundToInt((double)((double)editor2.getLineHeight() * (double)13 / (double)18)));
            }

            public boolean isForeground() {
                return true;
            }
        };
        rangeHighlighter2.setCustomRenderer(customHighlighterRenderer);
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        editor3.addEditorMouseMotionListener(new EditorMouseMotionListener(editor3, rangeHighlighter2, (Ref.ObjectRef<Rectangle>)objectRef, this, booleanRef){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ RangeHighlighter $labelHighlighter;
            final /* synthetic */ Ref.ObjectRef<Rectangle> $rectangle;
            final /* synthetic */ DotNetFrameLocationUpdater this$0;
            final /* synthetic */ Ref.BooleanRef $lastHoveredState;
            {
                this.$editor = $editor;
                this.$labelHighlighter = $labelHighlighter;
                this.$rectangle = $rectangle;
                this.this$0 = $receiver;
                this.$lastHoveredState = $lastHoveredState;
            }

            private final void G() {
                Editor editor2 = this.$editor;
                Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
                ((EditorEx)editor2).repaint(this.$labelHighlighter.getStartOffset(), this.$labelHighlighter.getEndOffset());
            }

            public void mouseMoved(EditorMouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Point point = e.getMouseEvent().getPoint();
                if (((Rectangle)this.$rectangle.element).contains(point) && !DotNetFrameLocationUpdater.access$isTooNarrowForIndicator(this.this$0, this.$editor)) {
                    this.$lastHoveredState.element = true;
                    UIUtil.setCursor((Component)this.$editor.getContentComponent(), (Cursor)Cursor.getPredefinedCursor(12));
                    this.G();
                } else if (this.$lastHoveredState.element) {
                    this.$lastHoveredState.element = false;
                    UIUtil.setCursor((Component)this.$editor.getContentComponent(), (Cursor)Cursor.getDefaultCursor());
                    this.G();
                }
            }
        }, (Disposable)xStackFrame);
        editor3.addEditorMouseListener(new EditorMouseListener(this, editor3, (Ref.ObjectRef<Rectangle>)objectRef){
            final /* synthetic */ DotNetFrameLocationUpdater this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ Ref.ObjectRef<Rectangle> $rectangle;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$rectangle = $rectangle;
            }

            public void mouseClicked(EditorMouseEvent event) {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (DotNetFrameLocationUpdater.access$isTooNarrowForIndicator(this.this$0, this.$editor)) {
                        return;
                    }
                    Point point = event.getMouseEvent().getPoint();
                    Project project = this.$editor.getProject();
                    if (project == null) {
                        return;
                    }
                    Project project2 = project;
                    if (!((Rectangle)this.$rectangle.element).contains(point) || event.getMouseEvent().getButton() != 1) break block3;
                    ToolWindow toolWindow = ToolWindowManagerEx.Companion.getInstanceEx(project2).getToolWindow("Debug");
                    if (toolWindow != null) {
                        toolWindow.show(() -> drawThreadLabel.2.G(this.this$0));
                    }
                }
            }

            private static final void G(DotNetFrameLocationUpdater dotNetFrameLocationUpdater) {
                DotNetDebugProcess dotNetDebugProcess = DotnetDebuggerExtKt.getDotnetDebugProcess(DotNetFrameLocationUpdater.access$getSession$p(dotNetFrameLocationUpdater));
                if (dotNetDebugProcess == null) {
                    return;
                }
                DotNetDebugProcess dotNetDebugProcess2 = dotNetDebugProcess;
                if (dotNetDebugProcess2.focusTab("ParallelStacks")) {
                    dotNetDebugProcess2.getParallelStacksView$intellij_rider().showActiveFrame();
                } else {
                    dotNetDebugProcess2.focusTab("ThreadsView");
                }
            }
        }, (Disposable)xStackFrame);
        this.myLabelHighlighter = rangeHighlighter2;
        this.myLabelDisposable = xStackFrame;
    }

    private final String G(int n) {
        XDebugSession xDebugSession = this.session;
        Intrinsics.checkNotNull((Object)xDebugSession, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebugSessionImpl");
        XExecutionStack xExecutionStack = ((XDebugSessionImpl)xDebugSession).getCurrentExecutionStack();
        if (xExecutionStack == null) {
            throw new IllegalStateException("currentExecutionStack is null".toString());
        }
        XExecutionStack xExecutionStack2 = xExecutionStack;
        String string = xExecutionStack2.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        String string2 = ((Object)StringsKt.trimStart((CharSequence)string)).toString();
        Object object = string2;
        int n2 = 150 / n;
        if (n2 < string2.length()) {
            object = StringsKt.take((String)string2, (int)(n2 - 3)) + "...";
        }
        return "'" + (String)object + "'";
    }

    private final boolean G(DotNetStackFrame dotNetStackFrame) {
        return Intrinsics.areEqual((Object)dotNetStackFrame.getStack().getTopFrame(), (Object)dotNetStackFrame);
    }

    private final TextAttributesKey G(boolean bl) {
        return bl ? DebuggerColors.EXECUTIONPOINT_ATTRIBUTES : DebuggerColors.NOT_TOP_FRAME_ATTRIBUTES;
    }

    public void sessionStopped() {
        ActionsKt.invokeLater$default(null, () -> DotNetFrameLocationUpdater.G(this), (int)1, null);
    }

    private final void r() {
        RangeHighlighter rangeHighlighter = this.myLabelHighlighter;
        if (rangeHighlighter != null) {
            rangeHighlighter.dispose();
        }
        this.myLabelHighlighter = null;
        Disposable disposable = this.myLabelDisposable;
        if (disposable != null) {
            Disposable disposable2 = disposable;
            boolean bl = false;
            Disposer.dispose((Disposable)disposable2);
        }
        this.myLabelDisposable = null;
    }

    private static final void G(DotNetFrameLocationUpdater dotNetFrameLocationUpdater) {
        dotNetFrameLocationUpdater.r();
    }

    private static final Unit r(DotNetFrameLocationUpdater dotNetFrameLocationUpdater) {
        UIUtil.invokeLaterIfNeeded(() -> DotNetFrameLocationUpdater.G(dotNetFrameLocationUpdater));
        return Unit.INSTANCE;
    }

    private static final Unit b(DotNetFrameLocationUpdater dotNetFrameLocationUpdater) {
        dotNetFrameLocationUpdater.b();
        return Unit.INSTANCE;
    }

    private static final Unit G(DotNetFrameLocationUpdater dotNetFrameLocationUpdater) {
        dotNetFrameLocationUpdater.r();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$isTooNarrowForIndicator(DotNetFrameLocationUpdater $this, Editor editor2) {
        return $this.G(editor2);
    }

    public static final /* synthetic */ TextAttributesKey access$getTextAttributesKey(DotNetFrameLocationUpdater $this, boolean isTopFrame) {
        return $this.G(isTopFrame);
    }

    public static final /* synthetic */ boolean access$isTop(DotNetFrameLocationUpdater $this, DotNetStackFrame $receiver) {
        return $this.G($receiver);
    }

    public static final /* synthetic */ String access$calculateLabelString(DotNetFrameLocationUpdater $this, int averageCharWidth) {
        return $this.G(averageCharWidth);
    }

    public static final /* synthetic */ int access$getFloatingButtonsMargin$p(DotNetFrameLocationUpdater $this) {
        return $this.floatingButtonsMargin;
    }

    static {
        TextAttributesKey textAttributesKey = TextAttributesKey.createTextAttributesKey((String)"DEBUG_THREAD_LABEL");
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"createTextAttributesKey(...)");
        threadLabelAttributes = textAttributesKey;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/debugger/DotNetFrameLocationUpdater$Companion;", "", "DotNetFrameLocationUpdater$Companion", "()V", "threadLabelAttributes", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Lorg/jetbrains/annotations/NotNull;", "getThreadLabelAttributes", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "LabelMaxWidth", "", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextAttributesKey getThreadLabelAttributes() {
            return threadLabelAttributes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

