/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.debugger.ConsoleViewUtilKt;
import com.jetbrains.rider.debugger.DotNetDebugNotificationListener;
import com.jetbrains.rider.debugger.DotNetInitializeDebuggerTask;
import com.jetbrains.rider.debugger.RiderDebuggerElevationUtilKt;
import com.jetbrains.rider.model.debuggerWorker.DotNetDebuggerSessionModel;
import com.jetbrains.rider.model.debuggerWorker.OutputSubject;
import com.jetbrains.rider.model.debuggerWorker.OutputType;
import com.jetbrains.rider.model.debuggerWorker.ShowNotification;
import com.jetbrains.rider.run.IDebuggerOutputListener;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"adviseOnDebugNotifications", "", "Lcom/jetbrains/rider/model/debuggerWorker/DotNetDebuggerSessionModel;", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "console", "Lcom/intellij/execution/ui/ExecutionConsole;", "customListener", "Lcom/jetbrains/rider/run/IDebuggerOutputListener;", "initializeDebuggerTask", "Lcom/jetbrains/rider/debugger/DotNetInitializeDebuggerTask;", "intellij.rider"})
public final class DotNetDebugNotificationListenerKt {
    public static final void adviseOnDebugNotifications(@NotNull DotNetDebuggerSessionModel $this$adviseOnDebugNotifications, @NotNull Lifetime sessionLifetime, @NotNull XDebugSession session, @NotNull ExecutionConsole console2, @NotNull IDebuggerOutputListener customListener, @NotNull DotNetInitializeDebuggerTask initializeDebuggerTask) {
        Intrinsics.checkNotNullParameter((Object)$this$adviseOnDebugNotifications, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)console2, (String)"console");
        Intrinsics.checkNotNullParameter((Object)customListener, (String)"customListener");
        Intrinsics.checkNotNullParameter((Object)((Object)initializeDebuggerTask), (String)"initializeDebuggerTask");
        $this$adviseOnDebugNotifications.getShowNotification().advise(sessionLifetime, arg_0 -> DotNetDebugNotificationListenerKt.G(session, console2, initializeDebuggerTask, customListener, arg_0));
    }

    private static final Unit G(XDebugSession xDebugSession, ExecutionConsole executionConsole, DotNetInitializeDebuggerTask dotNetInitializeDebuggerTask, IDebuggerOutputListener iDebuggerOutputListener, ShowNotification showNotification) {
        NotificationGroup notificationGroup;
        Intrinsics.checkNotNullParameter((Object)showNotification, (String)"it");
        if (showNotification.getAddToEventLog()) {
            notificationGroup = DotNetDebugNotificationListener.INSTANCE.getEVENT_LOG_NOTIFICATION_GROUP();
        } else {
            NotificationGroup notificationGroup2 = XDebuggerManagerImpl.getNotificationGroup();
            notificationGroup = notificationGroup2;
            Intrinsics.checkNotNullExpressionValue((Object)notificationGroup2, (String)"getNotificationGroup(...)");
        }
        NotificationGroup notificationGroup3 = notificationGroup;
        String string = showNotification.getOutputMessage().getOutput();
        Notification notification2 = notificationGroup3.createNotification(string, switch (WhenMappings.$EnumSwitchMapping$0[showNotification.getOutputMessage().getType().ordinal()]) {
            case 1 -> NotificationType.INFORMATION;
            case 2 -> NotificationType.WARNING;
            case 3 -> NotificationType.ERROR;
            default -> throw new NoWhenBranchMatchedException();
        });
        notification2.setListener(NotificationListener.URL_OPENING_LISTENER);
        notification2.notify(xDebugSession.getProject());
        if (showNotification.getOutputMessage().getSubject() == OutputSubject.StartupElevationRequiredError) {
            Project project = xDebugSession.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RiderDebuggerElevationUtilKt.showElevationDialogForDebug(project);
        }
        if (showNotification.getOutputMessage().getSubject() != OutputSubject.Default) {
            ConsoleViewUtilKt.tryWriteMessageToConsoleView(executionConsole, showNotification.getOutputMessage());
            dotNetInitializeDebuggerTask.cancel();
        }
        iDebuggerOutputListener.onOutputMessageAvailable(showNotification.getOutputMessage());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OutputType.values().length];
            try {
                nArray[OutputType.Info.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OutputType.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OutputType.Error.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

