/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdEndpoint;
import com.jetbrains.rd.framework.RdId;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.DotNetValueUtilsKt;
import com.jetbrains.rider.debugger.DotnetDebuggerExtKt;
import com.jetbrains.rider.debugger.breakpoint.DotNetExceptionBreakpointProperties;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointProperties;
import com.jetbrains.rider.debugger.breakpoint.DotNetMethodBreakpointProperties;
import com.jetbrains.rider.debugger.breakpoint.IDotNetVerifiableBreakpointType;
import com.jetbrains.rider.debugger.evaluation.RiderExpressionUtilKt;
import com.jetbrains.rider.debugger.util.DebuggerWorkerModelUtilKt;
import com.jetbrains.rider.model.debuggerWorker.BreakpointAdditionalDataModel;
import com.jetbrains.rider.model.debuggerWorker.BreakpointElement;
import com.jetbrains.rider.model.debuggerWorker.BreakpointHitCountModeModel;
import com.jetbrains.rider.model.debuggerWorker.BreakpointId;
import com.jetbrains.rider.model.debuggerWorker.BreakpointModel;
import com.jetbrains.rider.model.debuggerWorker.BreakpointStatus;
import com.jetbrains.rider.model.debuggerWorker.BreakpointStatusKind;
import com.jetbrains.rider.model.debuggerWorker.BreakpointWithExpressionAdditionalDataModel;
import com.jetbrains.rider.model.debuggerWorker.DotNetDebuggerSessionModel;
import com.jetbrains.rider.model.debuggerWorker.ExceptionBreakpointModel;
import com.jetbrains.rider.model.debuggerWorker.LineBreakpointModel;
import com.jetbrains.rider.model.debuggerWorker.MethodBreakpointModel;
import com.jetbrains.rider.projectView.utils.ProjectModelViewUtilKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 )2\u00020\u0001:\u0001)B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016J\u0014\u0010\u0017\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00180\u0011J\u0014\u0010\u0019\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0011J\u001a\u0010\u001b\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u001c\u001a\u00020\u001dJ\u001c\u0010\u001e\u001a\u00020\u00142\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0002J\u0012\u0010$\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016J\u0014\u0010%\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00180\u0011J\u0014\u0010&\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0011J\u0014\u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0006\u0010(\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/jetbrains/rider/debugger/DotNetBreakpointsManager;", "", "session", "Lcom/intellij/xdebugger/XDebugSession;", "protocol", "Lcom/jetbrains/rd/framework/IProtocol;", "sessionProxy", "Lcom/jetbrains/rider/model/debuggerWorker/DotNetDebuggerSessionModel;", "DotNetBreakpointsManager", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rd/framework/IProtocol;Lcom/jetbrains/rider/model/debuggerWorker/DotNetDebuggerSessionModel;)V", "getSessionProxy", "()Lcom/jetbrains/rider/model/debuggerWorker/DotNetDebuggerSessionModel;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "breakpointMap", "Lcom/intellij/util/containers/BidirectionalMap;", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "Lcom/jetbrains/rider/model/debuggerWorker/BreakpointId;", "registerLineBreakpoint", "", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "registerExceptionBreakpoint", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetExceptionBreakpointProperties;", "registerMethodBreakpoint", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetMethodBreakpointProperties;", "registerBreakpointAndModel", "breakpointModel", "Lcom/jetbrains/rider/model/debuggerWorker/BreakpointModel;", "G", "xBreakpoint", "G", "breakPointModel", "status", "Lcom/jetbrains/rider/model/debuggerWorker/BreakpointStatus;", "unregisterLineBreakpoint", "unregisterExceptionBreakpoint", "unregisterMethodBreakpoint", "tryGetBreakpoint", "breakpointId", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDotNetBreakpointsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetBreakpointsManager.kt\ncom/jetbrains/rider/debugger/DotNetBreakpointsManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,227:1\n69#2,4:228\n69#2,4:233\n69#2,4:237\n69#2,4:242\n15#2:247\n1863#3:232\n1864#3:241\n13#4:246\n*S KotlinDebug\n*F\n+ 1 DotNetBreakpointsManager.kt\ncom/jetbrains/rider/debugger/DotNetBreakpointsManager\n*L\n47#1:228,4\n49#1:233,4\n55#1:237,4\n57#1:242,4\n38#1:247\n48#1:232\n48#1:241\n38#1:246\n*E\n"})
public final class DotNetBreakpointsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final IProtocol protocol;
    @NotNull
    private final DotNetDebuggerSessionModel sessionProxy;
    @NotNull
    private final Project project;
    @NotNull
    private final BidirectionalMap<XBreakpoint<?>, BreakpointId> breakpointMap;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<ArrayList<BreakpointAdditionalDataModel>> breakpointAdditionalDataKey;

    public DotNetBreakpointsManager(@NotNull XDebugSession session, @NotNull IProtocol protocol, @NotNull DotNetDebuggerSessionModel sessionProxy) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)sessionProxy, (String)"sessionProxy");
        this.session = session;
        this.protocol = protocol;
        this.sessionProxy = sessionProxy;
        Project project = this.session.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.breakpointMap = new BidirectionalMap();
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)this.sessionProxy.getNotifyDisabledBreakpointHit(), null, null, arg_0 -> DotNetBreakpointsManager.G(this, arg_0), (int)3, null);
    }

    @NotNull
    public final DotNetDebuggerSessionModel getSessionProxy() {
        return this.sessionProxy;
    }

    public final void registerLineBreakpoint(@NotNull XLineBreakpoint<?> breakpoint) {
        Object object;
        Object object2;
        String string;
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        RunProfile runProfile2 = this.session.getRunProfile();
        logger.info("Registering line breakpoint " + breakpoint.getProperties() + " on the session " + (runProfile2 != null ? runProfile2.getName() : null));
        DotNetDebugProcess dotNetDebugProcess = DotnetDebuggerExtKt.getDotnetDebugProcess(this.session);
        if (dotNetDebugProcess == null) {
            return;
        }
        DotNetDebugProcess dotNetDebugProcess2 = dotNetDebugProcess;
        BreakpointId breakpointId = new BreakpointId(this.protocol.getIdentity().next-rSJKwng(RdId.Companion.getNull-yyTGXKE()), null);
        XBreakpointProperties xBreakpointProperties = breakpoint.getProperties();
        DotNetLineBreakpointProperties dotNetLineBreakpointProperties = xBreakpointProperties instanceof DotNetLineBreakpointProperties ? (DotNetLineBreakpointProperties)xBreakpointProperties : null;
        xBreakpointProperties = BreakpointHitCountModeModel.None;
        long l = -1L;
        int n = 0;
        if (dotNetLineBreakpointProperties != null) {
            xBreakpointProperties = DebuggerWorkerModelUtilKt.toHitCountModeModel(dotNetLineBreakpointProperties);
            Long l2 = dotNetLineBreakpointProperties.getDebugProcessToThreadIdToStopMap().get((Object)dotNetDebugProcess2);
            l = l2 != null ? l2 : -1L;
            n = dotNetLineBreakpointProperties.getHitCount();
        }
        Object object3 = this;
        boolean bl = false;
        Object object4 = breakpoint.getFileUrl();
        if (Intrinsics.areEqual((Object)"file", (Object)VirtualFileManager.extractProtocol((String)object4))) {
            string = FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)object4));
        } else {
            logger.error("Unable to get breakpoint local file path");
            string = object4;
        }
        String string2 = string;
        Object object5 = dotNetLineBreakpointProperties;
        if (object5 == null || (object5 = object5.getBreakpointElements(breakpoint)) == null) {
            Intrinsics.checkNotNull((Object)string2);
            object5 = object2 = CollectionsKt.listOf((Object)new BreakpointElement(string2, breakpoint.getLine(), 0, true));
        }
        if ((object = dotNetLineBreakpointProperties) == null || (object = object.getFilename()) == null) {
            object = string2;
        }
        object3 = new File((String)object);
        bl = ProjectModelViewUtilKt.isSolutionFile((File)object3, this.project, false);
        ArrayList arrayList = (ArrayList)breakpoint.getUserData(breakpointAdditionalDataKey);
        object4 = CollectionsKt.toMutableList((Collection)(arrayList != null ? (List)arrayList : CollectionsKt.emptyList()));
        if (breakpoint.getConditionExpression() != null || breakpoint.getLogExpressionObject() != null) {
            ((Collection)object4).add(new BreakpointWithExpressionAdditionalDataModel(DotNetValueUtilsKt.getNameAliases(this.session)));
        }
        LineBreakpointModel lineBreakpointModel = new LineBreakpointModel((List)object2, bl, l, (List)object4, breakpointId, RiderExpressionUtilKt.toExpressionModel(breakpoint.getConditionExpression(), this.session), breakpoint.getSuspendPolicy() != SuspendPolicy.NONE, RiderExpressionUtilKt.toExpressionModel(breakpoint.getLogExpressionObject(), this.session), breakpoint.isLogMessage(), breakpoint.isLogStack(), n, (BreakpointHitCountModeModel)xBreakpointProperties);
        this.registerBreakpointAndModel((XBreakpoint)breakpoint, (BreakpointModel)lineBreakpointModel);
    }

    public final void registerExceptionBreakpoint(@NotNull XBreakpoint<DotNetExceptionBreakpointProperties> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        RunProfile runProfile2 = this.session.getRunProfile();
        logger.info("Registering exception breakpoint " + breakpoint.getProperties() + " on the session " + (runProfile2 != null ? runProfile2.getName() : null));
        BreakpointId breakpointId = new BreakpointId(this.protocol.getIdentity().next-rSJKwng(RdId.Companion.getNull-yyTGXKE()), null);
        DotNetExceptionBreakpointProperties dotNetExceptionBreakpointProperties = (DotNetExceptionBreakpointProperties)breakpoint.getProperties();
        Intrinsics.checkNotNull((Object)((Object)dotNetExceptionBreakpointProperties));
        BreakpointHitCountModeModel breakpointHitCountModeModel = DebuggerWorkerModelUtilKt.toHitCountModeModel(dotNetExceptionBreakpointProperties);
        ExceptionBreakpointModel exceptionBreakpointModel = new ExceptionBreakpointModel(dotNetExceptionBreakpointProperties.getException(), dotNetExceptionBreakpointProperties.getBreakIfThrownInUserCode(), dotNetExceptionBreakpointProperties.getBreakIfThrownInExternalCode(), dotNetExceptionBreakpointProperties.getBreakIfHandledByUserCode(), dotNetExceptionBreakpointProperties.getBreakIfHandledByOtherCode(), dotNetExceptionBreakpointProperties.getBreakIfUnhandled(), breakpointId, RiderExpressionUtilKt.toExpressionModel(breakpoint.getConditionExpression(), this.session), breakpoint.getSuspendPolicy() != SuspendPolicy.NONE, RiderExpressionUtilKt.toExpressionModel(breakpoint.getLogExpressionObject(), this.session), breakpoint.isLogMessage(), breakpoint.isLogStack(), dotNetExceptionBreakpointProperties.getHitCount(), breakpointHitCountModeModel);
        this.registerBreakpointAndModel(breakpoint, (BreakpointModel)exceptionBreakpointModel);
    }

    public final void registerMethodBreakpoint(@NotNull XBreakpoint<DotNetMethodBreakpointProperties> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        RunProfile runProfile2 = this.session.getRunProfile();
        logger.info("Registering method breakpoint " + breakpoint.getProperties() + " on the session " + (runProfile2 != null ? runProfile2.getName() : null));
        BreakpointId breakpointId = new BreakpointId(this.protocol.getIdentity().next-rSJKwng(RdId.Companion.getNull-yyTGXKE()), null);
        DotNetMethodBreakpointProperties dotNetMethodBreakpointProperties = (DotNetMethodBreakpointProperties)breakpoint.getProperties();
        Intrinsics.checkNotNull((Object)((Object)dotNetMethodBreakpointProperties));
        BreakpointHitCountModeModel breakpointHitCountModeModel = DebuggerWorkerModelUtilKt.toHitCountModeModel(dotNetMethodBreakpointProperties);
        MethodBreakpointModel methodBreakpointModel = new MethodBreakpointModel(dotNetMethodBreakpointProperties.getClrTypeName(), dotNetMethodBreakpointProperties.getMethodName(), breakpointId, RiderExpressionUtilKt.toExpressionModel(breakpoint.getConditionExpression(), this.session), breakpoint.getSuspendPolicy() != SuspendPolicy.NONE, RiderExpressionUtilKt.toExpressionModel(breakpoint.getLogExpressionObject(), this.session), breakpoint.isLogMessage(), breakpoint.isLogStack(), dotNetMethodBreakpointProperties.getHitCount(), breakpointHitCountModeModel);
        this.registerBreakpointAndModel(breakpoint, (BreakpointModel)methodBreakpointModel);
    }

    public final void registerBreakpointAndModel(@NotNull XBreakpoint<?> breakpoint, @NotNull BreakpointModel breakpointModel) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        Intrinsics.checkNotNullParameter((Object)breakpointModel, (String)"breakpointModel");
        UIUtil.invokeLaterIfNeeded(() -> DotNetBreakpointsManager.G(breakpoint, this, breakpointModel));
    }

    private final void G(XBreakpoint<?> xBreakpoint, BreakpointModel breakpointModel) {
        breakpointModel.getStatusChanged().advise(Lifetime.Companion.getEternal(), arg_0 -> DotNetBreakpointsManager.G(this, breakpointModel, arg_0));
        breakpointModel.getShouldNotifyHitWhenDisabled().set((Object)(xBreakpoint.getSuspendPolicy() == SuspendPolicy.NONE ? 1 : 0));
    }

    private final void G(BreakpointModel breakpointModel, BreakpointStatus breakpointStatus) {
        if (breakpointModel instanceof LineBreakpointModel) {
            Object object;
            XDebugSession xDebugSession = this.session;
            List list2 = this.breakpointMap.getKeysByValue((Object)breakpointModel.getId());
            if (list2 == null || (list2 = (XBreakpoint)CollectionsKt.firstOrNull((List)list2)) == null) {
                return;
            }
            List list3 = list2;
            switch (WhenMappings.$EnumSwitchMapping$0[breakpointStatus.getStatus().ordinal()]) {
                case 1: {
                    XBreakpointType xBreakpointType;
                    if (list3.getSuspendPolicy() == SuspendPolicy.NONE) {
                        xBreakpointType = list3.getType();
                        object = xBreakpointType instanceof IDotNetVerifiableBreakpointType ? (IDotNetVerifiableBreakpointType)xBreakpointType : null;
                        if (object != null && (object = object.getVerifiedIconWithNoSuspend()) != null) break;
                        Icon icon = AllIcons.Debugger.Db_verified_no_suspend_breakpoint;
                        object = icon;
                        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Db_verified_no_suspend_breakpoint");
                        break;
                    }
                    xBreakpointType = list3.getType();
                    object = xBreakpointType instanceof IDotNetVerifiableBreakpointType ? (IDotNetVerifiableBreakpointType)xBreakpointType : null;
                    if (object != null && (object = object.getVerifiedIcon()) != null) break;
                    Icon icon = AllIcons.Debugger.Db_set_breakpoint;
                    object = icon;
                    Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Db_set_breakpoint");
                    break;
                }
                case 2: {
                    Icon icon = list3.getType().getEnabledIcon();
                    object = icon;
                    Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getEnabledIcon(...)");
                    break;
                }
                case 3: {
                    Icon icon = list3.getType().getDisabledIcon();
                    object = icon;
                    Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getDisabledIcon(...)");
                    break;
                }
                default: {
                    XBreakpointType xBreakpointType = list3.getType();
                    object = xBreakpointType instanceof IDotNetVerifiableBreakpointType ? (IDotNetVerifiableBreakpointType)xBreakpointType : null;
                    if (object != null && (object = object.getInvalidIcon()) != null) break;
                    Icon icon = AllIcons.Debugger.Db_invalid_breakpoint;
                    object = icon;
                    Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Db_invalid_breakpoint");
                }
            }
            Icon icon = object;
            String string = breakpointStatus.getMessage();
            XLineBreakpoint xLineBreakpoint = (XLineBreakpoint)list3;
            xDebugSession.updateBreakpointPresentation(xLineBreakpoint, icon, string);
        }
    }

    public final void unregisterLineBreakpoint(@NotNull XLineBreakpoint<?> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        UIUtil.invokeLaterIfNeeded(() -> DotNetBreakpointsManager.G(breakpoint, this));
    }

    public final void unregisterExceptionBreakpoint(@NotNull XBreakpoint<DotNetExceptionBreakpointProperties> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        UIUtil.invokeLaterIfNeeded(() -> DotNetBreakpointsManager.G(breakpoint, this));
    }

    public final void unregisterMethodBreakpoint(@NotNull XBreakpoint<DotNetMethodBreakpointProperties> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        UIUtil.invokeLaterIfNeeded(() -> DotNetBreakpointsManager.b(breakpoint, this));
    }

    @Nullable
    public final XBreakpoint<?> tryGetBreakpoint(@NotNull BreakpointId breakpointId) {
        Intrinsics.checkNotNullParameter((Object)breakpointId, (String)"breakpointId");
        List list2 = this.breakpointMap.getKeysByValue((Object)breakpointId);
        return list2 != null ? (XBreakpoint)CollectionsKt.firstOrNull((List)list2) : null;
    }

    private static final Unit G(DotNetBreakpointsManager dotNetBreakpointsManager, BreakpointId breakpointId) {
        boolean bl;
        Logger logger2;
        Intrinsics.checkNotNullParameter((Object)breakpointId, (String)"breakpointId");
        Logger logger3 = logger;
        boolean bl2 = false;
        if (logger3.isTraceEnabled()) {
            logger2 = logger3;
            bl = false;
            logger2.trace("Get signal about disabled breakpoint hit, breakpointId = " + RdId.toString-impl((long)breakpointId.getId-yyTGXKE()));
        }
        List list2 = dotNetBreakpointsManager.breakpointMap.getKeysByValue((Object)breakpointId);
        if (list2 != null) {
            Iterable iterable = list2;
            bl = false;
            for (Object t : iterable) {
                boolean bl3;
                Logger logger4;
                XBreakpoint xBreakpoint = (XBreakpoint)t;
                boolean bl4 = false;
                Logger logger5 = logger;
                boolean bl5 = false;
                if (logger5.isTraceEnabled()) {
                    logger4 = logger5;
                    bl3 = false;
                    logger4.trace("Get matching breakpoint " + xBreakpoint);
                }
                XDebugSession xDebugSession = dotNetBreakpointsManager.session;
                Intrinsics.checkNotNull((Object)xDebugSession, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebugSessionImpl");
                ((XDebugSessionImpl)xDebugSession).processDependencies(xBreakpoint);
                if (xBreakpoint instanceof XLineBreakpoint && ((XLineBreakpoint)xBreakpoint).isTemporary()) {
                    XDebuggerUtil.getInstance().removeBreakpoint(dotNetBreakpointsManager.project, xBreakpoint);
                }
                logger5 = logger;
                bl5 = false;
                if (!logger5.isTraceEnabled()) continue;
                logger4 = logger5;
                bl3 = false;
                logger4.trace("Finished processing breakpoint " + xBreakpoint);
            }
        }
        logger3 = logger;
        boolean bl6 = false;
        if (logger3.isTraceEnabled()) {
            logger2 = logger3;
            bl = false;
            logger2.trace("Finished processing signal");
        }
        return Unit.INSTANCE;
    }

    private static final void G(XBreakpoint xBreakpoint, DotNetBreakpointsManager dotNetBreakpointsManager, BreakpointModel breakpointModel) {
        BreakpointModel breakpointModel2;
        RunProfile runProfile2 = dotNetBreakpointsManager.session.getRunProfile();
        logger.info("Registering " + xBreakpoint.getType() + " " + xBreakpoint.getProperties() + " on the session " + (runProfile2 != null ? runProfile2.getName() : null));
        BreakpointId breakpointId = breakpointModel.getId();
        Map map2 = (Map)dotNetBreakpointsManager.sessionProxy.getBreakpoints();
        BreakpointModel breakpointModel3 = breakpointModel2 = breakpointModel;
        boolean bl = false;
        dotNetBreakpointsManager.G(xBreakpoint, breakpointModel3);
        map2.put(breakpointId, breakpointModel2);
        ((Map)dotNetBreakpointsManager.breakpointMap).put(xBreakpoint, breakpointId);
    }

    private static final Unit G(DotNetBreakpointsManager dotNetBreakpointsManager, BreakpointModel breakpointModel, BreakpointStatus breakpointStatus) {
        Intrinsics.checkNotNullParameter((Object)breakpointStatus, (String)"it");
        dotNetBreakpointsManager.G(breakpointModel, breakpointStatus);
        return Unit.INSTANCE;
    }

    private static final void G(XLineBreakpoint xLineBreakpoint, DotNetBreakpointsManager dotNetBreakpointsManager) {
        RunProfile runProfile2 = dotNetBreakpointsManager.session.getRunProfile();
        logger.info("Unregistering line breakpoint " + xLineBreakpoint.getProperties() + " on the session " + (runProfile2 != null ? runProfile2.getName() : null));
        BreakpointId breakpointId = (BreakpointId)dotNetBreakpointsManager.breakpointMap.get((Object)xLineBreakpoint);
        if (breakpointId == null) {
            return;
        }
        BreakpointId breakpointId2 = breakpointId;
        dotNetBreakpointsManager.sessionProxy.getBreakpoints().remove((Object)breakpointId2);
        dotNetBreakpointsManager.breakpointMap.remove((Object)xLineBreakpoint);
    }

    private static final void G(XBreakpoint xBreakpoint, DotNetBreakpointsManager dotNetBreakpointsManager) {
        RunProfile runProfile2 = dotNetBreakpointsManager.session.getRunProfile();
        logger.info("Unregistering exception breakpoint " + xBreakpoint.getProperties() + " on the session " + (runProfile2 != null ? runProfile2.getName() : null));
        BreakpointId breakpointId = (BreakpointId)dotNetBreakpointsManager.breakpointMap.get((Object)xBreakpoint);
        if (breakpointId == null) {
            return;
        }
        BreakpointId breakpointId2 = breakpointId;
        dotNetBreakpointsManager.sessionProxy.getBreakpoints().remove((Object)breakpointId2);
        dotNetBreakpointsManager.breakpointMap.remove((Object)xBreakpoint);
    }

    private static final void b(XBreakpoint xBreakpoint, DotNetBreakpointsManager dotNetBreakpointsManager) {
        RunProfile runProfile2 = dotNetBreakpointsManager.session.getRunProfile();
        logger.info("Unregistering method breakpoint " + xBreakpoint.getProperties() + " on the session " + (runProfile2 != null ? runProfile2.getName() : null));
        BreakpointId breakpointId = (BreakpointId)dotNetBreakpointsManager.breakpointMap.get((Object)xBreakpoint);
        if (breakpointId == null) {
            return;
        }
        BreakpointId breakpointId2 = breakpointId;
        dotNetBreakpointsManager.sessionProxy.getBreakpoints().remove((Object)breakpointId2);
        dotNetBreakpointsManager.breakpointMap.remove((Object)xBreakpoint);
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(DotNetBreakpointsManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
        Key key = Key.create((String)"BreakpointAdditionalData");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        breakpointAdditionalDataKey = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007RF\u0010\b\u001a7\u0012.\u0012,\u0012\u0004\u0012\u00020\u000b \r*\u0016\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nj\n\u0012\u0004\u0012\u00020\u000b\u0018\u0001`\f0\nj\b\u0012\u0004\u0012\u00020\u000b`\f0\t\u00a2\u0006\u0002\b\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/debugger/DotNetBreakpointsManager$Companion;", "", "DotNetBreakpointsManager$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "breakpointAdditionalDataKey", "Lcom/intellij/openapi/util/Key;", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/model/debuggerWorker/BreakpointAdditionalDataModel;", "Lkotlin/collections/ArrayList;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getBreakpointAdditionalDataKey", "()Lcom/intellij/openapi/util/Key;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final Key<ArrayList<BreakpointAdditionalDataModel>> getBreakpointAdditionalDataKey() {
            return breakpointAdditionalDataKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BreakpointStatusKind.values().length];
            try {
                nArray[BreakpointStatusKind.Bound.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BreakpointStatusKind.Disconnected.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BreakpointStatusKind.ExternalCodeDisabled.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

