/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.execution.KillableProcess;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rider.debugger.DebuggerWorkerProcessHandlerBase;
import com.jetbrains.rider.model.debuggerWorker.DebuggerReady;
import com.jetbrains.rider.model.debuggerWorker.DebuggerSessionInfo;
import com.jetbrains.rider.model.debuggerWorker.DebuggerWorkerModel;
import com.jetbrains.rider.model.debuggerWorker.DotNetDebuggerSessionModel;
import com.jetbrains.rider.model.debuggerWorker.TargetConnectionStatusBase;
import com.jetbrains.rider.run.ExternalConsoleProcessHandler;
import com.jetbrains.rider.run.KillableSshProcessHandler;
import com.jetbrains.rider.run.TerminalProcessHandlerKt;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.UInt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 M2\u00020\u00012\u00020\u0002:\u0004MNOPB/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u000204J\u0016\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206J\u0010\u00107\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\b\u00108\u001a\u00020\bH\u0016J\b\u00109\u001a\u000202H\u0016J\u000e\u0010:\u001a\u0002022\u0006\u0010;\u001a\u00020\u0004J\u0006\u0010<\u001a\u000202J\b\u0010=\u001a\u000202H\u0014J\b\u0010>\u001a\u000202H\u0014J\b\u0010?\u001a\u00020\bH\u0016J\n\u0010@\u001a\u0004\u0018\u00010AH\u0016J\b\u0010B\u001a\u00020\bH\u0016J\u0010\u0010B\u001a\u00020\b2\u0006\u0010C\u001a\u00020DH\u0016J!\u0010E\u001a\u0002HF\"\u0004\b\u0000\u0010F2\f\u0010G\u001a\b\u0012\u0004\u0012\u0002HF0HH\u0002\u00a2\u0006\u0002\u0010IJ\u001c\u0010J\u001a\u0002022\u0006\u0010K\u001a\u00020!2\n\u0010L\u001a\u0006\u0012\u0002\b\u00030\"H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001e\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020!\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0 0\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0013\u0010-\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0010R\u0013\u0010/\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0017\u00a8\u0006Q"}, d2={"Lcom/jetbrains/rider/debugger/DebuggerWorkerProcessHandler;", "Lcom/jetbrains/rider/debugger/DebuggerWorkerProcessHandlerBase;", "Lcom/intellij/execution/KillableProcess;", "debuggerWorkerRealHandler", "Lcom/intellij/execution/process/ProcessHandler;", "workerModel", "Lcom/jetbrains/rider/model/debuggerWorker/DebuggerWorkerModel;", "attached", "", "presentableCommandLine", "", "projectLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "DebuggerWorkerProcessHandler", "(Lcom/intellij/execution/process/ProcessHandler;Lcom/jetbrains/rider/model/debuggerWorker/DebuggerWorkerModel;ZLjava/lang/String;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getDebuggerWorkerRealHandler", "()Lcom/intellij/execution/process/ProcessHandler;", "getPresentableCommandLine", "()Ljava/lang/String;", "targetProcessHandler", "targetPidProcess", "", "getTargetPidProcess", "()Ljava/lang/Integer;", "setTargetPidProcess", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "startupMessagesLock", "", "sessionStarted", "startupMessages", "", "Lkotlin/Pair;", "Lcom/intellij/execution/process/ProcessEvent;", "Lcom/intellij/openapi/util/Key;", "shouldBeDetached", "getShouldBeDetached", "()Z", "setShouldBeDetached", "(Z)V", "targetResumed", "Lcom/jetbrains/rd/util/reactive/OptProperty;", "Lkotlin/UInt;", "getTargetResumed", "()Lcom/jetbrains/rd/util/reactive/OptProperty;", "target", "getTarget", "pid", "getPid", "addProcessListener", "", "listener", "Lcom/intellij/execution/process/ProcessListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "G", "canKillProcess", "killProcess", "attachTargetProcess", "processHandler", "startNotify", "destroyProcessImpl", "detachProcessImpl", "detachIsDefault", "getProcessInput", "Ljava/io/OutputStream;", "waitFor", "timeoutInMilliseconds", "", "G", "T", "call", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "G", "event", "outputType", "Companion", "DebuggerWorkerTerminationListener", "RealProcessTerminationAndOutputListener", "TargetProcessOutputListener", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDebuggerWorkerProcessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebuggerWorkerProcessHandler.kt\ncom/jetbrains/rider/debugger/DebuggerWorkerProcessHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,243:1\n84#2,3:244\n15#2:248\n13#3:247\n*S KotlinDebug\n*F\n+ 1 DebuggerWorkerProcessHandler.kt\ncom/jetbrains/rider/debugger/DebuggerWorkerProcessHandler\n*L\n59#1:244,3\n33#1:248\n33#1:247\n*E\n"})
public class DebuggerWorkerProcessHandler
extends DebuggerWorkerProcessHandlerBase
implements KillableProcess {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProcessHandler debuggerWorkerRealHandler;
    private final boolean attached;
    @NotNull
    private final String presentableCommandLine;
    @NotNull
    private final Lifetime projectLifetime;
    @Nullable
    private ProcessHandler targetProcessHandler;
    @Nullable
    private Integer targetPidProcess;
    @NotNull
    private final Object startupMessagesLock;
    private boolean sessionStarted;
    @NotNull
    private List<Pair<ProcessEvent, Key<?>>> startupMessages;
    private boolean shouldBeDetached;
    @NotNull
    private final OptProperty<UInt> targetResumed;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<Integer> PID_KEY;

    public DebuggerWorkerProcessHandler(@NotNull ProcessHandler debuggerWorkerRealHandler, @NotNull DebuggerWorkerModel workerModel, boolean attached, @NotNull String presentableCommandLine, @NotNull Lifetime projectLifetime) {
        Intrinsics.checkNotNullParameter((Object)debuggerWorkerRealHandler, (String)"debuggerWorkerRealHandler");
        Intrinsics.checkNotNullParameter((Object)workerModel, (String)"workerModel");
        Intrinsics.checkNotNullParameter((Object)presentableCommandLine, (String)"presentableCommandLine");
        Intrinsics.checkNotNullParameter((Object)projectLifetime, (String)"projectLifetime");
        super(workerModel);
        this.debuggerWorkerRealHandler = debuggerWorkerRealHandler;
        this.attached = attached;
        this.presentableCommandLine = presentableCommandLine;
        this.projectLifetime = projectLifetime;
        this.startupMessagesLock = new Object();
        this.startupMessages = new ArrayList();
        this.targetResumed = new OptProperty();
        InterfacesKt.viewNotNull((IViewable)((IViewable)workerModel.getActiveSession()), (Lifetime)RLifetimeKt.getEternalLifetime(), (arg_0, arg_1) -> DebuggerWorkerProcessHandler.G(this, arg_0, arg_1));
        this.debuggerWorkerRealHandler.addProcessListener((ProcessListener)new RealProcessTerminationAndOutputListener());
        this.addProcessListener((ProcessListener)new DebuggerWorkerTerminationListener());
        this.startNotify();
    }

    @NotNull
    public final ProcessHandler getDebuggerWorkerRealHandler() {
        return this.debuggerWorkerRealHandler;
    }

    @NotNull
    public final String getPresentableCommandLine() {
        return this.presentableCommandLine;
    }

    @Nullable
    public final Integer getTargetPidProcess() {
        return this.targetPidProcess;
    }

    public final void setTargetPidProcess(@Nullable Integer n) {
        this.targetPidProcess = n;
    }

    public final boolean getShouldBeDetached() {
        return this.shouldBeDetached;
    }

    public final void setShouldBeDetached(boolean bl) {
        this.shouldBeDetached = bl;
    }

    @NotNull
    public final OptProperty<UInt> getTargetResumed() {
        return this.targetResumed;
    }

    @Nullable
    public final ProcessHandler getTarget() {
        return this.targetProcessHandler;
    }

    @Nullable
    public final Integer getPid() {
        Integer n;
        ProcessHandler processHandler2 = this.debuggerWorkerRealHandler;
        if (processHandler2 instanceof ExternalConsoleProcessHandler) {
            n = ((ExternalConsoleProcessHandler)processHandler2).getPid();
        } else if (processHandler2 instanceof BaseOSProcessHandler) {
            Object object;
            Logger logger2 = LOG;
            boolean bl = false;
            Logger logger3 = logger2;
            try {
                object = logger3;
                boolean bl2 = false;
                boolean bl3 = false;
                object = Result.constructor-impl((Object)((int)((BaseOSProcessHandler)processHandler2).getProcess().pid()));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Integer n2 = (Integer)LoggerKt.getOrLogException((Object)object, (Logger)logger2);
            n = n2 != null ? n2 : 0;
        } else if (processHandler2 instanceof KillableSshProcessHandler) {
            n = null;
        } else {
            LOG.error("Can't get pid of " + this.debuggerWorkerRealHandler.getClass().getSimpleName() + ".");
            n = null;
        }
        return n;
    }

    public final void addProcessListener(@NotNull ProcessListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.G(listener2);
        super.addProcessListener(listener2);
    }

    public final void addProcessListener(@NotNull ProcessListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.G(listener2);
        super.addProcessListener(listener2, parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void G(ProcessListener processListener) {
        processListener.startNotified(new ProcessEvent((ProcessHandler)this));
        Object object = this.startupMessagesLock;
        synchronized (object) {
            boolean bl = false;
            for (Pair<ProcessEvent, Key<?>> pair : this.startupMessages) {
                processListener.onTextAvailable((ProcessEvent)pair.getFirst(), (Key)pair.getSecond());
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public boolean canKillProcess() {
        ProcessHandler processHandler2 = this.debuggerWorkerRealHandler;
        KillableProcess killableProcess = processHandler2 instanceof KillableProcess ? (KillableProcess)processHandler2 : null;
        return killableProcess != null && killableProcess.canKillProcess();
    }

    public void killProcess() {
        block2: {
            KillableProcess killableProcess;
            ProcessHandler processHandler2 = this.debuggerWorkerRealHandler;
            KillableProcess killableProcess2 = killableProcess = processHandler2 instanceof KillableProcess ? (KillableProcess)processHandler2 : null;
            if (killableProcess != null && killableProcess.canKillProcess()) {
                killableProcess.killProcess();
            }
            if (this.attached) break block2;
            ProcessHandler processHandler3 = this.targetProcessHandler;
            if (processHandler3 != null) {
                processHandler3.destroyProcess();
            }
        }
    }

    public final void attachTargetProcess(@NotNull ProcessHandler processHandler2) {
        Intrinsics.checkNotNullParameter((Object)processHandler2, (String)"processHandler");
        this.setTargetIsAlive(true);
        this.targetProcessHandler = processHandler2;
        processHandler2.addProcessListener((ProcessListener)new TargetProcessOutputListener());
    }

    public final void startNotify() {
        if (!this.debuggerWorkerRealHandler.isStartNotified()) {
            this.debuggerWorkerRealHandler.startNotify();
        }
        super.startNotify();
    }

    @Override
    protected void destroyProcessImpl() {
        if (this.debuggerWorkerRealHandler instanceof KillableProcessHandler && ((KillableProcessHandler)this.debuggerWorkerRealHandler).shouldKillProcessSoftly()) {
            this.debuggerWorkerRealHandler.destroyProcess();
        }
        super.destroyProcessImpl();
    }

    @Override
    protected void detachProcessImpl() {
        this.shouldBeDetached = true;
        TerminalProcessHandlerKt.markDetachInsteadDestroy(this.debuggerWorkerRealHandler, true);
        ProcessHandler processHandler2 = this.targetProcessHandler;
        if (processHandler2 != null) {
            TerminalProcessHandlerKt.markDetachInsteadDestroy(processHandler2, true);
        }
        super.detachProcessImpl();
    }

    public boolean detachIsDefault() {
        return this.attached;
    }

    @Nullable
    public OutputStream getProcessInput() {
        return this.debuggerWorkerRealHandler.getProcessInput();
    }

    public boolean waitFor() {
        return (Boolean)this.G(() -> DebuggerWorkerProcessHandler.G(this));
    }

    public boolean waitFor(long timeoutInMilliseconds) {
        return (Boolean)this.G(() -> DebuggerWorkerProcessHandler.G(this, timeoutInMilliseconds));
    }

    private final <T> T G(Function0<? extends T> function0) {
        if (!ApplicationKt.getApplication().isDispatchThread()) {
            return (T)function0.invoke();
        }
        IPermittedModalities.Companion.getInstance$default((IPermittedModalities.Companion)IPermittedModalities.Companion, null, (int)1, null).allowPumpProtocolUnderCurrentModality();
        return (T)function0.invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void G(ProcessEvent processEvent, Key<?> key) {
        this.notifyTextAvailable(processEvent.getText(), key);
        Object object = this.startupMessagesLock;
        synchronized (object) {
            boolean bl = false;
            if (this.sessionStarted) {
                return;
            }
            bl = this.startupMessages.add(new Pair((Object)processEvent, key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit G(DebuggerWorkerProcessHandler debuggerWorkerProcessHandler, DebuggerSessionInfo debuggerSessionInfo) {
        Intrinsics.checkNotNullParameter((Object)debuggerSessionInfo, (String)"it");
        LOG.info("Receiving debugger session info, target process pid is " + debuggerSessionInfo.getProcessId());
        debuggerWorkerProcessHandler.targetPidProcess = debuggerSessionInfo.getProcessId();
        Object object = debuggerWorkerProcessHandler.startupMessagesLock;
        synchronized (object) {
            boolean bl = false;
            debuggerWorkerProcessHandler.sessionStarted = true;
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final Unit G(DebuggerWorkerProcessHandler debuggerWorkerProcessHandler, TargetConnectionStatusBase targetConnectionStatusBase) {
        Intrinsics.checkNotNullParameter((Object)targetConnectionStatusBase, (String)"it");
        if (targetConnectionStatusBase instanceof DebuggerReady) {
            debuggerWorkerProcessHandler.targetResumed.set((Object)UInt.box-impl((int)((DebuggerReady)targetConnectionStatusBase).getProcessId-pVg5ArA()));
        }
        return Unit.INSTANCE;
    }

    private static final Unit G(DebuggerWorkerProcessHandler debuggerWorkerProcessHandler, Lifetime lifetime, DotNetDebuggerSessionModel dotNetDebuggerSessionModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lt");
        Intrinsics.checkNotNullParameter((Object)dotNetDebuggerSessionModel, (String)"session");
        dotNetDebuggerSessionModel.getTargetReady().advise(lifetime, arg_0 -> DebuggerWorkerProcessHandler.G(debuggerWorkerProcessHandler, arg_0));
        dotNetDebuggerSessionModel.getTargetConnectionStatus().advise(lifetime, arg_0 -> DebuggerWorkerProcessHandler.G(debuggerWorkerProcessHandler, arg_0));
        return Unit.INSTANCE;
    }

    private static final boolean G(DebuggerWorkerProcessHandler debuggerWorkerProcessHandler) {
        return super.waitFor();
    }

    private static final boolean G(DebuggerWorkerProcessHandler debuggerWorkerProcessHandler, long l) {
        return super.waitFor(l);
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(DebuggerWorkerProcessHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
        PID_KEY = new Key("DebuggerWorkerProcessHandler_PID_KEY");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/debugger/DebuggerWorkerProcessHandler$Companion;", "", "DebuggerWorkerProcessHandler$Companion", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "PID_KEY", "Lcom/intellij/openapi/util/Key;", "", "getPID_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Integer> getPID_KEY() {
            return PID_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/debugger/DebuggerWorkerProcessHandler$DebuggerWorkerTerminationListener;", "Lcom/intellij/execution/process/ProcessAdapter;", "DebuggerWorkerProcessHandler$DebuggerWorkerTerminationListener", "(Lcom/jetbrains/rider/debugger/DebuggerWorkerProcessHandler;)V", "processTerminated", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "intellij.rider"})
    private final class DebuggerWorkerTerminationListener
    extends ProcessAdapter {
        public void processTerminated(@NotNull ProcessEvent event) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getExitCode() == 0) {
                object = DebuggerWorkerProcessHandler.this.targetProcessHandler;
                if (!(DebuggerWorkerProcessHandler.this.getShouldBeDetached() || object == null || object.isProcessTerminated() || object.isProcessTerminating())) {
                    if (DebuggerWorkerProcessHandler.this.attached) {
                        object.detachProcess();
                    } else {
                        object.destroyProcess();
                    }
                }
            }
            if (!DebuggerWorkerProcessHandler.this.attached && !DebuggerWorkerProcessHandler.this.getShouldBeDetached() && (object = DebuggerWorkerProcessHandler.this.getTargetPidProcess()) != null && SystemInfo.isUnix && (Integer)object != 0) {
                UnixProcessManager.sendSignalToProcessTree((int)((Integer)object), (int)9, (int)-1);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/debugger/DebuggerWorkerProcessHandler$RealProcessTerminationAndOutputListener;", "Lcom/intellij/execution/process/ProcessAdapter;", "DebuggerWorkerProcessHandler$RealProcessTerminationAndOutputListener", "(Lcom/jetbrains/rider/debugger/DebuggerWorkerProcessHandler;)V", "processWillTerminate", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "willBeDestroyed", "", "processTerminated", "onTextAvailable", "outputType", "Lcom/intellij/openapi/util/Key;", "intellij.rider"})
    private final class RealProcessTerminationAndOutputListener
    extends ProcessAdapter {
        public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!willBeDestroyed) {
                boolean bl;
                boolean bl2 = bl = DebuggerWorkerProcessHandler.this.isProcessTerminated() || DebuggerWorkerProcessHandler.this.isProcessTerminating();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processTerminated(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (RLifetimeKt.isNotAlive((Lifetime)DebuggerWorkerProcessHandler.this.projectLifetime)) {
                return;
            }
            Object object = DebuggerWorkerProcessHandler.this.startupMessagesLock;
            DebuggerWorkerProcessHandler debuggerWorkerProcessHandler = DebuggerWorkerProcessHandler.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                if (!debuggerWorkerProcessHandler.sessionStarted) {
                    String string = CollectionsKt.joinToString$default((Iterable)debuggerWorkerProcessHandler.startupMessages, (CharSequence)"", null, null, (int)0, null, RealProcessTerminationAndOutputListener::G, (int)30, null);
                    LOG.warn("Debugger.Worker process was terminated before the debug session was initialized. Exit code: " + event.getExitCode() + ". Output: " + System.lineSeparator() + string);
                }
                Unit unit = Unit.INSTANCE;
            }
            DebuggerWorkerProcessHandler.this.setTargetIsAlive(false);
            DebuggerWorkerProcessHandler.this.destroyProcess();
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            DebuggerWorkerProcessHandler.this.G(event, outputType);
        }

        private static final CharSequence G(Pair pair) {
            Intrinsics.checkNotNullParameter((Object)pair, (String)"it");
            String string = ((ProcessEvent)pair.getFirst()).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/debugger/DebuggerWorkerProcessHandler$TargetProcessOutputListener;", "Lcom/intellij/execution/process/ProcessAdapter;", "DebuggerWorkerProcessHandler$TargetProcessOutputListener", "(Lcom/jetbrains/rider/debugger/DebuggerWorkerProcessHandler;)V", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "intellij.rider"})
    private final class TargetProcessOutputListener
    extends ProcessAdapter {
        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            DebuggerWorkerProcessHandler.this.G(event, outputType);
        }
    }
}

