/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rider.model.debuggerWorker.SourcePositionProxy;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"findFileConsiderProjectMoved", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "originPath", "", "Lcom/jetbrains/rider/model/debuggerWorker/SourcePositionProxy;", "intellij.rider"})
public final class DebuggerFileUtilKt {
    @Nullable
    public static final VirtualFile findFileConsiderProjectMoved(@NotNull Project project, @NotNull String originPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)originPath, (String)"originPath");
        if (((CharSequence)originPath).length() == 0) {
            return null;
        }
        File file2 = new File(originPath);
        return (VirtualFile)ApplicationKt.getApplication().runReadAction(() -> DebuggerFileUtilKt.G(file2, project));
    }

    @Nullable
    public static final VirtualFile findFileConsiderProjectMoved(@Nullable SourcePositionProxy $this$findFileConsiderProjectMoved, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if ($this$findFileConsiderProjectMoved == null) {
            return null;
        }
        return DebuggerFileUtilKt.findFileConsiderProjectMoved(project, $this$findFileConsiderProjectMoved.getFilename());
    }

    private static final VirtualFile G(File file2, Project project) {
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file2, (boolean)false);
        if (virtualFile != null) {
            return virtualFile;
        }
        Collection collection = FilenameIndex.getVirtualFilesByName((String)file2.getName(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
        Collection collection2 = collection;
        for (VirtualFile virtualFile2 : collection2) {
            String string;
            VirtualFile virtualFile3;
            Intrinsics.checkNotNull((Object)ProjectUtil.guessProjectDir((Project)project));
            if (VfsUtil.getRelativePath((VirtualFile)virtualFile2, (VirtualFile)virtualFile3) == null || !FilesKt.endsWith((File)file2, (String)string)) continue;
            return virtualFile2;
        }
        return null;
    }
}

