/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.DFA.EditorDebuggerModeWidget;

import com.intellij.ide.HelpTooltip;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rider.debugger.DFA.DFAManager;
import com.jetbrains.rider.debugger.DFA.DFAManagerUtilsKt;
import com.jetbrains.rider.debugger.DFA.DFAOperationStatus;
import com.jetbrains.rider.debugger.DFA.DFAOperationStatusKt;
import com.jetbrains.rider.debugger.DFA.EditorDebuggerModeWidget.DFAModeAction;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.FontUIResource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/debugger/DFA/EditorDebuggerModeWidget/DFAModeComponent;", "Lcom/intellij/openapi/actionSystem/impl/ActionButtonWithText;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "minimumSize", "Ljava/awt/Dimension;", "DFAModeComponent", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/actionSystem/AnAction;Lcom/intellij/openapi/actionSystem/Presentation;Ljava/lang/String;Ljava/awt/Dimension;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "FOREGROUND", "Lcom/intellij/openapi/editor/colors/ColorKey;", "Lorg/jetbrains/annotations/NotNull;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "iconTextSpace", "", "helpTooltipSeqLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "updateToolTipText", "", "G", "getInsets", "Ljava/awt/Insets;", "updateUI", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDFAModeComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DFAModeComponent.kt\ncom/jetbrains/rider/debugger/DFA/EditorDebuggerModeWidget/DFAModeComponent\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n13#2:116\n15#3:117\n1#4:118\n*S KotlinDebug\n*F\n+ 1 DFAModeComponent.kt\ncom/jetbrains/rider/debugger/DFA/EditorDebuggerModeWidget/DFAModeComponent\n*L\n34#1:116\n34#1:117\n*E\n"})
public final class DFAModeComponent
extends ActionButtonWithText {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Editor editor;
    @NotNull
    private final ColorKey FOREGROUND;
    @NotNull
    private final Logger logger;
    @NotNull
    private SequentialLifetimes helpTooltipSeqLifetimes;

    public DFAModeComponent(@NotNull Lifetime lifetime, @NotNull Editor editor2, @NotNull AnAction action2, @Nullable Presentation presentation, @NotNull String place, @NotNull Dimension minimumSize) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)minimumSize, (String)"minimumSize");
        super(action2, presentation, place, minimumSize);
        this.lifetime = lifetime;
        this.editor = editor2;
        ColorKey colorKey = ColorKey.createColorKey((String)"ActionButton.iconTextForeground", (Color)UIUtil.getContextHelpForeground());
        Intrinsics.checkNotNullExpressionValue((Object)colorKey, (String)"createColorKey(...)");
        this.FOREGROUND = colorKey;
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(DFAModeComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.logger = logger2;
        JBColor.lazy(() -> DFAModeComponent.G(this));
        if (!SystemInfo.isWindows) {
            this.setFont(new FontUIResource(this.getFont().deriveFont(this.getFont().getStyle(), (float)this.getFont().getSize() - (float)JBUIScale.scale((int)2))));
        }
        this.helpTooltipSeqLifetimes = new SequentialLifetimes(this.lifetime);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    protected int iconTextSpace() {
        return JBUI.scale((int)2);
    }

    protected void updateToolTipText() {
        try {
            this.G();
        }
        catch (Throwable throwable) {
            this.logger.error(throwable);
        }
    }

    private final void G() {
        HelpTooltip helpTooltip;
        Project project = this.editor.getProject();
        if (project == null) {
            DFAModeComponent dFAModeComponent = this;
            boolean bl = false;
            dFAModeComponent.logger.error("Can't get a project from editor");
            return;
        }
        Project project2 = project;
        DFAManager dFAManager = DFAManagerUtilsKt.getDFAManager(project2);
        if (dFAManager == null) {
            DFAModeComponent dFAModeComponent = this;
            boolean bl = false;
            dFAModeComponent.logger.trace("Can't get DFA manager, exiting");
            return;
        }
        DFAManager dFAManager2 = dFAManager;
        boolean bl = Intrinsics.areEqual((Object)this.myPresentation.getClientProperty(DFAModeAction.Companion.getDFADisabledForCurrentSessionPresentationKey()), (Object)true);
        HelpTooltip.dispose((Component)((Component)((Object)this)));
        HelpTooltip helpTooltip2 = helpTooltip = new HelpTooltip().setTitle(this.myPresentation.getDescription()).setDescription(DFAModeComponent.G(bl, (DFAOperationStatus)((Object)dFAManager2.getDFAOperationStatusSource().getValue())));
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)helpTooltip2);
        DFAModeComponent.G(this, helpTooltip2, (DFAOperationStatus)((Object)dFAManager2.getDFAOperationStatusSource().getValue()));
        helpTooltip2.installOn((JComponent)((Object)this));
        HelpTooltip helpTooltip3 = helpTooltip;
        if (!bl) {
            dFAManager2.getDFAOperationStatusSource().advise((Lifetime)this.helpTooltipSeqLifetimes.next(), arg_0 -> DFAModeComponent.G(helpTooltip3, this, bl, arg_0));
        }
    }

    @NotNull
    public Insets getInsets() {
        JBInsets jBInsets = JBUI.insets((int)2);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
        return (Insets)jBInsets;
    }

    public void updateUI() {
        super.updateUI();
        if (!SystemInfo.isWindows) {
            this.setFont(new FontUIResource(this.getFont().deriveFont(this.getFont().getStyle(), (float)this.getFont().getSize() - (float)JBUIScale.scale((int)2))));
        }
    }

    private static final Color G(DFAModeComponent dFAModeComponent) {
        Color color = dFAModeComponent.editor.getColorsScheme().getColor(dFAModeComponent.FOREGROUND);
        if (color == null && (color = dFAModeComponent.FOREGROUND.getDefaultColor()) == null) {
            color = UIUtil.getInactiveTextColor();
        }
        return color;
    }

    private static final String G(boolean bl, DFAOperationStatus dFAOperationStatus) {
        String string = RiderDebuggerBundle.Companion.message("rider.debugger.DFA.mode.popup.description", new Object[0]);
        if (bl) {
            return string;
        }
        String string2 = DFAOperationStatusKt.getStatusMessage(dFAOperationStatus);
        Object[] objectArray = new Object[]{string2};
        String string3 = RiderDebuggerBundle.Companion.message("rider.debugger.DFA.status", objectArray) + string;
        return string3;
    }

    private static final void b(DFAModeComponent dFAModeComponent) {
        ShowSettingsUtilImpl.Companion.showSettingsDialog(dFAModeComponent.editor.getProject(), "project.propDebugger", RiderDebuggerBundle.Companion.message("rider.debugger.DFA.timeout.setting", new Object[0]));
    }

    private static final void G(DFAModeComponent dFAModeComponent) {
        ShowSettingsUtilImpl.Companion.showSettingsDialog(dFAModeComponent.editor.getProject(), "project.propDebugger", RiderDebuggerBundle.Companion.message("rider.debugger.DFA.title", new Object[0]));
    }

    private static final void G(DFAModeComponent dFAModeComponent, HelpTooltip helpTooltip, DFAOperationStatus dFAOperationStatus) {
        HelpTooltip helpTooltip2 = dFAOperationStatus == DFAOperationStatus.Timeout_NoResults ? helpTooltip.setLink(RiderDebuggerBundle.Companion.message("rider.debugger.DFA.mode.link.change.timeout", new Object[0]), () -> DFAModeComponent.b(dFAModeComponent)) : helpTooltip.setLink(RiderDebuggerBundle.Companion.message("rider.debugger.DFA.mode.link.configure", new Object[0]), () -> DFAModeComponent.G(dFAModeComponent));
    }

    private static final Unit G(HelpTooltip helpTooltip, DFAModeComponent dFAModeComponent, boolean bl, DFAOperationStatus dFAOperationStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)dFAOperationStatus), (String)"it");
        String string = DFAModeComponent.G(bl, dFAOperationStatus);
        helpTooltip.setDescription(string);
        Intrinsics.checkNotNull((Object)helpTooltip);
        DFAModeComponent.G(dFAModeComponent, helpTooltip, dFAOperationStatus);
        dFAModeComponent.logger.trace("Status text in help tooltip is set to " + string);
        return Unit.INSTANCE;
    }
}

