/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPreselectionBehaviourProvider;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.FocusBehaviour;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.completion.ClientCompletionSupport;
import com.jetbrains.rider.completion.FrontendCompletionHost;
import com.jetbrains.rider.completion.RiderFrontendLanguagesPreselectionStrategy;
import com.jetbrains.rider.completion.RiderLookupListener;
import com.jetbrains.rider.completion.UtilsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/completion/RiderTypingSessionPreselectionStrategy;", "Lcom/intellij/codeInsight/completion/CompletionPreselectionBehaviourProvider;", "RiderTypingSessionPreselectionStrategy", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "shouldPreselectFirstSuggestion", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderTypingSessionPreselectionStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderTypingSessionPreselectionStrategy.kt\ncom/jetbrains/rider/completion/RiderTypingSessionPreselectionStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,61:1\n1#2:62\n12567#3,2:63\n1069#4,2:65\n*S KotlinDebug\n*F\n+ 1 RiderTypingSessionPreselectionStrategy.kt\ncom/jetbrains/rider/completion/RiderTypingSessionPreselectionStrategy\n*L\n25#1:63,2\n34#1:65,2\n*E\n"})
public final class RiderTypingSessionPreselectionStrategy
extends CompletionPreselectionBehaviourProvider {
    @NotNull
    private final Logger logger;

    public RiderTypingSessionPreselectionStrategy() {
        Logger logger2 = Logger.getInstance((String)"#com.jetbrains.rider.completion.RiderTypingSessionPreselectionStrategy");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.logger = logger2;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public boolean shouldPreselectFirstSuggestion(@NotNull CompletionParameters parameters) {
        CompletionProcess completionProcess;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        if (!(!ApplicationKt.getApplication().isDispatchThread() || ApplicationKt.getApplication().isUnitTestMode())) {
            boolean bl = false;
            String string = "preselection strategy API in a product from AWT thread";
            throw new IllegalArgumentException(string.toString());
        }
        ClientCompletionSupport clientCompletionSupport = ClientCompletionSupport.Companion.getInstance();
        PsiFile psiFile = parameters.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        if (!clientCompletionSupport.backendCompletionEnabled(psiFile, parameters.getOffset())) {
            boolean bl;
            block10: {
                Object[] objectArray = RiderFrontendLanguagesPreselectionStrategy.Companion.getEP_NAME().getExtensions();
                boolean bl2 = false;
                for (Object object : objectArray) {
                    RiderFrontendLanguagesPreselectionStrategy riderFrontendLanguagesPreselectionStrategy = (RiderFrontendLanguagesPreselectionStrategy)object;
                    boolean bl3 = false;
                    if (!riderFrontendLanguagesPreselectionStrategy.shouldPreselectFirstSuggestion(parameters)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
            return bl;
        }
        Project project = parameters.getOriginalFile().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        FrontendCompletionHost frontendCompletionHost = FrontendCompletionHost.Companion.getInstance(project2);
        int n = parameters.getOffset();
        CompletionParameters completionParameters = parameters;
        int n2 = 0;
        Document document = completionParameters.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        PsiFile psiFile2 = completionParameters.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getOriginalFile(...)");
        String string = FrontendCompletionHost.getCompletionPrefix$default((FrontendCompletionHost)frontendCompletionHost, (int)n, (Document)document, (PsiFile)psiFile2, (int)n, null, (boolean)false, (int)48, null);
        if (((CharSequence)string).length() > 0) {
            boolean bl;
            block11: {
                charSequence = string;
                boolean bl4 = false;
                for (n2 = 0; n2 < charSequence.length(); ++n2) {
                    char c;
                    char c2 = c = charSequence.charAt(n2);
                    boolean bl5 = false;
                    if (Character.isDigit(c2)) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
            if (bl) {
                return false;
            }
        }
        CompletionProgressIndicator completionProgressIndicator = (completionProcess = parameters.getProcess()) instanceof CompletionProgressIndicator ? (CompletionProgressIndicator)completionProcess : null;
        if (completionProgressIndicator == null) {
            return false;
        }
        charSequence = completionProgressIndicator;
        Disposable disposable = charSequence instanceof Disposable ? (Disposable)charSequence : null;
        if (disposable == null) {
            return false;
        }
        Disposable disposable2 = disposable;
        LookupEx lookupEx = LookupManagerImpl.Companion.getActiveLookup(parameters.getEditor());
        LookupImpl lookupImpl = lookupEx instanceof LookupImpl ? (LookupImpl)lookupEx : null;
        if (lookupImpl == null) {
            return false;
        }
        completionProcess = lookupImpl;
        if (Disposer.isDisposed((Disposable)disposable2)) {
            return false;
        }
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        LifetimeDisposableExKt.doIfAlive((Disposable)disposable2, arg_0 -> RiderTypingSessionPreselectionStrategy.G(frontendCompletionHost, parameters, (CompletionProgressIndicator)charSequence, (LookupImpl)completionProcess, string, booleanRef, arg_0));
        return booleanRef.element;
    }

    private static final Unit G(FrontendCompletionHost frontendCompletionHost, CompletionParameters completionParameters, CompletionProgressIndicator completionProgressIndicator, LookupImpl lookupImpl, String string, Ref.BooleanRef booleanRef, Lifetime lifetime) {
        LookupFocusDegree lookupFocusDegree;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lookupLifetime");
        Editor editor2 = completionParameters.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        frontendCompletionHost.waitForFirstResults(editor2, lifetime);
        if (!completionProgressIndicator.isAutopopupCompletion()) {
            lookupFocusDegree = lookupImpl.getLookupFocusDegree();
        } else if (lookupImpl.getUserData(RiderLookupListener.Companion.getForceSoftSelectionKey()) != null) {
            lookupFocusDegree = LookupFocusDegree.SEMI_FOCUSED;
        } else {
            Editor editor3 = completionParameters.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"getEditor(...)");
            FocusBehaviour focusBehaviour = frontendCompletionHost.getBackendFocusBehaviour(editor3);
            LookupFocusDegree lookupFocusDegree2 = lookupImpl.getLookupFocusDegree();
            Intrinsics.checkNotNullExpressionValue((Object)lookupFocusDegree2, (String)"getLookupFocusDegree(...)");
            lookupFocusDegree = UtilsKt.matchWithPrefix((FocusBehaviour)focusBehaviour, (LookupFocusDegree)lookupFocusDegree2, (String)string);
        }
        LookupFocusDegree lookupFocusDegree3 = lookupFocusDegree;
        Intrinsics.checkNotNull((Object)lookupFocusDegree3);
        LookupFocusDegree lookupFocusDegree4 = lookupFocusDegree3;
        boolean bl = booleanRef.element = lookupFocusDegree4 == LookupFocusDegree.FOCUSED;
        if (!booleanRef.element) {
            lookupImpl.setLookupFocusDegree(LookupFocusDegree.SEMI_FOCUSED);
        }
        return Unit.INSTANCE;
    }
}

