/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion;

import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.patches.FrontendPatchEngineKt;
import com.jetbrains.rider.completion.ClientCompletionSupport;
import com.jetbrains.rider.completion.FrontendCompletionHost;
import com.jetbrains.rider.completion.PreemptiveCompletionHost;
import com.jetbrains.rider.completion.RiderCodeCompletionExtraSettings;
import com.jetbrains.rider.completion.RiderCompletionBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/completion/RiderCharFilter;", "Lcom/intellij/codeInsight/lookup/CharFilter;", "RiderCharFilter", "()V", "acceptChar", "Lcom/intellij/codeInsight/lookup/CharFilter$Result;", "c", "", "prefixLength", "", "lookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderCharFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCharFilter.kt\ncom/jetbrains/rider/completion/RiderCharFilter\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,80:1\n19#2,2:81\n15#3:83\n*S KotlinDebug\n*F\n+ 1 RiderCharFilter.kt\ncom/jetbrains/rider/completion/RiderCharFilter\n*L\n56#1:81,2\n14#1:83\n*E\n"})
public final class RiderCharFilter
extends CharFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Nullable
    public CharFilter.Result acceptChar(char c, int prefixLength, @NotNull Lookup lookup) {
        LookupElement lookupElement;
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        PsiFile psiFile = lookup.getPsiFile();
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        if (Intrinsics.areEqual((Object)psiFile2.getLanguage().getID(), (Object)"Razor") && (Character.isJavaIdentifierPart(c) || c == '-')) {
            LOG.trace("Razor file :: c=`" + c + "`, prefixLength=" + prefixLength);
            return CharFilter.Result.ADD_TO_PREFIX;
        }
        LookupImpl lookupImpl = (LookupImpl)lookup;
        if (!ClientCompletionSupport.Companion.getInstance().backendCompletionEnabled(psiFile2, ((LookupImpl)lookup).getLookupOriginalStart())) {
            LOG.trace("Backend completion is disabled :: c=`" + c + "`, prefixLength=`" + prefixLength + "`");
            return null;
        }
        LOG.trace("Check for space in prefix :: c=`" + c + "`, additionalPrefix=`" + ((LookupImpl)lookup).getAdditionalPrefix() + "`");
        String string = ((LookupImpl)lookup).getAdditionalPrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAdditionalPrefix(...)");
        boolean bl = StringsKt.contains$default((CharSequence)string, (char)' ', (boolean)false, (int)2, null);
        if (bl || c == ' ') {
            LookupElement lookupElement2 = ((LookupImpl)lookup).getCurrentItem();
            if (lookupElement2 == null) {
                return null;
            }
            lookupElement = lookupElement2;
            String string2 = ((LookupImpl)lookup).itemPattern(lookupElement) + c;
            int n = RangesKt.coerceAtMost((int)((LookupImpl)lookup).getItems().size(), (int)5);
            for (int j = 0; j < n; ++j) {
                LookupElement lookupElement3 = (LookupElement)((LookupImpl)lookup).getItems().get(j);
                String string3 = lookupElement3.getLookupString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLookupString(...)");
                if (!StringsKt.contains((CharSequence)string3, (CharSequence)string2, (boolean)true)) continue;
                Disposer.register((Disposable)((Disposable)lookup), () -> RiderCharFilter.G(lookupImpl, lookup));
                LOG.trace("Matched against prefix with whitespace. acceptChar: c=`" + c + "`, prefixLength=" + prefixLength);
                return CharFilter.Result.ADD_TO_PREFIX;
            }
            if (bl) {
                Project project = ((LookupImpl)lookup).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                ComponentManager componentManager = (ComponentManager)project;
                n = 0;
                Object object = componentManager.getComponent(FrontendCompletionHost.class);
                if (object == null) {
                    throw new IllegalStateException("Component " + FrontendCompletionHost.class + " not found in container " + componentManager);
                }
                FrontendCompletionHost frontendCompletionHost = (FrontendCompletionHost)object;
                Editor editor2 = ((LookupImpl)lookup).getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                frontendCompletionHost.terminateCurrentCompletion(editor2, RiderCompletionBundle.Companion.message("failed.to.match.against.prefix.with.whitespace", new Object[0]));
                LOG.trace("Space in prefix. acceptChar: c=`" + c + "`, prefixLength=" + prefixLength);
                return CharFilter.Result.HIDE_LOOKUP;
            }
            if (!RiderCodeCompletionExtraSettings.Companion.getInstance().getAllowToCompleteWithWhitespace()) {
                LOG.trace("Complete with whitespace is disabled. acceptChar: c=`" + c + "`, prefixLength=" + prefixLength);
                return CharFilter.Result.HIDE_LOOKUP;
            }
        }
        Project project = lookupImpl.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        lookupElement = FrontendPatchEngineKt.getEngine((ClientAppSession)FrontendSessionsUtilKt.getFrontendProjectSession((Project)project).getAppSession());
        if (lookupElement.getHasActivePatch() && StringsKt.contains$default((CharSequence)"(.,;:= ", (char)c, (boolean)false, (int)2, null)) {
            LOG.trace("Overriding `SELECT_ITEM_AND_FINISH_LOOKUP`, replace with `HIDE_LOOKUP`. acceptChar: c=`" + c + "`, prefixLength=" + prefixLength);
            return CharFilter.Result.HIDE_LOOKUP;
        }
        LOG.trace("No space in prefix. acceptChar: c=`" + c + "`, prefixLength=" + prefixLength);
        return null;
    }

    private static final void G(LookupImpl lookupImpl, Lookup lookup) {
        if (lookupImpl.getItems().size() == 0) {
            Project project = ((LookupImpl)lookup).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            PreemptiveCompletionHost preemptiveCompletionHost = PreemptiveCompletionHost.Companion.getInstance(project);
            Editor editor2 = ((LookupImpl)lookup).getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            preemptiveCompletionHost.tryScheduleCompletion(editor2, "Lookup with variants containing session terminators is now gone");
        }
    }

    static {
        boolean bl = false;
        Logger logger2 = Logger.getInstance(RiderCharFilter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/completion/RiderCharFilter$Companion;", "", "RiderCharFilter$Companion", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

