/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.build.ui.old;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ConsoleHighlighter;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rider.build.diagnostics.BuildDiagnostic;
import com.jetbrains.rider.build.ui.old.RiderBuildResultTreePanel;
import com.jetbrains.rider.model.BuildEventBase;
import com.jetbrains.rider.model.BuildMessageKind;
import com.jetbrains.rider.model.ConsoleBuildEvent;
import com.jetbrains.rider.model.ErrorBuildEvent;
import com.jetbrains.rider.model.ImportantBuildEvent;
import com.jetbrains.rider.model.InfoBuildEvent;
import com.jetbrains.rider.model.MessageBuildEvent;
import com.jetbrains.rider.model.ProjectId;
import com.jetbrains.rider.model.ReferenceBuildEvent;
import com.jetbrains.rider.model.WarningBuildEvent;
import java.awt.CardLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 <2\u00020\u00012\u00020\u0002:\u0001<B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020\u001dJ\u0006\u0010 \u001a\u00020\u001dJ\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020%2\u0006\u0010&\u001a\u00020)H\u0002J\"\u0010*\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020)2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.0,J\u000e\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020.J\b\u00101\u001a\u00020\u000eH\u0016J\b\u00102\u001a\u00020\u000eH\u0016J\n\u00103\u001a\u0004\u0018\u000104H\u0016J\n\u00105\u001a\u0004\u0018\u000104H\u0016J\b\u00106\u001a\u00020.H\u0016J\b\u00107\u001a\u00020.H\u0016J\u0018\u00108\u001a\u00020\u001d2\u0006\u00100\u001a\u00020.2\u0006\u0010&\u001a\u00020%H\u0002J\u0010\u00108\u001a\u00020\u001d2\u0006\u0010\"\u001a\u000209H\u0002J$\u00108\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020;2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.0,H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0015\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/jetbrains/rider/build/ui/old/BuildResultPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/ide/OccurenceNavigator;", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "BuildResultPanel", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "console", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "buildEvents", "Lcom/jetbrains/rider/build/ui/old/RiderBuildResultTreePanel;", "value", "", "isConsoleActivated", "()Z", "hasErrors", "G", "hasWarnings", "b", "hasEvents", "getHasEvents", "currentOccurrenceNavigator", "layout", "Ljava/awt/CardLayout;", "container", "Ljavax/swing/JPanel;", "clearConsole", "", "clearTree", "showConsole", "showEvents", "addBuildEvent", "buildEvent", "Lcom/jetbrains/rider/build/diagnostics/BuildDiagnostic;", "G", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "type", "Lcom/jetbrains/rider/model/BuildMessageKind;", "G", "Lcom/jetbrains/rider/model/BuildEventBase;", "addOutputMessage", "projectsDirectories", "Lcom/jetbrains/rd/util/reactive/IMutableViewableMap;", "Lcom/jetbrains/rider/model/ProjectId;", "", "addStatusMessage", "message", "hasNextOccurence", "hasPreviousOccurence", "goNextOccurence", "Lcom/intellij/ide/OccurenceNavigator$OccurenceInfo;", "goPreviousOccurence", "getNextOccurenceActionName", "getPreviousOccurenceActionName", "G", "Lcom/jetbrains/rider/model/MessageBuildEvent;", "ev", "Lcom/jetbrains/rider/model/ImportantBuildEvent;", "Companion", "intellij.rider"})
public final class BuildResultPanel
extends SimpleToolWindowPanel
implements OccurenceNavigator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConsoleViewImpl console;
    @NotNull
    private final RiderBuildResultTreePanel buildEvents;
    private boolean isConsoleActivated;
    @Nullable
    private OccurenceNavigator currentOccurrenceNavigator;
    @NotNull
    private final CardLayout layout;
    @NotNull
    private final JPanel container;
    @NotNull
    private static final String consolePanelName = "console";
    @NotNull
    private static final String buildEventsPanelName = "events";
    @NotNull
    private static final ConsoleViewContentType CONSOLE_NORMAL_OUTPUT = new ConsoleViewContentType("CONSOLE_NORMAL_OUTPUT", ConsoleViewContentType.NORMAL_OUTPUT_KEY);
    @NotNull
    private static final ConsoleViewContentType CONSOLE_GREEN_OUTPUT = new ConsoleViewContentType("CONSOLE_NORMAL_OUTPUT", ConsoleHighlighter.GREEN);

    public BuildResultPanel(@NotNull Project project, @NotNull Lifetime lifetime) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        super(false);
        this.project = project;
        ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(this.project).getConsole();
        Intrinsics.checkNotNull((Object)consoleView, (String)"null cannot be cast to non-null type com.intellij.execution.impl.ConsoleViewImpl");
        this.console = (ConsoleViewImpl)consoleView;
        this.buildEvents = new RiderBuildResultTreePanel(this.project);
        this.layout = new CardLayout();
        Disposer.register((Disposable)((Disposable)this.project), (Disposable)((Disposable)this.console));
        this.setProvideQuickActions(true);
        this.console.setFocusable(true);
        JPanel jPanel2 = jPanel = new JPanel(this.layout);
        BuildResultPanel buildResultPanel = this;
        boolean bl = false;
        jPanel2.add((Component)this.console.getComponent(), consolePanelName);
        jPanel2.add((Component)((Object)this.buildEvents), buildEventsPanelName);
        buildResultPanel.container = jPanel;
        this.showConsole();
        this.setContent(this.container);
        lifetime.onTermination(() -> BuildResultPanel.G(this));
    }

    public final boolean isConsoleActivated() {
        return this.isConsoleActivated;
    }

    private final boolean G() {
        return this.buildEvents.getHasErrors();
    }

    private final boolean b() {
        return this.buildEvents.getHasWarnings();
    }

    public final boolean getHasEvents() {
        return this.buildEvents.getHasEvents();
    }

    public final void clearConsole() {
        this.console.clear();
    }

    public final void clearTree() {
        this.buildEvents.clearTree();
    }

    public final void showConsole() {
        if (this.isConsoleActivated) {
            return;
        }
        this.currentOccurrenceNavigator = (OccurenceNavigator)this.console;
        this.layout.show(this.container, consolePanelName);
        this.isConsoleActivated = true;
    }

    public final void showEvents() {
        if (!this.isConsoleActivated) {
            return;
        }
        this.currentOccurrenceNavigator = this.buildEvents;
        this.buildEvents.activate();
        this.layout.show(this.container, buildEventsPanelName);
        this.isConsoleActivated = false;
    }

    public final void addBuildEvent(@NotNull BuildDiagnostic buildEvent) {
        Intrinsics.checkNotNullParameter((Object)buildEvent, (String)"buildEvent");
        this.buildEvents.addBuildEvent(buildEvent);
    }

    private final ConsoleViewContentType G(BuildMessageKind buildMessageKind) {
        ConsoleViewContentType consoleViewContentType;
        switch (WhenMappings.$EnumSwitchMapping$0[buildMessageKind.ordinal()]) {
            case 1: {
                ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.LOG_ERROR_OUTPUT;
                consoleViewContentType = consoleViewContentType2;
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"LOG_ERROR_OUTPUT");
                break;
            }
            case 2: {
                ConsoleViewContentType consoleViewContentType3 = ConsoleViewContentType.LOG_WARNING_OUTPUT;
                consoleViewContentType = consoleViewContentType3;
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType3, (String)"LOG_WARNING_OUTPUT");
                break;
            }
            case 3: {
                consoleViewContentType = CONSOLE_NORMAL_OUTPUT;
                break;
            }
            case 4: {
                consoleViewContentType = CONSOLE_GREEN_OUTPUT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return consoleViewContentType;
    }

    private final ConsoleViewContentType G(BuildEventBase buildEventBase) {
        ConsoleViewContentType consoleViewContentType;
        BuildEventBase buildEventBase2 = buildEventBase;
        if (buildEventBase2 instanceof ConsoleBuildEvent) {
            ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.LOG_DEBUG_OUTPUT;
            consoleViewContentType = consoleViewContentType2;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"LOG_DEBUG_OUTPUT");
        } else if (buildEventBase2 instanceof MessageBuildEvent) {
            consoleViewContentType = this.G(((MessageBuildEvent)buildEventBase).getKind());
        } else if (buildEventBase2 instanceof WarningBuildEvent) {
            ConsoleViewContentType consoleViewContentType3 = ConsoleViewContentType.LOG_WARNING_OUTPUT;
            consoleViewContentType = consoleViewContentType3;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType3, (String)"LOG_WARNING_OUTPUT");
        } else if (buildEventBase2 instanceof InfoBuildEvent) {
            ConsoleViewContentType consoleViewContentType4 = ConsoleViewContentType.LOG_INFO_OUTPUT;
            consoleViewContentType = consoleViewContentType4;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType4, (String)"LOG_INFO_OUTPUT");
        } else if (buildEventBase2 instanceof ReferenceBuildEvent) {
            ConsoleViewContentType consoleViewContentType5 = ConsoleViewContentType.LOG_INFO_OUTPUT;
            consoleViewContentType = consoleViewContentType5;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType5, (String)"LOG_INFO_OUTPUT");
        } else if (buildEventBase2 instanceof ErrorBuildEvent) {
            ConsoleViewContentType consoleViewContentType6 = ConsoleViewContentType.ERROR_OUTPUT;
            consoleViewContentType = consoleViewContentType6;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType6, (String)"ERROR_OUTPUT");
        } else {
            ConsoleViewContentType consoleViewContentType7 = ConsoleViewContentType.LOG_DEBUG_OUTPUT;
            consoleViewContentType = consoleViewContentType7;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType7, (String)"LOG_DEBUG_OUTPUT");
        }
        return consoleViewContentType;
    }

    public final void addOutputMessage(@NotNull BuildEventBase buildEvent, @NotNull IMutableViewableMap<ProjectId, String> projectsDirectories) {
        Intrinsics.checkNotNullParameter((Object)buildEvent, (String)"buildEvent");
        Intrinsics.checkNotNullParameter(projectsDirectories, (String)"projectsDirectories");
        BuildEventBase buildEventBase = buildEvent;
        if (buildEventBase instanceof ConsoleBuildEvent) {
            this.G("CONSOLE: " + buildEvent.getMessage(), this.G(buildEvent));
        } else if (buildEventBase instanceof MessageBuildEvent) {
            this.G((MessageBuildEvent)buildEvent);
        } else if (buildEventBase instanceof WarningBuildEvent) {
            this.G((ImportantBuildEvent)buildEvent, projectsDirectories);
        } else if (buildEventBase instanceof InfoBuildEvent) {
            this.G((ImportantBuildEvent)buildEvent, projectsDirectories);
        } else if (buildEventBase instanceof ReferenceBuildEvent) {
            this.G((ImportantBuildEvent)buildEvent, projectsDirectories);
        } else if (buildEventBase instanceof ErrorBuildEvent) {
            this.G((ImportantBuildEvent)buildEvent, projectsDirectories);
        }
    }

    public final void addStatusMessage(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        ConsoleViewContentType consoleViewContentType = this.G() ? ConsoleViewContentType.LOG_ERROR_OUTPUT : (this.b() ? ConsoleViewContentType.LOG_WARNING_OUTPUT : CONSOLE_GREEN_OUTPUT);
        Intrinsics.checkNotNull((Object)consoleViewContentType);
        this.console.print(message2, consoleViewContentType);
    }

    public boolean hasNextOccurence() {
        OccurenceNavigator occurenceNavigator = this.currentOccurrenceNavigator;
        if (occurenceNavigator == null) {
            return false;
        }
        OccurenceNavigator occurenceNavigator2 = occurenceNavigator;
        return occurenceNavigator2.hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        OccurenceNavigator occurenceNavigator = this.currentOccurrenceNavigator;
        if (occurenceNavigator == null) {
            return false;
        }
        OccurenceNavigator occurenceNavigator2 = occurenceNavigator;
        return occurenceNavigator2.hasPreviousOccurence();
    }

    @Nullable
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        OccurenceNavigator occurenceNavigator = this.currentOccurrenceNavigator;
        if (occurenceNavigator == null) {
            return null;
        }
        OccurenceNavigator occurenceNavigator2 = occurenceNavigator;
        return occurenceNavigator2.goNextOccurence();
    }

    @Nullable
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        OccurenceNavigator occurenceNavigator = this.currentOccurrenceNavigator;
        if (occurenceNavigator == null) {
            return null;
        }
        OccurenceNavigator occurenceNavigator2 = occurenceNavigator;
        return occurenceNavigator2.goPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        OccurenceNavigator occurenceNavigator = this.currentOccurrenceNavigator;
        if (occurenceNavigator == null) {
            String string = IdeBundle.message((String)"action.next.message", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        OccurenceNavigator occurenceNavigator2 = occurenceNavigator;
        String string = occurenceNavigator2.getNextOccurenceActionName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNextOccurenceActionName(...)");
        return string;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        OccurenceNavigator occurenceNavigator = this.currentOccurrenceNavigator;
        if (occurenceNavigator == null) {
            String string = IdeBundle.message((String)"action.previous.message", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        OccurenceNavigator occurenceNavigator2 = occurenceNavigator;
        String string = occurenceNavigator2.getPreviousOccurenceActionName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPreviousOccurenceActionName(...)");
        return string;
    }

    private final void G(String string, ConsoleViewContentType consoleViewContentType) {
        this.console.print(string + "\n", consoleViewContentType);
    }

    private final void G(MessageBuildEvent messageBuildEvent) {
        Object object = messageBuildEvent.getMessage();
        ProjectId projectId = messageBuildEvent.getProjectId();
        if (projectId != null) {
            object = projectId.getId() + ">" + (String)object;
        }
        this.G((String)object, this.G((BuildEventBase)messageBuildEvent));
    }

    private final void G(ImportantBuildEvent importantBuildEvent, IMutableViewableMap<ProjectId, String> iMutableViewableMap) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        boolean bl;
        VirtualFile virtualFile;
        ConsoleViewContentType consoleViewContentType = this.G((BuildEventBase)importantBuildEvent);
        String string6 = importantBuildEvent.getProjectId().getId() + ">";
        this.console.print(string6, consoleViewContentType);
        String string7 = (String)iMutableViewableMap.get((Object)importantBuildEvent.getProjectId());
        String string8 = importantBuildEvent.getFile();
        if (string8 == null) {
            string8 = "";
        }
        VirtualFile virtualFile2 = virtualFile = (bl = FileUtil.isAbsolute((String)(string5 = string8))) ? VfsUtil.findFileByIoFile((File)new File(string5), (boolean)true) : VfsUtil.findFileByIoFile((File)new File(string7, string5), (boolean)true);
        Object object = importantBuildEvent.getLineNumber() != 0 ? (importantBuildEvent.getColumnNumber() != 0 ? string5 + "(" + importantBuildEvent.getLineNumber() + "," + importantBuildEvent.getColumnNumber() + ")" : string5 + "(" + importantBuildEvent.getLineNumber() + ")") : (string4 = string5);
        if (virtualFile != null) {
            string3 = new OpenFileHyperlinkInfo(this.project, virtualFile, Math.max(0, importantBuildEvent.getLineNumber() - 1), Math.max(0, importantBuildEvent.getColumnNumber() - 1));
            this.console.printHyperlink(string4, (HyperlinkInfo)string3);
        } else {
            this.console.print(string4, consoleViewContentType);
        }
        if ((string2 = importantBuildEvent.getCode()) == null) {
            string2 = string3 = "";
        }
        if ((string = importantBuildEvent.getSubcategory()) == null) {
            string = "";
        }
        String string9 = string;
        String string10 = "";
        if (importantBuildEvent instanceof ErrorBuildEvent) {
            string10 = "Error";
        }
        if (importantBuildEvent instanceof WarningBuildEvent) {
            string10 = "Warning";
        }
        if (importantBuildEvent instanceof InfoBuildEvent) {
            string10 = "Message";
        }
        if (importantBuildEvent instanceof ReferenceBuildEvent) {
            string10 = "Reference";
        }
        String string11 = ": " + string10 + " " + string3 + " " + string9 + ": " + importantBuildEvent.getMessage() + "\n";
        this.console.print(string11, consoleViewContentType);
    }

    private static final Unit G(BuildResultPanel buildResultPanel) {
        Disposer.dispose((Disposable)((Disposable)buildResultPanel.console));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/build/ui/old/BuildResultPanel$Companion;", "", "BuildResultPanel$Companion", "()V", "consolePanelName", "", "buildEventsPanelName", "CONSOLE_NORMAL_OUTPUT", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "CONSOLE_GREEN_OUTPUT", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BuildMessageKind.values().length];
            try {
                nArray[BuildMessageKind.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildMessageKind.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildMessageKind.Message.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildMessageKind.Success.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

