/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.build.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.jetbrains.rider.build.BuildEventsService;
import com.jetbrains.rider.build.redesign.BuildToolwindowWidget;
import com.jetbrains.rider.build.ui.OpenFileWithTargetFrameworkDescriptor;
import com.jetbrains.rider.build.ui.RiderBuildResultTreeNode;
import com.jetbrains.rider.model.BuildEventRef;
import com.jetbrains.rider.model.build.BuildEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0000H\u0096\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/build/ui/RiderBuildResultItemTreeNode;", "Lcom/jetbrains/rider/build/ui/RiderBuildResultTreeNode;", "", "eventRef", "Lcom/jetbrains/rider/model/BuildEventRef;", "widget", "Lcom/jetbrains/rider/build/redesign/BuildToolwindowWidget;", "RiderBuildResultItemTreeNode", "(Lcom/jetbrains/rider/model/BuildEventRef;Lcom/jetbrains/rider/build/redesign/BuildToolwindowWidget;)V", "getEventRef", "()Lcom/jetbrains/rider/model/BuildEventRef;", "getWidget", "()Lcom/jetbrains/rider/build/redesign/BuildToolwindowWidget;", "compareTo", "", "other", "createNavigatable", "Lcom/intellij/pom/Navigatable;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
public final class RiderBuildResultItemTreeNode
extends RiderBuildResultTreeNode
implements Comparable<RiderBuildResultItemTreeNode> {
    @NotNull
    private final BuildEventRef eventRef;
    @NotNull
    private final BuildToolwindowWidget widget;

    public RiderBuildResultItemTreeNode(@NotNull BuildEventRef eventRef, @NotNull BuildToolwindowWidget widget) {
        Intrinsics.checkNotNullParameter((Object)eventRef, (String)"eventRef");
        Intrinsics.checkNotNullParameter((Object)((Object)widget), (String)"widget");
        this.eventRef = eventRef;
        this.widget = widget;
    }

    @NotNull
    public final BuildEventRef getEventRef() {
        return this.eventRef;
    }

    @NotNull
    public final BuildToolwindowWidget getWidget() {
        return this.widget;
    }

    @Override
    public int compareTo(@NotNull RiderBuildResultItemTreeNode other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.eventRef.getKind() != other.eventRef.getKind() ? this.eventRef.getKind().compareTo((Enum)other.eventRef.getKind()) : Intrinsics.compare((long)this.eventRef.getOffset(), (long)other.eventRef.getOffset());
    }

    @Override
    @Nullable
    public Navigatable createNavigatable(@NotNull Project project) {
        VirtualFile virtualFile;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        BuildEventsService buildEventsService = BuildEventsService.Companion.getInstance(project);
        if (!buildEventsService.isSessionActive()) {
            return null;
        }
        BuildEvent buildEvent = buildEventsService.getEvent(this.eventRef.getOffset());
        if (buildEvent.getLine() != null) {
            Integer n3 = buildEvent.getLine();
            Intrinsics.checkNotNull((Object)n3);
            v1 = n3;
        } else {
            v1 = n2 = 1;
        }
        if (buildEvent.getColumn() != null) {
            Integer n4 = buildEvent.getColumn();
            Intrinsics.checkNotNull((Object)n4);
            n = n4;
        } else {
            n = 1;
        }
        int n5 = n;
        String string = buildEvent.getFilePath();
        boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl && this.eventRef.getProjectId() != null) {
            String string2 = buildEvent.getFilePath();
            Intrinsics.checkNotNull((Object)string2);
            Integer n6 = this.eventRef.getProjectId();
            Intrinsics.checkNotNull((Object)n6);
            v8 = this.widget.resolveSourceFile$intellij_rider(new BuildToolwindowWidget.ProjectFileKey(string2, n6));
        } else {
            v8 = virtualFile = null;
        }
        if (virtualFile == null) {
            return null;
        }
        return (Navigatable)new OpenFileWithTargetFrameworkDescriptor(project, virtualFile, n2 - 1, n5 - 1, this.eventRef.getTargetFrameworkId(), this.eventRef.getProjectId());
    }
}

