/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.build.tasks;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.jetbrains.rider.build.BuildHost;
import com.jetbrains.rider.build.BuildParameters;
import com.jetbrains.rider.build.RiderBuildBundle;
import com.jetbrains.rider.build.tasks.BeforeRunTaskWithProjectProvider;
import com.jetbrains.rider.build.tasks.BuildProjectBeforeRunTask;
import com.jetbrains.rider.build.tasks.BuildTaskThrottler;
import com.jetbrains.rider.model.BuildTarget;
import com.jetbrains.rider.model.BuildTargetBase;
import com.jetbrains.rider.model.RdTargetFrameworkId;
import com.jetbrains.rider.run.configurations.IProjectBasedRunConfiguration;
import com.jetbrains.rider.run.configurations.multiPlatform.RiderMultiPlatformConfiguration;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J(\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u0019\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/build/tasks/BuildProjectBeforeRunTaskProvider;", "Lcom/jetbrains/rider/build/tasks/BeforeRunTaskWithProjectProvider;", "Lcom/jetbrains/rider/build/tasks/BuildProjectBeforeRunTask;", "BuildProjectBeforeRunTaskProvider", "()V", "baseDescription", "", "Lorg/jetbrains/annotations/Nls;", "getBaseDescription", "()Ljava/lang/String;", "getId", "Lcom/intellij/openapi/util/Key;", "getName", "getIcon", "Ljavax/swing/Icon;", "createTask", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "canExecuteTask", "", "task", "executeTask", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nBuildProjectBeforeRunTaskProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildProjectBeforeRunTaskProvider.kt\ncom/jetbrains/rider/build/tasks/BuildProjectBeforeRunTaskProvider\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,79:1\n13#2:80\n15#3:81\n*S KotlinDebug\n*F\n+ 1 BuildProjectBeforeRunTaskProvider.kt\ncom/jetbrains/rider/build/tasks/BuildProjectBeforeRunTaskProvider\n*L\n26#1:80\n26#1:81\n*E\n"})
public final class BuildProjectBeforeRunTaskProvider
extends BeforeRunTaskWithProjectProvider<BuildProjectBeforeRunTask> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<BuildProjectBeforeRunTask> providerId;
    @Nls
    @NotNull
    private static final String TASK_NAME;
    @NotNull
    private static final Logger logger;

    @Override
    @NotNull
    public String getBaseDescription() {
        return RiderBuildBundle.Companion.message("description.build.project", new Object[0]);
    }

    @NotNull
    public Key<BuildProjectBeforeRunTask> getId() {
        return providerId;
    }

    @NotNull
    public String getName() {
        return TASK_NAME;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Actions.Compile;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Compile");
        return icon;
    }

    @NotNull
    public BuildProjectBeforeRunTask createTask(@NotNull RunConfiguration configuration) {
        BuildProjectBeforeRunTask buildProjectBeforeRunTask;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        BuildProjectBeforeRunTask buildProjectBeforeRunTask2 = buildProjectBeforeRunTask = new BuildProjectBeforeRunTask();
        boolean bl = false;
        buildProjectBeforeRunTask2.setEnabled(this.shouldCreateBuildBeforeRunTaskByDefault(configuration));
        return buildProjectBeforeRunTask;
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull BuildProjectBeforeRunTask task2) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)task2), (String)"task");
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return (Boolean)BuildHost.Companion.getInstance(project).getReady().getValue();
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull BuildProjectBeforeRunTask task2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)((Object)task2), (String)"task");
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        BuildHost buildHost = BuildHost.Companion.getInstance(project);
        if (!((Boolean)buildHost.getReady().getValue()).booleanValue()) {
            logger.warn("buildHost is not ready");
            return false;
        }
        Object object2 = task2.getSelectedProject().getPath();
        if (object2 == null || (object2 = object2.toString()) == null) {
            BuildProjectBeforeRunTaskProvider buildProjectBeforeRunTaskProvider = this;
            boolean bl = false;
            RunConfiguration runConfiguration = configuration;
            object2 = runConfiguration instanceof RiderMultiPlatformConfiguration ? (String)((RiderMultiPlatformConfiguration)configuration).getParameters().getProjectFilePath().getValue() : (runConfiguration instanceof IProjectBasedRunConfiguration ? ((IProjectBasedRunConfiguration)configuration).getProjectFilePath() : null);
        }
        if ((object = object2) == null) {
            logger.warn("projectToBuildPath is null");
            return false;
        }
        List list2 = CollectionsKt.listOf((Object)object);
        RiderMultiPlatformConfiguration riderMultiPlatformConfiguration = configuration instanceof RiderMultiPlatformConfiguration ? (RiderMultiPlatformConfiguration)configuration : null;
        RdTargetFrameworkId rdTargetFrameworkId = riderMultiPlatformConfiguration != null ? riderMultiPlatformConfiguration.getTargetFrameworkId() : null;
        Project project2 = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        BuildTaskThrottler buildTaskThrottler = BuildTaskThrottler.Companion.getInstance(project2);
        return buildTaskThrottler.buildSequentiallySync(new BuildParameters((BuildTargetBase)new BuildTarget(), list2, false, false, false, false, false, rdTargetFrameworkId, 124, null)).getMsBuildStatus();
    }

    static {
        Key key = Key.create((String)"Build");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        providerId = key;
        TASK_NAME = RiderBuildBundle.Companion.message("BuildProjectBeforeRunTaskProvider.task.name.build.project", new Object[0]);
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(BuildProjectBeforeRunTaskProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/build/tasks/BuildProjectBeforeRunTaskProvider$Companion;", "", "BuildProjectBeforeRunTaskProvider$Companion", "()V", "providerId", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rider/build/tasks/BuildProjectBeforeRunTask;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getProviderId", "()Lcom/intellij/openapi/util/Key;", "TASK_NAME", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<BuildProjectBeforeRunTask> getProviderId() {
            return providerId;
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

