/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.build.redesign;

import com.jetbrains.rider.build.redesign.EventNode;
import com.jetbrains.rider.build.redesign.ProjectKey;
import com.jetbrains.rider.build.ui.RiderBuildResultProjectTreeNode;
import com.jetbrains.rider.model.BuildEventKind;
import com.jetbrains.rider.model.BuildEventRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001b\u001a\u00020\u0019J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/build/redesign/ProjectNode;", "", "key", "Lcom/jetbrains/rider/build/redesign/ProjectKey;", "isExpanded", "", "ProjectNode", "(Lcom/jetbrains/rider/build/redesign/ProjectKey;Z)V", "getKey", "()Lcom/jetbrains/rider/build/redesign/ProjectKey;", "()Z", "setExpanded", "(Z)V", "node", "Lcom/jetbrains/rider/build/ui/RiderBuildResultProjectTreeNode;", "getNode", "()Lcom/jetbrains/rider/build/ui/RiderBuildResultProjectTreeNode;", "setNode", "(Lcom/jetbrains/rider/build/ui/RiderBuildResultProjectTreeNode;)V", "eventNodes", "", "Lcom/jetbrains/rider/build/redesign/EventNode;", "getEventNodes", "()Ljava/util/List;", "errCount", "", "warnCount", "getRowsNumber", "addEvent", "", "ref", "Lcom/jetbrains/rider/model/BuildEventRef;", "intellij.rider"})
final class ProjectNode {
    @NotNull
    private final ProjectKey key;
    private boolean isExpanded;
    @Nullable
    private RiderBuildResultProjectTreeNode node;
    @NotNull
    private final List<EventNode> eventNodes;
    private int errCount;
    private int warnCount;

    public ProjectNode(@NotNull ProjectKey key, boolean isExpanded) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.key = key;
        this.isExpanded = isExpanded;
        this.eventNodes = new ArrayList();
    }

    @NotNull
    public final ProjectKey getKey() {
        return this.key;
    }

    public final boolean isExpanded() {
        return this.isExpanded;
    }

    public final void setExpanded(boolean bl) {
        this.isExpanded = bl;
    }

    @Nullable
    public final RiderBuildResultProjectTreeNode getNode() {
        return this.node;
    }

    public final void setNode(@Nullable RiderBuildResultProjectTreeNode riderBuildResultProjectTreeNode) {
        this.node = riderBuildResultProjectTreeNode;
    }

    @NotNull
    public final List<EventNode> getEventNodes() {
        return this.eventNodes;
    }

    public final int getRowsNumber() {
        if (!this.isExpanded) {
            return 1;
        }
        return ((Collection)this.eventNodes).size() + 1;
    }

    public final void addEvent(@NotNull BuildEventRef ref) {
        int n;
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        if (ref.getKind() == BuildEventKind.Error) {
            n = this.errCount;
            this.errCount = n + 1;
        }
        if (ref.getKind() == BuildEventKind.Warning) {
            n = this.warnCount;
            this.warnCount = n + 1;
        }
        this.eventNodes.add(new EventNode(ref));
    }
}

