/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rider.build.BuildToolWindowService;
import com.jetbrains.rider.build.RdBuildExtensionsKt;
import com.jetbrains.rider.build.diagnostics.BuildDiagnostic;
import com.jetbrains.rider.build.redesign.BuildToolwindowWidget;
import com.jetbrains.rider.build.redesign.model.BuildNotificationsListener;
import com.jetbrains.rider.model.BuildEventBase;
import com.jetbrains.rider.model.BuildResultKind;
import com.jetbrains.rider.model.BuildTargetBase;
import com.jetbrains.rider.model.ProjectId;
import com.jetbrains.rider.model.TxOutputItemBase;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 22\u00020\u0001:\u00012B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\"\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014J\u0006\u0010\u0017\u001a\u00020\u000eJ\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0016H\u0007J\u0006\u0010\u001f\u001a\u00020\u000eJ\u000e\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000bJ\b\u0010\"\u001a\u00020\u000eH\u0002J\u0006\u0010#\u001a\u00020\u000eJ\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0016J(\u0010+\u001a\u00020\u000e2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014J\u0006\u0010/\u001a\u00020\u000eJ\u000e\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u00063"}, d2={"Lcom/jetbrains/rider/build/BuildToolWindowContext;", "Lcom/jetbrains/rider/build/redesign/model/BuildNotificationsListener;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "content", "Lcom/intellij/ui/content/Content;", "widget", "Lcom/jetbrains/rider/build/redesign/BuildToolwindowWidget;", "BuildToolWindowContext", "(Lcom/intellij/openapi/wm/ToolWindow;Lcom/intellij/ui/content/Content;Lcom/jetbrains/rider/build/redesign/BuildToolwindowWidget;)V", "isActive", "", "()Z", "addBuildEvent", "", "buildEvent", "Lcom/jetbrains/rider/build/diagnostics/BuildDiagnostic;", "addOutputMessage", "Lcom/jetbrains/rider/model/BuildEventBase;", "projectsDirectories", "Lcom/jetbrains/rd/util/reactive/IMutableViewableMap;", "Lcom/jetbrains/rider/model/ProjectId;", "", "clear", "updateProgress", "operation", "Lcom/jetbrains/rider/model/BuildTargetBase;", "updateStatus", "kind", "Lcom/jetbrains/rider/model/BuildResultKind;", "buildTargetName", "invalidatePanelMode", "showToolWindowIfHidden", "activate", "G", "setToolwindowActions", "notifyBuildProgress", "n", "", "notifySolutionBuildFinished", "errorsCount", "", "warningsCount", "addOutputBatch", "items", "", "Lcom/jetbrains/rider/model/TxOutputItemBase;", "notifyBuildFinished", "updateLiveIcon", "isLive", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nBuildToolWindowContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildToolWindowContext.kt\ncom/jetbrains/rider/build/BuildToolWindowContext\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,100:1\n13#2:101\n15#3:102\n*S KotlinDebug\n*F\n+ 1 BuildToolWindowContext.kt\ncom/jetbrains/rider/build/BuildToolWindowContext\n*L\n18#1:101\n18#1:102\n*E\n"})
public final class BuildToolWindowContext
implements BuildNotificationsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ToolWindow toolWindow;
    @NotNull
    private final Content content;
    @NotNull
    private final BuildToolwindowWidget widget;
    @NotNull
    private static final Logger myLogger;

    public BuildToolWindowContext(@NotNull ToolWindow toolWindow, @NotNull Content content, @NotNull BuildToolwindowWidget widget) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)((Object)widget), (String)"widget");
        this.toolWindow = toolWindow;
        this.content = content;
        this.widget = widget;
    }

    public final boolean isActive() {
        return this.toolWindow.isActive();
    }

    public final void addBuildEvent(@NotNull BuildDiagnostic buildEvent) {
        Intrinsics.checkNotNullParameter((Object)buildEvent, (String)"buildEvent");
    }

    public final void addOutputMessage(@NotNull BuildEventBase buildEvent, @NotNull IMutableViewableMap<ProjectId, String> projectsDirectories) {
        Intrinsics.checkNotNullParameter((Object)buildEvent, (String)"buildEvent");
        Intrinsics.checkNotNullParameter(projectsDirectories, (String)"projectsDirectories");
        this.widget.addOutputMessage(buildEvent, projectsDirectories);
    }

    public final void clear() {
        this.widget.clear();
    }

    public final void updateProgress(@NotNull BuildTargetBase operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        String string = RdBuildExtensionsKt.toProgressText(operation);
    }

    @Nls
    @NotNull
    public final String updateStatus(@NotNull BuildResultKind kind, @NotNull String buildTargetName) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)buildTargetName, (String)"buildTargetName");
        String string = RdBuildExtensionsKt.toStatusText(kind, buildTargetName);
        String string2 = RdBuildExtensionsKt.toShortStatusText(kind, buildTargetName);
        myLogger.info("Build result: " + string2 + " - " + string);
        this.widget.addStatusMessage(string);
        return string;
    }

    public final void invalidatePanelMode() {
    }

    public final void showToolWindowIfHidden(boolean activate) {
        if (activate) {
            if (!this.toolWindow.isActive()) {
                this.toolWindow.activate(null);
                this.widget.updateViewport(true);
            }
        } else if (!this.toolWindow.isVisible()) {
            this.toolWindow.show(null);
            this.widget.updateViewport(true);
        }
        this.G();
    }

    private final void G() {
        this.toolWindow.getContentManager().setSelectedContent(this.content);
    }

    public final void setToolwindowActions() {
        this.widget.setToolwindowActions();
    }

    @Override
    public void notifyBuildProgress(float n) {
    }

    @Override
    public void notifySolutionBuildFinished(int errorsCount, int warningsCount) {
    }

    public final void addOutputBatch(@NotNull List<? extends TxOutputItemBase> items, @NotNull IMutableViewableMap<ProjectId, String> projectsDirectories) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(projectsDirectories, (String)"projectsDirectories");
        this.widget.addOutputBatch(items, (Map)projectsDirectories);
    }

    public final void notifyBuildFinished() {
        this.widget.notifyBuildFinished();
    }

    public final void updateLiveIcon(boolean isLive) {
        this.toolWindow.setIcon(BuildToolWindowService.Companion.getTW_ICON().getLiveIndicatorIcon(isLive));
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(BuildToolWindowContext.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        myLogger = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/build/BuildToolWindowContext$Companion;", "", "BuildToolWindowContext$Companion", "()V", "myLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

