/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.build;

import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.ui.SystemNotifications;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.model.SettingsModel;
import com.jetbrains.rd.ide.model.SettingsModel_GeneratedKt;
import com.jetbrains.rd.ide.model.WhenShowBuildResultMode;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rider.build.BuildEventsService;
import com.jetbrains.rider.build.BuildHost;
import com.jetbrains.rider.build.BuildToolWindowContext;
import com.jetbrains.rider.build.BuildToolWindowService;
import com.jetbrains.rider.build.BuildUsagesCollector;
import com.jetbrains.rider.build.RdBuildExtensionsKt;
import com.jetbrains.rider.build.Rider25962Notification;
import com.jetbrains.rider.build.RiderBuildBundle;
import com.jetbrains.rider.build.diagnostics.BuildDiagnostic;
import com.jetbrains.rider.build.diagnostics.DiagnosticKind;
import com.jetbrains.rider.model.BuildEvent;
import com.jetbrains.rider.model.BuildResult;
import com.jetbrains.rider.model.BuildSession;
import com.jetbrains.rider.model.ProjectId;
import com.jetbrains.rider.model.build.BuildEventKind;
import com.jetbrains.rider.model.dialog.RiderSettingsModel_PregeneratedKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u0019H\u0002J\n\u0010\u001f\u001a\u00020 *\u00020!J\f\u0010\"\u001a\u00020#*\u00020$H\u0002J\f\u0010\"\u001a\u00020#*\u00020%H\u0002J8\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u0011H\u0002J\"\u0010-\u001a\u00020\u00192\b\b\u0001\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u0002002\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/jetbrains/rider/build/BuildSessionView;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "BuildSessionView", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "protocol", "Lcom/jetbrains/rd/framework/IProtocol;", "G", "()Lcom/jetbrains/rd/framework/IProtocol;", "settingsModel", "Lcom/jetbrains/rd/ide/model/SettingsModel;", "G", "()Lcom/jetbrains/rd/ide/model/SettingsModel;", "rider25962DontShow", "", "rider25962LastTimestamp", "", "rider25962Notification", "Lcom/jetbrains/rider/build/Rider25962Notification;", "context", "Lcom/jetbrains/rider/build/BuildToolWindowContext;", "viewBuildSession", "", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/jetbrains/rider/model/BuildSession;", "G", "toDiagnostic", "Lcom/jetbrains/rider/build/diagnostics/BuildDiagnostic;", "Lcom/jetbrains/rider/model/BuildEvent;", "G", "Lcom/jetbrains/rider/build/diagnostics/DiagnosticKind;", "Lcom/jetbrains/rider/model/build/BuildEventKind;", "Lcom/jetbrains/rider/model/BuildEventKind;", "G", "buildTargetName", "", "buildResult", "Lcom/jetbrains/rider/model/BuildResult;", "activateToolWindow", "alwaysHidden", "G", "text", "type", "Lcom/intellij/notification/NotificationType;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nBuildSessionView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildSessionView.kt\ncom/jetbrains/rider/build/BuildSessionView\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,240:1\n13#2:241\n15#3:242\n*S KotlinDebug\n*F\n+ 1 BuildSessionView.kt\ncom/jetbrains/rider/build/BuildSessionView\n*L\n29#1:241\n29#1:242\n*E\n"})
public final class BuildSessionView
extends LifetimedService {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    private boolean rider25962DontShow;
    private long rider25962LastTimestamp;
    @NotNull
    private final Rider25962Notification rider25962Notification;
    @NotNull
    private final BuildToolWindowContext context;

    public BuildSessionView(@NotNull Project project) {
        Rider25962Notification rider25962Notification;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(BuildSessionView.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.logger = logger2;
        Rider25962Notification rider25962Notification2 = rider25962Notification = new Rider25962Notification();
        BuildSessionView buildSessionView = this;
        boolean bl3 = false;
        rider25962Notification2.addAction((AnAction)NotificationAction.createSimple((String)RiderBuildBundle.Companion.message("BuildSessionView.notification.content.how.to.fix", new Object[0]), () -> BuildSessionView.G(rider25962Notification2)));
        rider25962Notification2.addAction((AnAction)NotificationAction.createSimple((String)RiderBuildBundle.Companion.message("BuildSessionView.notification.content.do.not.show.again", new Object[0]), () -> BuildSessionView.G(rider25962Notification2, this)));
        buildSessionView.rider25962Notification = rider25962Notification;
        this.context = BuildToolWindowService.Companion.getInstance(this.project).getOrCreateContext(this.project);
    }

    private final IProtocol G() {
        return ApplicationProtocolKt.getProtocolHost((Project)this.project).getProtocol();
    }

    private final SettingsModel G() {
        return SettingsModel_GeneratedKt.getSettingsModel((IProtocol)this.G());
    }

    public final void viewBuildSession(@NotNull Lifetime sessionLifetime, @NotNull BuildSession session) {
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (session.getDumbOpeningIsApplicable() && BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.G().getShowBuildProgressInToolWindow())) && BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)RiderSettingsModel_PregeneratedKt.getRiderSettingsModel((IProtocol)this.G()).getSolBuilderShowToolWindowWithoutSmartness())) && !session.getAlwaysHidden()) {
            BuildToolWindowService.Companion.getInstance(this.project).getOrCreateContext(this.project).showToolWindowIfHidden(false);
        }
        this.context.clear();
        if (!session.getAlwaysHidden()) {
            this.context.updateLiveIcon(true);
        }
        BuildEventsService buildEventsService = BuildEventsService.Companion.getInstance(this.project);
        session.getResult().advise(sessionLifetime, arg_0 -> BuildSessionView.G(this, arg_0));
        this.logger.info("new session");
        sessionLifetime.onTermination(() -> BuildSessionView.G(this));
        buildEventsService.acceptNewSession(sessionLifetime, session);
        sessionLifetime.onTermination(() -> BuildSessionView.G(buildEventsService, this));
        buildEventsService.replaceListener(this.context);
        boolean bl = this.context.isActive();
        this.context.updateProgress(session.getOperation());
        session.getBuildEventRefs().advise(sessionLifetime, arg_0 -> BuildSessionView.G(buildEventsService, arg_0));
        session.getOutput().getItem().advise(sessionLifetime, arg_0 -> BuildSessionView.G(this, session, arg_0));
        session.getResult().advise(sessionLifetime, arg_0 -> BuildSessionView.G(buildEventsService, this, session, sessionLifetime, arg_0));
    }

    private final void G() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.rider25962DontShow || this.rider25962Notification.getBalloon() != null) {
            return;
        }
        long l = System.nanoTime();
        if (l - this.rider25962LastTimestamp < 1000000000L) {
            return;
        }
        this.rider25962LastTimestamp = l;
        this.rider25962Notification.notify(this.project);
    }

    @NotNull
    public final BuildDiagnostic toDiagnostic(@NotNull BuildEvent $this$toDiagnostic) {
        Intrinsics.checkNotNullParameter((Object)$this$toDiagnostic, (String)"<this>");
        return new BuildDiagnostic(this.G($this$toDiagnostic.getKind()), $this$toDiagnostic.getMessage(), $this$toDiagnostic.getCode(), $this$toDiagnostic.getProjectId(), $this$toDiagnostic.getTargetFramework(), $this$toDiagnostic.getFilePath(), $this$toDiagnostic.getLine(), $this$toDiagnostic.getColumn());
    }

    private final DiagnosticKind G(BuildEventKind buildEventKind) {
        return switch (WhenMappings.$EnumSwitchMapping$0[buildEventKind.ordinal()]) {
            case 1 -> DiagnosticKind.Error;
            case 2 -> DiagnosticKind.Warning;
            case 3 -> DiagnosticKind.Reference;
            default -> throw new Exception("Unknown kind");
        };
    }

    private final DiagnosticKind G(com.jetbrains.rider.model.BuildEventKind buildEventKind) {
        return switch (WhenMappings.$EnumSwitchMapping$1[buildEventKind.ordinal()]) {
            case 1 -> DiagnosticKind.Error;
            case 2 -> DiagnosticKind.Warning;
            case 3 -> DiagnosticKind.Reference;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void G(String string, BuildResult buildResult, Lifetime lifetime, boolean bl, BuildToolWindowContext buildToolWindowContext, boolean bl2) {
        String string2 = buildToolWindowContext.updateStatus(buildResult.getKind(), string);
        if (BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.G().getSwitchToTreeViewForEvents()))) {
            buildToolWindowContext.invalidatePanelMode();
        }
        ApplicationKt.getApplication().invokeLater(() -> BuildSessionView.G(lifetime, buildResult, string, this, string2, bl2, buildToolWindowContext, bl));
    }

    private final void G(@NlsContexts.NotificationContent String string, NotificationType notificationType, Lifetime lifetime) {
        Notification notification2 = new Notification("Build Messages", "", string, notificationType);
        Notifications.Bus.notify((Notification)notification2, (Project)this.project);
        this.logger.trace("Build notification " + notification2.hashCode() + " expired");
        lifetime.onTermination(() -> BuildSessionView.G(this, notification2));
    }

    private static final void G(Rider25962Notification rider25962Notification) {
        rider25962Notification.hideBalloon();
        BrowserUtil.browse((String)"https://jb.gg/incompatible-mono-dotnet-core");
    }

    private static final void G(Rider25962Notification rider25962Notification, BuildSessionView buildSessionView) {
        rider25962Notification.expire();
        buildSessionView.rider25962DontShow = true;
    }

    private static final Unit G(BuildSessionView buildSessionView, BuildResult buildResult) {
        Intrinsics.checkNotNullParameter((Object)buildResult, (String)"buildResultKind");
        buildSessionView.logger.info("result: " + buildResult);
        buildSessionView.context.updateLiveIcon(false);
        return Unit.INSTANCE;
    }

    private static final Unit G(BuildSessionView buildSessionView) {
        buildSessionView.logger.info("terminate");
        return Unit.INSTANCE;
    }

    private static final Unit G(BuildEventsService buildEventsService, BuildSessionView buildSessionView) {
        BuildEventsService.SessionEventStatistics sessionEventStatistics = buildEventsService.getCurrentStatistics();
        if (sessionEventStatistics != null) {
            BuildUsagesCollector.INSTANCE.logSessionClosed(buildSessionView.project, sessionEventStatistics);
        }
        return Unit.INSTANCE;
    }

    private static final Unit G(BuildEventsService buildEventsService, List list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"refs");
        buildEventsService.consumeRefs(list2);
        return Unit.INSTANCE;
    }

    private static final Unit G(BuildSessionView buildSessionView, BuildSession buildSession, List list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"outputItems");
        buildSessionView.context.addOutputBatch(list2, (IMutableViewableMap<ProjectId, String>)buildSession.getOutput().getProjectsDirectories());
        return Unit.INSTANCE;
    }

    private static final Unit G(BuildEventsService buildEventsService, BuildSessionView buildSessionView, BuildSession buildSession, Lifetime lifetime, BuildResult buildResult) {
        Intrinsics.checkNotNullParameter((Object)buildResult, (String)"buildResult");
        buildEventsService.notifyBuildFinished();
        buildSessionView.context.notifyBuildFinished();
        buildSessionView.G(BuildHost.Companion.getBuildTargetName(buildSession.getOperation()), buildResult, lifetime, buildSession.getActivateBuildResultsWindow(), buildSessionView.context, buildSession.getAlwaysHidden());
        return Unit.INSTANCE;
    }

    private static final void G(Lifetime lifetime, BuildResult buildResult, String string, BuildSessionView buildSessionView, String string2, boolean bl, BuildToolWindowContext buildToolWindowContext, boolean bl2) {
        if (!RLifetimeKt.isAlive((Lifetime)lifetime)) {
            return;
        }
        NotificationType notificationType = RdBuildExtensionsKt.toNotificationType(buildResult.getKind());
        if (buildResult.getShowNotification()) {
            SystemNotifications.getInstance().notify("Build Messages", RdBuildExtensionsKt.toShortStatusText(buildResult.getKind(), string), buildSessionView.project.getName());
            if (notificationType == NotificationType.INFORMATION || notificationType == NotificationType.WARNING) {
                buildSessionView.G(string2, notificationType, lifetime);
            } else {
                new Notification("Build Errors", "", string2, notificationType).notify(buildSessionView.project);
                StatusBarUtil.setStatusBarInfo((Project)buildSessionView.project, (String)string2);
            }
        } else {
            StatusBarUtil.setStatusBarInfo((Project)buildSessionView.project, (String)string2);
        }
        if (!bl) {
            WhenShowBuildResultMode whenShowBuildResultMode = (WhenShowBuildResultMode)buildSessionView.G().getShowResultAfterBuild().getValueOrNull();
            switch (whenShowBuildResultMode == null ? -1 : WhenMappings.$EnumSwitchMapping$2[whenShowBuildResultMode.ordinal()]) {
                case 1: {
                    buildToolWindowContext.showToolWindowIfHidden(bl2);
                    break;
                }
                case 2: {
                    if (notificationType != NotificationType.ERROR) break;
                    buildToolWindowContext.showToolWindowIfHidden(bl2);
                    break;
                }
                case 3: {
                    if (notificationType != NotificationType.WARNING && notificationType != NotificationType.ERROR) break;
                    buildToolWindowContext.showToolWindowIfHidden(bl2);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    if (notificationType != NotificationType.ERROR) break;
                    buildToolWindowContext.showToolWindowIfHidden(bl2);
                }
            }
        }
    }

    private static final Unit G(BuildSessionView buildSessionView, Notification notification2) {
        if (!buildSessionView.project.isDisposed()) {
            buildSessionView.logger.trace("Build notification " + notification2.hashCode() + " expired");
            notification2.expire();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[BuildEventKind.values().length];
            try {
                nArray[BuildEventKind.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildEventKind.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildEventKind.Reference.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[com.jetbrains.rider.model.BuildEventKind.values().length];
            try {
                nArray[com.jetbrains.rider.model.BuildEventKind.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[com.jetbrains.rider.model.BuildEventKind.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[com.jetbrains.rider.model.BuildEventKind.Reference.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[WhenShowBuildResultMode.values().length];
            try {
                nArray[WhenShowBuildResultMode.Always.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WhenShowBuildResultMode.ForErrors.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WhenShowBuildResultMode.ForWarningsOrErrors.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WhenShowBuildResultMode.Never.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

