/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.build;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdDynamic;
import com.jetbrains.rd.framework.InterfacesKt;
import com.jetbrains.rd.ide.model.SettingsModel;
import com.jetbrains.rd.ide.model.SettingsModel_GeneratedKt;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.build.BuildEventsService;
import com.jetbrains.rider.build.BuildHostKt;
import com.jetbrains.rider.build.BuildParameters;
import com.jetbrains.rider.build.BuildProgressOnApplicationIconProgressIndicator;
import com.jetbrains.rider.build.BuildRequest;
import com.jetbrains.rider.build.BuildSessionView;
import com.jetbrains.rider.build.BuildToolWindowService;
import com.jetbrains.rider.build.RiderBuildBundle;
import com.jetbrains.rider.build.ui.OpenFileWithTargetFrameworkDescriptor;
import com.jetbrains.rider.model.BuildArgs;
import com.jetbrains.rider.model.BuildModel;
import com.jetbrains.rider.model.BuildModel_PregeneratedKt;
import com.jetbrains.rider.model.BuildResult;
import com.jetbrains.rider.model.BuildResultKind;
import com.jetbrains.rider.model.BuildSession;
import com.jetbrains.rider.model.BuildTarget;
import com.jetbrains.rider.model.BuildTargetBase;
import com.jetbrains.rider.model.CleanTarget;
import com.jetbrains.rider.model.CustomTarget;
import com.jetbrains.rider.model.RdBuildEventNavigation;
import com.jetbrains.rider.model.RebuildTarget;
import com.jetbrains.rider.model.build.BuildEvent;
import com.jetbrains.rider.model.dialog.RiderSettingsModel_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.util.idea.IExternalTask;
import com.jetbrains.rider.util.idea.ProgressApiKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 @2\u00020\u0001:\u0002@AB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020!H\u0002J\u0010\u00102\u001a\u00020.2\u0006\u00103\u001a\u00020\u0016H\u0002J\u0006\u00104\u001a\u00020.J5\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u0002072%\b\u0002\u00108\u001a\u001f\u0012\u0013\u0012\u00110:\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b(=\u0012\u0004\u0012\u00020.\u0018\u000109J\b\u0010>\u001a\u00020.H\u0002J5\u0010?\u001a\u00020.2\u0006\u00106\u001a\u0002072%\b\u0002\u00108\u001a\u001f\u0012\u0013\u0012\u00110:\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b(=\u0012\u0004\u0012\u00020.\u0018\u000109R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0018R\u0019\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0018R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020+0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/jetbrains/rider/build/BuildHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "BuildHost", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "protocol", "Lcom/jetbrains/rd/framework/IProtocol;", "getProtocol", "()Lcom/jetbrains/rd/framework/IProtocol;", "settingsModel", "Lcom/jetbrains/rd/ide/model/SettingsModel;", "G", "()Lcom/jetbrains/rd/ide/model/SettingsModel;", "buildModel", "Lcom/jetbrains/rider/model/BuildModel;", "getBuildModel", "()Lcom/jetbrains/rider/model/BuildModel;", "ready", "Lcom/jetbrains/rd/util/reactive/Property;", "", "getReady", "()Lcom/jetbrains/rd/util/reactive/Property;", "building", "getBuilding", "canceling", "getCanceling", "lastBuildLog", "", "getLastBuildLog", "buildSession", "Lcom/jetbrains/rider/model/BuildSession;", "getBuildSession", "queuedRequest", "Lcom/jetbrains/rider/build/BuildRequest;", "getQueuedRequest", "()Lcom/jetbrains/rider/build/BuildRequest;", "setQueuedRequest", "(Lcom/jetbrains/rider/build/BuildRequest;)V", "notificationsExpireOnBuildStart", "", "Lcom/intellij/notification/Notification;", "notificationsExpireOnBuildFinish", "G", "", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "G", "value", "cancel", "requestBuild", "buildParameters", "Lcom/jetbrains/rider/build/BuildParameters;", "onFinished", "Lkotlin/Function1;", "Lcom/jetbrains/rider/model/BuildResultKind;", "Lkotlin/ParameterName;", "name", "result", "b", "queueBuild", "Companion", "ProtocolListener", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nBuildHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildHost.kt\ncom/jetbrains/rider/build/BuildHost\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,371:1\n1863#2:372\n1864#2:374\n1863#2,2:377\n1#3:373\n31#4,2:375\n*S KotlinDebug\n*F\n+ 1 BuildHost.kt\ncom/jetbrains/rider/build/BuildHost\n*L\n89#1:372\n89#1:374\n100#1:377,2\n150#1:375,2\n*E\n"})
public final class BuildHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Property<Boolean> ready;
    @NotNull
    private final Property<Boolean> building;
    @NotNull
    private final Property<Boolean> canceling;
    @NotNull
    private final Property<String> lastBuildLog;
    @NotNull
    private final Property<BuildSession> buildSession;
    @Nullable
    private BuildRequest queuedRequest;
    @NotNull
    private final List<Notification> notificationsExpireOnBuildStart;
    @NotNull
    private final List<Notification> notificationsExpireOnBuildFinish;
    @NotNull
    public static final String GLOBAL_BUILD_GROUP_ID = "Global Build Messages";

    public BuildHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.ready = new Property((Object)false);
        this.building = new Property((Object)false);
        this.canceling = new Property((Object)false);
        this.lastBuildLog = new Property((Object)"");
        this.buildSession = new Property(null);
        this.notificationsExpireOnBuildStart = new ArrayList();
        this.notificationsExpireOnBuildFinish = new ArrayList();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final IProtocol getProtocol() {
        return ApplicationProtocolKt.getProtocolHost((Project)this.project).getProtocol();
    }

    private final SettingsModel G() {
        return SettingsModel_GeneratedKt.getSettingsModel((IProtocol)this.getProtocol());
    }

    @NotNull
    public final BuildModel getBuildModel() {
        return BuildModel_PregeneratedKt.getBuildModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project));
    }

    @NotNull
    public final Property<Boolean> getReady() {
        return this.ready;
    }

    @NotNull
    public final Property<Boolean> getBuilding() {
        return this.building;
    }

    @NotNull
    public final Property<Boolean> getCanceling() {
        return this.canceling;
    }

    @NotNull
    public final Property<String> getLastBuildLog() {
        return this.lastBuildLog;
    }

    @NotNull
    public final Property<BuildSession> getBuildSession() {
        return this.buildSession;
    }

    @Nullable
    public final BuildRequest getQueuedRequest() {
        return this.queuedRequest;
    }

    public final void setQueuedRequest(@Nullable BuildRequest buildRequest) {
        this.queuedRequest = buildRequest;
    }

    private final void G(Lifetime lifetime, BuildSession buildSession) {
        Object object;
        boolean bl;
        Notification notification2;
        Object object22;
        Iterable iterable = this.notificationsExpireOnBuildStart;
        boolean bl2 = false;
        for (Object object22 : iterable) {
            Object object3;
            notification2 = (Notification)object22;
            bl = false;
            object = BuildHostKt.access$getLogger$p();
            try {
                object3 = object;
                boolean bl3 = false;
                notification2.expire();
                object3 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
        this.notificationsExpireOnBuildStart.clear();
        iterable = lifetime.createNested();
        Lifetime lifetime2 = iterable.getLifetime();
        buildSession.getResult().advise(lifetime, arg_0 -> BuildHost.G((LifetimeDefinition)iterable, this, arg_0));
        this.buildSession.setValue((Object)buildSession);
        lifetime.onTermination(() -> BuildHost.G(this, buildSession));
        this.building.setValue((Object)true);
        this.canceling.setValue((Object)false);
        this.lastBuildLog.setValue((Object)"");
        buildSession.getLogFileName().view(lifetime, (arg_0, arg_1) -> BuildHost.G(this, arg_0, arg_1));
        String string = buildSession.getProgressTitle();
        object22 = () -> BuildHost.b(this, buildSession);
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)this.canceling), (Lifetime)lifetime, arg_0 -> BuildHost.G(object22, arg_0));
        if (!ApplicationKt.getApplication().isUnitTestMode() && BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.G().getShowBuildProgressOnStatusBar())) && !buildSession.getAlwaysHidden()) {
            notification2 = ProgressApiKt.externalTask((Project)this.project, (boolean)true, (IExternalTask)new IExternalTask(lifetime2, (Function0<Unit>)object22, string, buildSession){
                final /* synthetic */ Lifetime $activeBuildLifetime;
                final /* synthetic */ Function0<Unit> $cancelAction;
                final /* synthetic */ String $progressTitle;
                final /* synthetic */ BuildSession $session;
                {
                    this.$activeBuildLifetime = $activeBuildLifetime;
                    this.$cancelAction = $cancelAction;
                    this.$progressTitle = $progressTitle;
                    this.$session = $session;
                }

                public Lifetime getLifetime() {
                    return this.$activeBuildLifetime;
                }

                public Function0<Unit> getCancel() {
                    return this.$cancelAction;
                }

                public String getTitle() {
                    return this.$progressTitle;
                }

                public String getHeader() {
                    return (String)this.$session.getActiveProjectName().getValue();
                }

                public String getDescription() {
                    return "";
                }

                public boolean isIndeterminate() {
                    return false;
                }

                public double getProgress() {
                    return ((Number)this.$session.getProgress().getValue()).doubleValue();
                }
            }, (ProgressIndicatorEx)((ProgressIndicatorEx)new BuildProgressOnApplicationIconProgressIndicator(lifetime, this.project, buildSession)));
            BuildHostKt.access$getLogger$p().trace("Build running with progress on application icon");
            ProgressManager.getInstance().run((Task)notification2);
        } else {
            BuildHostKt.access$getLogger$p().trace("Build running without progress on application icon");
        }
        notification2 = (ComponentManager)this.project;
        bl = false;
        object = BuildSessionView.class;
        Object object4 = notification2.getService((Class)object);
        if (object4 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)notification2, (Class)object);
        }
        ((BuildSessionView)((Object)object4)).viewBuildSession(lifetime, buildSession);
    }

    private final void G(boolean bl) {
        BuildRequest buildRequest;
        this.ready.setValue((Object)bl);
        if (bl && (buildRequest = this.queuedRequest) != null) {
            BuildHostKt.access$getLogger$p().trace("Transform queued request into backend request");
            this.requestBuild(buildRequest.getBuildParameters(), buildRequest.getOnFinished());
            this.building.setValue((Object)true);
            BuildHostKt.access$getLogger$p().trace("Cleanup queued request");
            this.queuedRequest = null;
        }
    }

    public final void cancel() {
        if (this.queuedRequest != null) {
            BuildHostKt.access$getLogger$p().trace("Cancel: clear queuedRequest");
            this.queuedRequest = null;
        } else {
            BuildHostKt.access$getLogger$p().trace("Cancel: send signal to backend");
            this.canceling.setValue((Object)true);
            com.jetbrains.rd.util.reactive.InterfacesKt.fire((ISignal)this.getBuildModel().getCancelCurrentRequest());
        }
    }

    public final boolean requestBuild(@NotNull BuildParameters buildParameters, @Nullable Function1<? super BuildResultKind, Unit> onFinished) {
        Intrinsics.checkNotNullParameter((Object)buildParameters, (String)"buildParameters");
        ThreadingAssertions.assertEventDispatchThread();
        WriteIntentReadAction.run(BuildHost::G);
        if (BuildHostKt.access$getLogger$p().isTraceEnabled()) {
            BuildHostKt.access$getLogger$p().trace((Throwable)new Exception("requestBuild stack"));
        }
        if (((Boolean)this.building.getValue()).booleanValue()) {
            Notification notification2 = new Notification(GLOBAL_BUILD_GROUP_ID, "", RiderBuildBundle.Companion.message("BuildHost.notification.content.cannot.start.already.building", new Object[0]), NotificationType.WARNING);
            Notifications.Bus.notify((Notification)notification2, (Project)this.project);
            this.notificationsExpireOnBuildFinish.add(notification2);
            if (onFinished != null) {
                onFinished.invoke((Object)BuildResultKind.Crashed);
            }
            return false;
        }
        if (BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.getBuildModel().getReady()))) {
            try {
                BuildHostKt.access$getLogger$p().info("Request new build: operation=" + buildParameters.getOperation().getClass().getSimpleName() + ", selectedProjectPaths='" + CollectionsKt.joinToString$default((Iterable)buildParameters.getSelectedProjectsPaths(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "', silentMode=" + buildParameters.getSilentMode() + ", activateWindowOnStart=" + buildParameters.getActivateWindowOnStart() + ", diagnosticsMode=" + buildParameters.getDiagnosticsMode() + ", withoutDependencies=" + buildParameters.getWithoutDependencies() + ", targetFramework=" + buildParameters.getTargetFramework());
                this.buildSession.set(null);
                BuildTargetBase buildTargetBase = buildParameters.getOperation();
                this.getBuildModel().getRequest().set((Object)new BuildArgs(buildTargetBase, buildParameters.getSelectedProjectsPaths(), buildParameters.getDiagnosticsMode(), buildParameters.getSilentMode(), buildParameters.getWithoutDependencies(), buildParameters.getNoRestore(), buildParameters.getTargetFramework()));
                LifetimeDefinition lifetimeDefinition = this.getServiceLifetime().createNested();
                Lifetime lifetime = lifetimeDefinition.getLifetime();
                com.jetbrains.rd.util.reactive.InterfacesKt.viewNotNull((IViewable)((IViewable)this.buildSession), (Lifetime)lifetime, (arg_0, arg_1) -> BuildHost.G(this, buildParameters, lifetimeDefinition, onFinished, lifetime, arg_0, arg_1));
                this.building.set((Object)true);
                return true;
            }
            catch (Throwable throwable) {
                BuildHostKt.access$getLogger$p().error(throwable);
                if (onFinished != null) {
                    onFinished.invoke((Object)BuildResultKind.Crashed);
                }
                return false;
            }
        }
        BuildHostKt.access$getLogger$p().warn("Cannot execute request !buildModel.buildModelReady.hasValue");
        if (onFinished != null) {
            onFinished.invoke((Object)BuildResultKind.Crashed);
        }
        return false;
    }

    public static /* synthetic */ boolean requestBuild$default(BuildHost buildHost, BuildParameters buildParameters, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return buildHost.requestBuild(buildParameters, (Function1<? super BuildResultKind, Unit>)function1);
    }

    private final void b() {
        boolean bl = !ApplicationKt.getApplication().isUnitTestMode();
        LocalFileSystem.getInstance().refresh(bl);
    }

    public final void queueBuild(@NotNull BuildParameters buildParameters, @Nullable Function1<? super BuildResultKind, Unit> onFinished) {
        Intrinsics.checkNotNullParameter((Object)buildParameters, (String)"buildParameters");
        this.queuedRequest = new BuildRequest(buildParameters, onFinished);
        Notification notification2 = new Notification(GLOBAL_BUILD_GROUP_ID, "", RiderBuildBundle.Companion.message("BuildHost.notification.content.queue.build", new Object[0]), NotificationType.INFORMATION);
        Notifications.Bus.notify((Notification)notification2, (Project)this.project);
        this.notificationsExpireOnBuildStart.add(notification2);
    }

    public static /* synthetic */ void queueBuild$default(BuildHost buildHost, BuildParameters buildParameters, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        buildHost.queueBuild(buildParameters, (Function1<? super BuildResultKind, Unit>)function1);
    }

    private static final Unit G(LifetimeDefinition lifetimeDefinition, BuildHost buildHost, BuildResult buildResult) {
        Intrinsics.checkNotNullParameter((Object)buildResult, (String)"it");
        LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        buildHost.building.setValue((Object)false);
        buildHost.canceling.setValue((Object)false);
        ActionToolbarImpl.updateAllToolbarsImmediately();
        Iterable iterable = buildHost.notificationsExpireOnBuildFinish;
        boolean bl = false;
        for (Object t : iterable) {
            Object object;
            Notification notification2 = (Notification)t;
            boolean bl2 = false;
            Logger logger2 = BuildHostKt.access$getLogger$p();
            try {
                object = logger2;
                boolean bl3 = false;
                notification2.expire();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
        buildHost.notificationsExpireOnBuildFinish.clear();
        return Unit.INSTANCE;
    }

    private static final Unit G(BuildHost buildHost, BuildSession buildSession) {
        if (Intrinsics.areEqual((Object)buildHost.buildSession.getValue(), (Object)buildSession)) {
            buildHost.buildSession.setValue(null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit G(BuildHost buildHost) {
        buildHost.lastBuildLog.setValue((Object)"");
        return Unit.INSTANCE;
    }

    private static final Unit G(BuildHost buildHost, Lifetime lifetime, String string) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"logFileLifetime");
        Intrinsics.checkNotNullParameter((Object)string, (String)"fileName");
        if (((CharSequence)string).length() > 0) {
            buildHost.lastBuildLog.setValue((Object)string);
        }
        lifetime.onTermination(() -> BuildHost.G(buildHost));
        return Unit.INSTANCE;
    }

    private static final Unit r(BuildHost buildHost, BuildSession buildSession) {
        if (RLifetimeKt.isAlive((Lifetime)buildHost.getServiceLifetime())) {
            com.jetbrains.rd.util.reactive.InterfacesKt.fire((ISignal)buildSession.getCancel());
        }
        return Unit.INSTANCE;
    }

    private static final Unit b(BuildHost buildHost, BuildSession buildSession) {
        InterfacesKt.getProtocolOrThrow((IRdDynamic)((IRdDynamic)buildHost.getBuildModel())).getScheduler().invokeOrQueue(() -> BuildHost.r(buildHost, buildSession));
        return Unit.INSTANCE;
    }

    private static final Unit G(Function0 function0, Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"it");
        function0.invoke();
        return Unit.INSTANCE;
    }

    private static final void G() {
        FileDocumentManager.getInstance().saveAllDocuments();
    }

    private static final Unit G(BuildHost buildHost, LifetimeDefinition lifetimeDefinition, Function1 function1, BuildResult buildResult) {
        Intrinsics.checkNotNullParameter((Object)buildResult, (String)"res");
        BuildHostKt.access$getLogger$p().info("Build finished with result: " + buildResult);
        buildHost.b();
        LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        if (function1 != null) {
            function1.invoke((Object)buildResult.getKind());
        }
        return Unit.INSTANCE;
    }

    private static final Unit G(Lifetime lifetime, LifetimeDefinition lifetimeDefinition, Function1 function1) {
        if (RLifetimeKt.isAlive((Lifetime)lifetime)) {
            BuildHostKt.access$getLogger$p().info("Build finished by lifetime termination");
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
            if (function1 != null) {
                function1.invoke((Object)BuildResultKind.Crashed);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit G(BuildHost buildHost, BuildParameters buildParameters, LifetimeDefinition lifetimeDefinition, Function1 function1, Lifetime lifetime, Lifetime lifetime2, BuildSession buildSession) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"sessionLifetime");
        Intrinsics.checkNotNullParameter((Object)buildSession, (String)"session");
        BuildHostKt.access$getLogger$p().info("Build session started");
        if (BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)buildHost.G().getShowBuildProgressInToolWindow())) && (buildParameters.getActivateWindowOnStart() || BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)RiderSettingsModel_PregeneratedKt.getRiderSettingsModel((IProtocol)buildHost.getProtocol()).getSolBuilderShowToolWindowWithoutSmartness()))) && !buildSession.getAlwaysHidden()) {
            BuildToolWindowService.Companion.getInstance(buildHost.project).getOrCreateContext(buildHost.project).showToolWindowIfHidden(false);
        }
        buildSession.getResult().advise(lifetime2, arg_0 -> BuildHost.G(buildHost, lifetimeDefinition, function1, arg_0));
        lifetime2.onTermination(() -> BuildHost.G(lifetime, lifetimeDefinition, function1));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/build/BuildHost$Companion;", "", "BuildHost$Companion", "()V", "GLOBAL_BUILD_GROUP_ID", "", "getBuildTargetName", "buildTarget", "Lcom/jetbrains/rider/model/BuildTargetBase;", "getInstance", "Lcom/jetbrains/rider/build/BuildHost;", "project", "Lcom/intellij/openapi/project/Project;", "isIdle", "", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nBuildHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildHost.kt\ncom/jetbrains/rider/build/BuildHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,371:1\n31#2,2:372\n*S KotlinDebug\n*F\n+ 1 BuildHost.kt\ncom/jetbrains/rider/build/BuildHost$Companion\n*L\n66#1:372,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getBuildTargetName(@NotNull BuildTargetBase buildTarget) {
            Intrinsics.checkNotNullParameter((Object)buildTarget, (String)"buildTarget");
            BuildTargetBase buildTargetBase = buildTarget;
            if (buildTargetBase instanceof BuildTarget) {
                return "Build";
            }
            if (buildTargetBase instanceof RebuildTarget) {
                return "Rebuild";
            }
            if (buildTargetBase instanceof CleanTarget) {
                return "Clean";
            }
            if (buildTargetBase instanceof CustomTarget) {
                return ((CustomTarget)buildTarget).getTargetName();
            }
            return "";
        }

        @NotNull
        public final BuildHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Class<BuildHost> clazz = BuildHost.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (BuildHost)((Object)object);
        }

        public final boolean isIdle(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            BuildHost buildHost = this.getInstance(project);
            return (Boolean)buildHost.getReady().getValue() != false && buildHost.getQueuedRequest() == null && (Boolean)buildHost.getBuilding().getValue() == false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/build/BuildHost$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/model/BuildModel;", "BuildHost$ProtocolListener", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "G", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "", "projectId", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nBuildHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildHost.kt\ncom/jetbrains/rider/build/BuildHost$ProtocolListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,371:1\n1863#2,2:372\n*S KotlinDebug\n*F\n+ 1 BuildHost.kt\ncom/jetbrains/rider/build/BuildHost$ProtocolListener\n*L\n356#1:372,2\n*E\n"})
    public static final class ProtocolListener
    implements SolutionExtListener<BuildModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull BuildModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            com.jetbrains.rd.util.reactive.InterfacesKt.viewNotNull((IViewable)((IViewable)model.getBuildSession()), (Lifetime)lifetime, (arg_0, arg_1) -> ProtocolListener.G(session, arg_0, arg_1));
            model.getReady().advise(lifetime, arg_0 -> ProtocolListener.G(session, arg_0));
            model.getRequestIsCancelledBeforeExecution().advise(lifetime, arg_0 -> ProtocolListener.G(session, arg_0));
            model.getNavigateToEvent().advise(lifetime, arg_0 -> ProtocolListener.G(session, this, arg_0));
            model.getShowToolWindow().advise(lifetime, arg_0 -> ProtocolListener.b(session, arg_0));
        }

        private final VirtualFile G(String string, int n, Project project) {
            File file2 = new File(string);
            if (file2.isAbsolute()) {
                return VfsUtil.findFileByIoFile((File)file2, (boolean)false);
            }
            WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project);
            Object object = new ProjectModelEntity[]{WorkspaceModelExtensionsKt.getProjectModelEntity((WorkspaceModel)workspaceModel, (int)n), WorkspaceModelExtensionsKt.getSolutionEntity((WorkspaceModel)workspaceModel)};
            List list2 = CollectionsKt.listOf((Object[])object);
            object = CollectionsKt.filterNotNull((Iterable)list2);
            boolean bl = false;
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                ProjectModelEntity projectModelEntity = (ProjectModelEntity)t;
                boolean bl2 = false;
                VirtualFile virtualFile = ProjectModelEntityExtensionsKt.getVirtualFileAsParent((ProjectModelEntity)projectModelEntity);
                if (virtualFile == null) continue;
                File file3 = DocumentUtilKt.toIOFile((VirtualFile)virtualFile);
                String string2 = file2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                VirtualFile virtualFile2 = VfsUtil.findFileByIoFile((File)FilesKt.resolve((File)file3, (String)string2), (boolean)true);
                if (virtualFile2 == null) continue;
                return virtualFile2;
            }
            return null;
        }

        private static final Unit G(ClientProjectSession clientProjectSession, Lifetime lifetime, BuildSession buildSession) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"sessionLifetime");
            Intrinsics.checkNotNullParameter((Object)buildSession, (String)"buildSession");
            Companion.getInstance(clientProjectSession.getProject()).G(lifetime, buildSession);
            return Unit.INSTANCE;
        }

        private static final Unit G(ClientProjectSession clientProjectSession, boolean bl) {
            Companion.getInstance(clientProjectSession.getProject()).G(bl);
            return Unit.INSTANCE;
        }

        private static final Unit G(ClientProjectSession clientProjectSession, Unit unit) {
            BuildHost buildHost;
            Intrinsics.checkNotNullParameter((Object)unit, (String)"it");
            BuildHost buildHost2 = buildHost = Companion.getInstance(clientProjectSession.getProject());
            boolean bl = false;
            BuildHostKt.access$getLogger$p().trace("Receive requestIsCancelledBeforeExecution");
            buildHost2.getCanceling().setValue((Object)false);
            buildHost2.getBuilding().setValue((Object)false);
            return Unit.INSTANCE;
        }

        private static final Unit G(ClientProjectSession clientProjectSession, ProtocolListener protocolListener, RdBuildEventNavigation rdBuildEventNavigation) {
            BuildHost buildHost;
            Intrinsics.checkNotNullParameter((Object)rdBuildEventNavigation, (String)"it");
            BuildHost buildHost2 = buildHost = Companion.getInstance(clientProjectSession.getProject());
            boolean bl = false;
            BuildEventsService buildEventsService = BuildEventsService.Companion.getInstance(clientProjectSession.getProject());
            if (buildEventsService.isSessionActive()) {
                try {
                    VirtualFile virtualFile;
                    int n;
                    int n2;
                    BuildEvent buildEvent = buildEventsService.getEvent(rdBuildEventNavigation.getOffset());
                    if (buildEvent.getLine() != null) {
                        Integer n3 = buildEvent.getLine();
                        Intrinsics.checkNotNull((Object)n3);
                        v1 = n3;
                    } else {
                        v1 = n2 = 1;
                    }
                    if (buildEvent.getColumn() != null) {
                        Integer n4 = buildEvent.getColumn();
                        Intrinsics.checkNotNull((Object)n4);
                        n = n4;
                    } else {
                        n = 1;
                    }
                    int n5 = n;
                    String string = buildEvent.getFilePath();
                    boolean bl2 = string != null ? ((CharSequence)string).length() > 0 : false;
                    if (bl2 && buildEvent.getProjectId() != null) {
                        String string2 = buildEvent.getFilePath();
                        Intrinsics.checkNotNull((Object)string2);
                        Integer n6 = buildEvent.getProjectId();
                        Intrinsics.checkNotNull((Object)n6);
                        v8 = protocolListener.G(string2, n6, clientProjectSession.getProject());
                    } else {
                        v8 = virtualFile = null;
                    }
                    if (virtualFile != null) {
                        OpenFileWithTargetFrameworkDescriptor openFileWithTargetFrameworkDescriptor = new OpenFileWithTargetFrameworkDescriptor(buildHost2.getProject(), virtualFile, n2 - 1, n5 - 1, buildEvent.getTargetFramework(), buildEvent.getProjectId());
                        openFileWithTargetFrameworkDescriptor.navigate(true);
                    }
                }
                catch (Exception exception) {
                    BuildHostKt.access$getLogger$p().error("Failed navigation to " + rdBuildEventNavigation.getOffset(), (Throwable)exception);
                }
            }
            return Unit.INSTANCE;
        }

        private static final Unit b(ClientProjectSession clientProjectSession, boolean bl) {
            BuildToolWindowService.Companion.getInstance(clientProjectSession.getProject()).getOrCreateContext(clientProjectSession.getProject()).showToolWindowIfHidden(bl);
            return Unit.INSTANCE;
        }
    }
}

