/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.build;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rider.build.InFileBuildEventsLoader;
import com.jetbrains.rider.build.redesign.model.BuildNotificationsListener;
import com.jetbrains.rider.model.BuildEventKind;
import com.jetbrains.rider.model.BuildEventRef;
import com.jetbrains.rider.model.BuildSession;
import com.jetbrains.rider.model.build.BuildEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 72\u00020\u0001:\u000278B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u001dJ\u0006\u0010 \u001a\u00020\u000bJ\u0014\u0010!\u001a\u00020\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0016\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u0006\u0010*\u001a\u00020)J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J.\u00102\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u00103\u001a\u00020%2\u0018\u00104\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u000b0\bJ\b\u00105\u001a\u0004\u0018\u000106R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u000b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001e\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\n0\u001aj\b\u0012\u0004\u0012\u00020\n`\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010/\u001a\u000700\u00a2\u0006\u0002\b1X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/jetbrains/rider/build/BuildEventsService;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "BuildEventsService", "(Lcom/intellij/openapi/project/Project;)V", "myEventHandlers", "", "Lkotlin/Function1;", "", "Lcom/jetbrains/rider/model/BuildEventRef;", "", "loader", "Lcom/jetbrains/rider/build/InFileBuildEventsLoader;", "mySequence", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "errCnt", "", "getErrCnt", "()I", "setErrCnt", "(I)V", "warnCnt", "getWarnCnt", "setWarnCnt", "myCurrentEvents", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "listeners", "Lcom/jetbrains/rider/build/redesign/model/BuildNotificationsListener;", "replaceListener", "l", "notifyBuildFinished", "consumeRefs", "refs", "acceptNewSession", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/jetbrains/rider/model/BuildSession;", "sessionActive", "", "isSessionActive", "getEvent", "Lcom/jetbrains/rider/model/build/BuildEvent;", "item", "", "LOCK", "", "Lorg/jetbrains/annotations/NotNull;", "getEventsAndSubscribe", "lifetime", "handler", "getCurrentStatistics", "Lcom/jetbrains/rider/build/BuildEventsService$SessionEventStatistics;", "Companion", "SessionEventStatistics", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nBuildEventsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildEventsService.kt\ncom/jetbrains/rider/build/BuildEventsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1863#2,2:102\n*S KotlinDebug\n*F\n+ 1 BuildEventsService.kt\ncom/jetbrains/rider/build/BuildEventsService\n*L\n53#1:102,2\n*E\n"})
public final class BuildEventsService
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<Function1<List<BuildEventRef>, Unit>> myEventHandlers;
    @Nullable
    private InFileBuildEventsLoader loader;
    @NotNull
    private final SequentialLifetimes mySequence;
    private int errCnt;
    private int warnCnt;
    @NotNull
    private ArrayList<BuildEventRef> myCurrentEvents;
    @NotNull
    private final List<BuildNotificationsListener> listeners;
    private boolean sessionActive;
    @NotNull
    private final Object LOCK;

    public BuildEventsService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myEventHandlers = new ArrayList();
        this.mySequence = new SequentialLifetimes(this.getServiceLifetime());
        this.myCurrentEvents = new ArrayList();
        this.listeners = new ArrayList();
        Object object = ObjectUtils.sentinel((String)"BuildEventsService Lock");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sentinel(...)");
        this.LOCK = object;
    }

    public final int getErrCnt() {
        return this.errCnt;
    }

    public final void setErrCnt(int n) {
        this.errCnt = n;
    }

    public final int getWarnCnt() {
        return this.warnCnt;
    }

    public final void setWarnCnt(int n) {
        this.warnCnt = n;
    }

    public final void replaceListener(@NotNull BuildNotificationsListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.clear();
        this.listeners.add(l);
    }

    public final void notifyBuildFinished() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void consumeRefs(@NotNull List<BuildEventRef> refs) {
        Intrinsics.checkNotNullParameter(refs, (String)"refs");
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            int n = 0;
            for (BuildEventRef buildEventRef : refs) {
                int n2;
                if (n == 0 && buildEventRef.getProjectId() != null) {
                    Integer n3 = buildEventRef.getProjectId();
                    Intrinsics.checkNotNull((Object)n3);
                    n = n3;
                }
                if (buildEventRef.getKind() == BuildEventKind.Error) {
                    n2 = this.errCnt;
                    this.errCnt = n2 + 1;
                }
                if (buildEventRef.getKind() == BuildEventKind.Warning) {
                    n2 = this.warnCnt;
                    this.warnCnt = n2 + 1;
                }
                this.myCurrentEvents.add(buildEventRef);
            }
            Iterable iterable = this.myEventHandlers;
            boolean bl2 = false;
            Iterator iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                Function1 function1 = (Function1)t;
                boolean bl3 = false;
                function1.invoke(refs);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void acceptNewSession(@NotNull Lifetime sessionLifetime, @NotNull BuildSession session) {
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            Lifetime lifetime = this.mySequence.next().getLifetime();
            sessionLifetime.onTermination(() -> BuildEventsService.G(this));
            this.loader = new InFileBuildEventsLoader(lifetime, session.getEventsStoragePath());
            this.sessionActive = true;
            lifetime.onTermination(() -> BuildEventsService.b(this));
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean isSessionActive() {
        return this.sessionActive;
    }

    @NotNull
    public final BuildEvent getEvent(long item) {
        InFileBuildEventsLoader inFileBuildEventsLoader = this.loader;
        Intrinsics.checkNotNull((Object)inFileBuildEventsLoader);
        return inFileBuildEventsLoader.loadEvent(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<BuildEventRef> getEventsAndSubscribe(@NotNull Lifetime lifetime, @NotNull Function1<? super List<BuildEventRef>, Unit> handler2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            this.myEventHandlers.add(handler2);
            lifetime.onTermination(() -> BuildEventsService.G(this, handler2));
            List list2 = CollectionsKt.toList((Iterable)this.myCurrentEvents);
            return list2;
        }
    }

    @Nullable
    public final SessionEventStatistics getCurrentStatistics() {
        if (this.loader == null) {
            return null;
        }
        int n = ((Collection)this.myCurrentEvents).size();
        InFileBuildEventsLoader inFileBuildEventsLoader = this.loader;
        Intrinsics.checkNotNull((Object)inFileBuildEventsLoader);
        return new SessionEventStatistics(n, inFileBuildEventsLoader.getLoadedEventsCount(), this.errCnt, this.warnCnt);
    }

    private static final Unit G(BuildEventsService buildEventsService) {
        buildEventsService.mySequence.terminateCurrent();
        return Unit.INSTANCE;
    }

    private static final Unit b(BuildEventsService buildEventsService) {
        buildEventsService.myCurrentEvents.clear();
        buildEventsService.listeners.clear();
        buildEventsService.sessionActive = false;
        buildEventsService.errCnt = 0;
        buildEventsService.warnCnt = 0;
        return Unit.INSTANCE;
    }

    private static final Unit G(BuildEventsService buildEventsService, Function1 function1) {
        buildEventsService.myEventHandlers.remove(function1);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/build/BuildEventsService$Companion;", "", "BuildEventsService$Companion", "()V", "getInstance", "Lcom/jetbrains/rider/build/BuildEventsService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nBuildEventsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildEventsService.kt\ncom/jetbrains/rider/build/BuildEventsService$Companion\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,101:1\n17#2,2:102\n*S KotlinDebug\n*F\n+ 1 BuildEventsService.kt\ncom/jetbrains/rider/build/BuildEventsService$Companion\n*L\n24#1:102,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BuildEventsService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Object object = componentManager.getService(BuildEventsService.class);
            if (object == null) {
                throw new IllegalStateException("Service " + BuildEventsService.class + " not found in container " + componentManager);
            }
            return (BuildEventsService)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/build/BuildEventsService$SessionEventStatistics;", "", "totalEvents", "", "loadedEvents", "errCnt", "warnCnt", "BuildEventsService$SessionEventStatistics", "(IIII)V", "getTotalEvents", "()I", "getLoadedEvents", "getErrCnt", "getWarnCnt", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.rider"})
    public static final class SessionEventStatistics {
        private final int totalEvents;
        private final int loadedEvents;
        private final int errCnt;
        private final int warnCnt;

        public SessionEventStatistics(int totalEvents, int loadedEvents, int errCnt, int warnCnt) {
            this.totalEvents = totalEvents;
            this.loadedEvents = loadedEvents;
            this.errCnt = errCnt;
            this.warnCnt = warnCnt;
        }

        public final int getTotalEvents() {
            return this.totalEvents;
        }

        public final int getLoadedEvents() {
            return this.loadedEvents;
        }

        public final int getErrCnt() {
            return this.errCnt;
        }

        public final int getWarnCnt() {
            return this.warnCnt;
        }

        public final int component1() {
            return this.totalEvents;
        }

        public final int component2() {
            return this.loadedEvents;
        }

        public final int component3() {
            return this.errCnt;
        }

        public final int component4() {
            return this.warnCnt;
        }

        @NotNull
        public final SessionEventStatistics copy(int totalEvents, int loadedEvents, int errCnt, int warnCnt) {
            return new SessionEventStatistics(totalEvents, loadedEvents, errCnt, warnCnt);
        }

        public static /* synthetic */ SessionEventStatistics copy$default(SessionEventStatistics sessionEventStatistics, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = sessionEventStatistics.totalEvents;
            }
            if ((n5 & 2) != 0) {
                n2 = sessionEventStatistics.loadedEvents;
            }
            if ((n5 & 4) != 0) {
                n3 = sessionEventStatistics.errCnt;
            }
            if ((n5 & 8) != 0) {
                n4 = sessionEventStatistics.warnCnt;
            }
            return sessionEventStatistics.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "SessionEventStatistics(totalEvents=" + this.totalEvents + ", loadedEvents=" + this.loadedEvents + ", errCnt=" + this.errCnt + ", warnCnt=" + this.warnCnt + ")";
        }

        public int hashCode() {
            int n = Integer.hashCode(this.totalEvents);
            n = n * 31 + Integer.hashCode(this.loadedEvents);
            n = n * 31 + Integer.hashCode(this.errCnt);
            n = n * 31 + Integer.hashCode(this.warnCnt);
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SessionEventStatistics)) {
                return false;
            }
            SessionEventStatistics sessionEventStatistics = (SessionEventStatistics)other;
            if (this.totalEvents != sessionEventStatistics.totalEvents) {
                return false;
            }
            if (this.loadedEvents != sessionEventStatistics.loadedEvents) {
                return false;
            }
            if (this.errCnt != sessionEventStatistics.errCnt) {
                return false;
            }
            return this.warnCnt == sessionEventStatistics.warnCnt;
        }
    }
}

