/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.actions.impl.cleanup;

import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.rider.actions.impl.cleanup.RiderCodeCleanupCallStrategy;
import com.jetbrains.rider.actions.impl.cleanup.RiderCodeCleanupSupportKt;
import com.jetbrains.rider.actions.impl.cleanup.RiderCodeCleanupSupportPolicy;
import com.jetbrains.rider.platform.ProtocolLanguageFeatureProvider;
import com.jetbrains.rider.platform.SinglePerLanguageExtension;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0007\u001a\u0014 \t*\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\b0\u0006\u00a2\u0006\u0002\b\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/actions/impl/cleanup/RiderCodeCleanupSupport;", "Lcom/jetbrains/rider/platform/ProtocolLanguageFeatureProvider;", "RiderCodeCleanupSupport", "()V", "extensions", "Lcom/jetbrains/rider/platform/SinglePerLanguageExtension;", "Lcom/jetbrains/rider/actions/impl/cleanup/RiderCodeCleanupSupportPolicy;", "forLanguage", "Lorg/jetbrains/annotations/UnknownNullability;", "kotlin.jvm.PlatformType", "language", "Lcom/intellij/lang/Language;", "(Lcom/intellij/lang/Language;)Lcom/jetbrains/rider/actions/impl/cleanup/RiderCodeCleanupSupportPolicy;", "getSupportPolicy", "Lcom/jetbrains/rider/actions/impl/cleanup/RiderCodeCleanupCallStrategy;", "element", "Lcom/intellij/psi/PsiElement;", "hasBackendParts", "", "file", "Lcom/intellij/psi/PsiFile;", "hasFrontendParts", "isAvailable", "intellij.rider"})
public final class RiderCodeCleanupSupport
implements ProtocolLanguageFeatureProvider {
    @NotNull
    public static final RiderCodeCleanupSupport INSTANCE = new RiderCodeCleanupSupport();
    @NotNull
    private static final SinglePerLanguageExtension<RiderCodeCleanupSupportPolicy> extensions = new SinglePerLanguageExtension("com.intellij.code.cleanup.support");

    private RiderCodeCleanupSupport() {
    }

    @JvmStatic
    public static final RiderCodeCleanupSupportPolicy forLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return (RiderCodeCleanupSupportPolicy)extensions.findSingle((Object)language);
    }

    @NotNull
    public final RiderCodeCleanupCallStrategy getSupportPolicy(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Object object = RiderCodeCleanupSupport.forLanguage(language);
        if (object == null || (object = object.getPolicy()) == null) {
            object = RiderCodeCleanupCallStrategy.FRONTEND_ONLY;
        }
        return object;
    }

    @NotNull
    public final RiderCodeCleanupCallStrategy getSupportPolicy(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return RiderCodeCleanupCallStrategy.FRONTEND_ONLY;
        }
        PsiFile psiFile2 = psiFile;
        boolean bl = psiFile2.isValid();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Language language = psiFile2.getViewProvider().getBaseLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getBaseLanguage(...)");
        Language language2 = language;
        return this.getSupportPolicy(language2);
    }

    public final boolean hasBackendParts(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        return RiderCodeCleanupSupportKt.isBackendInvolved(this.getSupportPolicy(language));
    }

    public final boolean hasFrontendParts(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        return RiderCodeCleanupSupportKt.isFrontendInvolved(this.getSupportPolicy(language));
    }

    public boolean isAvailable(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.hasBackendParts(file2);
    }
}

