/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.actions.impl.cleanup;

import com.intellij.lang.Language;
import com.intellij.openapi.util.JDOMUtil;
import com.jetbrains.rider.actions.impl.cleanup.CleanupAction;
import com.jetbrains.rider.actions.impl.cleanup.RiderCodeCleanupSupport;
import com.jetbrains.rider.actions.impl.cleanup.RiderCodeCleanupSupportKt;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\u0003J\u0012\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/actions/impl/cleanup/FrontendReformatCleanupProfileModel;", "", "content", "", "FrontendReformatCleanupProfileModel", "(Ljava/lang/String;)V", "getContent", "()Ljava/lang/String;", "languages", "", "Lcom/jetbrains/rider/actions/impl/cleanup/FrontendReformatCleanupProfileModel$LanguageData;", "serialize", "G", "language", "Lcom/intellij/lang/Language;", "getLanguages", "", "getActions", "Lcom/jetbrains/rider/actions/impl/cleanup/CleanupAction;", "", "getActionsForThisAndBaseLanguage", "setActionValue", "", "action", "value", "Companion", "LanguageData", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nFrontendReformatCleanupProfileModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendReformatCleanupProfileModel.kt\ncom/jetbrains/rider/actions/impl/cleanup/FrontendReformatCleanupProfileModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1557#2:106\n1628#2,3:107\n*S KotlinDebug\n*F\n+ 1 FrontendReformatCleanupProfileModel.kt\ncom/jetbrains/rider/actions/impl/cleanup/FrontendReformatCleanupProfileModel\n*L\n91#1:106\n91#1:107,3\n*E\n"})
public final class FrontendReformatCleanupProfileModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String content;
    @NotNull
    private final Map<String, LanguageData> languages;
    @NotNull
    public static final String languageElementName = "Language";
    @NotNull
    public static final String languageIdAttributeName = "id";

    public FrontendReformatCleanupProfileModel(@NotNull String content) {
        Object object;
        Language language;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.content = content;
        boolean bl = Intrinsics.areEqual((Object)this.content, (Object)"$DEFAULT$");
        TreeMap treeMap = new TreeMap();
        for (Object object2 : Language.getRegisteredLanguages()) {
            if (object2.getBaseLanguage() != null && !Intrinsics.areEqual((Object)object2.getID(), (Object)"HTML")) continue;
            Element element2 = new HashMap();
            language = CleanupAction.Companion.getEP_NAME().getExtensionList().iterator();
            while (language.hasNext()) {
                object = (CleanupAction)language.next();
                Intrinsics.checkNotNull((Object)object2);
                if (!object.allowForLanguage((Language)object2) || !RiderCodeCleanupSupportKt.isFrontendInvolved(RiderCodeCleanupSupport.INSTANCE.getSupportPolicy((Language)object2))) continue;
                ((Map)element2).put(object, bl || object.getAllowForReformatProfile());
            }
            if (element2.size() <= 0) continue;
            Map map2 = treeMap;
            String string = object2.getID();
            Intrinsics.checkNotNull((Object)object2);
            map2.put(string, new LanguageData((Language)object2, (Map)element2));
        }
        this.languages = treeMap;
        if (!Intrinsics.areEqual((Object)this.content, (Object)"$DEFAULT$") && !Intrinsics.areEqual((Object)this.content, (Object)"$REFORMAT$")) {
            Element element = JDOMUtil.load((Reader)new StringReader(this.content));
            for (Element element2 : element.getChildren()) {
                if (!Intrinsics.areEqual((Object)element2.getName(), (Object)languageElementName) || (language = Language.findLanguageByID((String)element2.getAttributeValue(languageIdAttributeName))) == null || (object = (LanguageData)((TreeMap)this.languages).get(language.getID())) == null) continue;
                block3: for (Element element3 : element2.getChildren()) {
                    for (CleanupAction cleanupAction : (CleanupAction[])CleanupAction.Companion.getEP_NAME().getExtensions()) {
                        if (!Intrinsics.areEqual((Object)cleanupAction.getId(), (Object)element3.getName()) || !((LanguageData)object).getActions().containsKey(cleanupAction)) continue;
                        boolean bl2 = Boolean.parseBoolean(element3.getTextTrim());
                        Boolean bl3 = bl2;
                        ((LanguageData)object).getActions().put(cleanupAction, bl3);
                        continue block3;
                    }
                }
            }
        }
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @NotNull
    public final String serialize() {
        Element element = new Element("profile");
        for (Map.Entry<String, LanguageData> entry2 : this.languages.entrySet()) {
            String string = entry2.getKey();
            LanguageData languageData = entry2.getValue();
            Element element2 = new Element(languageElementName);
            element2.setAttribute(languageIdAttributeName, string);
            for (Map.Entry<CleanupAction, Boolean> entry3 : languageData.getActions().entrySet()) {
                CleanupAction cleanupAction = entry3.getKey();
                boolean bl = entry3.getValue();
                Element element3 = new Element(cleanupAction.getId());
                element3.setText(String.valueOf(bl));
                element2.addContent(element3);
            }
            element.addContent(element2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JDOMUtil.write((Parent)((Parent)element), (OutputStream)byteArrayOutputStream);
        String string = byteArrayOutputStream.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final LanguageData G(Language language) {
        for (Language language2 = language; language2 != null; language2 = language2.getBaseLanguage()) {
            LanguageData languageData = this.languages.get(language2.getID());
            if (languageData == null) continue;
            return languageData;
        }
        return null;
    }

    @NotNull
    public final List<Language> getLanguages() {
        Iterable iterable = this.languages.values();
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            LanguageData languageData = (LanguageData)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(languageData.getLanguage());
        }
        return (List)collection;
    }

    @Nullable
    public final Map<CleanupAction, Boolean> getActions(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        LanguageData languageData = this.languages.get(language.getID());
        return languageData != null ? languageData.getActions() : null;
    }

    @Nullable
    public final Map<CleanupAction, Boolean> getActionsForThisAndBaseLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        LanguageData languageData = this.G(language);
        if (languageData == null) {
            return null;
        }
        LanguageData languageData2 = languageData;
        return languageData2.getActions();
    }

    public final void setActionValue(@NotNull Language language, @NotNull CleanupAction action2, boolean value2) {
        block0: {
            Map<CleanupAction, Boolean> map2;
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            LanguageData languageData = this.languages.get(language.getID());
            if (languageData == null || (map2 = languageData.getActions()) == null) break block0;
            Boolean bl = value2;
            map2.put(action2, bl);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/actions/impl/cleanup/FrontendReformatCleanupProfileModel$Companion;", "", "FrontendReformatCleanupProfileModel$Companion", "()V", "languageElementName", "", "languageIdAttributeName", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/actions/impl/cleanup/FrontendReformatCleanupProfileModel$LanguageData;", "", "language", "Lcom/intellij/lang/Language;", "actions", "", "Lcom/jetbrains/rider/actions/impl/cleanup/CleanupAction;", "", "FrontendReformatCleanupProfileModel$LanguageData", "(Lcom/intellij/lang/Language;Ljava/util/Map;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "getActions", "()Ljava/util/Map;", "intellij.rider"})
    private static final class LanguageData {
        @NotNull
        private final Language language;
        @NotNull
        private final Map<CleanupAction, Boolean> actions;

        public LanguageData(@NotNull Language language, @NotNull Map<CleanupAction, Boolean> actions) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter(actions, (String)"actions");
            this.language = language;
            this.actions = actions;
        }

        @NotNull
        public final Language getLanguage() {
            return this.language;
        }

        @NotNull
        public final Map<CleanupAction, Boolean> getActions() {
            return this.actions;
        }
    }
}

