/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.personalization.impl;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.completion.ml.personalization.UserFactor;
import com.intellij.completion.ml.personalization.UserFactorsManager;
import com.intellij.completion.ml.personalization.impl.AveragePrefixLength;
import com.intellij.completion.ml.personalization.impl.AverageSelectedItemPosition;
import com.intellij.completion.ml.personalization.impl.AverageTimeBetweenTyping;
import com.intellij.completion.ml.personalization.impl.CompletionTypeRatio;
import com.intellij.completion.ml.personalization.impl.ExplicitSelectRatio;
import com.intellij.completion.ml.personalization.impl.FullLineSelectionCountDecayedBy;
import com.intellij.completion.ml.personalization.impl.FullLineShowUpCountDecayedBy;
import com.intellij.completion.ml.personalization.impl.FullLineSmoothedAcceptanceRate;
import com.intellij.completion.ml.personalization.impl.FullLineTimeSinceLastSelection;
import com.intellij.completion.ml.personalization.impl.FullLineTimeSinceLastShowUp;
import com.intellij.completion.ml.personalization.impl.FullLineUserFactorsKt;
import com.intellij.completion.ml.personalization.impl.FullLineWasSelected;
import com.intellij.completion.ml.personalization.impl.LookupCancelledRatio;
import com.intellij.completion.ml.personalization.impl.MaxSelectedItemPosition;
import com.intellij.completion.ml.personalization.impl.MnemonicsRatio;
import com.intellij.completion.ml.personalization.impl.MostFrequentPrefixLength;
import com.intellij.completion.ml.personalization.impl.MostFrequentSelectedItemPosition;
import com.intellij.completion.ml.personalization.impl.PrefixMatchingTypeRatio;
import com.intellij.completion.ml.personalization.impl.TemplatesRatio;
import com.intellij.completion.ml.personalization.impl.TodayCompletionUsageCount;
import com.intellij.completion.ml.personalization.impl.TotalUsageCount;
import com.intellij.completion.ml.personalization.impl.TypedSelectRatio;
import com.intellij.completion.ml.personalization.impl.WeekAverageUsageCount;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.textMatching.PrefixMatchingType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/completion/ml/personalization/impl/UserFactorsManagerImpl;", "Lcom/intellij/completion/ml/personalization/UserFactorsManager;", "<init>", "()V", "userFactors", "", "", "Lcom/intellij/completion/ml/personalization/UserFactor;", "registerAllFactors", "", "getAllFactors", "", "register", "factor", "Companion", "intellij.completionMlRanking"})
public final class UserFactorsManagerImpl
implements UserFactorsManager {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, UserFactor> userFactors = new LinkedHashMap();
    @NotNull
    private static final Logger LOG;

    public UserFactorsManagerImpl() {
        this.registerAllFactors();
    }

    private final void registerAllFactors() {
        this.register(new TypedSelectRatio());
        this.register(new ExplicitSelectRatio());
        this.register(new LookupCancelledRatio());
        this.register(new CompletionTypeRatio(CompletionType.BASIC));
        this.register(new CompletionTypeRatio(CompletionType.SMART));
        this.register(new CompletionTypeRatio(CompletionType.CLASS_NAME));
        this.register(new TodayCompletionUsageCount());
        this.register(new TotalUsageCount());
        this.register(new WeekAverageUsageCount());
        this.register(new MostFrequentPrefixLength());
        this.register(new AveragePrefixLength());
        this.register(new AverageSelectedItemPosition());
        this.register(new MaxSelectedItemPosition());
        this.register(new MostFrequentSelectedItemPosition());
        this.register(new AverageTimeBetweenTyping());
        this.register(new MnemonicsRatio());
        this.register(new TemplatesRatio());
        PrefixMatchingType[] prefixMatchingTypeArray = FullLineUserFactorsKt.getDECAY_DURATIONS().iterator();
        while (prefixMatchingTypeArray.hasNext()) {
            long duration = prefixMatchingTypeArray.next().unbox-impl();
            this.register(new FullLineSmoothedAcceptanceRate(duration, null));
            this.register(new FullLineSelectionCountDecayedBy(duration, null));
            this.register(new FullLineShowUpCountDecayedBy(duration, null));
        }
        this.register(new FullLineTimeSinceLastSelection());
        this.register(new FullLineTimeSinceLastShowUp());
        this.register(new FullLineWasSelected());
        for (PrefixMatchingType type : PrefixMatchingType.values()) {
            this.register(new PrefixMatchingTypeRatio(type));
        }
    }

    @Override
    @NotNull
    public List<UserFactor> getAllFactors() {
        return CollectionsKt.toList((Iterable)this.userFactors.values());
    }

    private final void register(UserFactor factor) {
        UserFactor old = this.userFactors.put(factor.getId(), factor);
        if (old != null) {
            if (old == factor) {
                LOG.warn("The same factor was registered twice");
            } else {
                Object[] objectArray = new String[]{factor.getClass().getCanonicalName(), old.getClass().getCanonicalName()};
                LOG.warn("Two different factors with the same id found: id = " + old.getId() + ", classes = " + CollectionsKt.listOf((Object[])objectArray));
            }
        }
    }

    static {
        Logger logger = Logger.getInstance(UserFactorsManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/completion/ml/personalization/impl/UserFactorsManagerImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.completionMlRanking"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

