/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fortea.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.fortea.psi.T4ElementType;
import com.jetbrains.fortea.psi.T4TokenType;
import com.jetbrains.fortea.psi.impl.T4AttributeImpl;
import com.jetbrains.fortea.psi.impl.T4AttributeNameImpl;
import com.jetbrains.fortea.psi.impl.T4BlockImpl;
import com.jetbrains.fortea.psi.impl.T4CodeBlockImpl;
import com.jetbrains.fortea.psi.impl.T4DirectiveImpl;
import com.jetbrains.fortea.psi.impl.T4DirectiveNameImpl;
import com.jetbrains.fortea.psi.impl.T4ExpressionBlockImpl;
import com.jetbrains.fortea.psi.impl.T4FeatureBlockImpl;
import com.jetbrains.fortea.psi.impl.T4StatementBlockImpl;

public interface T4ElementTypes {
    public static final IElementType ATTRIBUTE = new T4ElementType("ATTRIBUTE");
    public static final IElementType ATTRIBUTE_NAME = new T4ElementType("ATTRIBUTE_NAME");
    public static final IElementType BLOCK = new T4ElementType("BLOCK");
    public static final IElementType CODE_BLOCK = new T4ElementType("CODE_BLOCK");
    public static final IElementType DIRECTIVE = new T4ElementType("DIRECTIVE");
    public static final IElementType DIRECTIVE_NAME = new T4ElementType("DIRECTIVE_NAME");
    public static final IElementType EXPRESSION_BLOCK = new T4ElementType("EXPRESSION_BLOCK");
    public static final IElementType FEATURE_BLOCK = new T4ElementType("FEATURE_BLOCK");
    public static final IElementType STATEMENT_BLOCK = new T4ElementType("STATEMENT_BLOCK");
    public static final IElementType BLOCK_END = new T4TokenType("BLOCK_END");
    public static final IElementType DIRECTIVE_START = new T4TokenType("DIRECTIVE_START");
    public static final IElementType DOLLAR = new T4TokenType("DOLLAR");
    public static final IElementType EQUAL = new T4TokenType("EQUAL");
    public static final IElementType EXPRESSION_BLOCK_START = new T4TokenType("EXPRESSION_BLOCK_START");
    public static final IElementType FEATURE_BLOCK_START = new T4TokenType("FEATURE_BLOCK_START");
    public static final IElementType LEFT_PARENTHESIS = new T4TokenType("LEFT_PARENTHESIS");
    public static final IElementType NEW_LINE = new T4TokenType("NEW_LINE");
    public static final IElementType PERCENT = new T4TokenType("PERCENT");
    public static final IElementType QUOTE = new T4TokenType("QUOTE");
    public static final IElementType RAW_ATTRIBUTE_VALUE = new T4TokenType("RAW_ATTRIBUTE_VALUE");
    public static final IElementType RAW_CODE = new T4TokenType("RAW_CODE");
    public static final IElementType RAW_TEXT = new T4TokenType("RAW_TEXT");
    public static final IElementType RIGHT_PARENTHESIS = new T4TokenType("RIGHT_PARENTHESIS");
    public static final IElementType STATEMENT_BLOCK_START = new T4TokenType("STATEMENT_BLOCK_START");
    public static final IElementType TOKEN = new T4TokenType("TOKEN");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == ATTRIBUTE) {
                return new T4AttributeImpl(node);
            }
            if (type == ATTRIBUTE_NAME) {
                return new T4AttributeNameImpl(node);
            }
            if (type == BLOCK) {
                return new T4BlockImpl(node);
            }
            if (type == CODE_BLOCK) {
                return new T4CodeBlockImpl(node);
            }
            if (type == DIRECTIVE) {
                return new T4DirectiveImpl(node);
            }
            if (type == DIRECTIVE_NAME) {
                return new T4DirectiveNameImpl(node);
            }
            if (type == EXPRESSION_BLOCK) {
                return new T4ExpressionBlockImpl(node);
            }
            if (type == FEATURE_BLOCK) {
                return new T4FeatureBlockImpl(node);
            }
            if (type == STATEMENT_BLOCK) {
                return new T4StatementBlockImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + String.valueOf(type)));
        }
    }
}

