/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fortea.highlighting;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.fortea.highlighting.T4TextAttributeKeys;
import com.jetbrains.fortea.lexer.T4Lexer;
import com.jetbrains.fortea.psi.T4ElementTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u001b\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u001b\u0010\t\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u001b\u0010\n\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/fortea/highlighting/T4SyntaxHighlighter;", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighterBase;", "<init>", "()V", "BLOCK_MARKER_KEYS", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Lorg/jetbrains/annotations/NotNull;", "[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "EQUAL_KEYS", "QUOTE_KEYS", "getTokenHighlights", "elementType", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/tree/IElementType;)[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getHighlightingLexer", "Lcom/jetbrains/fortea/lexer/T4Lexer;", "intellij.rider.plugins.for.tea"})
public final class T4SyntaxHighlighter
extends SyntaxHighlighterBase {
    @NotNull
    public static final T4SyntaxHighlighter INSTANCE = new T4SyntaxHighlighter();
    @NotNull
    private static final TextAttributesKey[] BLOCK_MARKER_KEYS;
    @NotNull
    private static final TextAttributesKey[] EQUAL_KEYS;
    @NotNull
    private static final TextAttributesKey[] QUOTE_KEYS;

    private T4SyntaxHighlighter() {
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(@Nullable IElementType elementType) {
        TextAttributesKey[] textAttributesKeyArray;
        IElementType iElementType = elementType;
        if (Intrinsics.areEqual((Object)iElementType, (Object)T4ElementTypes.BLOCK_END)) {
            textAttributesKeyArray = BLOCK_MARKER_KEYS;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)T4ElementTypes.STATEMENT_BLOCK_START)) {
            textAttributesKeyArray = BLOCK_MARKER_KEYS;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)T4ElementTypes.DIRECTIVE_START)) {
            textAttributesKeyArray = BLOCK_MARKER_KEYS;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)T4ElementTypes.EQUAL)) {
            textAttributesKeyArray = EQUAL_KEYS;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)T4ElementTypes.EXPRESSION_BLOCK_START)) {
            textAttributesKeyArray = BLOCK_MARKER_KEYS;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)T4ElementTypes.FEATURE_BLOCK_START)) {
            textAttributesKeyArray = BLOCK_MARKER_KEYS;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)T4ElementTypes.QUOTE)) {
            textAttributesKeyArray = QUOTE_KEYS;
        } else {
            textAttributesKeyArray = TextAttributesKey.EMPTY_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)TextAttributesKey.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public T4Lexer getHighlightingLexer() {
        return new T4Lexer();
    }

    static {
        TextAttributesKey[] textAttributesKeyArray = new TextAttributesKey[]{T4TextAttributeKeys.INSTANCE.getT4_BLOCK_MARKER()};
        BLOCK_MARKER_KEYS = textAttributesKeyArray;
        textAttributesKeyArray = new TextAttributesKey[]{T4TextAttributeKeys.INSTANCE.getT4_DIRECTIVE_EQ_SIGN()};
        EQUAL_KEYS = textAttributesKeyArray;
        textAttributesKeyArray = new TextAttributesKey[]{T4TextAttributeKeys.INSTANCE.getT4_DIRECTIVE_QUOTE()};
        QUOTE_KEYS = textAttributesKeyArray;
    }
}

