/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fortea.highlighting;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.text.EditorHighlighterUpdater;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.fortea.highlighting.T4SyntaxHighlighter;
import com.jetbrains.fortea.highlighting.T4SyntaxHighlightingHost;
import com.jetbrains.fortea.psi.T4ElementTypes;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rider.document.DocumentExKt;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpFileType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/fortea/highlighting/T4EditorSyntaxHighlighter;", "Lcom/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "colors", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "highlighterLifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "rawTextLayerExtension", "", "registerLayers", "", "subscribeToOutputExtensionUpdates", "Companion", "intellij.rider.plugins.for.tea"})
public final class T4EditorSyntaxHighlighter
extends LayeredLexerEditorHighlighter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile virtualFile;
    @NotNull
    private final LifetimeDefinition highlighterLifetime;
    @Nullable
    private final String rawTextLayerExtension;
    @NotNull
    private static final Key<String> OUTPUT_EXTENSION_KEY = new Key("OUTPUT_EXTENSION_KEY");

    public T4EditorSyntaxHighlighter(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        super((SyntaxHighlighter)T4SyntaxHighlighter.INSTANCE, colors);
        this.project = project;
        this.virtualFile = virtualFile;
        this.highlighterLifetime = ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)).createNested();
        this.rawTextLayerExtension = T4EditorSyntaxHighlighter.Companion.getT4OutputExtension(this.virtualFile);
        this.registerLayers();
        this.subscribeToOutputExtensionUpdates();
    }

    private final void registerLayers() {
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)((FileType)CSharpFileType.INSTANCE), (Project)this.project, (VirtualFile)this.virtualFile);
        Intrinsics.checkNotNull((Object)syntaxHighlighter);
        SyntaxHighlighter codeHighlighter = syntaxHighlighter;
        this.registerLayer(T4ElementTypes.RAW_CODE, new LayerDescriptor(codeHighlighter, ""));
        if (this.rawTextLayerExtension == null) {
            return;
        }
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName("dummy." + this.rawTextLayerExtension);
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByFileName(...)");
        FileType rawTextFileType = fileType;
        SyntaxHighlighter syntaxHighlighter2 = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)rawTextFileType, (Project)this.project, (VirtualFile)this.virtualFile);
        if (syntaxHighlighter2 == null) {
            return;
        }
        SyntaxHighlighter rawTextHighlighter = syntaxHighlighter2;
        this.registerLayer(T4ElementTypes.RAW_TEXT, new LayerDescriptor(rawTextHighlighter, "\n"));
    }

    private final void subscribeToOutputExtensionUpdates() {
        block2: {
            Document document = FileDocumentManager.getInstance().getDocument(this.virtualFile);
            if (document == null) {
                return;
            }
            Document document2 = document;
            Editor editor = DocumentExKt.getFirstEditor((Document)document2, (Project)this.project);
            if (!(editor instanceof EditorEx)) {
                return;
            }
            Disposable highlighterDisposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.highlighterLifetime.getLifetime(), null, (int)1, null);
            IProperty<String> iProperty = T4SyntaxHighlightingHost.Companion.getT4RdDocumentModel(document2, this.project);
            if (iProperty == null || (iProperty = iProperty.getRawTextExtension()) == null) break block2;
            iProperty.advise((Lifetime)this.highlighterLifetime, arg_0 -> T4EditorSyntaxHighlighter.subscribeToOutputExtensionUpdates$lambda$0(this, highlighterDisposable, editor, arg_0));
        }
    }

    private static final Unit subscribeToOutputExtensionUpdates$lambda$0(T4EditorSyntaxHighlighter this$0, Disposable $highlighterDisposable, Editor $editor, String extension) {
        if (Intrinsics.areEqual((Object)extension, (Object)this$0.rawTextLayerExtension)) {
            return Unit.INSTANCE;
        }
        T4EditorSyntaxHighlighter.Companion.setT4OutputExtension(this$0.virtualFile, extension);
        EditorHighlighterUpdater updater = new EditorHighlighterUpdater(this$0.project, $highlighterDisposable, (EditorEx)$editor, this$0.virtualFile);
        updater.updateHighlighters();
        this$0.highlighterLifetime.terminate(true);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\b\u001a\u0004\u0018\u00010\u0006*\u00020\t2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00068B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/fortea/highlighting/T4EditorSyntaxHighlighter$Companion;", "", "<init>", "()V", "OUTPUT_EXTENSION_KEY", "Lcom/intellij/openapi/util/Key;", "", "value", "t4OutputExtension", "Lcom/intellij/openapi/vfs/VirtualFile;", "getT4OutputExtension", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/String;", "setT4OutputExtension", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "intellij.rider.plugins.for.tea"})
    public static final class Companion {
        private Companion() {
        }

        private final String getT4OutputExtension(VirtualFile $this$t4OutputExtension) {
            return (String)$this$t4OutputExtension.getUserData(OUTPUT_EXTENSION_KEY);
        }

        private final void setT4OutputExtension(VirtualFile $this$t4OutputExtension, String value) {
            $this$t4OutputExtension.putUserData(OUTPUT_EXTENSION_KEY, (Object)value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

