/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fortea.configuration.execution.impl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.fortea.configuration.execution.impl.T4RunConfigurationExecutorBase;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/fortea/configuration/execution/impl/T4SynchronousRunConfigurationExecutor;", "Lcom/jetbrains/fortea/configuration/execution/impl/T4RunConfigurationExecutorBase;", "project", "Lcom/intellij/openapi/project/Project;", "waitFunc", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)V", "executor", "Lcom/intellij/execution/Executor;", "executeConfiguration", "", "configuration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "waitPumping", "finished", "Lcom/intellij/util/concurrency/Semaphore;", "Companion", "intellij.rider.plugins.for.tea"})
@SourceDebugExtension(value={"SMAP\nT4SynchronousRunConfigurationExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 T4SynchronousRunConfigurationExecutor.kt\ncom/jetbrains/fortea/configuration/execution/impl/T4SynchronousRunConfigurationExecutor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,74:1\n15#2:75\n*S KotlinDebug\n*F\n+ 1 T4SynchronousRunConfigurationExecutor.kt\ncom/jetbrains/fortea/configuration/execution/impl/T4SynchronousRunConfigurationExecutor\n*L\n71#1:75\n*E\n"})
public final class T4SynchronousRunConfigurationExecutor
extends T4RunConfigurationExecutorBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Boolean> waitFunc;
    @NotNull
    private final Executor executor;
    private static boolean isExecutionRunning;
    @NotNull
    private static final Logger logger;

    public T4SynchronousRunConfigurationExecutor(@NotNull Project project, @NotNull Function0<Boolean> waitFunc) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(waitFunc, (String)"waitFunc");
        super(project);
        this.waitFunc = waitFunc;
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getRunExecutorInstance(...)");
        this.executor = executor;
    }

    @Override
    protected void executeConfiguration(@NotNull RunnerAndConfigurationSettings configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        isExecutionRunning = true;
        ExecutionEnvironmentBuilder builder = null;
        try {
            builder = ExecutionEnvironmentBuilder.Companion.create(this.executor, configuration);
        }
        catch (ExecutionException e) {
            logger.error((Throwable)e);
            return;
        }
        Semaphore finished = new Semaphore();
        finished.down();
        ExecutionEnvironment environment = ExecutionEnvironmentBuilder.build$default((ExecutionEnvironmentBuilder)builder.contentToReuse(null).dataContext(null).activeTarget(), null, (int)1, null);
        ProgramRunnerUtil.executeConfigurationAsync((ExecutionEnvironment)environment, (boolean)true, (boolean)true, arg_0 -> T4SynchronousRunConfigurationExecutor.executeConfiguration$lambda$0(this, environment, finished, arg_0));
        this.waitPumping(finished);
    }

    private final void waitPumping(Semaphore finished) {
        ExtensionsKt.pumpMessages$default(null, this.waitFunc, (int)1, null);
        finished.waitFor(10L);
    }

    private static final void executeConfiguration$lambda$0(T4SynchronousRunConfigurationExecutor this$0, ExecutionEnvironment $environment, Semaphore $finished, RunContentDescriptor it) {
        ProcessHandler processHandler = it.getProcessHandler();
        if (processHandler == null) {
            logger.error("processHandler is null");
        }
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 != null) {
            processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(ProcessEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    T4SynchronousRunConfigurationExecutor.access$getLogger$cp().info("T4 process terminated with exit code " + event.getExitCode() + ".");
                }

                public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    T4SynchronousRunConfigurationExecutor.access$getLogger$cp().info("T4 process " + outputType + ": " + event.getText());
                }
            });
        }
        ExecutionListener listener = (ExecutionListener)this$0.getProject().getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC);
        listener.processStarted(this$0.executor.getId(), $environment, (ProcessHandler)new NopProcessHandler());
        $finished.up();
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(T4SynchronousRunConfigurationExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        T4SynchronousRunConfigurationExecutor.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/fortea/configuration/execution/impl/T4SynchronousRunConfigurationExecutor$Companion;", "", "<init>", "()V", "isExecutionRunning", "", "()Z", "setExecutionRunning", "(Z)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.for.tea"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        public final boolean isExecutionRunning() {
            return isExecutionRunning;
        }

        public final void setExecutionRunning(boolean bl) {
            isExecutionRunning = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

