/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fortea.configuration.execution.impl;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.util.PathUtil;
import com.jetbrains.fortea.configuration.execution.T4RunConfigurationExecutor;
import com.jetbrains.fortea.configuration.run.T4RunConfiguration;
import com.jetbrains.fortea.configuration.run.T4RunConfigurationFactory;
import com.jetbrains.fortea.configuration.run.T4RunConfigurationParameters;
import com.jetbrains.fortea.model.T4ConfigurationModel;
import com.jetbrains.fortea.model.T4ExecutionRequest;
import com.jetbrains.fortea.model.T4FileLocation;
import com.jetbrains.fortea.model.T4ProtocolModel;
import com.jetbrains.fortea.model.T4ProtocolModel_PregeneratedKt;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/fortea/configuration/execution/impl/T4RunConfigurationExecutorBase;", "Lcom/jetbrains/fortea/configuration/execution/T4RunConfigurationExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "execute", "", "request", "Lcom/jetbrains/fortea/model/T4ExecutionRequest;", "setupFromFile", "Lcom/jetbrains/fortea/configuration/run/T4RunConfiguration;", "executeConfiguration", "configuration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "intellij.rider.plugins.for.tea"})
public abstract class T4RunConfigurationExecutorBase
implements T4RunConfigurationExecutor {
    @NotNull
    private final Project project;

    public T4RunConfigurationExecutorBase(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @Override
    public final void execute(@NotNull T4ExecutionRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        T4RunConfiguration configuration = this.setupFromFile(request);
        RunManager runManager = RunManager.Companion.getInstance(this.project);
        RunnerAndConfigurationSettings configurationSettings = runManager.createConfiguration((RunConfiguration)configuration, (ConfigurationFactory)T4RunConfigurationFactory.INSTANCE);
        configurationSettings.setActivateToolWindowBeforeRun(request.isVisible());
        this.executeConfiguration(configurationSettings);
    }

    private final T4RunConfiguration setupFromFile(T4ExecutionRequest request) {
        T4ProtocolModel model = T4ProtocolModel_PregeneratedKt.getT4ProtocolModel(SolutionHostExtensionsKt.getSolution((Project)this.project));
        int projectModelId = request.getLocation().getId();
        ProjectModelEntity item = WorkspaceModelExtensionsKt.getProjectModelEntity((WorkspaceModel)WorkspaceModel.Companion.getInstance(this.project), (int)projectModelId);
        ProjectModelEntity projectModelEntity = item;
        VirtualFile virtualFile = projectModelEntity != null && (projectModelEntity = projectModelEntity.getUrl()) != null ? VirtualFileUrls.getVirtualFile((VirtualFileUrl)projectModelEntity) : null;
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile virtualFile2 = virtualFile;
        String string = virtualFile2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String t4Path = string;
        T4ConfigurationModel protocolConfiguration = (T4ConfigurationModel)IRdCall.DefaultImpls.sync$default(model.getGetConfiguration(), (Object)new T4FileLocation(projectModelId), null, (int)2, null);
        String string2 = protocolConfiguration.getExecutablePath();
        String string3 = "\"" + protocolConfiguration.getOutputPath() + "\"";
        int n = protocolConfiguration.getEnvDTEPort();
        String string4 = PathUtil.getParentPath((String)t4Path);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getParentPath(...)");
        T4RunConfigurationParameters parameters = new T4RunConfigurationParameters(request, string2, string3, n, string4);
        String string5 = virtualFile2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
        return new T4RunConfiguration(string5, this.project, parameters);
    }

    protected abstract void executeConfiguration(@NotNull RunnerAndConfigurationSettings var1);
}

