/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui.rest;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.swagger.core.ErrorType;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.SwaggerResource;
import com.intellij.swagger.core.SwaggerResult;
import com.intellij.swagger.core.ui.SwPreviewType;
import com.intellij.swagger.core.ui.rest.SpecData;
import com.intellij.swagger.core.ui.rest.SpecificationId;
import com.intellij.swagger.core.ui.rest.SwUrlBuilderKt;
import com.intellij.swagger.core.ui.rest.SwUrlParser;
import com.intellij.swagger.core.ui.rest.resource.SwPreviewResourceProvider;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bH\u0000\u001a\"\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u001f\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0011\u001a\u001f\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u0019\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\"\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b#\u0010$\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"specDataToId", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/swagger/core/ui/rest/SpecificationId;", "Lcom/intellij/swagger/core/ui/rest/SpecData;", "inlineVariablesIntoTemplate", "", "template", "variables", "", "prepareUIWebPageUrl", "specification", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "previewType", "Lcom/intellij/swagger/core/ui/SwPreviewType;", "addSpecAndProject", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)Ljava/util/UUID;", "removeOldKeyAssociatedWithValue", "", "key", "value", "removeOldKeyAssociatedWithValue-bFyn6F8", "(Ljava/util/UUID;Lcom/intellij/swagger/core/ui/rest/SpecData;)V", "getSpecification", "Lcom/intellij/swagger/core/SwaggerResult;", "Lcom/intellij/swagger/core/SwaggerResource;", "urlParser", "Lcom/intellij/swagger/core/ui/rest/SwUrlParser;", "resourceProvider", "Lcom/intellij/swagger/core/ui/rest/resource/SwPreviewResourceProvider;", "getSpecificationAndContentType", "virtualFile", "getSpecVirtualFile", "spec", "getSpecVirtualFile-Y7tB9Ug", "(Ljava/util/UUID;)Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwSpecFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwSpecFileProvider.kt\ncom/intellij/swagger/core/ui/rest/SwSpecFileProviderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,127:1\n1797#2,3:128\n1863#2,2:138\n503#3,7:131\n1310#4,2:140\n*S KotlinDebug\n*F\n+ 1 SwSpecFileProvider.kt\ncom/intellij/swagger/core/ui/rest/SwSpecFileProviderKt\n*L\n24#1:128,3\n46#1:138,2\n45#1:131,7\n77#1:140,2\n*E\n"})
public final class SwSpecFileProviderKt {
    @NotNull
    private static final ConcurrentHashMap<SpecificationId, SpecData> specDataToId = new ConcurrentHashMap();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String inlineVariablesIntoTemplate(@NotNull String template, @NotNull Map<String, String> variables2) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter(variables2, (String)"variables");
        Iterable $this$fold$iv = variables2.entrySet();
        boolean $i$f$fold = false;
        String accumulator$iv = template;
        for (Object element$iv : $this$fold$iv) {
            void entry;
            Map.Entry entry2 = (Map.Entry)element$iv;
            String acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = StringsKt.replace$default((String)acc, (String)((String)entry.getKey()), (String)((String)entry.getValue()), (boolean)false, (int)4, null);
        }
        return accumulator$iv;
    }

    @Nullable
    public static final String prepareUIWebPageUrl(@NotNull VirtualFile specification, @NotNull Project project, @NotNull SwPreviewType previewType) {
        Intrinsics.checkNotNullParameter((Object)specification, (String)"specification");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)previewType), (String)"previewType");
        UUID uUID = SwSpecFileProviderKt.addSpecAndProject(specification, project);
        if (uUID == null) {
            return null;
        }
        UUID specKey = uUID;
        return SwUrlBuilderKt.withPreviewType(SwUrlBuilderKt.withSpecificationKey-HlV1sj0(SwUrlBuilderKt.withSubPath(SwUrlBuilderKt.buildBaseUrlHandledBySwaggerPlugin(), "html"), specKey), previewType).toExternalForm();
    }

    private static final UUID addSpecAndProject(VirtualFile specification, Project project) {
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        UUID specificationId = SpecificationId.constructor-impl(uUID);
        String string = specification.getCanonicalPath();
        if (string == null) {
            return null;
        }
        String path = string;
        String string2 = project.getLocationHash();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocationHash(...)");
        SwSpecFileProviderKt.removeOldKeyAssociatedWithValue-bFyn6F8(specificationId, new SpecData(path, string2));
        return specificationId;
    }

    /*
     * WARNING - void declaration
     */
    private static final void removeOldKeyAssociatedWithValue-bFyn6F8(UUID key, SpecData value) {
        void $this$forEach$iv;
        ConcurrentHashMap<SpecificationId, SpecData> $this$removeOldKeyAssociatedWithValue_bFyn6F8_u24lambda_u243 = specDataToId;
        boolean bl = false;
        Object $this$filterValues$iv = $this$removeOldKeyAssociatedWithValue_bFyn6F8_u24lambda_u243;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            SpecData it = (SpecData)entry$iv.getValue();
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)it, (Object)value)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterValues$iv = ((Map)result$iv).keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID oldKey = ((SpecificationId)element$iv).unbox-impl();
            boolean bl3 = false;
            $this$removeOldKeyAssociatedWithValue_bFyn6F8_u24lambda_u243.remove(SpecificationId.box-impl(oldKey));
        }
        SpecificationId specificationId = SpecificationId.box-impl(key);
        ((Map)$this$removeOldKeyAssociatedWithValue_bFyn6F8_u24lambda_u243).put(specificationId, value);
    }

    @NotNull
    public static final SwaggerResult<SwaggerResource> getSpecification(@NotNull SwUrlParser urlParser, @NotNull SwPreviewResourceProvider resourceProvider) {
        Object object;
        String projectHash;
        VirtualFile virtualFile;
        UUID specificationId;
        block5: {
            Intrinsics.checkNotNullParameter((Object)urlParser, (String)"urlParser");
            Intrinsics.checkNotNullParameter((Object)resourceProvider, (String)"resourceProvider");
            specificationId = urlParser.recognizeSpecificationId-2Wqz4Ao();
            if (specificationId == null) {
                Object[] objectArray = new Object[]{urlParser.getPresentableUrl$intellij_swagger_core()};
                return SwaggerResult.Companion.failure(ErrorType.DOES_NOT_EXIST, SwaggerBundle.message("preview.error.unknown.path", objectArray), "Unknown specification key was provided: " + urlParser.getPresentableUrl$intellij_swagger_core());
            }
            SpecData specData = specDataToId.get(SpecificationId.box-impl(specificationId));
            if (specData == null) {
                Object[] objectArray = new Object[]{SpecificationId.box-impl(specificationId)};
                return SwaggerResult.Companion.failure(ErrorType.DOES_NOT_EXIST, SwaggerBundle.message("preview.error.specification.was.not.found", objectArray), "Spec key: " + SpecificationId.toString-impl(specificationId) + ", does not exist in spec key map");
            }
            SpecData specData2 = specData;
            virtualFile = SwSpecFileProviderKt.getSpecVirtualFile-Y7tB9Ug(specificationId);
            if (virtualFile == null) {
                Object[] objectArray = new Object[]{SpecificationId.box-impl(specificationId)};
                return SwaggerResult.Companion.failure(ErrorType.DOES_NOT_EXIST, SwaggerBundle.message("preview.error.specification.was.not.found", objectArray), "Virtual file for " + SpecificationId.toString-impl(specificationId) + " does not exist");
            }
            projectHash = specData2.getProjectHash();
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Object[] $this$firstOrNull$iv = projectArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Project it = (Project)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getLocationHash(), (Object)projectHash)) continue;
                object = element$iv;
                break block5;
            }
            object = null;
        }
        Project projectInstance = (Project)object;
        if (projectInstance == null) {
            Object[] objectArray = new Object[]{SpecificationId.box-impl(specificationId)};
            return SwaggerResult.Companion.failure(ErrorType.DOES_NOT_EXIST, SwaggerBundle.message("preview.error.specification.was.not.found", objectArray), "Project with hash: " + projectHash + " does not exist");
        }
        return SwSpecFileProviderKt.getSpecificationAndContentType(projectInstance, virtualFile, resourceProvider);
    }

    private static final SwaggerResult<SwaggerResource> getSpecificationAndContentType(Project project, VirtualFile virtualFile, SwPreviewResourceProvider resourceProvider) {
        PsiFile file = (PsiFile)ActionsKt.runReadAction(() -> SwSpecFileProviderKt.getSpecificationAndContentType$lambda$5(project, virtualFile));
        if (file == null) {
            Object[] objectArray = new Object[]{virtualFile.getName()};
            return SwaggerResult.Companion.failure(ErrorType.DOES_NOT_EXIST, SwaggerBundle.message("preview.error.specification.was.not.found", objectArray), "Psi file for virtual file: " + virtualFile + " does not exist");
        }
        SwaggerResult<String> specificationText = resourceProvider.getSpec(file, project);
        if (specificationText.isFailure()) {
            return SwaggerResult.Companion.failure(specificationText.getFailureOrThrow());
        }
        byte[] byArray = specificationText.getSuccessOrThrow().getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return SwaggerResult.Companion.success(new SwaggerResource(byArray, "application/json"));
    }

    private static final VirtualFile getSpecVirtualFile-Y7tB9Ug(UUID spec) {
        VirtualFile virtualFile;
        SpecData specData = specDataToId.get(SpecificationId.box-impl(spec));
        if (specData != null) {
            SpecData it = specData;
            boolean bl = false;
            virtualFile = VfsUtil.findFile((Path)Path.of(it.getSpecPath(), new String[0]), (boolean)true);
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    private static final PsiFile getSpecificationAndContentType$lambda$5(Project $project, VirtualFile $virtualFile) {
        return PsiManager.getInstance((Project)$project).findFile($virtualFile);
    }
}

