/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridEditorPanel;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.run.ui.grid.GridEditorPanelBase;
import com.intellij.grid.core.impl.icons.GridCoreImplIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Dimension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridFilterPanel
extends GridEditorPanelBase {
    private JBPopup myFilterHistoryPopup;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public GridFilterPanel(@NotNull Project project, final @NotNull DataGrid grid) {
        if (project == null) {
            GridFilterPanel.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            GridFilterPanel.$$$reportNull$$$0(1);
        }
        super(project, grid, grid.getDataHookup().getFilterPrefix(), grid.getDataHookup().getFilterEmptyText(), GridFilterPanel.getFilterDocument(grid));
        this.setVisible(grid.getDataHookup().isFilterApplicable());
        @NotNull @Nullable Function getPanel = g -> g.getFilterComponent().getFilterPanel();
        new GridEditorPanelBase.ApplyAction((Function<DataGrid, GridEditorPanel>)getPanel).registerCustomShortcutSet(CommonShortcuts.ENTER, this.myEditor.getComponent());
        new GridEditorPanelBase.CancelAction((Function<DataGrid, GridEditorPanel>)getPanel).registerCustomShortcutSet(CommonShortcuts.ESCAPE, this.myEditor.getComponent());
        new GridEditorPanelBase.ShowHistoryAction((Function<DataGrid, GridEditorPanel>)getPanel).registerCustomShortcutSet((ShortcutSet)GridFilterPanel.getShowHistoryShortcut(), this.myEditor.getComponent());
        GridFilteringModel filteringModel = this.myGrid.getDataHookup().getFilteringModel();
        if (filteringModel != null) {
            filteringModel.addListener(new GridFilteringModel.Listener(){

                public void onPsiUpdated() {
                    GridFilterPanel.this.setHighlighter();
                }

                public void onPrefixUpdated() {
                    GridFilterPanel.this.updatePrefix(grid.getDataHookup().getFilterPrefix(), grid.getDataHookup().getFilterEmptyText());
                }

                public void onApplicableUpdated() {
                    GridFilterPanel.this.setVisible(grid.getDataHookup().isFilterApplicable());
                }
            }, (Disposable)this.myGrid);
        }
        this.add((Component)((Object)new GridEditorPanelBase.HistoryIcon(GridCoreImplIcons.FilterHistory)), "West");
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        return new Dimension(Math.max(300, preferredSize.width), preferredSize.height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    void clearText() {
        GridFilteringModel filteringModel = this.myGrid.getDataHookup().getFilteringModel();
        boolean wasApplied = filteringModel != null && !StringUtil.isEmpty((String)filteringModel.getAppliedText());
        GridFilterPanel.setFilterText(this, this.myGrid, "", -1);
        if (wasApplied) {
            this.myGrid.getFilterComponent().getFilterPanel().apply();
        }
    }

    @Override
    @NotNull
    @NlsContexts.PopupContent
    public String getInvalidTextErrorMessage() {
        String string = DataGridBundle.message((String)"popup.content.invalid.filter.criteria", (Object[])new Object[0]);
        if (string == null) {
            GridFilterPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static Document getFilterDocument(@NotNull DataGrid grid) {
        GridFilteringModel filteringMode;
        if (grid == null) {
            GridFilterPanel.$$$reportNull$$$0(3);
        }
        Document document = (filteringMode = grid.getDataHookup().getFilteringModel()) == null ? EditorFactory.getInstance().createDocument((CharSequence)"") : filteringMode.getFilterDocument();
        if (document == null) {
            GridFilterPanel.$$$reportNull$$$0(4);
        }
        return document;
    }

    public static void setFilterText(@NotNull GridEditorPanel filterPanel, @NotNull DataGrid grid, @NotNull String filter, int caretPosition) {
        GridFilteringModel model2;
        if (filterPanel == null) {
            GridFilterPanel.$$$reportNull$$$0(5);
        }
        if (grid == null) {
            GridFilterPanel.$$$reportNull$$$0(6);
        }
        if (filter == null) {
            GridFilterPanel.$$$reportNull$$$0(7);
        }
        if ((model2 = grid.getDataHookup().getFilteringModel()) == null) {
            return;
        }
        model2.setFilterText(filter);
        if (caretPosition < 0) {
            return;
        }
        filterPanel.getComponent().requestFocusInWindow();
        filterPanel.getEditor().getCaretModel().moveToOffset(caretPosition);
    }

    @Override
    public void showHistoryPopup() {
        GridFilteringModel model2;
        if (this.myFilterHistoryPopup != null) {
            this.myFilterHistoryPopup.cancel();
            this.myFilterHistoryPopup = null;
        }
        if ((model2 = this.myGrid.getDataHookup().getFilteringModel()) == null) {
            return;
        }
        this.myFilterHistoryPopup = GridFilterPanel.createHistoryPopup(model2.getHistory(), this.myProject, (Editor)this.myEditor, () -> this.myGrid.getFilterComponent().getFilterPanel().apply());
        this.myFilterHistoryPopup.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                GridFilterPanel.this.myFilterHistoryPopup = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/run/ui/grid/GridFilterPanel$2", "onClosed"));
            }
        });
        if (this.myGrid.getPanel().getComponent().isShowing()) {
            this.myFilterHistoryPopup.showUnderneathOf((Component)this);
        }
    }

    @Override
    public void apply() {
        super.apply();
        GridUtil.activeGridListener().onFilterApplied(this.myGrid);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridFilterPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterPanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridFilterPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidTextErrorMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFilterDocument";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setFilterText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

