/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.dap;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderEx;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.dap.DapDriver;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u0019\u001a\u00070\u0005\u00a2\u0006\u0002\b\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J4\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020.H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0014\"\u0004\b\u0017\u0010\u0018\u00a8\u0006/"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/dap/DapDriverConfiguration;", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriverConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "adapterId", "", "launchOptions", "", "", "attach", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/util/Map;Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getAdapterId", "()Ljava/lang/String;", "getLaunchOptions", "()Ljava/util/Map;", "getAttach", "()Z", "allowRequestCancellation", "getAllowRequestCancellation", "setAllowRequestCancellation", "(Z)V", "getDriverName", "Lcom/intellij/openapi/util/NlsSafe;", "createDriver", "Lcom/jetbrains/cidr/execution/debugger/backend/dap/DapDriver;", "handler", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Handler;", "architectureType", "Lcom/jetbrains/cidr/ArchitectureType;", "createEvaluationContext", "Lcom/jetbrains/cidr/execution/debugger/backend/EvaluationContext;", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "expirable", "Lcom/intellij/openapi/util/Expirable;", "thread", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "frame", "Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;", "cacheHolder", "Lcom/intellij/openapi/util/UserDataHolderEx;", "getConsoleLanguage", "Lcom/intellij/lang/Language;", "intellij.cidr.debugger.dap"})
@ApiStatus.Internal
public abstract class DapDriverConfiguration
extends DebuggerDriverConfiguration {
    @NotNull
    private final Project project;
    @NotNull
    private final String adapterId;
    @NotNull
    private final Map<String, Object> launchOptions;
    private final boolean attach;
    private boolean allowRequestCancellation;

    public DapDriverConfiguration(@NotNull Project project, @NotNull String adapterId, @NotNull Map<String, ? extends Object> launchOptions, boolean attach) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)adapterId, (String)"adapterId");
        Intrinsics.checkNotNullParameter(launchOptions, (String)"launchOptions");
        this.project = project;
        this.adapterId = adapterId;
        this.launchOptions = launchOptions;
        this.attach = attach;
    }

    public /* synthetic */ DapDriverConfiguration(Project project, String string, Map map, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(project, string, map, bl);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getAdapterId() {
        return this.adapterId;
    }

    @NotNull
    public final Map<String, Object> getLaunchOptions() {
        return this.launchOptions;
    }

    public final boolean getAttach() {
        return this.attach;
    }

    public final boolean getAllowRequestCancellation() {
        return this.allowRequestCancellation;
    }

    public final void setAllowRequestCancellation(boolean bl) {
        this.allowRequestCancellation = bl;
    }

    @NotNull
    public String getDriverName() {
        return "DAP";
    }

    @NotNull
    public DapDriver createDriver(@NotNull DebuggerDriver.Handler handler, @NotNull ArchitectureType architectureType) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)architectureType, (String)"architectureType");
        return new DapDriver(handler, this, architectureType);
    }

    @Nullable
    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, @NotNull LLThread thread, @NotNull LLFrame frame, @NotNull UserDataHolderEx cacheHolder) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)cacheHolder, (String)"cacheHolder");
        return new EvaluationContext(driver, expirable, thread, frame, cacheHolder){

            public String convertToRValue(LLValueData rValue, Pair<LLValue, String> valuePair) {
                Intrinsics.checkNotNullParameter((Object)rValue, (String)"rValue");
                Intrinsics.checkNotNullParameter(valuePair, (String)"valuePair");
                String string = EvaluationContext.cast((String)((String)valuePair.second), (String)((LLValue)valuePair.first).getType());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cast(...)");
                return string;
            }
        };
    }

    @NotNull
    public Language getConsoleLanguage() {
        PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)plainTextLanguage, (String)"INSTANCE");
        return (Language)plainTextLanguage;
    }
}

