/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.LogRecord;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.SandboxPolicy;
import org.graalvm.polyglot.impl.ModuleToUnnamedAPIAccessGen;
import org.graalvm.polyglot.io.ByteSequence;
import org.graalvm.polyglot.io.MessageTransport;
import org.graalvm.polyglot.io.ProcessHandler;

public abstract class AbstractPolyglotImpl {
    private APIAccess api;
    private ManagementAccess management;
    private IOAccessor io;
    private AbstractPolyglotImpl next;
    private AbstractPolyglotImpl prev;

    protected AbstractPolyglotImpl() {
    }

    MethodHandles.Lookup getLookup() {
        try {
            return MethodHandles.privateLookupIn(AbstractPolyglotImpl.class, MethodHandles.lookup());
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public final void setMonitoring(ManagementAccess monitoring) {
        this.management = monitoring;
        AbstractPolyglotImpl nextImpl = this.next;
        if (nextImpl != null) {
            nextImpl.setMonitoring(monitoring);
        }
    }

    public final void setConstructors(APIAccess constructors) {
        this.api = constructors;
        AbstractPolyglotImpl nextImpl = this.next;
        if (nextImpl != null) {
            nextImpl.setConstructors(constructors);
        }
    }

    public final void setNext(AbstractPolyglotImpl next) {
        this.next = next;
        if (next != null) {
            next.prev = this;
        }
    }

    public final AbstractPolyglotImpl getNext() {
        if (this.next == null) {
            throw new AbstractMethodError("No implementation available.");
        }
        return this.next;
    }

    public final AbstractPolyglotImpl getNextOrNull() {
        return this.next;
    }

    public final void setIO(IOAccessor ioAccess) {
        Objects.requireNonNull(ioAccess, "IOAccess must be non null.");
        this.io = ioAccess;
        AbstractPolyglotImpl nextImpl = this.next;
        if (nextImpl != null) {
            nextImpl.setIO(ioAccess);
        }
    }

    public final APIAccess getAPIAccess() {
        return this.api;
    }

    public final ManagementAccess getManagement() {
        return this.management;
    }

    public final IOAccessor getIO() {
        return this.io;
    }

    public void initialize() {
    }

    public Object initializeModuleToUnnamedAccess(MethodHandles.Lookup unnamedLookup, Object unnamedAccess, Object unnamedAPIAccess, Object unnamedIOAccess, Object unnamedManagementAccess) {
        return this.getNext().initializeModuleToUnnamedAccess(unnamedLookup, unnamedAccess, unnamedAPIAccess, unnamedIOAccess, unnamedManagementAccess);
    }

    public Object buildEngine(String[] permittedLanguages, SandboxPolicy sandboxPolicy, OutputStream out, OutputStream err, InputStream in, Map<String, String> options, boolean allowExperimentalOptions, boolean boundEngine, MessageTransport messageInterceptor, Object logHandler, Object hostLanguage, boolean hostLanguageOnly, boolean registerInActiveEngines, Object polyglotHostService) {
        return this.getNext().buildEngine(permittedLanguages, sandboxPolicy, out, err, in, options, allowExperimentalOptions, boundEngine, messageInterceptor, logHandler, hostLanguage, hostLanguageOnly, registerInActiveEngines, polyglotHostService);
    }

    public abstract int getPriority();

    public void preInitializeEngine() {
        this.getNext().preInitializeEngine();
    }

    public Object createHostLanguage(Object access) {
        return this.getNext().createHostLanguage(access);
    }

    public void resetPreInitializedEngine() {
        this.getNext().resetPreInitializedEngine();
    }

    public Object buildSource(String language, Object origin, URI uri, String name, String mimeType, Object content2, boolean interactive, boolean internal, boolean cached, Charset encoding, URL url, String path) throws IOException {
        return this.getNext().buildSource(language, origin, uri, name, mimeType, content2, interactive, internal, cached, encoding, url, path);
    }

    public String findLanguage(File file) throws IOException {
        return this.getNext().findLanguage(file);
    }

    public String findLanguage(URL url) throws IOException {
        return this.getNext().findLanguage(url);
    }

    public String findLanguage(String mimeType) {
        return this.getNext().findLanguage(mimeType);
    }

    public String findMimeType(File file) throws IOException {
        return this.getNext().findMimeType(file);
    }

    public String findMimeType(URL url) throws IOException {
        return this.getNext().findMimeType(url);
    }

    public Object createHostAccess() {
        return this.getNext().createHostAccess();
    }

    public boolean isHostFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return this.getNext().isHostFileSystem(fileSystem);
    }

    public boolean copyResources(Path targetFolder, String ... components) throws IOException {
        return this.getNext().copyResources(targetFolder, components);
    }

    public String getTruffleVersion() {
        return null;
    }

    public Class<?> loadLanguageClass(String className) {
        return this.getNext().loadLanguageClass(className);
    }

    public Object getCurrentContext() {
        return this.getNext().getCurrentContext();
    }

    public Object asValue(Object o) {
        return this.getNext().asValue(o);
    }

    public <S, T> Object newTargetTypeMapping(Class<S> sourceType, Class<T> targetType, Predicate<S> acceptsValue, Function<S, T> convertValue, HostAccess.TargetMappingPrecedence precedence) {
        return this.getNext().newTargetTypeMapping(sourceType, targetType, acceptsValue, convertValue, precedence);
    }

    public Object buildLimits(long statementLimit, Predicate<Object> statementLimitSourceFilter, Consumer<Object> onLimit) {
        return this.getNext().buildLimits(statementLimit, statementLimitSourceFilter, onLimit);
    }

    public org.graalvm.polyglot.io.FileSystem newDefaultFileSystem(String hostTmpDir) {
        return this.getNext().newDefaultFileSystem(hostTmpDir);
    }

    public org.graalvm.polyglot.io.FileSystem allowInternalResourceAccess(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return this.getNext().allowInternalResourceAccess(fileSystem);
    }

    public org.graalvm.polyglot.io.FileSystem newReadOnlyFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return this.getNext().newReadOnlyFileSystem(fileSystem);
    }

    public org.graalvm.polyglot.io.FileSystem newNIOFileSystem(FileSystem fileSystem) {
        return this.getNext().newNIOFileSystem(fileSystem);
    }

    public ByteSequence asByteSequence(Object object) {
        return this.getNext().asByteSequence(object);
    }

    public ProcessHandler newDefaultProcessHandler() {
        return this.getNext().newDefaultProcessHandler();
    }

    public Object newIOAccess(String name, boolean allowHostFileAccess, boolean allowHostSocketAccess, org.graalvm.polyglot.io.FileSystem customFileSystem) {
        return this.getNext().newIOAccess(name, allowHostFileAccess, allowHostSocketAccess, customFileSystem);
    }

    public boolean isDefaultProcessHandler(ProcessHandler processHandler) {
        return this.getNext().isDefaultProcessHandler(processHandler);
    }

    public boolean isInternalFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return this.getNext().isInternalFileSystem(fileSystem);
    }

    public ThreadScope createThreadScope() {
        return this.getNext().createThreadScope();
    }

    public boolean isInCurrentEngineHostCallback(Object engine) {
        return this.getNext().isInCurrentEngineHostCallback(engine);
    }

    public Object newLogHandler(Object logHandlerOrStream) {
        return this.getNext().newLogHandler(logHandlerOrStream);
    }

    public OptionDescriptors createUnionOptionDescriptors(OptionDescriptors ... optionDescriptors) {
        return this.getNext().createUnionOptionDescriptors(optionDescriptors);
    }

    public Object newFileSystem(org.graalvm.polyglot.io.FileSystem fs) {
        return this.getNext().newFileSystem(fs);
    }

    protected final OptionDescriptors createAllEngineOptionDescriptors() {
        AbstractPolyglotImpl current = this;
        while (current.prev != null) {
            current = current.prev;
        }
        OptionDescriptors union = OptionDescriptors.EMPTY;
        while (current != null) {
            union = this.createUnionOptionDescriptors(current.createEngineOptionDescriptors(), union);
            current = current.next;
        }
        return union;
    }

    protected OptionDescriptors createEngineOptionDescriptors() {
        return OptionDescriptors.EMPTY;
    }

    public final AbstractPolyglotImpl getRootImpl() {
        AbstractPolyglotImpl current = this;
        while (current.prev != null) {
            current = current.prev;
        }
        return current;
    }

    public static abstract class ManagementAccess {
        protected ManagementAccess() {
            if (!this.getClass().getCanonicalName().equals("org.graalvm.polyglot.management.Management.ManagementAccessImpl") && !this.getClass().getCanonicalName().equals("org.graalvm.polyglot.impl.ModuleToUnnamedManagementAccessGen")) {
                throw new AssertionError((Object)("Only one implementation of ManagementAccessImpl allowed. " + this.getClass().getCanonicalName()));
            }
        }

        public abstract Object newExecutionListener(AbstractExecutionListenerDispatch var1, Object var2);

        public abstract Object newExecutionEvent(AbstractExecutionEventDispatch var1, Object var2);

        public abstract Object getExecutionListenerReceiver(Object var1);

        public abstract AbstractExecutionListenerDispatch getExecutionListenerDispatch(Object var1);

        public abstract Object getExecutionEventReceiver(Object var1);

        public abstract AbstractExecutionEventDispatch getExecutionEventDispatch(Object var1);
    }

    public static abstract class APIAccess {
        protected APIAccess() {
            String name = this.getClass().getCanonicalName();
            if (!name.equals("org.graalvm.polyglot.Engine.APIAccessImpl") && this.getClass() != ModuleToUnnamedAPIAccessGen.class) {
                throw new AssertionError((Object)("Only one implementation of APIAccess allowed. " + this.getClass().getCanonicalName()));
            }
        }

        public abstract Object newEngine(AbstractEngineDispatch var1, Object var2, boolean var3);

        public abstract Object newContext(AbstractContextDispatch var1, Object var2, Object var3);

        public abstract Object newLanguage(AbstractLanguageDispatch var1, Object var2);

        public abstract Object newInstrument(AbstractInstrumentDispatch var1, Object var2);

        public abstract Object newValue(AbstractValueDispatch var1, Object var2, Object var3);

        public abstract Object[] newValueArray(int var1);

        public abstract Object newSource(AbstractSourceDispatch var1, Object var2);

        public abstract Object newSourceSection(Object var1, AbstractSourceSectionDispatch var2, Object var3);

        public abstract Object getSourceSectionSource(Object var1);

        public abstract RuntimeException newLanguageException(String var1, AbstractExceptionDispatch var2, Object var3);

        public abstract boolean isInstrument(Object var1);

        public abstract boolean isLanguage(Object var1);

        public abstract boolean isEngine(Object var1);

        public abstract boolean isContext(Object var1);

        public abstract boolean isPolyglotException(Object var1);

        public abstract boolean isValue(Object var1);

        public abstract boolean isSource(Object var1);

        public abstract boolean isSourceSection(Object var1);

        public abstract Class<?> getValueClass();

        public abstract Object getInstrumentReceiver(Object var1);

        public abstract Object getLanguageReceiver(Object var1);

        public abstract Object getEngineReceiver(Object var1);

        public abstract Object getContextReceiver(Object var1);

        public abstract Object getPolyglotExceptionReceiver(RuntimeException var1);

        public abstract Object getValueReceiver(Object var1);

        public abstract Object getResourceLimitsReceiver(Object var1);

        public abstract Object getSourceReceiver(Object var1);

        public abstract Object getSourceSectionReceiver(Object var1);

        public abstract AbstractStackFrameImpl getStackFrameReceiver(Object var1);

        public abstract AbstractValueDispatch getValueDispatch(Object var1);

        public abstract Object getValueContext(Object var1);

        public abstract AbstractStackFrameImpl getStackFrameDispatch(Object var1);

        public abstract AbstractLanguageDispatch getLanguageDispatch(Object var1);

        public abstract AbstractInstrumentDispatch getInstrumentDispatch(Object var1);

        public abstract AbstractEngineDispatch getEngineDispatch(Object var1);

        public abstract AbstractContextDispatch getContextDispatch(Object var1);

        public abstract AbstractSourceDispatch getSourceDispatch(Object var1);

        public abstract AbstractSourceSectionDispatch getSourceSectionDispatch(Object var1);

        public abstract Object newResourceLimitsEvent(Object var1);

        public abstract Object newPolyglotStackTraceElement(AbstractStackFrameImpl var1, RuntimeException var2);

        public abstract List<Object> getTargetMappings(Object var1);

        public abstract boolean allowsAccess(Object var1, AnnotatedElement var2);

        public abstract boolean allowsImplementation(Object var1, Class<?> var2);

        public abstract boolean isMethodScopingEnabled(Object var1);

        public abstract boolean isMethodScoped(Object var1, Executable var2);

        public abstract boolean isArrayAccessible(Object var1);

        public abstract boolean isListAccessible(Object var1);

        public abstract boolean isBufferAccessible(Object var1);

        public abstract boolean isIterableAccessible(Object var1);

        public abstract boolean isIteratorAccessible(Object var1);

        public abstract boolean isMapAccessible(Object var1);

        public abstract boolean isBigIntegerAccessibleAsNumber(Object var1);

        public abstract boolean allowsPublicAccess(Object var1);

        public abstract boolean allowsAccessInheritance(Object var1);

        public abstract Object getHostAccessImpl(Object var1);

        public abstract MethodHandles.Lookup getMethodLookup(Object var1);

        public abstract void setHostAccessImpl(Object var1, Object var2);

        public abstract Set<String> getEvalAccess(Object var1, String var2);

        public abstract Map<String, Set<String>> getEvalAccess(Object var1);

        public abstract Set<String> getBindingsAccess(Object var1);

        public abstract String validatePolyglotAccess(Object var1, Set<String> var2);

        public abstract void engineClosed(Object var1);

        public abstract HostAccess.MutableTargetMapping[] getMutableTargetMappings(Object var1);

        public abstract Map<String, String> readOptionsFromSystemProperties();

        public abstract boolean isByteSequence(Object var1);

        public abstract Class<?> getByteSequenceClass();

        public abstract ByteSequence asByteSequence(Object var1);

        public abstract Object toByteSequence(Object var1);

        public abstract int byteSequenceLength(Object var1);

        public abstract byte byteSequenceByteAt(Object var1, int var2);

        public abstract boolean isProxyArray(Object var1);

        public abstract boolean isProxyDate(Object var1);

        public abstract boolean isProxyDuration(Object var1);

        public abstract boolean isProxyExecutable(Object var1);

        public abstract boolean isProxyHashMap(Object var1);

        public abstract boolean isProxyInstant(Object var1);

        public abstract boolean isProxyInstantiable(Object var1);

        public abstract boolean isProxyIterable(Object var1);

        public abstract boolean isProxyIterator(Object var1);

        public abstract boolean isProxyNativeObject(Object var1);

        public abstract boolean isProxyObject(Object var1);

        public abstract boolean isProxyTime(Object var1);

        public abstract boolean isProxyTimeZone(Object var1);

        public abstract boolean isProxy(Object var1);

        public abstract Class<?> getProxyArrayClass();

        public abstract Class<?> getProxyDateClass();

        public abstract Class<?> getProxyDurationClass();

        public abstract Class<?> getProxyExecutableClass();

        public abstract Class<?> getProxyHashMapClass();

        public abstract Class<?> getProxyInstantClass();

        public abstract Class<?> getProxyInstantiableClass();

        public abstract Class<?> getProxyIterableClass();

        public abstract Class<?> getProxyIteratorClass();

        public abstract Class<?> getProxyNativeObjectClass();

        public abstract Class<?> getProxyObjectClass();

        public abstract Class<?> getProxyTimeClass();

        public abstract Class<?> getProxyTimeZoneClass();

        public abstract Class<?> getProxyClass();

        public abstract Object callProxyExecutableExecute(Object var1, Object[] var2);

        public abstract Object callProxyNativeObjectAsPointer(Object var1);

        public abstract Object callProxyInstantiableNewInstance(Object var1, Object[] var2);

        public abstract Object callProxyArrayGet(Object var1, long var2);

        public abstract void callProxyArraySet(Object var1, long var2, Object var4);

        public abstract boolean callProxyArrayRemove(Object var1, long var2);

        public abstract Object callProxyArraySize(Object var1);

        public abstract Object callProxyObjectMemberKeys(Object var1);

        public abstract Object callProxyObjectGetMember(Object var1, String var2);

        public abstract void callProxyObjectPutMember(Object var1, String var2, Object var3);

        public abstract boolean callProxyObjectRemoveMember(Object var1, String var2);

        public abstract Object callProxyObjectHasMember(Object var1, String var2);

        public abstract ZoneId callProxyTimeZoneAsTimeZone(Object var1);

        public abstract LocalDate callProxyDateAsDate(Object var1);

        public abstract LocalTime callProxyTimeAsTime(Object var1);

        public abstract Instant callProxyInstantAsInstant(Object var1);

        public abstract Duration callProxyDurationAsDuration(Object var1);

        public abstract Object callProxyIterableGetIterator(Object var1);

        public abstract Object callProxyIteratorHasNext(Object var1);

        public abstract Object callProxyIteratorGetNext(Object var1);

        public abstract Object callProxyHashMapHasHashEntry(Object var1, Object var2);

        public abstract Object callProxyHashMapGetHashSize(Object var1);

        public abstract Object callProxyHashMapGetHashValue(Object var1, Object var2);

        public abstract void callProxyHashMapPutHashEntry(Object var1, Object var2, Object var3);

        public abstract Object callProxyHashMapRemoveHashEntry(Object var1, Object var2);

        public abstract Object callProxyHashMapGetEntriesIterator(Object var1);

        public abstract Object getIOAccessNone();

        public abstract Object getIOAccessAll();

        public abstract Object getEnvironmentAccessNone();

        public abstract Object getEnvironmentAccessInherit();

        public abstract Object getPolyglotAccessNone();

        public abstract Object getPolyglotAccessAll();

        public abstract Object createPolyglotAccess(Set<String> var1, Map<String, Set<String>> var2);

        public abstract Object getHostAccessNone();

        public abstract <T> T callValueAs(Object var1, Class<T> var2);

        public abstract <T> T callValueAs(Object var1, Class<T> var2, Type var3);

        public abstract Object callValueGetMetaObject(Object var1);

        public abstract long callValueGetArraySize(Object var1);

        public abstract Object callValueGetArrayElement(Object var1, int var2);

        public abstract boolean callValueIsString(Object var1);

        public abstract String callValueAsString(Object var1);

        public abstract Object getContextEngine(Object var1);

        public abstract void contextEnter(Object var1);

        public abstract void contextLeave(Object var1);

        public abstract void contextClose(Object var1, boolean var2);

        public abstract Object contextAsValue(Object var1, Object var2);

        public abstract Class<?> getPolyglotExceptionClass();

        public abstract Object callContextGetCurrent();

        public abstract Object callContextAsValue(Object var1, Object var2);
    }

    public static abstract class IOAccessor {
        protected IOAccessor() {
            if (!this.getClass().getCanonicalName().equals("org.graalvm.polyglot.io.IOHelper.IOAccessorImpl") && !this.getClass().getCanonicalName().equals("org.graalvm.polyglot.impl.ModuleToUnnamedIOAccessorGen")) {
                throw new AssertionError((Object)("Only one implementation of IOAccess allowed. " + this.getClass().getCanonicalName()));
            }
        }

        public abstract Object createIOAccess(String var1, boolean var2, boolean var3, org.graalvm.polyglot.io.FileSystem var4);

        public abstract org.graalvm.polyglot.io.FileSystem getFileSystem(Object var1);

        public abstract boolean hasHostFileAccess(Object var1);

        public abstract boolean hasHostSocketAccess(Object var1);

        public abstract boolean isVetoException(Throwable var1);

        public abstract Exception createVetoException(String var1);
    }

    public static abstract class ThreadScope
    implements AutoCloseable {
        protected ThreadScope(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
        }

        ThreadScope() {
        }

        @Override
        public abstract void close();
    }

    public static abstract class LogHandler {
        public abstract void publish(LogRecord var1);

        public abstract void flush();

        public abstract void close();
    }

    public static abstract class AbstractValueDispatch
    extends AbstractDispatchClass {
        AbstractValueDispatch() {
        }

        protected AbstractValueDispatch(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
        }

        public boolean hasArrayElements(Object context2, Object receiver) {
            return false;
        }

        public abstract Object getArrayElement(Object var1, Object var2, long var3);

        public abstract void setArrayElement(Object var1, Object var2, long var3, Object var5);

        public abstract boolean removeArrayElement(Object var1, Object var2, long var3);

        public abstract long getArraySize(Object var1, Object var2);

        public boolean hasBufferElements(Object context2, Object receiver) {
            return false;
        }

        public abstract boolean isBufferWritable(Object var1, Object var2);

        public abstract long getBufferSize(Object var1, Object var2);

        public abstract byte readBufferByte(Object var1, Object var2, long var3);

        public abstract void readBuffer(Object var1, Object var2, long var3, byte[] var5, int var6, int var7);

        public abstract void writeBufferByte(Object var1, Object var2, long var3, byte var5);

        public abstract short readBufferShort(Object var1, Object var2, ByteOrder var3, long var4);

        public abstract void writeBufferShort(Object var1, Object var2, ByteOrder var3, long var4, short var6);

        public abstract int readBufferInt(Object var1, Object var2, ByteOrder var3, long var4);

        public abstract void writeBufferInt(Object var1, Object var2, ByteOrder var3, long var4, int var6);

        public abstract long readBufferLong(Object var1, Object var2, ByteOrder var3, long var4);

        public abstract void writeBufferLong(Object var1, Object var2, ByteOrder var3, long var4, long var6);

        public abstract float readBufferFloat(Object var1, Object var2, ByteOrder var3, long var4);

        public abstract void writeBufferFloat(Object var1, Object var2, ByteOrder var3, long var4, float var6);

        public abstract double readBufferDouble(Object var1, Object var2, ByteOrder var3, long var4);

        public abstract void writeBufferDouble(Object var1, Object var2, ByteOrder var3, long var4, double var6);

        public boolean hasMembers(Object context2, Object receiver) {
            return false;
        }

        public abstract Object getMember(Object var1, Object var2, String var3);

        public boolean hasMember(Object context2, Object receiver, String key) {
            return false;
        }

        public Object getContext(Object context2) {
            return null;
        }

        public Set<String> getMemberKeys(Object context2, Object receiver) {
            return Collections.emptySet();
        }

        public abstract void putMember(Object var1, Object var2, String var3, Object var4);

        public abstract boolean removeMember(Object var1, Object var2, String var3);

        public boolean canExecute(Object context2, Object receiver) {
            return false;
        }

        public abstract Object execute(Object var1, Object var2, Object[] var3);

        public abstract Object execute(Object var1, Object var2);

        public boolean canInstantiate(Object context2, Object receiver) {
            return false;
        }

        public abstract Object newInstance(Object var1, Object var2, Object[] var3);

        public abstract void executeVoid(Object var1, Object var2, Object[] var3);

        public abstract void executeVoid(Object var1, Object var2);

        public boolean canInvoke(Object context2, String identifier, Object receiver) {
            return false;
        }

        public abstract Object invoke(Object var1, Object var2, String var3, Object[] var4);

        public abstract Object invoke(Object var1, Object var2, String var3);

        public boolean isString(Object context2, Object receiver) {
            return false;
        }

        public abstract String asString(Object var1, Object var2);

        public boolean isBoolean(Object context2, Object receiver) {
            return false;
        }

        public abstract boolean asBoolean(Object var1, Object var2);

        public boolean fitsInInt(Object context2, Object receiver) {
            return false;
        }

        public abstract int asInt(Object var1, Object var2);

        public boolean fitsInLong(Object context2, Object receiver) {
            return false;
        }

        public abstract long asLong(Object var1, Object var2);

        public boolean fitsInBigInteger(Object context2, Object receiver) {
            return false;
        }

        public abstract BigInteger asBigInteger(Object var1, Object var2);

        public boolean fitsInDouble(Object context2, Object receiver) {
            return false;
        }

        public abstract double asDouble(Object var1, Object var2);

        public boolean fitsInFloat(Object context2, Object receiver) {
            return false;
        }

        public abstract float asFloat(Object var1, Object var2);

        public boolean isNull(Object context2, Object receiver) {
            return false;
        }

        public boolean isNativePointer(Object context2, Object receiver) {
            return false;
        }

        public boolean fitsInByte(Object context2, Object receiver) {
            return false;
        }

        public abstract byte asByte(Object var1, Object var2);

        public boolean fitsInShort(Object context2, Object receiver) {
            return false;
        }

        public abstract short asShort(Object var1, Object var2);

        public abstract long asNativePointer(Object var1, Object var2);

        public boolean isHostObject(Object context2, Object receiver) {
            return false;
        }

        public boolean isProxyObject(Object context2, Object receiver) {
            return false;
        }

        public abstract Object asHostObject(Object var1, Object var2);

        public abstract Object asProxyObject(Object var1, Object var2);

        public abstract String toString(Object var1, Object var2);

        public abstract Object getMetaObject(Object var1, Object var2);

        public boolean isNumber(Object context2, Object receiver) {
            return false;
        }

        public abstract <T> T asClass(Object var1, Object var2, Class<T> var3);

        public abstract <T> T asTypeLiteral(Object var1, Object var2, Class<T> var3, Type var4);

        public abstract Object getSourceLocation(Object var1, Object var2);

        public boolean isDate(Object context2, Object receiver) {
            return false;
        }

        public abstract LocalDate asDate(Object var1, Object var2);

        public boolean isTime(Object context2, Object receiver) {
            return false;
        }

        public abstract LocalTime asTime(Object var1, Object var2);

        public abstract Instant asInstant(Object var1, Object var2);

        public boolean isTimeZone(Object context2, Object receiver) {
            return false;
        }

        public abstract ZoneId asTimeZone(Object var1, Object var2);

        public boolean isDuration(Object context2, Object receiver) {
            return false;
        }

        public abstract Duration asDuration(Object var1, Object var2);

        public boolean isException(Object context2, Object receiver) {
            return false;
        }

        public abstract RuntimeException throwException(Object var1, Object var2);

        public boolean isMetaObject(Object context2, Object receiver) {
            return false;
        }

        public abstract String getMetaQualifiedName(Object var1, Object var2);

        public abstract String getMetaSimpleName(Object var1, Object var2);

        public abstract boolean isMetaInstance(Object var1, Object var2, Object var3);

        public abstract boolean hasMetaParents(Object var1, Object var2);

        public abstract Object getMetaParents(Object var1, Object var2);

        public abstract boolean equalsImpl(Object var1, Object var2, Object var3);

        public abstract int hashCodeImpl(Object var1, Object var2);

        public boolean hasIterator(Object context2, Object receiver) {
            return false;
        }

        public abstract Object getIterator(Object var1, Object var2);

        public boolean isIterator(Object context2, Object receiver) {
            return false;
        }

        public abstract boolean hasIteratorNextElement(Object var1, Object var2);

        public abstract Object getIteratorNextElement(Object var1, Object var2);

        public boolean hasHashEntries(Object context2, Object receiver) {
            return false;
        }

        public abstract long getHashSize(Object var1, Object var2);

        public boolean hasHashEntry(Object context2, Object receiver, Object key) {
            return false;
        }

        public abstract Object getHashValue(Object var1, Object var2, Object var3);

        public abstract Object getHashValueOrDefault(Object var1, Object var2, Object var3, Object var4);

        public abstract void putHashEntry(Object var1, Object var2, Object var3, Object var4);

        public abstract boolean removeHashEntry(Object var1, Object var2, Object var3);

        public abstract Object getHashEntriesIterator(Object var1, Object var2);

        public abstract Object getHashKeysIterator(Object var1, Object var2);

        public abstract Object getHashValuesIterator(Object var1, Object var2);

        public abstract void pin(Object var1, Object var2);
    }

    public static abstract class AbstractHostLanguageService
    extends AbstractDispatchClass {
        protected AbstractHostLanguageService(AbstractPolyglotImpl polyglot) {
            Objects.requireNonNull(polyglot);
        }

        public abstract void release();

        public abstract void initializeHostContext(Object var1, Object var2, Object var3, ClassLoader var4, Predicate<String> var5, boolean var6, boolean var7);

        public abstract void throwHostLanguageException(String var1);

        public abstract void addToHostClassPath(Object var1, Object var2);

        public abstract Object toGuestValue(Object var1, Object var2, boolean var3);

        public abstract Object asHostDynamicClass(Object var1, Class<?> var2);

        public abstract Object asHostStaticClass(Object var1, Class<?> var2);

        public abstract Object findDynamicClass(Object var1, String var2);

        public abstract Object findStaticClass(Object var1, String var2);

        public abstract <T> T toHostType(Object var1, Object var2, Object var3, Object var4, Class<T> var5, Type var6);

        public abstract boolean isHostValue(Object var1);

        public abstract Object unboxHostObject(Object var1);

        public abstract Object unboxProxyObject(Object var1);

        public abstract Throwable unboxHostException(Throwable var1);

        public abstract Object toHostObject(Object var1, Object var2);

        public abstract RuntimeException toHostException(Object var1, Throwable var2);

        public abstract boolean isHostException(Object var1);

        public abstract boolean isHostFunction(Object var1);

        public abstract boolean isHostObject(Object var1);

        public abstract boolean isHostSymbol(Object var1);

        public abstract Object createHostAdapter(Object var1, Object[] var2, Object var3);

        public abstract boolean isHostProxy(Object var1);

        public abstract Error toHostResourceError(Throwable var1);

        public abstract int findNextGuestToHostStackTraceElement(StackTraceElement var1, StackTraceElement[] var2, int var3);

        public abstract Object migrateValue(Object var1, Object var2, Object var3);

        public abstract void pin(Object var1);

        public abstract void hostExit(int var1);

        public abstract boolean allowsPublicAccess();

        public final boolean isHostStackTraceVisibleToGuest() {
            return this.allowsPublicAccess();
        }
    }

    public static abstract class AbstractPolyglotHostService
    extends AbstractDispatchClass {
        protected AbstractPolyglotHostService(AbstractPolyglotImpl polyglot) {
            Objects.requireNonNull(polyglot);
        }

        public abstract void notifyClearExplicitContextStack(Object var1);

        public abstract void notifyContextCancellingOrExiting(Object var1, boolean var2, int var3, boolean var4, String var5);

        public abstract void notifyContextClosed(Object var1, boolean var2, boolean var3, String var4);

        public abstract void notifyEngineClosed(Object var1, boolean var2);

        public abstract RuntimeException hostToGuestException(AbstractHostLanguageService var1, Throwable var2);
    }

    public static abstract class AbstractHostAccess
    extends AbstractDispatchClass {
        protected AbstractHostAccess(AbstractPolyglotImpl impl) {
            Objects.requireNonNull(impl);
        }

        public abstract Object toGuestValue(Object var1, Object var2);

        public abstract <T> List<T> toList(Object var1, Object var2, boolean var3, Class<T> var4, Type var5);

        public abstract Object toByteSequence(Object var1, Object var2);

        public abstract <K, V> Map<K, V> toMap(Object var1, Object var2, boolean var3, Class<K> var4, Type var5, Class<V> var6, Type var7);

        public abstract <K, V> Map.Entry<K, V> toMapEntry(Object var1, Object var2, boolean var3, Class<K> var4, Type var5, Class<V> var6, Type var7);

        public abstract <T> Function<?, ?> toFunction(Object var1, Object var2, Class<?> var3, Type var4, Class<?> var5, Type var6);

        public abstract Object toObjectProxy(Object var1, Class<?> var2, Object var3) throws IllegalArgumentException;

        public abstract <T> T toFunctionProxy(Object var1, Class<T> var2, Object var3);

        public abstract <T> Iterable<T> toIterable(Object var1, Object var2, boolean var3, Class<T> var4, Type var5);

        public abstract <T> Iterator<T> toIterator(Object var1, Object var2, boolean var3, Class<T> var4, Type var5);

        public abstract RuntimeException toPolyglotException(Object var1, Throwable var2);

        public abstract Object toValue(Object var1, Object var2);

        public abstract String getValueInfo(Object var1, Object var2);

        public abstract Object[] toValues(Object var1, Object[] var2, int var3);

        public abstract Object[] toValues(Object var1, Object[] var2);

        public abstract void rethrowPolyglotException(Object var1, RuntimeException var2);

        public abstract RuntimeException toEngineException(RuntimeException var1);

        public abstract boolean isEngineException(RuntimeException var1);

        public abstract RuntimeException unboxEngineException(RuntimeException var1);

        public abstract Class<?> getValueClass();

        public abstract Class<?> getPoylglotExceptionClass();

        public abstract boolean isPolyglotException(RuntimeException var1);
    }

    public static abstract class AbstractLanguageDispatch
    extends AbstractDispatchClass {
        AbstractLanguageDispatch() {
        }

        protected AbstractLanguageDispatch(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
        }

        public abstract String getName(Object var1);

        public abstract String getImplementationName(Object var1);

        public abstract boolean isInteractive(Object var1);

        public abstract String getVersion(Object var1);

        public abstract String getId(Object var1);

        public abstract OptionDescriptors getOptions(Object var1);

        public abstract Set<String> getMimeTypes(Object var1);

        public abstract String getDefaultMimeType(Object var1);

        public abstract String getWebsite(Object var1);
    }

    public static abstract class AbstractInstrumentDispatch
    extends AbstractDispatchClass {
        AbstractInstrumentDispatch() {
        }

        protected AbstractInstrumentDispatch(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
        }

        public abstract String getId(Object var1);

        public abstract String getName(Object var1);

        public abstract OptionDescriptors getOptions(Object var1);

        public abstract String getVersion(Object var1);

        public abstract <T> T lookup(Object var1, Class<T> var2);

        public abstract String getWebsite(Object var1);
    }

    public static abstract class AbstractStackFrameImpl
    extends AbstractDispatchClass {
        AbstractStackFrameImpl() {
        }

        protected AbstractStackFrameImpl(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
        }

        public abstract StackTraceElement toHostFrame();

        public abstract Object getSourceLocation();

        public abstract String getRootName();

        public abstract Object getLanguage();

        public abstract boolean isHostFrame();

        public abstract String toStringImpl(int var1);
    }

    public static abstract class AbstractExceptionDispatch
    extends AbstractDispatchClass {
        protected AbstractExceptionDispatch(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
        }

        AbstractExceptionDispatch() {
        }

        public abstract boolean isInternalError(Object var1);

        public abstract boolean isCancelled(Object var1);

        public abstract boolean isExit(Object var1);

        public abstract int getExitStatus(Object var1);

        public abstract Iterable<Object> getPolyglotStackTrace(Object var1);

        public abstract boolean isSyntaxError(Object var1);

        public abstract Object getGuestObject(Object var1);

        public abstract boolean isIncompleteSource(Object var1);

        public abstract void onCreate(Object var1, RuntimeException var2);

        public abstract void printStackTrace(Object var1, PrintStream var2);

        public abstract void printStackTrace(Object var1, PrintWriter var2);

        public abstract StackTraceElement[] getStackTrace(Object var1);

        public abstract String getMessage(Object var1);

        public abstract boolean isHostException(Object var1);

        public abstract Throwable asHostException(Object var1);

        public abstract Object getSourceLocation(Object var1);

        public abstract boolean isResourceExhausted(Object var1);

        public abstract boolean isInterrupted(Object var1);
    }

    public static abstract class AbstractEngineDispatch
    extends AbstractDispatchClass {
        protected AbstractEngineDispatch(AbstractPolyglotImpl impl) {
            Objects.requireNonNull(impl);
        }

        AbstractEngineDispatch() {
        }

        public abstract void setAPI(Object var1, Object var2);

        public abstract Object requirePublicLanguage(Object var1, String var2);

        public abstract Object requirePublicInstrument(Object var1, String var2);

        public abstract void close(Object var1, Object var2, boolean var3);

        public abstract Map<String, Object> getInstruments(Object var1);

        public abstract Map<String, Object> getLanguages(Object var1);

        public abstract OptionDescriptors getOptions(Object var1);

        public abstract Object createContext(Object var1, SandboxPolicy var2, OutputStream var3, OutputStream var4, InputStream var5, boolean var6, Object var7, Object var8, boolean var9, boolean var10, boolean var11, boolean var12, boolean var13, Predicate<String> var14, Map<String, String> var15, Map<String, String[]> var16, String[] var17, Object var18, Object var19, boolean var20, ProcessHandler var21, Object var22, Map<String, String> var23, ZoneId var24, Object var25, String var26, String var27, ClassLoader var28, boolean var29, boolean var30);

        public abstract String getImplementationName(Object var1);

        public abstract Set<Object> getCachedSources(Object var1);

        public abstract String getVersion(Object var1);

        public abstract Object attachExecutionListener(Object var1, Consumer<Object> var2, Consumer<Object> var3, boolean var4, boolean var5, boolean var6, Predicate<Object> var7, Predicate<String> var8, boolean var9, boolean var10, boolean var11);

        public abstract void shutdown(Object var1);

        public abstract RuntimeException hostToGuestException(Object var1, Throwable var2);

        public abstract SandboxPolicy getSandboxPolicy(Object var1);
    }

    public static abstract class AbstractContextDispatch
    extends AbstractDispatchClass {
        protected AbstractContextDispatch(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
        }

        AbstractContextDispatch() {
        }

        public abstract boolean initializeLanguage(Object var1, String var2);

        public abstract Object eval(Object var1, String var2, Object var3);

        public abstract Object parse(Object var1, String var2, Object var3);

        public abstract void close(Object var1, boolean var2);

        public abstract boolean interrupt(Object var1, Duration var2);

        public abstract Object asValue(Object var1, Object var2);

        public abstract void explicitEnter(Object var1);

        public abstract void explicitLeave(Object var1);

        public abstract Object getBindings(Object var1, String var2);

        public abstract Object getPolyglotBindings(Object var1);

        public abstract void resetLimits(Object var1);

        public abstract void safepoint(Object var1);

        public abstract void setAPI(Object var1, Object var2);
    }

    public static abstract class AbstractSourceSectionDispatch
    extends AbstractDispatchClass {
        AbstractSourceSectionDispatch() {
        }

        protected AbstractSourceSectionDispatch(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
        }

        public abstract boolean isAvailable(Object var1);

        public abstract boolean hasLines(Object var1);

        public abstract boolean hasColumns(Object var1);

        public abstract boolean hasCharIndex(Object var1);

        public abstract int getStartLine(Object var1);

        public abstract int getStartColumn(Object var1);

        public abstract int getEndLine(Object var1);

        public abstract int getEndColumn(Object var1);

        public abstract int getCharIndex(Object var1);

        public abstract int getCharLength(Object var1);

        public abstract int getCharEndIndex(Object var1);

        public abstract CharSequence getCode(Object var1);

        public abstract String toString(Object var1);

        public abstract int hashCode(Object var1);

        public abstract boolean equals(Object var1, Object var2);
    }

    public static abstract class AbstractSourceDispatch
    extends AbstractDispatchClass {
        AbstractSourceDispatch() {
        }

        protected AbstractSourceDispatch(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
        }

        public abstract String getName(Object var1);

        public abstract String getPath(Object var1);

        public abstract boolean isCached(Object var1);

        public abstract boolean isInteractive(Object var1);

        public abstract URL getURL(Object var1);

        public abstract URI getURI(Object var1);

        public abstract Reader getReader(Object var1);

        public abstract InputStream getInputStream(Object var1);

        public abstract int getLength(Object var1);

        public abstract CharSequence getCharacters(Object var1);

        public abstract CharSequence getCharacters(Object var1, int var2);

        public abstract int getLineCount(Object var1);

        public abstract int getLineNumber(Object var1, int var2);

        public abstract int getColumnNumber(Object var1, int var2);

        public abstract int getLineStartOffset(Object var1, int var2);

        public abstract int getLineLength(Object var1, int var2);

        public abstract String toString(Object var1);

        public abstract int hashCode(Object var1);

        public abstract boolean equals(Object var1, Object var2);

        public abstract boolean isInternal(Object var1);

        public abstract ByteSequence getBytes(Object var1);

        public abstract byte[] getByteArray(Object var1);

        public abstract boolean hasCharacters(Object var1);

        public abstract boolean hasBytes(Object var1);

        public abstract String getMimeType(Object var1);

        public abstract String getLanguage(Object var1);
    }

    public static abstract class AbstractExecutionEventDispatch
    extends AbstractDispatchClass {
        protected AbstractExecutionEventDispatch(AbstractPolyglotImpl polyglotImpl) {
            Objects.requireNonNull(polyglotImpl);
        }

        AbstractExecutionEventDispatch() {
        }

        public abstract List<Object> getExecutionEventInputValues(Object var1);

        public abstract Object getExecutionEventLocation(Object var1);

        public abstract String getExecutionEventRootName(Object var1);

        public abstract Object getExecutionEventReturnValue(Object var1);

        public abstract boolean isExecutionEventExpression(Object var1);

        public abstract boolean isExecutionEventStatement(Object var1);

        public abstract boolean isExecutionEventRoot(Object var1);

        public abstract RuntimeException getExecutionEventException(Object var1);
    }

    public static abstract class AbstractExecutionListenerDispatch
    extends AbstractDispatchClass {
        protected AbstractExecutionListenerDispatch(AbstractPolyglotImpl polyglotImpl) {
            Objects.requireNonNull(polyglotImpl);
        }

        AbstractExecutionListenerDispatch() {
        }

        public abstract void closeExecutionListener(Object var1);
    }

    public static abstract class AbstractDispatchClass {
    }
}

