/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.util.Computable;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.FileId2ValueMapping;
import com.intellij.util.indexing.impl.UpdatableValueContainer;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ChangeTrackingValueContainer<Value>
extends UpdatableValueContainer<Value> {
    protected ValueContainerImpl<Value> myAdded;
    protected IntSet myInvalidated;
    private volatile ValueContainerImpl<Value> myMergedSnapshot;
    @NotNull
    private final Computable<? extends UpdatableValueContainer<Value>> myInitializer;

    public ChangeTrackingValueContainer(@NotNull Computable<? extends UpdatableValueContainer<Value>> initializer) {
        if (initializer == null) {
            ChangeTrackingValueContainer.$$$reportNull$$$0(0);
        }
        this.myInitializer = initializer;
    }

    @Override
    public void addValue(int inputId, Value value) {
        ValueContainerImpl<Value> mergedSnapshot = this.myMergedSnapshot;
        if (mergedSnapshot != null) {
            mergedSnapshot.addValue(inputId, value);
        }
        if (this.myAdded == null) {
            this.myAdded = ValueContainerImpl.createNewValueContainer();
        }
        this.myAdded.addValue(inputId, value);
    }

    @Override
    public boolean removeAssociatedValue(int inputId) {
        ValueContainerImpl<Value> mergedSnapshot = this.myMergedSnapshot;
        if (mergedSnapshot != null) {
            mergedSnapshot.removeAssociatedValue(inputId);
        }
        boolean wasRemovedFromAdded = this.removeFromAdded(inputId);
        boolean wasAddedToRemoved = this.addToRemoved(inputId);
        return wasRemovedFromAdded || wasAddedToRemoved;
    }

    private boolean addToRemoved(int inputId) {
        if (this.myInvalidated == null) {
            this.myInvalidated = new IntOpenHashSet(1);
        }
        return this.myInvalidated.add(inputId);
    }

    protected boolean removeFromAdded(int inputId) {
        return this.myAdded != null && this.myAdded.removeAssociatedValue(inputId);
    }

    @Override
    public int size() {
        return this.getMergedData().size();
    }

    @Override
    @NotNull
    public ValueContainer.ValueIterator<Value> getValueIterator() {
        ValueContainer.ValueIterator valueIterator = this.getMergedData().getValueIterator();
        if (valueIterator == null) {
            ChangeTrackingValueContainer.$$$reportNull$$$0(1);
        }
        return valueIterator;
    }

    public void dropMergedData() {
        this.myMergedSnapshot = null;
    }

    private ValueContainerImpl<Value> getMergedData() {
        ValueContainerImpl<Value> mergedSnapshot = this.myMergedSnapshot;
        if (mergedSnapshot != null) {
            return mergedSnapshot;
        }
        UpdatableValueContainer<Value> fromDisk = this.myInitializer.compute();
        mergedSnapshot = this.myMergedSnapshot;
        if (mergedSnapshot != null) {
            return mergedSnapshot;
        }
        Object newMerged = fromDisk instanceof ValueContainerImpl ? ((ValueContainerImpl)fromDisk).clone() : ((ChangeTrackingValueContainer)fromDisk).getMergedData().clone();
        FileId2ValueMapping fileId2ValueMapping = (this.myAdded != null || this.myInvalidated != null) && (((ValueContainerImpl)newMerged).size() > 20 || this.myAdded != null && this.myAdded.size() > 20) ? new FileId2ValueMapping(newMerged) : null;
        if (this.myInvalidated != null) {
            this.myInvalidated.forEach(arg_0 -> ChangeTrackingValueContainer.lambda$getMergedData$0(fileId2ValueMapping, (ValueContainerImpl)newMerged, arg_0));
        }
        if (this.myAdded != null) {
            this.myAdded.forEach((arg_0, arg_1) -> ChangeTrackingValueContainer.lambda$getMergedData$1(fileId2ValueMapping, (ValueContainerImpl)newMerged, arg_0, arg_1));
        }
        this.setNeedsCompacting(fromDisk.needsCompacting());
        this.myMergedSnapshot = newMerged;
        return newMerged;
    }

    public boolean isDirty() {
        return this.myAdded != null && this.myAdded.size() > 0 || this.myInvalidated != null && !this.myInvalidated.isEmpty() || this.needsCompacting();
    }

    public boolean containsOnlyInvalidatedChange() {
        return this.myInvalidated != null && !this.myInvalidated.isEmpty() && (this.myAdded == null || this.myAdded.size() == 0);
    }

    public boolean containsCachedMergedData() {
        return this.myMergedSnapshot != null;
    }

    @Override
    public void saveTo(@NotNull DataOutput out, @NotNull DataExternalizer<? super Value> externalizer) throws IOException {
        if (out == null) {
            ChangeTrackingValueContainer.$$$reportNull$$$0(2);
        }
        if (externalizer == null) {
            ChangeTrackingValueContainer.$$$reportNull$$$0(3);
        }
        this.getMergedData().saveTo(out, externalizer);
    }

    public void saveDiffTo(@NotNull DataOutput out, @NotNull DataExternalizer<? super Value> externalizer) throws IOException {
        ValueContainerImpl<Value> toAppend;
        IntSet set;
        if (out == null) {
            ChangeTrackingValueContainer.$$$reportNull$$$0(4);
        }
        if (externalizer == null) {
            ChangeTrackingValueContainer.$$$reportNull$$$0(5);
        }
        if ((set = this.myInvalidated) != null && !set.isEmpty()) {
            for (int inputId : this.myInvalidated.toIntArray()) {
                DataInputOutputUtil.writeINT(out, -inputId);
            }
        }
        if ((toAppend = this.myAdded) != null && ((ValueContainer)toAppend).size() > 0) {
            ((UpdatableValueContainer)toAppend).saveTo(out, externalizer);
        }
    }

    private static /* synthetic */ boolean lambda$getMergedData$1(FileId2ValueMapping fileId2ValueMapping, ValueContainerImpl newMerged, int inputId, Object value) {
        if (fileId2ValueMapping != null) {
            fileId2ValueMapping.removeFileId(inputId);
            fileId2ValueMapping.associateFileIdToValue(inputId, value);
        } else {
            newMerged.removeAssociatedValue(inputId);
            newMerged.addValue(inputId, value);
        }
        return true;
    }

    private static /* synthetic */ void lambda$getMergedData$0(FileId2ValueMapping fileId2ValueMapping, ValueContainerImpl newMerged, int inputId) {
        if (fileId2ValueMapping != null) {
            fileId2ValueMapping.removeFileId(inputId);
        } else {
            newMerged.removeAssociatedValue(inputId);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/ChangeTrackingValueContainer";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/ChangeTrackingValueContainer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveTo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveDiffTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

