/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import java.io.Serializable;
import kotlin.SinceKotlin;
import kotlin.jvm.internal.CallableReference;
import kotlin.jvm.internal.FunctionBase;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;

@SinceKotlin(version="1.4")
public class AdaptedFunctionReference
implements FunctionBase,
Serializable {
    protected final Object receiver;
    private final Class owner;
    private final String name;
    private final String signature;
    private final boolean isTopLevel;
    private final int arity;
    private final int flags;

    public AdaptedFunctionReference(int arity, Class owner, String name, String signature2, int flags) {
        this(arity, CallableReference.NO_RECEIVER, owner, name, signature2, flags);
    }

    public AdaptedFunctionReference(int arity, Object receiver, Class owner, String name, String signature2, int flags) {
        this.receiver = receiver;
        this.owner = owner;
        this.name = name;
        this.signature = signature2;
        this.isTopLevel = (flags & 1) == 1;
        this.arity = arity;
        this.flags = flags >> 1;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    public KDeclarationContainer getOwner() {
        return this.owner == null ? null : (this.isTopLevel ? Reflection.getOrCreateKotlinPackage(this.owner) : Reflection.getOrCreateKotlinClass(this.owner));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdaptedFunctionReference)) {
            return false;
        }
        AdaptedFunctionReference other2 = (AdaptedFunctionReference)o;
        return this.isTopLevel == other2.isTopLevel && this.arity == other2.arity && this.flags == other2.flags && Intrinsics.areEqual(this.receiver, other2.receiver) && Intrinsics.areEqual(this.owner, other2.owner) && this.name.equals(other2.name) && this.signature.equals(other2.signature);
    }

    public int hashCode() {
        int result2 = this.receiver != null ? this.receiver.hashCode() : 0;
        result2 = result2 * 31 + (this.owner != null ? this.owner.hashCode() : 0);
        result2 = result2 * 31 + this.name.hashCode();
        result2 = result2 * 31 + this.signature.hashCode();
        result2 = result2 * 31 + (this.isTopLevel ? 1231 : 1237);
        result2 = result2 * 31 + this.arity;
        result2 = result2 * 31 + this.flags;
        return result2;
    }

    public String toString() {
        return Reflection.renderLambdaToString(this);
    }
}

