/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.parsing;

import com.jetbrains.jdbc.base.models.RdFullyQualifiedName;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/jdbc/sqlserver/parsing/ProcedureNameParser;", "", "()V", "THREE_PART_NAME", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "sqlIdentifierPart", "", "sqlIdentifierWithGroups", "parse", "Lcom/jetbrains/jdbc/base/models/RdFullyQualifiedName;", "procedureName", "Frontend"})
public final class ProcedureNameParser {
    @NotNull
    public static final ProcedureNameParser INSTANCE = new ProcedureNameParser();
    @NotNull
    private static final String sqlIdentifierPart = "(?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))";
    @NotNull
    private static final String sqlIdentifierWithGroups = "((?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?)))(?:\\.((?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))))?";
    private static final Pattern THREE_PART_NAME = Pattern.compile("((?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?)))(?:\\.((?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))))?");

    private ProcedureNameParser() {
    }

    @NotNull
    public final RdFullyQualifiedName parse(@NotNull String procedureName) {
        Intrinsics.checkNotNullParameter(procedureName, "procedureName");
        String procedurePart = procedureName;
        String ownerPart = null;
        String databasePart = null;
        Matcher matcher = null;
        Matcher matcher2 = THREE_PART_NAME.matcher(procedureName);
        Intrinsics.checkNotNullExpressionValue(matcher2, "THREE_PART_NAME.matcher(procedureName)");
        matcher = matcher2;
        if (matcher.matches()) {
            if (matcher.group(2) != null) {
                databasePart = matcher.group(1);
                Matcher matcher3 = THREE_PART_NAME.matcher(matcher.group(2));
                Intrinsics.checkNotNullExpressionValue(matcher3, "THREE_PART_NAME.matcher(matcher.group(2))");
                matcher = matcher3;
                if (matcher.matches()) {
                    if (matcher.group(2) != null) {
                        ownerPart = matcher.group(1);
                        String string = matcher.group(2);
                        Intrinsics.checkNotNullExpressionValue(string, "matcher.group(2)");
                        procedurePart = string;
                    } else {
                        ownerPart = databasePart;
                        databasePart = null;
                        String string = matcher.group(1);
                        Intrinsics.checkNotNullExpressionValue(string, "matcher.group(1)");
                        procedurePart = string;
                    }
                }
            } else {
                String string = matcher.group(1);
                Intrinsics.checkNotNullExpressionValue(string, "matcher.group(1)");
                procedurePart = string;
            }
        }
        return new RdFullyQualifiedName(procedurePart, databasePart, ownerPart);
    }
}

