/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.parsing;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u00a8\u0006\r"}, d2={"Lcom/jetbrains/jdbc/sqlserver/parsing/ParametersPositionProvider;", "", "()V", "getParameterPositions", "", "", "sql", "", "scanSqlForChar", "charToSearch", "", "offset", "ParserState", "Frontend"})
public final class ParametersPositionProvider {
    @NotNull
    public static final ParametersPositionProvider INSTANCE = new ParametersPositionProvider();

    private ParametersPositionProvider() {
    }

    @NotNull
    public final List<Integer> getParameterPositions(@NotNull String sql) {
        Intrinsics.checkNotNullParameter(sql, "sql");
        List parameterPositions = new ArrayList();
        for (int parameterIndex = 0; parameterIndex < sql.length() && (parameterIndex = this.scanSqlForChar('?', sql, parameterIndex)) != -1; ++parameterIndex) {
            parameterPositions.add(parameterIndex);
        }
        return parameterPositions;
    }

    private final int scanSqlForChar(char charToSearch, String sql, int offset) {
        int currentOffset = offset;
        ParserState parserState = ParserState.Regular;
        block11: while (currentOffset < sql.length()) {
            switch (WhenMappings.$EnumSwitchMapping$0[parserState.ordinal()]) {
                case 1: {
                    if (sql.charAt(currentOffset) == '*') {
                        parserState = ParserState.InMultiLineComment;
                        break;
                    }
                    parserState = ParserState.Regular;
                    continue block11;
                }
                case 2: {
                    if (sql.charAt(currentOffset) != '*') break;
                    parserState = ParserState.PossibleEndOfMultilineComment;
                    break;
                }
                case 3: {
                    if (sql.charAt(currentOffset) == '/') {
                        parserState = ParserState.Regular;
                        break;
                    }
                    parserState = ParserState.InMultiLineComment;
                    break;
                }
                case 4: {
                    if (sql.charAt(currentOffset) == '-') {
                        parserState = ParserState.InSingleLineComment;
                        break;
                    }
                    parserState = ParserState.Regular;
                    continue block11;
                }
                case 5: {
                    if (sql.charAt(currentOffset) != '\n' && sql.charAt(currentOffset) != '\r') break;
                    parserState = ParserState.Regular;
                    break;
                }
                case 6: {
                    if (sql.charAt(currentOffset) != '\'') break;
                    parserState = ParserState.Regular;
                    break;
                }
                case 7: {
                    if (sql.charAt(currentOffset) != '\"') break;
                    parserState = ParserState.Regular;
                    break;
                }
                case 8: {
                    if (sql.charAt(currentOffset) != ']') break;
                    parserState = ParserState.Regular;
                    break;
                }
                case 9: {
                    if (sql.charAt(currentOffset) == '/') {
                        parserState = ParserState.PossibleStartOfMultilineComment;
                    }
                    if (sql.charAt(currentOffset) == '-') {
                        parserState = ParserState.PossibleStartOfSingleLineComment;
                    }
                    if (sql.charAt(currentOffset) == '\'') {
                        parserState = ParserState.InSingleQuote;
                    }
                    if (sql.charAt(currentOffset) == '\"') {
                        parserState = ParserState.InDoubleQuote;
                    }
                    if (sql.charAt(currentOffset) == '[') {
                        parserState = ParserState.InBracket;
                    }
                    if (sql.charAt(currentOffset) != charToSearch) break;
                    return currentOffset;
                }
            }
            ++currentOffset;
        }
        return -1;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/jdbc/sqlserver/parsing/ParametersPositionProvider$ParserState;", "", "(Ljava/lang/String;I)V", "PossibleStartOfMultilineComment", "InMultiLineComment", "PossibleEndOfMultilineComment", "PossibleStartOfSingleLineComment", "InSingleLineComment", "InSingleQuote", "InDoubleQuote", "InBracket", "Regular", "Frontend"})
    public static final class ParserState
    extends Enum<ParserState> {
        public static final /* enum */ ParserState PossibleStartOfMultilineComment = new ParserState();
        public static final /* enum */ ParserState InMultiLineComment = new ParserState();
        public static final /* enum */ ParserState PossibleEndOfMultilineComment = new ParserState();
        public static final /* enum */ ParserState PossibleStartOfSingleLineComment = new ParserState();
        public static final /* enum */ ParserState InSingleLineComment = new ParserState();
        public static final /* enum */ ParserState InSingleQuote = new ParserState();
        public static final /* enum */ ParserState InDoubleQuote = new ParserState();
        public static final /* enum */ ParserState InBracket = new ParserState();
        public static final /* enum */ ParserState Regular = new ParserState();
        private static final /* synthetic */ ParserState[] $VALUES;

        public static ParserState[] values() {
            return (ParserState[])$VALUES.clone();
        }

        public static ParserState valueOf(String value2) {
            return Enum.valueOf(ParserState.class, value2);
        }

        static {
            $VALUES = parserStateArray = new ParserState[]{ParserState.PossibleStartOfMultilineComment, ParserState.InMultiLineComment, ParserState.PossibleEndOfMultilineComment, ParserState.PossibleStartOfSingleLineComment, ParserState.InSingleLineComment, ParserState.InSingleQuote, ParserState.InDoubleQuote, ParserState.InBracket, ParserState.Regular};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ParserState.values().length];
            try {
                nArray[ParserState.PossibleStartOfMultilineComment.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParserState.InMultiLineComment.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParserState.PossibleEndOfMultilineComment.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParserState.PossibleStartOfSingleLineComment.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParserState.InSingleLineComment.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParserState.InSingleQuote.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParserState.InDoubleQuote.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParserState.InBracket.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParserState.Regular.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

