/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.parsing;

import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u000b\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u0012R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/jdbc/sqlserver/parsing/LimitSyntaxParser;", "", "()V", "limitOnlyPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "limitSyntaxGeneric", "limitSyntaxWithOffset", "openQueryPattern", "openRowsetPattern", "selectPattern", "translateLimit", "", "sql", "Ljava/lang/StringBuffer;", "indx", "endChar", "", "", "State", "Frontend"})
@SourceDebugExtension(value={"SMAP\nLimitSyntaxParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LimitSyntaxParser.kt\ncom/jetbrains/jdbc/sqlserver/parsing/LimitSyntaxParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1#2:192\n*E\n"})
public final class LimitSyntaxParser {
    @NotNull
    public static final LimitSyntaxParser INSTANCE = new LimitSyntaxParser();
    private static final Pattern limitSyntaxWithOffset = Pattern.compile("\\{\\s*[lL][iI][mM][iI][tT]\\s+(.*)\\s+[oO][fF][fF][sS][eE][tT]\\s+(.*)\\}");
    private static final Pattern limitSyntaxGeneric = Pattern.compile("\\{\\s*[lL][iI][mM][iI][tT]\\s+(.*)(\\s+[oO][fF][fF][sS][eE][tT](.*)\\}|\\s*\\})");
    private static final Pattern selectPattern = Pattern.compile("([sS][eE][lL][eE][cC][tT])\\s+");
    private static final Pattern openQueryPattern = Pattern.compile("[oO][pP][eE][nN][qQ][uU][eE][rR][yY]\\s*\\(.*,\\s*'(.*)'\\s*\\)");
    private static final Pattern openRowsetPattern = Pattern.compile("[oO][pP][eE][nN][rR][oO][wW][sS][eE][tT]\\s*\\(.*,.*,\\s*'(.*)'\\s*\\)");
    private static final Pattern limitOnlyPattern = Pattern.compile("\\{\\s*[lL][iI][mM][iI][tT]\\s+(((\\(|\\s)*)(\\d*|\\?)((\\)|\\s)*))\\s*\\}");

    private LimitSyntaxParser() {
    }

    @NotNull
    public final String translateLimit(@NotNull String sql) {
        Intrinsics.checkNotNullParameter(sql, "sql");
        Matcher matcher = limitSyntaxGeneric.matcher(sql);
        if (matcher.find()) {
            StringBuffer sqlbuf = new StringBuffer(sql);
            this.translateLimit(sqlbuf, 0, '\u0000');
            String string = sqlbuf.toString();
            Intrinsics.checkNotNullExpressionValue(string, "sqlbuf.toString()");
            return string;
        }
        return sql;
    }

    private final int translateLimit(StringBuffer sql, int indx, char endChar) {
        int index = indx;
        Matcher selectMatcher = selectPattern.matcher(sql);
        Matcher openQueryMatcher = openQueryPattern.matcher(sql);
        Matcher openRowsetMatcher = openRowsetPattern.matcher(sql);
        Matcher limitMatcher = limitOnlyPattern.matcher(sql);
        Matcher offsetMatcher = limitSyntaxWithOffset.matcher(sql);
        int startIndx = index;
        Stack<Integer> topPosition = new Stack<Integer>();
        State nextState = State.START;
        block12: while (index < sql.length()) {
            char ch = sql.charAt(index);
            switch (WhenMappings.$EnumSwitchMapping$0[nextState.ordinal()]) {
                case 1: {
                    nextState = State.PROCESS;
                    continue block12;
                }
                case 2: {
                    if (endChar == ch) {
                        nextState = State.END;
                        continue block12;
                    }
                    if ('\'' == ch) {
                        nextState = State.QUOTE;
                        continue block12;
                    }
                    if ('(' == ch) {
                        nextState = State.SUBQUERY;
                        continue block12;
                    }
                    if (limitMatcher.find(index) && index == limitMatcher.start()) {
                        nextState = State.LIMIT;
                        continue block12;
                    }
                    if (offsetMatcher.find(index) && index == offsetMatcher.start()) {
                        nextState = State.OFFSET;
                        continue block12;
                    }
                    if (openQueryMatcher.find(index) && index == openQueryMatcher.start()) {
                        nextState = State.OPENQUERY;
                        continue block12;
                    }
                    if (openRowsetMatcher.find(index) && index == openRowsetMatcher.start()) {
                        nextState = State.OPENROWSET;
                        continue block12;
                    }
                    if (selectMatcher.find(index) && index == selectMatcher.start()) {
                        nextState = State.SELECT;
                        continue block12;
                    }
                    ++index;
                    continue block12;
                }
                case 3: {
                    throw ExceptionsKt.keywordNotSupported("OFFSET");
                }
                case 4: {
                    Unit unit;
                    int it;
                    int n;
                    int n2;
                    int openingParentheses = 0;
                    int closingParentheses = 0;
                    int pos = 0;
                    pos = -1;
                    String openingStr = limitMatcher.group(2);
                    String closingStr = limitMatcher.group(5);
                    while (true) {
                        Intrinsics.checkNotNullExpressionValue(openingStr, "openingStr");
                        int n3 = n2 = StringsKt.indexOf$default((CharSequence)openingStr, '(', pos + 1, false, 4, null);
                        n = -1;
                        boolean bl = false;
                        pos = it;
                        unit = Unit.INSTANCE;
                        if (n == n2) break;
                        ++openingParentheses;
                    }
                    pos = -1;
                    while (true) {
                        Intrinsics.checkNotNullExpressionValue(closingStr, "closingStr");
                        it = n2 = StringsKt.indexOf$default((CharSequence)closingStr, ')', pos + 1, false, 4, null);
                        n = -1;
                        boolean bl = false;
                        pos = it;
                        unit = Unit.INSTANCE;
                        if (n == n2) break;
                        ++closingParentheses;
                    }
                    if (openingParentheses != closingParentheses) {
                        throw ExceptionsKt.invalidEscapeSyntax();
                    }
                    if (!topPosition.empty()) {
                        Integer top = (Integer)topPosition.pop();
                        String rows = limitMatcher.group(1);
                        sql.delete(limitMatcher.start() - 1, limitMatcher.end());
                        if ('?' == rows.charAt(0)) {
                            Intrinsics.checkNotNullExpressionValue(top, "top");
                            sql.insert((int)top, " TOP (" + rows + ")");
                            index += 7 + rows.length() - 1;
                        } else {
                            Intrinsics.checkNotNullExpressionValue(top, "top");
                            sql.insert((int)top, " TOP " + rows);
                            index += 5 + rows.length() - 1;
                        }
                    } else {
                        index = limitMatcher.end() - 1;
                    }
                    nextState = State.PROCESS;
                    continue block12;
                }
                case 5: {
                    index = selectMatcher.end(1);
                    topPosition.push(index);
                    nextState = State.PROCESS;
                    continue block12;
                }
                case 6: {
                    if (sql.length() > ++index && '\'' == sql.charAt(index)) {
                        if (sql.length() > ++index && '\'' == sql.charAt(index)) {
                            nextState = State.QUOTE;
                            continue block12;
                        }
                        nextState = State.PROCESS;
                        continue block12;
                    }
                    nextState = State.QUOTE;
                    continue block12;
                }
                case 7: {
                    ++index;
                    index += this.translateLimit(sql, index, ')');
                    nextState = State.PROCESS;
                    continue block12;
                }
                case 8: {
                    index = openQueryMatcher.start(1);
                    index += this.translateLimit(sql, index, '\'');
                    nextState = State.PROCESS;
                    continue block12;
                }
                case 9: {
                    index = openRowsetMatcher.start(1);
                    index += this.translateLimit(sql, index, '\'');
                    nextState = State.PROCESS;
                    continue block12;
                }
                case 10: {
                    return ++index - startIndx;
                }
            }
        }
        return index - startIndx;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\f\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/jdbc/sqlserver/parsing/LimitSyntaxParser$State;", "", "(Ljava/lang/String;I)V", "START", "END", "SUBQUERY", "SELECT", "OPENQUERY", "OPENROWSET", "LIMIT", "OFFSET", "QUOTE", "PROCESS", "Frontend"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State START = new State();
        public static final /* enum */ State END = new State();
        public static final /* enum */ State SUBQUERY = new State();
        public static final /* enum */ State SELECT = new State();
        public static final /* enum */ State OPENQUERY = new State();
        public static final /* enum */ State OPENROWSET = new State();
        public static final /* enum */ State LIMIT = new State();
        public static final /* enum */ State OFFSET = new State();
        public static final /* enum */ State QUOTE = new State();
        public static final /* enum */ State PROCESS = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        static {
            $VALUES = stateArray = new State[]{State.START, State.END, State.SUBQUERY, State.SELECT, State.OPENQUERY, State.OPENROWSET, State.LIMIT, State.OFFSET, State.QUOTE, State.PROCESS};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.PROCESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.OFFSET.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.LIMIT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.SELECT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.QUOTE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.SUBQUERY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.OPENQUERY.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.OPENROWSET.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.END.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

