/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.factories;

import com.jetbrains.jdbc.base.conversions.get.ValueGetter;
import com.jetbrains.jdbc.base.conversions.set.ValueSetter;
import com.jetbrains.jdbc.base.factories.IRowsAndColumnsFactory;
import com.jetbrains.jdbc.base.models.RdGetResultSetColumn;
import com.jetbrains.jdbc.base.models.RdGetResultSetRow;
import com.jetbrains.jdbc.base.resultsets.models.IResultSetColumn;
import com.jetbrains.jdbc.base.resultsets.models.IResultSetRow;
import com.jetbrains.jdbc.base.resultsets.models.ResultSetColumn;
import com.jetbrains.jdbc.base.resultsets.models.ResultSetRow;
import com.jetbrains.jdbc.base.resultsets.models.ResultSetRowMetadata;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/jdbc/sqlserver/factories/SqlServerRowsAndColumnsFactory;", "Lcom/jetbrains/jdbc/base/factories/IRowsAndColumnsFactory;", "valueGetter", "Lcom/jetbrains/jdbc/base/conversions/get/ValueGetter;", "valueSetter", "Lcom/jetbrains/jdbc/base/conversions/set/ValueSetter;", "(Lcom/jetbrains/jdbc/base/conversions/get/ValueGetter;Lcom/jetbrains/jdbc/base/conversions/set/ValueSetter;)V", "createResultSetColumn", "Lcom/jetbrains/jdbc/base/resultsets/models/IResultSetColumn;", "rdColumn", "Lcom/jetbrains/jdbc/base/models/RdGetResultSetColumn;", "createResultSetRow", "Lcom/jetbrains/jdbc/base/resultsets/models/IResultSetRow;", "positionInBatch", "", "row", "Lcom/jetbrains/jdbc/base/models/RdGetResultSetRow;", "metadata", "Lcom/jetbrains/jdbc/base/resultsets/models/ResultSetRowMetadata;", "Frontend"})
public final class SqlServerRowsAndColumnsFactory
implements IRowsAndColumnsFactory {
    @NotNull
    private final ValueGetter valueGetter;
    @NotNull
    private final ValueSetter valueSetter;

    public SqlServerRowsAndColumnsFactory(@NotNull ValueGetter valueGetter, @NotNull ValueSetter valueSetter) {
        Intrinsics.checkNotNullParameter(valueGetter, "valueGetter");
        Intrinsics.checkNotNullParameter(valueSetter, "valueSetter");
        this.valueGetter = valueGetter;
        this.valueSetter = valueSetter;
    }

    @Override
    @NotNull
    public IResultSetColumn createResultSetColumn(@NotNull RdGetResultSetColumn rdColumn) {
        Intrinsics.checkNotNullParameter(rdColumn, "rdColumn");
        return new ResultSetColumn(rdColumn, this.valueGetter, this.valueSetter);
    }

    @Override
    @NotNull
    public IResultSetRow createResultSetRow(int positionInBatch, @NotNull RdGetResultSetRow row, @NotNull ResultSetRowMetadata metadata2) {
        Intrinsics.checkNotNullParameter(row, "row");
        Intrinsics.checkNotNullParameter(metadata2, "metadata");
        return new ResultSetRow(positionInBatch, row, metadata2, this);
    }
}

