/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.converters.set;

import com.jetbrains.jdbc.base.conversions.set.SetValueConverter;
import com.jetbrains.jdbc.base.models.RdDateTime;
import com.jetbrains.jdbc.base.models.RdSetDateTimeRequest;
import com.jetbrains.jdbc.base.models.RdSetNullRequest;
import com.jetbrains.jdbc.base.models.RdSetValueRequest;
import com.jetbrains.jdbc.base.utils.conversions.DateTimeUtilsKt;
import com.jetbrains.jdbc.sqlserver.SqlServerJdbcToNativeTypeTranslator;
import com.jetbrains.jdbc.sqlserver.converters.SqlDateTimeFormatter;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u0010\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u0012\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u0014\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u0018\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u0019\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u001b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u001d\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/jdbc/sqlserver/converters/set/SetTimestampConverter;", "Lcom/jetbrains/jdbc/base/conversions/set/SetValueConverter;", "()V", "to", "", "Ljava/sql/JDBCType;", "getTo", "()Ljava/util/List;", "fromLocalDate", "Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "value", "Ljava/time/LocalDate;", "sqlType", "", "fromLocalDateTime", "Ljava/time/LocalDateTime;", "fromLocalTime", "Ljava/time/LocalTime;", "fromNString", "", "fromSqlDate", "Ljava/sql/Date;", "timeZone", "Ljava/util/TimeZone;", "fromString", "fromTime", "Ljava/sql/Time;", "fromTimestamp", "Ljava/sql/Timestamp;", "fromUtilDate", "Ljava/util/Date;", "Frontend"})
public final class SetTimestampConverter
extends SetValueConverter {
    @NotNull
    public static final SetTimestampConverter INSTANCE = new SetTimestampConverter();
    @NotNull
    private static final List<JDBCType> to = CollectionsKt.listOf(JDBCType.TIMESTAMP);

    private SetTimestampConverter() {
        super(SqlServerJdbcToNativeTypeTranslator.INSTANCE);
    }

    @NotNull
    public List<JDBCType> getTo() {
        return to;
    }

    @Override
    @NotNull
    public RdSetValueRequest fromSqlDate(@Nullable Date value2, @NotNull TimeZone timeZone, int sqlType) {
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Instant instant = Instant.ofEpochMilli(value2.getTime());
        Intrinsics.checkNotNullExpressionValue(instant, "instant");
        Instant converted = DateTimeUtilsKt.resetTime(DateTimeUtilsKt.fromGregorianToPureGregorian(instant, timeZone)).toInstant();
        java.util.Date date = java.util.Date.from(converted);
        Intrinsics.checkNotNullExpressionValue(date, "from(converted)");
        RdDateTime rdDateTime = new RdDateTime(date, 0);
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDateTimeRequest(rdDateTime, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromUtilDate(@Nullable java.util.Date value2, @NotNull TimeZone timeZone, int sqlType) {
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Instant instant = value2.toInstant();
        Intrinsics.checkNotNullExpressionValue(instant, "value.toInstant()");
        java.util.Date date = java.util.Date.from(DateTimeUtilsKt.fromGregorianToPureGregorian(instant, timeZone).toInstant());
        Intrinsics.checkNotNullExpressionValue(date, "from(\n                va\u2026toInstant()\n            )");
        RdDateTime rdDateTime = new RdDateTime(date, 0);
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDateTimeRequest(rdDateTime, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromTimestamp(@Nullable Timestamp value2, @NotNull TimeZone timeZone, int sqlType) {
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Instant instant = value2.toInstant();
        Intrinsics.checkNotNullExpressionValue(instant, "instant");
        Instant converted = DateTimeUtilsKt.fromGregorianToPureGregorian(instant, timeZone).toInstant();
        java.util.Date date = Date.from(converted);
        Intrinsics.checkNotNullExpressionValue(date, "from(converted)");
        RdDateTime rdDateTime = new RdDateTime(date, DateTimeUtilsKt.getLeftNanos(instant));
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDateTimeRequest(rdDateTime, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromLocalDateTime(@Nullable LocalDateTime value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Instant instant = value2.toInstant(ZoneOffset.UTC);
        java.util.Date date = java.util.Date.from(instant);
        Intrinsics.checkNotNullExpressionValue(date, "from(instant)");
        Intrinsics.checkNotNullExpressionValue(instant, "instant");
        RdDateTime rdDateTime = new RdDateTime(date, DateTimeUtilsKt.getLeftNanos(instant));
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDateTimeRequest(rdDateTime, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromLocalDate(@Nullable LocalDate value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Instant instant = value2.atTime(LocalTime.MIN).toInstant(ZoneOffset.UTC);
        java.util.Date date = java.util.Date.from(instant);
        Intrinsics.checkNotNullExpressionValue(date, "from(instant)");
        RdDateTime rdDateTime = new RdDateTime(date, 0);
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDateTimeRequest(rdDateTime, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromTime(@Nullable Time value2, @NotNull TimeZone timeZone, int sqlType) {
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Instant instant = Instant.ofEpochMilli(value2.getTime());
        Intrinsics.checkNotNullExpressionValue(instant, "instant");
        java.util.Date date = java.util.Date.from(DateTimeUtilsKt.fromGregorianToPureGregorian(instant, timeZone).toInstant());
        Intrinsics.checkNotNullExpressionValue(date, "from(instant.fromGregori\u2026an(timeZone).toInstant())");
        RdDateTime rdTime = new RdDateTime(date, 0);
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDateTimeRequest(rdTime, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromLocalTime(@Nullable LocalTime value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Instant instant = value2.atDate(LocalDate.EPOCH).toInstant(ZoneOffset.UTC);
        java.util.Date date = java.util.Date.from(instant);
        Intrinsics.checkNotNullExpressionValue(date, "from(instant)");
        Intrinsics.checkNotNullExpressionValue(instant, "instant");
        RdDateTime rdDateTime = new RdDateTime(date, DateTimeUtilsKt.getLeftNanos(instant));
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDateTimeRequest(rdDateTime, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromString(@Nullable String value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        LocalDateTime localDateTime = SqlDateTimeFormatter.INSTANCE.parseLocalDateTime(value2);
        return this.fromLocalDateTime(localDateTime, sqlType);
    }

    @Override
    @NotNull
    public RdSetValueRequest fromNString(@Nullable String value2, int sqlType) {
        return this.fromString(value2, sqlType);
    }
}

