/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.converters.set;

import com.jetbrains.jdbc.base.conversions.set.SetValueConverter;
import com.jetbrains.jdbc.base.models.RdSetNullRequest;
import com.jetbrains.jdbc.base.models.RdSetStringRequest;
import com.jetbrains.jdbc.base.models.RdSetValueRequest;
import com.jetbrains.jdbc.base.utils.conversions.DateTimeUtilsKt;
import com.jetbrains.jdbc.sqlserver.SqlServerJdbcToNativeTypeTranslator;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u001a\u0010\u0013\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\"\u0010\u0015\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u001a\u0010\u0016\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u001f\u0010\u0018\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001f\u0010\u001b\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001a\u0010\u001e\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\"\u0010 \u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010!2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u001a\u0010\"\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010#2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u001f\u0010$\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010%2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010&J\u001f\u0010'\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010(2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010)J\u001f\u0010*\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010+J\u001a\u0010,\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010-2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u001a\u0010.\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010/2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u001a\u00100\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u0001012\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u001f\u00102\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u0001032\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u00104J\"\u00105\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010!2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u001a\u00106\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u0001072\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u001a\u00108\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u0001092\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u001f\u0010:\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010;2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010<J\"\u0010=\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u00020@2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u001a\u0010A\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u0001092\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\"\u0010B\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010C2\u0006\u0010?\u001a\u00020@2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\"\u0010D\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010E2\u0006\u0010?\u001a\u00020@2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\"\u0010F\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010G2\u0006\u0010?\u001a\u00020@2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006H"}, d2={"Lcom/jetbrains/jdbc/sqlserver/converters/set/SetStringConverter;", "Lcom/jetbrains/jdbc/base/conversions/set/SetValueConverter;", "()V", "dateFormat", "Ljava/time/format/DateTimeFormatter;", "dateTimeFormat", "timeFormat", "to", "", "Ljava/sql/JDBCType;", "getTo", "()Ljava/util/List;", "fromAsciiStream", "Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "value", "Ljava/io/InputStream;", "length", "", "sqlType", "fromBigDecimal", "Ljava/math/BigDecimal;", "fromBinaryStream", "fromBlob", "Ljava/sql/Blob;", "fromBoolean", "", "(Ljava/lang/Boolean;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromByte", "", "(Ljava/lang/Byte;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromBytes", "", "fromCharacterStream", "Ljava/io/Reader;", "fromClob", "Ljava/sql/Clob;", "fromDouble", "", "(Ljava/lang/Double;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromFloat", "", "(Ljava/lang/Float;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromInt", "(Ljava/lang/Integer;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromLocalDate", "Ljava/time/LocalDate;", "fromLocalDateTime", "Ljava/time/LocalDateTime;", "fromLocalTime", "Ljava/time/LocalTime;", "fromLong", "", "(Ljava/lang/Long;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromNCharacterStream", "fromNClob", "Ljava/sql/NClob;", "fromNString", "", "fromShort", "", "(Ljava/lang/Short;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromSqlDate", "Ljava/sql/Date;", "timeZone", "Ljava/util/TimeZone;", "fromString", "fromTime", "Ljava/sql/Time;", "fromTimestamp", "Ljava/sql/Timestamp;", "fromUtilDate", "Ljava/util/Date;", "Frontend"})
@SourceDebugExtension(value={"SMAP\nSetStringConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetStringConverter.kt\ncom/jetbrains/jdbc/sqlserver/converters/set/SetStringConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,305:1\n1#2:306\n*E\n"})
public final class SetStringConverter
extends SetValueConverter {
    @NotNull
    public static final SetStringConverter INSTANCE = new SetStringConverter();
    @NotNull
    private static final List<JDBCType> to;
    @NotNull
    private static final DateTimeFormatter dateFormat;
    @NotNull
    private static final DateTimeFormatter dateTimeFormat;
    @NotNull
    private static final DateTimeFormatter timeFormat;

    private SetStringConverter() {
        super(SqlServerJdbcToNativeTypeTranslator.INSTANCE);
    }

    @NotNull
    public List<JDBCType> getTo() {
        return to;
    }

    @Override
    @NotNull
    public RdSetValueRequest fromSqlDate(@Nullable Date value2, @NotNull TimeZone timeZone, int sqlType) {
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Instant instant = Instant.ofEpochMilli(value2.getTime());
        Intrinsics.checkNotNullExpressionValue(instant, "ofEpochMilli(value.time)");
        Instant converted = DateTimeUtilsKt.resetTime(DateTimeUtilsKt.fromGregorianToPureGregorian(instant, timeZone)).toInstant();
        String string = dateFormat.format(converted);
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetStringRequest(string, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromUtilDate(@Nullable java.util.Date value2, @NotNull TimeZone timeZone, int sqlType) {
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Instant instant = value2.toInstant();
        Intrinsics.checkNotNullExpressionValue(instant, "value.toInstant()");
        Instant converted = DateTimeUtilsKt.fromGregorianToPureGregorian(instant, timeZone).toInstant();
        String string = dateTimeFormat.format(converted);
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetStringRequest(string, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromTimestamp(@Nullable Timestamp value2, @NotNull TimeZone timeZone, int sqlType) {
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Instant instant = value2.toInstant();
        Intrinsics.checkNotNullExpressionValue(instant, "instant");
        Instant converted = DateTimeUtilsKt.fromGregorianToPureGregorian(instant, timeZone).toInstant().plusNanos(DateTimeUtilsKt.getLeftNanos(instant));
        String string = dateTimeFormat.format(converted);
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetStringRequest(string, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromLocalDateTime(@Nullable LocalDateTime value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        String string = value2.format(dateTimeFormat);
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetStringRequest(string, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromLocalDate(@Nullable LocalDate value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        String string = value2.format(dateFormat);
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetStringRequest(string, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromTime(@Nullable Time value2, @NotNull TimeZone timeZone, int sqlType) {
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Instant instant = Instant.ofEpochMilli(value2.getTime());
        Intrinsics.checkNotNullExpressionValue(instant, "ofEpochMilli(value.time)");
        Instant converted = DateTimeUtilsKt.fromGregorianToPureGregorian(instant, timeZone).toInstant();
        String string = timeFormat.format(converted);
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetStringRequest(string, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromLocalTime(@Nullable LocalTime value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        String string = value2.format(timeFormat);
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetStringRequest(string, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromByte(@Nullable Byte value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        String string = value2.toString();
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetStringRequest(string, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromShort(@Nullable Short value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        String string = value2.toString();
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetStringRequest(string, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromInt(@Nullable Integer value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        String string = value2.toString();
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetStringRequest(string, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromLong(@Nullable Long value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        String string = value2.toString();
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetStringRequest(string, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromFloat(@Nullable Float value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        String string = value2.toString();
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetStringRequest(string, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromDouble(@Nullable Double value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        String string = value2.toString();
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetStringRequest(string, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromBoolean(@Nullable Boolean value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        String string = value2.toString();
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetStringRequest(string, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromBigDecimal(@Nullable BigDecimal value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        String string = value2.toString();
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetStringRequest(string, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromString(@Nullable String value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetStringRequest(value2, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromNString(@Nullable String value2, int sqlType) {
        return this.fromString(value2, sqlType);
    }

    @Override
    @NotNull
    public RdSetValueRequest fromBytes(@Nullable byte[] value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Charset charset = StandardCharsets.US_ASCII;
        Intrinsics.checkNotNullExpressionValue(charset, "US_ASCII");
        Charset charset2 = charset;
        String str = new String(value2, charset2);
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetStringRequest(str, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromBinaryStream(@Nullable InputStream value2, int length, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        byte[] arr = value2.readNBytes(length);
        return this.fromBytes(arr, sqlType);
    }

    @Override
    @NotNull
    public RdSetValueRequest fromAsciiStream(@Nullable InputStream value2, int length, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        byte[] arr = value2.readNBytes(length);
        return this.fromBytes(arr, sqlType);
    }

    @Override
    @NotNull
    public RdSetValueRequest fromCharacterStream(@Nullable Reader value2, int length, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        StringBuilder data2 = new StringBuilder(128);
        int charsIn = 0;
        charsIn = -1;
        char[] buffer = new char[1024];
        while (true) {
            int n;
            int it = n = value2.read(buffer);
            boolean bl = false;
            charsIn = it;
            if (n <= -1) break;
            data2.append(buffer, 0, charsIn);
        }
        String string = data2.toString();
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetStringRequest(string, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromNCharacterStream(@Nullable Reader value2, int length, int sqlType) {
        return this.fromCharacterStream(value2, length, sqlType);
    }

    @Override
    @NotNull
    public RdSetValueRequest fromBlob(@Nullable Blob value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        InputStream stream = value2.getBinaryStream();
        return this.fromBinaryStream(stream, Integer.MAX_VALUE, sqlType);
    }

    @Override
    @NotNull
    public RdSetValueRequest fromClob(@Nullable Clob value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Reader stream = value2.getCharacterStream();
        return this.fromCharacterStream(stream, Integer.MAX_VALUE, sqlType);
    }

    @Override
    @NotNull
    public RdSetValueRequest fromNClob(@Nullable NClob value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Reader stream = value2.getCharacterStream();
        return this.fromCharacterStream(stream, Integer.MAX_VALUE, sqlType);
    }

    static {
        JDBCType[] jDBCTypeArray = new JDBCType[]{JDBCType.CHAR, JDBCType.VARCHAR, JDBCType.NCHAR, JDBCType.NVARCHAR, JDBCType.LONGVARCHAR, JDBCType.LONGNVARCHAR, JDBCType.CLOB, JDBCType.NCLOB};
        to = CollectionsKt.listOf(jDBCTypeArray);
        DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").toFormatter().withZone(ZoneId.of("UTC"));
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "DateTimeFormatterBuilder\u2026ithZone(ZoneId.of(\"UTC\"))");
        dateFormat = dateTimeFormatter;
        DateTimeFormatter dateTimeFormatter2 = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 7, true).toFormatter().withZone(ZoneId.of("UTC"));
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter2, "DateTimeFormatterBuilder\u2026ithZone(ZoneId.of(\"UTC\"))");
        dateTimeFormat = dateTimeFormatter2;
        DateTimeFormatter dateTimeFormatter3 = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 7, true).toFormatter().withZone(ZoneId.of("UTC"));
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter3, "DateTimeFormatterBuilder\u2026ithZone(ZoneId.of(\"UTC\"))");
        timeFormat = dateTimeFormatter3;
    }
}

