/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.converters.get;

import com.jetbrains.jdbc.base.conversions.get.GetValueConverter;
import com.jetbrains.jdbc.base.models.RdGetStringResponse;
import com.jetbrains.jdbc.base.models.RdGetValueResponse;
import com.jetbrains.jdbc.base.models.RdNullResponse;
import com.jetbrains.jdbc.base.models.sql.ProtocolInMemoryBlob;
import com.jetbrains.jdbc.base.models.sql.ProtocolInMemoryNClob;
import com.jetbrains.jdbc.base.models.sql.xml.ProtocolXml;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.sqlserver.converters.SqlServerType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLXML;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/jdbc/sqlserver/converters/get/GetXmlConverter;", "Lcom/jetbrains/jdbc/base/conversions/get/GetValueConverter;", "()V", "from", "", "Lcom/jetbrains/jdbc/sqlserver/converters/SqlServerType;", "getFrom", "()Ljava/util/List;", "getBinaryStream", "Ljava/io/InputStream;", "response", "Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;", "getBlob", "Ljava/sql/Blob;", "getBytes", "", "getCharacterStream", "Ljava/io/Reader;", "getClob", "Ljava/sql/Clob;", "getNCharacterStream", "getNClob", "Ljava/sql/NClob;", "getNString", "", "getObject", "", "getSqlXml", "Ljava/sql/SQLXML;", "getString", "getValue", "Frontend"})
public final class GetXmlConverter
extends GetValueConverter {
    @NotNull
    public static final GetXmlConverter INSTANCE = new GetXmlConverter();
    @NotNull
    private static final List<SqlServerType> from = CollectionsKt.listOf(SqlServerType.Xml);

    private GetXmlConverter() {
    }

    @NotNull
    public List<SqlServerType> getFrom() {
        return from;
    }

    @Override
    @Nullable
    public String getString(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getValue(response);
    }

    @Override
    @Nullable
    public String getNString(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getString(response);
    }

    @Override
    @Nullable
    public SQLXML getSqlXml(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String value2 = string;
        return new ProtocolXml(value2);
    }

    @Override
    @Nullable
    public Object getObject(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getString(response);
    }

    @Override
    @Nullable
    public Clob getClob(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String str = string;
        return new ProtocolInMemoryNClob(str);
    }

    @Override
    @Nullable
    public NClob getNClob(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String str = string;
        return new ProtocolInMemoryNClob(str);
    }

    @Override
    @Nullable
    public byte[] getBytes(@NotNull RdGetValueResponse response) {
        String str;
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String string2 = str = string;
        Charset charset = Charset.forName("UTF-16");
        Intrinsics.checkNotNullExpressionValue(charset, "forName(\"UTF-16\")");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    @Override
    @Nullable
    public InputStream getBinaryStream(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        byte[] byArray = this.getBytes(response);
        if (byArray == null) {
            return null;
        }
        byte[] arr = byArray;
        return new ByteArrayInputStream(arr);
    }

    @Override
    @Nullable
    public Blob getBlob(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        byte[] byArray = this.getBytes(response);
        if (byArray == null) {
            return null;
        }
        byte[] arr = byArray;
        return new ProtocolInMemoryBlob(arr);
    }

    @Override
    @Nullable
    public Reader getCharacterStream(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String str = string;
        return new StringReader(str);
    }

    @Override
    @Nullable
    public Reader getNCharacterStream(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getCharacterStream(response);
    }

    private final String getValue(RdGetValueResponse response) {
        String string;
        RdGetValueResponse rdGetValueResponse = response;
        if (rdGetValueResponse instanceof RdGetStringResponse) {
            string = ((RdGetStringResponse)response).getValue();
        } else if (rdGetValueResponse instanceof RdNullResponse) {
            string = null;
        } else {
            String string2 = response.getClass().getName();
            Intrinsics.checkNotNullExpressionValue(string2, "response::class.java.name");
            String[] stringArray = new String[2];
            Intrinsics.checkNotNullExpressionValue(JvmClassMappingKt.getJavaClass(RdGetStringResponse.Companion.get_type()).getName(), "RdGetStringResponse._type.java.name");
            Intrinsics.checkNotNullExpressionValue(JvmClassMappingKt.getJavaClass(RdNullResponse.Companion.get_type()).getName(), "RdNullResponse._type.java.name");
            throw ExceptionsKt.invalidValueReceived(string2, stringArray);
        }
        return string;
    }
}

