/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.converters.get;

import com.jetbrains.jdbc.base.conversions.get.GetValueConverter;
import com.jetbrains.jdbc.base.models.RdGetTimeResponse;
import com.jetbrains.jdbc.base.models.RdGetValueResponse;
import com.jetbrains.jdbc.base.models.RdNullResponse;
import com.jetbrains.jdbc.base.models.RdTime;
import com.jetbrains.jdbc.base.utils.conversions.DateTimeUtilsKt;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.sqlserver.converters.SqlDateTimeFormatter;
import com.jetbrains.jdbc.sqlserver.converters.SqlServerType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/jdbc/sqlserver/converters/get/GetTimeConverter;", "Lcom/jetbrains/jdbc/base/conversions/get/GetValueConverter;", "()V", "from", "", "Lcom/jetbrains/jdbc/sqlserver/converters/SqlServerType;", "getFrom", "()Ljava/util/List;", "getLocalDateTime", "Ljava/time/LocalDateTime;", "response", "Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;", "getLocalTime", "Ljava/time/LocalTime;", "getNString", "", "getObject", "", "getString", "getTime", "Ljava/sql/Time;", "timeZone", "Ljava/util/TimeZone;", "getTimestamp", "Ljava/sql/Timestamp;", "getUtilDate", "Ljava/util/Date;", "getValue", "Lcom/jetbrains/jdbc/base/models/RdTime;", "Frontend"})
@SourceDebugExtension(value={"SMAP\nGetTimeConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetTimeConverter.kt\ncom/jetbrains/jdbc/sqlserver/converters/get/GetTimeConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public final class GetTimeConverter
extends GetValueConverter {
    @NotNull
    public static final GetTimeConverter INSTANCE = new GetTimeConverter();
    @NotNull
    private static final List<SqlServerType> from = CollectionsKt.listOf(SqlServerType.Time);

    private GetTimeConverter() {
    }

    @NotNull
    public List<SqlServerType> getFrom() {
        return from;
    }

    @Override
    @Nullable
    public Timestamp getTimestamp(@NotNull RdGetValueResponse response, @NotNull TimeZone timeZone) {
        Instant instant;
        Intrinsics.checkNotNullParameter(response, "response");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        RdTime rdTime = this.getValue(response);
        if (rdTime == null) {
            return null;
        }
        RdTime value2 = rdTime;
        Instant instant2 = instant = value2.getDatetime().toInstant();
        Intrinsics.checkNotNullExpressionValue(instant2, "instant");
        instant = DateTimeUtilsKt.fromPureGregorianToGregorian(instant2, timeZone).toInstant().plusNanos(value2.getNanos());
        return Timestamp.from(instant);
    }

    @Override
    @Nullable
    public Time getTime(@NotNull RdGetValueResponse response, @NotNull TimeZone timeZone) {
        Instant instant;
        Intrinsics.checkNotNullParameter(response, "response");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        RdTime rdTime = this.getValue(response);
        if (rdTime == null) {
            return null;
        }
        RdTime value2 = rdTime;
        Instant instant2 = instant = value2.getDatetime().toInstant();
        Intrinsics.checkNotNullExpressionValue(instant2, "instant");
        instant = DateTimeUtilsKt.fromPureGregorianToGregorian(instant2, timeZone).toInstant();
        return new Time(instant.toEpochMilli());
    }

    @Override
    @Nullable
    public Date getUtilDate(@NotNull RdGetValueResponse response) {
        Instant instant;
        Intrinsics.checkNotNullParameter(response, "response");
        RdTime rdTime = this.getValue(response);
        if (rdTime == null) {
            return null;
        }
        RdTime value2 = rdTime;
        Instant instant2 = instant = value2.getDatetime().toInstant();
        Intrinsics.checkNotNullExpressionValue(instant2, "instant");
        TimeZone timeZone = TimeZone.getDefault();
        Intrinsics.checkNotNullExpressionValue(timeZone, "getDefault()");
        instant = DateTimeUtilsKt.fromPureGregorianToGregorian(instant2, timeZone).toInstant();
        return new Date(instant.toEpochMilli());
    }

    @Override
    @Nullable
    public LocalDateTime getLocalDateTime(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        RdTime rdTime = this.getValue(response);
        if (rdTime == null) {
            return null;
        }
        RdTime value2 = rdTime;
        Instant instant = value2.getDatetime().toInstant();
        LocalDateTime local = LocalDateTime.ofInstant(instant, ZoneId.of("UTC"));
        return local.plusNanos(value2.getNanos());
    }

    @Override
    @Nullable
    public LocalTime getLocalTime(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        LocalDateTime localDateTime = this.getLocalDateTime(response);
        return localDateTime != null ? localDateTime.toLocalTime() : null;
    }

    @Override
    @Nullable
    public String getString(@NotNull RdGetValueResponse response) {
        String string;
        LocalTime localTime;
        Intrinsics.checkNotNullParameter(response, "response");
        LocalTime localTime2 = localTime = this.getLocalTime(response);
        if (localTime2 != null) {
            LocalTime it = localTime2;
            boolean bl = false;
            string = SqlDateTimeFormatter.INSTANCE.format(localTime);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public String getNString(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getString(response);
    }

    @Override
    @Nullable
    public Object getObject(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        TimeZone timeZone = TimeZone.getDefault();
        Intrinsics.checkNotNullExpressionValue(timeZone, "getDefault()");
        return this.getTime(response, timeZone);
    }

    private final RdTime getValue(RdGetValueResponse response) {
        RdTime rdTime;
        RdGetValueResponse rdGetValueResponse = response;
        if (rdGetValueResponse instanceof RdGetTimeResponse) {
            rdTime = ((RdGetTimeResponse)response).getValue();
        } else if (rdGetValueResponse instanceof RdNullResponse) {
            rdTime = null;
        } else {
            String string = response.getClass().getName();
            Intrinsics.checkNotNullExpressionValue(string, "response::class.java.name");
            String[] stringArray = new String[2];
            Intrinsics.checkNotNullExpressionValue(JvmClassMappingKt.getJavaClass(RdGetTimeResponse.Companion.get_type()).getName(), "RdGetTimeResponse._type.java.name");
            Intrinsics.checkNotNullExpressionValue(JvmClassMappingKt.getJavaClass(RdNullResponse.Companion.get_type()).getName(), "RdNullResponse._type.java.name");
            throw ExceptionsKt.invalidValueReceived(string, stringArray);
        }
        return rdTime;
    }
}

